/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.dataview.utils;

import com.digiwin.app.dao.DWQueryField;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.lcdp.modeldriven.constants.ModelDBConstants;
import com.digiwin.lcdp.modeldriven.dataview.constant.DataViewConstant;
import com.digiwin.lcdp.modeldriven.dataview.utils.DataViewDataTimeUtil;
import com.digiwin.lcdp.modeldriven.dataview.utils.OrganizationUtil;
import com.digiwin.lcdp.modeldriven.pojo.QueryConditionDTO;
import com.digiwin.lcdp.modeldriven.utils.ModelStringUtil;
import com.digiwin.lcdp.modeldriven.utils.SearchFieldUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SystemVariableUtil {
    private final OrganizationUtil organizationUtil;

    @Autowired
    public SystemVariableUtil(Optional<OrganizationUtil> optionalOrganizationUtil) {
        this.organizationUtil = optionalOrganizationUtil.orElse(null);
    }

    public List<DWQueryField> getSystemVariableValue(QueryConditionDTO searchInfo) {
        ArrayList<DWQueryField> result = new ArrayList<DWQueryField>();
        Iterator<?> iterator = searchInfo.getSearch_value().iterator();
        while (iterator.hasNext()) {
            String searchValue = iterator.next().toString();
            String searchOperator = searchInfo.getSearch_operator();
            String searchField = searchInfo.getSearch_field();
            switch (searchValue) {
                case "{@SYSTEM_DATE_TODAY}": {
                    List<DWQueryField> queryFieldsToday = SearchFieldUtil.generateDateToday(searchField, searchOperator);
                    result.addAll(queryFieldsToday);
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_DATE_WEEK}": {
                    List<DWQueryField> queryFieldsWeek = SearchFieldUtil.generateDateWeek(searchField, searchOperator);
                    result.addAll(queryFieldsWeek);
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_DATE_MONTH}": {
                    List<DWQueryField> queryFieldsMonth = SearchFieldUtil.generateDateMonth(searchField, searchOperator);
                    result.addAll(queryFieldsMonth);
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_DATE_IN_7}": {
                    List<DWQueryField> queryFieldsDateIn7 = SearchFieldUtil.generateDateIn7(searchField, searchOperator);
                    result.addAll(queryFieldsDateIn7);
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_TENANT_SID}": {
                    List<DWQueryField> queryFieldsTenantSid = SearchFieldUtil.generateTenantSid(searchField, searchOperator);
                    result.addAll(queryFieldsTenantSid);
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_USER_ID}": {
                    List<DWQueryField> queryFieldsUserId = SearchFieldUtil.generateUserId(searchField, searchOperator);
                    result.addAll(queryFieldsUserId);
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_EMPLOYEE_ID}": {
                    List<DWQueryField> queryFieldsEmpId = SearchFieldUtil.generateEmpId(searchField, searchOperator, this.organizationUtil.getEmpId(), searchInfo.getTable_name());
                    result.addAll(queryFieldsEmpId);
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_EMPLOYEE_DEPTID}": {
                    Object[] deptIdObjs = this.organizationUtil.getDeptId().toArray(new Object[1]);
                    List<DWQueryField> queryFieldsDeptId = SearchFieldUtil.generateDeptId(searchField, searchOperator, deptIdObjs, searchInfo.getTable_name());
                    result.addAll(queryFieldsDeptId);
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_EMPLOYEE_DEPTID_ALL}": {
                    Object[] deptIdAllObjs = this.organizationUtil.getDeptIdAll().toArray(new Object[1]);
                    List<DWQueryField> queryFieldsDeptIdAll = SearchFieldUtil.generateDeptIdAll(searchField, searchOperator, deptIdAllObjs, searchInfo.getTable_name());
                    result.addAll(queryFieldsDeptIdAll);
                    iterator.remove();
                    break;
                }
            }
        }
        return result;
    }

    public void replaceSystemVariable(StringBuilder sql) {
        String shouldModifySql2 = sql.toString();
        for (String systemVar : DataViewConstant.SQL_QUERY_PROJECT_SYSTEM_VAR) {
            if (!shouldModifySql2.contains(systemVar)) continue;
            switch (systemVar) {
                case "{@SYSTEM_DATE_TODAY}": {
                    shouldModifySql2 = this.replaceSysVarForToday(shouldModifySql2);
                    break;
                }
                case "{@SYSTEM_DATE_WEEK}": {
                    shouldModifySql2 = this.replaceSysVarForDateWeek(shouldModifySql2);
                    break;
                }
                case "{@SYSTEM_DATE_MONTH}": {
                    shouldModifySql2 = this.replaceSysVarForDateMonth(shouldModifySql2);
                    break;
                }
                case "{@SYSTEM_DATE_IN_7}": {
                    shouldModifySql2 = this.replaceSysVarForDateIn7(shouldModifySql2);
                    break;
                }
                case "{@SYSTEM_TENANT_SID}": {
                    shouldModifySql2 = this.replaceSysVarForTenantSid(shouldModifySql2);
                    break;
                }
                case "{@SYSTEM_USER_ID}": {
                    shouldModifySql2 = this.replaceSysVarForUserId(shouldModifySql2);
                    break;
                }
                case "{@SYSTEM_EMPLOYEE_ID}": {
                    shouldModifySql2 = this.replaceSysVarForEmpId(shouldModifySql2);
                    break;
                }
                case "{@SYSTEM_EMPLOYEE_DEPTID}": {
                    shouldModifySql2 = this.replaceSysVarForEmpDeptId(shouldModifySql2);
                    break;
                }
                case "{@SYSTEM_EMPLOYEE_DEPTID_ALL}": {
                    shouldModifySql2 = this.replaceSysVarForEmpDeptIdAll(shouldModifySql2);
                    break;
                }
            }
        }
        sql.setLength(0);
        sql.append(shouldModifySql2);
    }

    public Object getTenantSid() {
        return DWServiceContext.getContext().getProfile().get(ModelDBConstants.IAM_PROFILE_TENANT_SID);
    }

    public Object getUserId() {
        return DWServiceContext.getContext().getProfile().get("userId");
    }

    public Object getEmpId() {
        return this.organizationUtil.getEmpId().toArray(new Object[1]);
    }

    public Object getEmpDeptId() {
        return this.organizationUtil.getDeptId().toArray(new Object[1]);
    }

    public Object getEmpDeptIdAll() {
        return this.organizationUtil.getDeptIdAll().toArray(new Object[1]);
    }

    public String replaceSysVarForToday(String orgSqlStatement) {
        String systemTodayValue = DataViewDataTimeUtil.getCurrentDate().get(0);
        String targetTodayValue = ModelStringUtil.convertValueStringAndDate(systemTodayValue);
        Matcher systemTodayMatcher = DataViewConstant.SYSTEM_DATE_TODAY_PATTERN.matcher(orgSqlStatement);
        if (systemTodayMatcher.find()) {
            orgSqlStatement = systemTodayMatcher.replaceAll(targetTodayValue);
        }
        return orgSqlStatement;
    }

    public String replaceSysVarForDateWeek(String sqlStatement) {
        List<String> valueWeek = DataViewDataTimeUtil.getCurrentWeek();
        String weekConditionStart = String.format("%s '%s' AND '%s'", DWQueryValueOperator.Between, valueWeek.get(0), valueWeek.get(1));
        Matcher systemDateWeekMatcher = DataViewConstant.SYSTEM_DATE_WEEK_PATTERN.matcher(sqlStatement);
        if (systemDateWeekMatcher.find()) {
            sqlStatement = systemDateWeekMatcher.replaceAll(weekConditionStart);
        }
        return sqlStatement;
    }

    public String replaceSysVarForDateMonth(String sqlStatement) {
        String valueMonth = DataViewDataTimeUtil.getCurrentMonth().get(0);
        String targetMonthValue = ModelStringUtil.convertValueStringAndDate(valueMonth);
        Matcher systemDateMonthMatcher = DataViewConstant.SYSTEM_DATE_MONTH_PATTERN.matcher(sqlStatement);
        if (systemDateMonthMatcher.find()) {
            sqlStatement = systemDateMonthMatcher.replaceAll(targetMonthValue);
        }
        return sqlStatement;
    }

    private String replaceSysVarForEmpDeptIdAll(String sqlStatement) {
        Object valueEmpDeptIdAll = this.getEmpDeptIdAll();
        List<Object> empDeptIdAll = new ArrayList();
        if (valueEmpDeptIdAll instanceof Object[]) {
            empDeptIdAll = Arrays.asList((Object[])valueEmpDeptIdAll);
        }
        ArrayList<String> targetEmpDeptAll = new ArrayList<String>();
        for (Object empDeptId : empDeptIdAll) {
            targetEmpDeptAll.add(ModelStringUtil.convertValueString(empDeptId));
        }
        if (CollectionUtils.isNotEmpty(targetEmpDeptAll)) {
            String targetEmpDeptIdAllValue = String.join((CharSequence)", ", targetEmpDeptAll);
            Matcher systemEmpDeptIdAllMatcher = DataViewConstant.SYSTEM_EMPLOYEE_DEPTID_ALL_PATTERN.matcher(sqlStatement);
            if (systemEmpDeptIdAllMatcher.find()) {
                sqlStatement = systemEmpDeptIdAllMatcher.replaceAll(targetEmpDeptIdAllValue);
            }
        }
        return sqlStatement;
    }

    private String replaceSysVarForEmpDeptId(String sqlStatement) {
        Object valueEmpDeptIdParam = this.getEmpDeptId();
        String targetEmpDeptIdValue = "";
        if (valueEmpDeptIdParam instanceof Object[]) {
            Object empDeptData = ((Object[])valueEmpDeptIdParam)[0];
            targetEmpDeptIdValue = empDeptData == null ? "null" : "'" + empDeptData + "'";
            Matcher systemEmpDeptIdMatcher = DataViewConstant.SYSTEM_EMPLOYEE_DEPTID_PATTERN.matcher(sqlStatement);
            if (systemEmpDeptIdMatcher.find()) {
                sqlStatement = systemEmpDeptIdMatcher.replaceAll(targetEmpDeptIdValue);
            }
        }
        return sqlStatement;
    }

    private String replaceSysVarForEmpId(String sqlStatement) {
        Matcher systemEmpIdMatcher;
        Object valueEmpIdParam = this.getEmpId();
        String targetEmpIdValue = "";
        if (valueEmpIdParam instanceof Object[]) {
            Object empData = ((Object[])valueEmpIdParam)[0];
            String string = targetEmpIdValue = empData == null ? "null" : "'" + empData + "'";
        }
        if ((systemEmpIdMatcher = DataViewConstant.SYSTEM_EMPLOYEE_ID_PATTERN.matcher(sqlStatement)).find()) {
            sqlStatement = systemEmpIdMatcher.replaceAll(targetEmpIdValue);
        }
        return sqlStatement;
    }

    private String replaceSysVarForUserId(String sqlStatement) {
        Object value = this.getUserId();
        String targetValue = ModelStringUtil.convertValueStringAndDate(value);
        Matcher systemUserIdMatcher = DataViewConstant.SYSTEM_USER_ID_PATTERN.matcher(sqlStatement);
        if (systemUserIdMatcher.find()) {
            sqlStatement = systemUserIdMatcher.replaceAll(targetValue);
        }
        return sqlStatement;
    }

    private String replaceSysVarForTenantSid(String sqlStatement) {
        Object valueTenantSid = this.getTenantSid();
        String targetTenantSidValue = ModelStringUtil.convertValueStringAndDate(valueTenantSid);
        Matcher systemTenantSidMatcher = DataViewConstant.SYSTEM_TENANT_SID_PATTERN.matcher(sqlStatement);
        if (systemTenantSidMatcher.find()) {
            sqlStatement = systemTenantSidMatcher.replaceAll(targetTenantSidValue);
        }
        return sqlStatement;
    }

    private String replaceSysVarForDateIn7(String sqlStatement) {
        List<String> valueDateIn7 = DataViewDataTimeUtil.getLast7Days();
        String dateIn7ConditionStart = String.format("%s '%s' AND '%s'", DWQueryValueOperator.Between, valueDateIn7.get(0), valueDateIn7.get(1));
        Matcher dateIn7Matcher = DataViewConstant.SYSTEM_DATE_IN_7_PATTERN.matcher(sqlStatement);
        if (dateIn7Matcher.find()) {
            sqlStatement = dateIn7Matcher.replaceAll(dateIn7ConditionStart);
        }
        return sqlStatement;
    }
}

