/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.spring;

import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.app.resource.spring.DWLocaleResolver;
import com.google.gson.Gson;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class ModelDriverLocaleResolver
extends DWLocaleResolver {
    public Locale resolveLocale(HttpServletRequest request) {
        String digiHostString = request.getHeader("digi-host");
        Gson gson = DWGsonProvider.getGson();
        Map digiHost = (Map)gson.fromJson(digiHostString, Map.class);
        String lang = MapUtils.getString((Map)digiHost, (Object)"lang", null);
        if (lang == null) {
            String localeString = request.getHeader("locale");
            if (localeString == null) {
                localeString = request.getHeader("digi-locale");
            }
            if (localeString == null) {
                Locale digiAcceptLanguageLocale = this.getDigiAcceptLangueLocale(request);
                if (digiAcceptLanguageLocale != null) {
                    return digiAcceptLanguageLocale;
                }
                return request.getLocale();
            }
            return DWResourceBundleUtils.getLocale((String)localeString);
        }
        switch (lang) {
            case "en": {
                lang = "en_US";
                break;
            }
            case "zh_CN": {
                lang = "zh_CN";
                break;
            }
            case "zh_TW": {
                lang = "zh_TW";
                break;
            }
            default: {
                return request.getLocale();
            }
        }
        return DWResourceBundleUtils.getLocale((String)lang);
    }

    public void setLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        throw new UnsupportedOperationException("Cannot change locale - use a different locale resolution strategy");
    }

    private Locale getDigiAcceptLangueLocale(HttpServletRequest request) {
        List<Locale.LanguageRange> languageRanges;
        Locale result = null;
        String digiAcceptLanguage = request.getHeader("digi-accept-language");
        if (digiAcceptLanguage != null && CollectionUtils.isNotEmpty(languageRanges = Locale.LanguageRange.parse(digiAcceptLanguage))) {
            String firstRange = languageRanges.get(0).getRange();
            return Locale.forLanguageTag(firstRange);
        }
        return result;
    }
}

