/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelExtendModelInfo;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaExtends;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.model.TableSqlParamDTO;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelTableSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import com.digiwin.utils.DWTenantUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public final class ModelExtendSqlGenerator {
    private static final Logger log = LoggerFactory.getLogger(ModelExtendSqlGenerator.class);
    private static final String CLASS_LOG_TAG = "[" + ModelExtendSqlGenerator.class.getSimpleName() + "]";

    public static List<SqlParam> generateInsertOrUpdateModelSql(ModelDTO model) {
        Map profileMap = DWServiceContext.getContext().getProfile();
        String tenantSidColumnName = DWApplicationConfigUtils.getProperty((String)"tenantColumnname", (String)DWTenantUtils.getTenantColumnName());
        Object tenantSid = profileMap.get(DWTenantUtils.getIAMTenantSidKey());
        Object tenantUserSid = profileMap.get("userSid");
        String targetTenantId = model.getTargetTenantId();
        String appId = model.getAppId();
        ArrayList<SqlParam> resultSqlParams = new ArrayList<SqlParam>();
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map<String, Object> extraMapOfModelContext = modelDrivenContext.getExtraMap();
        Map draftModelTableMap = (Map)extraMapOfModelContext.get("draftModelTables");
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        ModelSchemaExtends schemaExtends = draftModel.getSchemaExtends();
        List<ModelExtendModelInfo> extendModelInfos = schemaExtends.getExtendModelInfo();
        HashMap extendModelInfoMap = new HashMap();
        extendModelInfos.stream().forEach(extendModelInfo -> extendModelInfoMap.put(extendModelInfo.getCurrentModelCode(), extendModelInfo));
        Map<String, String> modelStrMap = ModelExtendSqlGenerator.getDraftModelSchemaFromContextDraftJson();
        for (Map.Entry<String, String> entry : modelStrMap.entrySet()) {
            String extendModelCode = entry.getKey();
            String modelSchemaStr = entry.getValue();
            ModelTable modelTable = (ModelTable)draftModelTableMap.get(extendModelCode);
            String extendDescription = modelTable.getComment();
            String insertServiceMappingSql = String.format("insert into dw_lcdp_model (code, description, model_type, model_schema, target_tenant_id, app_id, %s , create_user_sid , create_time ) values(?, ?, ?, ?, ?, ?, ?, ? ,?) ON DUPLICATE KEY UPDATE description=?, model_schema=?, target_tenant_id=?, app_id=?, update_user_sid=? ", tenantSidColumnName);
            SqlParam insertSqlParam = new SqlParam(insertServiceMappingSql, new Object[]{extendModelCode, extendDescription, "extend", modelSchemaStr, targetTenantId, appId, tenantSid, tenantUserSid, new Date(), extendDescription, modelSchemaStr, targetTenantId, appId, tenantUserSid});
            resultSqlParams.add(insertSqlParam);
        }
        return resultSqlParams;
    }

    public static List<SqlParam> generateModelDeleteSql(ModelDTO draftModel) {
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map<String, Object> extraMapOfModelContext = modelDrivenContext.getExtraMap();
        Map publishedModelSchemaMap = (Map)extraMapOfModelContext.get("publishedModelSchemaMap");
        Map draftModelTableMap = (Map)extraMapOfModelContext.get("draftModelTables");
        List<String> needRemovedModelCodeNames = publishedModelSchemaMap.keySet().stream().filter(publishedModelCode -> !draftModelTableMap.containsKey(publishedModelCode)).collect(Collectors.toList());
        return ModelExtendSqlGenerator.generateModelDeleteSql(needRemovedModelCodeNames);
    }

    public static List<SqlParam> generateModelDeleteSql(List<String> needRemovedModelCodeNames) {
        LinkedList<SqlParam> resultSqlParams = new LinkedList<SqlParam>();
        if (CollectionUtils.isEmpty(needRemovedModelCodeNames)) {
            return resultSqlParams;
        }
        String inCondition = String.join((CharSequence)", ", Collections.nCopies(needRemovedModelCodeNames.size(), "?"));
        String deleteModelInSql = String.format("delete from dw_lcdp_model where code in (%s)", inCondition);
        SqlParam deletelSqlParam = new SqlParam(deleteModelInSql, needRemovedModelCodeNames.toArray(new String[0]));
        resultSqlParams.add(deletelSqlParam);
        return resultSqlParams;
    }

    public static List<SqlParam> generateModelExtendDeleteSql(List<String> needRemovedModelCodeNames) {
        LinkedList<SqlParam> resultSqlParams = new LinkedList<SqlParam>();
        if (CollectionUtils.isEmpty(needRemovedModelCodeNames)) {
            return resultSqlParams;
        }
        String inCondition = String.join((CharSequence)", ", Collections.nCopies(needRemovedModelCodeNames.size(), "?"));
        String deleteModelInSql = String.format("delete from dw_lcdp_model_extend where extend_model_code in (%s)", inCondition);
        SqlParam deletelSqlParam = new SqlParam(deleteModelInSql, needRemovedModelCodeNames.toArray(new String[0]));
        resultSqlParams.add(deletelSqlParam);
        return resultSqlParams;
    }

    public static List<SqlParam> generateUpdateModelExtendSql(ModelDTO model) {
        LinkedList<SqlParam> resultSqlParams = new LinkedList<SqlParam>();
        String tenantSidColumnName = DWApplicationConfigUtils.getProperty((String)"tenantColumnname", (String)DWTenantUtils.getTenantColumnName());
        ModelSchemaExtends schemaExtends = model.getSchemaExtends();
        List<ModelSchemaDTO> draftModelSchemas = schemaExtends.getExtendModels();
        String extendMainTable = schemaExtends.getExtendMainTable();
        List<ModelExtendModelInfo> extendModelInfos = schemaExtends.getExtendModelInfo();
        HashMap extendModelInfoMap = new HashMap();
        extendModelInfos.stream().forEach(extendModelInfo -> extendModelInfoMap.put(extendModelInfo.getCurrentModelCode(), extendModelInfo));
        String deleteAppCode = extendModelInfos.get(0).getAppCode();
        String insertModelInfoSql = String.format("delete from dw_lcdp_model_extend where app_code=? and main_table_code=?", tenantSidColumnName);
        Object[] sqlParamParams = new Object[]{deleteAppCode, extendMainTable};
        SqlParam deltelSqlParam = new SqlParam(insertModelInfoSql, sqlParamParams);
        resultSqlParams.add(deltelSqlParam);
        Map profileMap = DWServiceContext.getContext().getProfile();
        Object tenantSid = profileMap.get(DWTenantUtils.getIAMTenantSidKey());
        Object tenantUserSid = profileMap.get("userSid");
        for (ModelSchemaDTO draftModelSchema : draftModelSchemas) {
            String extendModelCode = draftModelSchema.getName();
            ModelExtendModelInfo extendModelInfo2 = (ModelExtendModelInfo)extendModelInfoMap.get(extendModelCode);
            String appCode = extendModelInfo2.getAppCode();
            String parentModelCode = extendModelInfo2.getParentModelCode();
            String insertExtendSchemaSql = String.format("insert into dw_lcdp_model_extend (extend_model_code, app_code, code, main_table_code, app_id, %s, create_time, create_user_sid ) values(?, ?, ?, ?, ?, ?, ? ,?) ", tenantSidColumnName);
            SqlParam insertSqlParam = new SqlParam(insertExtendSchemaSql, new Object[]{extendModelCode, appCode, parentModelCode, extendMainTable, model.getAppId(), tenantSid, new Date(), tenantUserSid});
            resultSqlParams.add(insertSqlParam);
        }
        return resultSqlParams;
    }

    public static Map<String, String> getDraftModelSchemaFromContextDraftJson() {
        String modelStr = (String)ModelDrivenContext.getContext().getExtraMap().get("modelStr");
        Assert.hasText((String)modelStr, (String)"modelStr of ModelDriven Context is null or empty");
        return ModelExtendSqlGenerator.getExtendModelSchemaFromJsonModel(modelStr);
    }

    public static Map<String, String> getExtendModelSchemaFromJsonModel(String modelStr) {
        Map orgModelMap = (Map)DWGsonProvider.getGson().fromJson(modelStr, Map.class);
        Map schemaExtendsMap = (Map)orgModelMap.get("schemaExtends");
        List extendModelsMap = (List)schemaExtendsMap.get("extendModels");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (Object extendModelObj : extendModelsMap) {
            String extendModelString = DWGsonProvider.getGson().toJson(extendModelObj);
            Map extendModelMap = (Map)extendModelObj;
            resultMap.put((String)extendModelMap.get("name"), extendModelString);
        }
        return resultMap;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> filterAlterTableCommand(ModelSchemaDTO draftModelSchema, ModelSchemaDTO publishedModelSchema) throws Exception {
        String masterTableName = draftModelSchema.getName();
        HashMap<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new HashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        log.debug("=============== filterAlterTableCommand ====== {} =========", (Object)masterTableName);
        log.debug("{}[filterAlterTableCommand] alterTable starting....parent(current) TableName({})", (Object)CLASS_LOG_TAG, (Object)masterTableName);
        if (!Objects.equals(draftModelSchema.getName(), publishedModelSchema.getName())) {
            throw new DWBusinessException(String.format(ResourceBundleUtils.getString("lcdp.modeldriven.publish.fail.CannotChangeMasterModelName"), new Object[0]));
        }
        LinkedHashMap alterMap = new LinkedHashMap();
        LinkedList<SqlParam> alterDMLSqlParam = new LinkedList<SqlParam>();
        LinkedList<SqlParam> alterDDLSqlParam = new LinkedList<SqlParam>();
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map dbModelTables = (Map)modelDrivenContext.getExtraMap().get("actualModelTablesFromDB");
        Map draftModelTableMap = (Map)modelDrivenContext.getExtraMap().get("draftModelTables");
        ModelTable draftModelTable = (ModelTable)draftModelTableMap.get(masterTableName);
        ModelTable actualModelTable = null;
        if (dbModelTables.containsKey(masterTableName)) {
            actualModelTable = (ModelTable)dbModelTables.get(masterTableName);
            Map publishedModelTableMap = (Map)modelDrivenContext.getExtraMap().get("publishedModelTables");
            ModelTable publishedModelTable = (ModelTable)publishedModelTableMap.get(masterTableName);
            TableSqlParamDTO tableSqlParamDTO = ModelSqlGenerator.getAlterTable(draftModelTable, publishedModelTable, actualModelTable);
            alterDMLSqlParam.addAll(tableSqlParamDTO.getDmlSqlParams());
            alterDDLSqlParam.addAll(tableSqlParamDTO.getDdlSqlParams());
        } else {
            log.info("{}[filterAlterTableCommand] table({}) is not existed", (Object)CLASS_LOG_TAG, (Object)masterTableName);
            TableSqlParamDTO tableSqlParamDTO = ModelSqlGenerator.getCreateTable(draftModelTable);
            alterDMLSqlParam.addAll(tableSqlParamDTO.getDmlSqlParams());
            alterDDLSqlParam.addAll(tableSqlParamDTO.getDdlSqlParams());
        }
        if (!CollectionUtils.isEmpty(alterDMLSqlParam) || !CollectionUtils.isEmpty(alterDDLSqlParam)) {
            alterMap.put("ddl", alterDDLSqlParam);
            alterMap.put("dml", alterDMLSqlParam);
            returnValue.put(publishedModelSchema.getName(), alterMap);
        }
        return returnValue;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> getAlterTableCommand(List<ModelSchemaDTO> draftChildrenSchemas, List<ModelSchemaDTO> publishedChildrenSchemas) throws Exception {
        Map<String, LinkedHashMap<String, List<SqlParam>>> childrenAlterData = ModelTableSqlGenerator.compareAndGetChildrenAlterData(draftChildrenSchemas, publishedChildrenSchemas);
        if (MapUtils.isNotEmpty(childrenAlterData)) {
            log.debug("{}  parentModel: add ddl sqls of sub draftChildSchemaNames({})", (Object)CLASS_LOG_TAG, childrenAlterData.keySet());
        }
        return childrenAlterData;
    }

    public static List<SqlParam> generateUpdateModelSql(ModelDTO model) {
        String code = model.getCode();
        String modelSchemaStr = ModelDataUtil.getDraftModelSchemaFromContextDraftJson();
        Object tenantUserSid = DWServiceContext.getContext().getProfile().get("userSid");
        Object[] params = new Object[]{model.getDescription(), modelSchemaStr, tenantUserSid, code, model.getAppId()};
        String updateModelSql = "update dw_lcdp_model set description=?, model_schema=? , update_user_sid=? where code=? and app_id=? ";
        SqlParam modelSqlParam = new SqlParam(updateModelSql, params);
        ArrayList<SqlParam> returnValue = new ArrayList<SqlParam>();
        returnValue.add(modelSqlParam);
        return returnValue;
    }

    public static List<SqlParam> generateModelRefreshSql(ModelDTO draftModel) {
        List<SqlParam> modelRelatedTableDMLs = ModelExtendSqlGenerator.generateModelDeleteSql(draftModel);
        modelRelatedTableDMLs.addAll(ModelExtendSqlGenerator.generateInsertOrUpdateModelSql(draftModel));
        return modelRelatedTableDMLs;
    }

    public static Map<String, Object> generateAllDXLDeleteModel(List<String> modelCodes) {
        HashMap<String, Object> paramAll = new HashMap<String, Object>();
        LinkedList<SqlParam> ddlSqlParams = new LinkedList<SqlParam>();
        LinkedList<SqlParam> dmlSqlParams = new LinkedList<SqlParam>();
        for (String targetTableName : modelCodes) {
            SqlParam deleteRdbmsTableParam = ModelSqlGenerator.generateDeleteRdbmsTableSql(targetTableName);
            dmlSqlParams.add(deleteRdbmsTableParam);
            SqlParam deleteRdbmsFieldsParam = ModelSqlGenerator.generateDeleteRdbmsFieldSql(targetTableName);
            dmlSqlParams.add(deleteRdbmsFieldsParam);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Delete Rdbms Table Params: tableName = {}", (Object)targetTableName);
                log.debug(">>>>> gen Delete Rdbms Table SQL: {}", (Object)deleteRdbmsTableParam);
                log.debug(">>>>> gen Delete Rdbms SQL: {}", dmlSqlParams);
            }
            SqlParam dropTableSqlParam = ModelSqlGenerator.generateRenameTableSql(targetTableName);
            ddlSqlParams.add(dropTableSqlParam);
        }
        List<SqlParam> modelDeleteSqls = ModelExtendSqlGenerator.generateModelDeleteSql(modelCodes);
        dmlSqlParams.addAll(modelDeleteSqls);
        List<SqlParam> deleteModelExtendSqlParams = ModelExtendSqlGenerator.generateModelExtendDeleteSql(modelCodes);
        dmlSqlParams.addAll(deleteModelExtendSqlParams);
        paramAll.put("dml", dmlSqlParams);
        paramAll.put("ddl", ddlSqlParams);
        return paramAll;
    }
}

