/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.eai;

import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.customize.eai.BMDataEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.customize.eai.BMEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.eai.builder.EaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.eai.builder.ModelStandardEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.pojo.TechEaiData;
import com.digiwin.lcdp.modeldriven.utils.service.RegTypeUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BMMixEaiHeaderBuilder
implements EaiHeaderBuilder {
    private static final Logger log = LoggerFactory.getLogger(BMMixEaiHeaderBuilder.class);
    private static final String CLASS_LOG_TAG = "[" + BMMixEaiHeaderBuilder.class.getSimpleName() + "]";
    @Autowired
    @Qualifier(value="dw-modeldriven-crud-eai-builder")
    ModelStandardEaiHeaderBuilder modelStandardEAIHeaderBuilder;
    @Autowired(required=false)
    @Qualifier(value="modeldriven-customize-bmmix-bm-builder")
    private BMEaiHeaderBuilder bmEaiHeaderBuilder;
    @Autowired(required=false)
    @Qualifier(value="modeldriven-customize-bmmix-bmd-builder")
    private BMDataEaiHeaderBuilder bmDataEaiHeaderBuilder;

    @Override
    public List<DWEAIHeader> getEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        return Collections.emptyList();
    }

    @Override
    public Map<String, Map<String, List<DWEAIHeader>>> getProdTechEaiHeaders(Map<String, List<DWServiceMapping>> serviceMappingMapByProd, Map<String, List<MappingModelInfo>> mappingModelInfoMap) throws Exception {
        HashMap<String, Map<String, List<DWEAIHeader>>> returnNewEaiHeadersMap = new HashMap<String, Map<String, List<DWEAIHeader>>>();
        for (String prod : serviceMappingMapByProd.keySet()) {
            List<DWServiceMapping> prodMixServiceMappings;
            List<MappingModelInfo> prodStdMappingModelInfos;
            Map<String, Map<String, List<DWEAIHeader>>> newProdStdEaiHeaders;
            List prodServiceMappings = serviceMappingMapByProd.getOrDefault(prod, new ArrayList());
            List prodMappingModelInfos = mappingModelInfoMap.getOrDefault(prod, new ArrayList());
            log.debug("{} getEaiHeadersByProd prod({}), serviceMappings({}) mappingModelInfos({}) process...", new Object[]{CLASS_LOG_TAG, prod, prodServiceMappings.size(), prodMappingModelInfos.size()});
            List<DWServiceMapping> prodStdServiceMappings = prodServiceMappings.stream().filter(dwServiceMapping -> StringUtils.isBlank((CharSequence)dwServiceMapping.getTargetProd())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(prodStdServiceMappings) && MapUtils.isNotEmpty(newProdStdEaiHeaders = this.modelStandardEAIHeaderBuilder.getProdEaiHeadersByService(prodStdServiceMappings, prodStdMappingModelInfos = prodMappingModelInfos.stream().filter(stdMappingModelInfo -> StringUtils.isBlank((CharSequence)stdMappingModelInfo.getTargetProd())).collect(Collectors.toList())))) {
                RegTypeUtil.mergeRegType(returnNewEaiHeadersMap, newProdStdEaiHeaders);
            }
            if (!CollectionUtils.isNotEmpty(prodMixServiceMappings = prodServiceMappings.stream().filter(dwServiceMapping -> StringUtils.isNotBlank((CharSequence)dwServiceMapping.getTargetProd())).collect(Collectors.toList()))) continue;
            List<MappingModelInfo> prodMixMappingModelInfos = prodMappingModelInfos.stream().filter(stdMappingModelInfo -> StringUtils.isNotBlank((CharSequence)stdMappingModelInfo.getTargetProd())).collect(Collectors.toList());
            Map<String, Map<String, List<DWEAIHeader>>> newProdBMEaiHeaders = this.bmEaiHeaderBuilder.getProdEaiHeadersByService(prodMixServiceMappings, prodMixMappingModelInfos);
            Map<String, Map<String, List<DWEAIHeader>>> newProdBMDataEaiHeaders = this.bmDataEaiHeaderBuilder.getProdEaiHeadersByService(prodMixServiceMappings, prodMixMappingModelInfos);
            if (MapUtils.isNotEmpty(newProdBMEaiHeaders)) {
                RegTypeUtil.mergeRegType(returnNewEaiHeadersMap, newProdBMEaiHeaders);
            }
            if (!MapUtils.isNotEmpty(newProdBMDataEaiHeaders)) continue;
            RegTypeUtil.mergeRegType(returnNewEaiHeadersMap, newProdBMDataEaiHeaders);
        }
        return returnNewEaiHeadersMap;
    }

    @Override
    public Map<String, List<DWEAIHeader>> getTechEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        return new HashMap<String, List<DWEAIHeader>>();
    }

    @Override
    public Map<String, Map<String, List<DWEAIHeader>>> getProdEaiHeadersByService(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        return new HashMap<String, Map<String, List<DWEAIHeader>>>();
    }

    @Override
    public List<DWEAIHeader> getSubListGetHeaders(Method setMappingMethod, List<MappingModelInfo> mappingModelInfos, ModelSchemaDTO modelSchema) throws Exception {
        return Collections.emptyList();
    }

    @Override
    public List<TechEaiData> getTechEaiData(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        return new ArrayList<TechEaiData>();
    }

    @Override
    public void clearEaiHeaders() {
        this.bmEaiHeaderBuilder.clearEaiHeaders();
        this.bmDataEaiHeaderBuilder.clearEaiHeaders();
        log.debug("{} bmMixEaiMethodRepository clearEaiHeaders", (Object)CLASS_LOG_TAG);
    }
}

