/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.registry;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.config.ModelDrivenProperties;
import com.digiwin.lcdp.modeldriven.customize.config.NacosServiceRegisterEvent;
import com.digiwin.lcdp.modeldriven.customize.registry.BMAbstractRegistryApplicationListener;
import com.digiwin.lcdp.modeldriven.enums.RegisterServiceTechTypeEnum;
import com.digiwin.lcdp.modeldriven.pojo.TechEaiData;
import com.digiwin.lcdp.modeldriven.utils.EaiHeaderUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.scheduling.annotation.Async;

public class BMDataLayerRegistryApplicationListener
extends BMAbstractRegistryApplicationListener {
    private static final Logger log = LoggerFactory.getLogger(BMDataLayerRegistryApplicationListener.class);
    private static final String CLASS_LOG_TAG = "[" + BMDataLayerRegistryApplicationListener.class.getSimpleName() + "]";
    @Autowired
    @Qualifier(value="modeldriven-tech-eaiheader")
    TechEaiData targetTechEaiData;
    @Autowired
    EaiHeaderUtil eaiHeaderUtil;

    @Async
    public void onApplicationEvent(ApplicationEvent event) {
        log.debug("{}[onApplicationEvent] start ({})", (Object)CLASS_LOG_TAG, event.getClass());
        if (event instanceof InstanceRegisteredEvent) {
            if (BooleanUtils.isTrue((Boolean)this.bmProperties.isInitRegEvent())) {
                log.debug("{} ignore InstanceRegisteredEvent", (Object)CLASS_LOG_TAG);
                return;
            }
            log.debug("{} process InstanceRegisteredEvent(event:{})", (Object)CLASS_LOG_TAG, event.getSource());
            Map techEaiHeaders = this.targetTechEaiData.getTechHeaders();
            List nacosEaiHeaders = techEaiHeaders.getOrDefault(RegisterServiceTechTypeEnum.NACOS.getTechType(), new ArrayList());
            try {
                if (CollectionUtils.isNotEmpty((Collection)nacosEaiHeaders)) {
                    this.eaiHeaderUtil.addAndUpdateCommonsHeaders(nacosEaiHeaders);
                }
                List<DWHeader> modelDrivenGroupHeaders = this.eaiHeaderUtil.getCommonsEaiHeaders();
                modelDrivenGroupHeaders.stream().filter(commonsEaiHeader -> nacosEaiHeaders.stream().noneMatch(newNacosHeader -> ((DWEAIHeader)commonsEaiHeader).getEAIServiceId().equals(newNacosHeader.getEAIServiceId()))).forEach(commonsEaiHeader -> nacosEaiHeaders.add((DWEAIHeader)commonsEaiHeader));
                Thread.sleep(2000L);
                log.info("{} nacos service start register, size:{}", (Object)CLASS_LOG_TAG, (Object)nacosEaiHeaders.size());
                this.nacosRegisterUtils.registerService(nacosEaiHeaders);
                log.info("{} nacos service registered finished", (Object)CLASS_LOG_TAG);
            }
            catch (Exception e) {
                String errorRootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
                log.error("{} nacos service register failed:{}", (Object)CLASS_LOG_TAG, (Object)errorRootCauseMessage);
                throw new RuntimeException("nacos service register failed", e);
            }
            this.bmProperties.setInitRegEvent(true);
            log.info("{}[onApplicationEvent] finished ({})", (Object)CLASS_LOG_TAG, event.getClass());
        } else if (event instanceof NacosServiceRegisterEvent) {
            try {
                log.debug("{} process NacosServiceRegisterEvent", (Object)CLASS_LOG_TAG);
                if (ModelDrivenProperties.getProperties().isNacosEnabledRegistration()) {
                    this.nacosRegisterUtils.nacosServiceRegister((List)event.getSource());
                }
            }
            catch (Exception e) {
                String errorRootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
                log.error("{} nacos service register failed:{}", (Object)CLASS_LOG_TAG, (Object)errorRootCauseMessage);
                throw new RuntimeException("nacos service register failed", e);
            }
        }
        log.debug("{}[onApplicationEvent] end ({})", (Object)CLASS_LOG_TAG, event.getClass());
    }
}

