/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.dataview.utils;

import com.digiwin.app.service.DWEAIResult;
import com.digiwin.lcdp.modeldriven.eoc.ModelDrivenEocService;
import com.digiwin.lcdp.modeldriven.eoc.pojo.EmpInfoData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrganizationUtil {
    private static final Logger log = LoggerFactory.getLogger(OrganizationUtil.class);
    private static final String LOG_ERROR_MESSAGE_FORMAT = "eoc error code({}), message({})";
    private final ModelDrivenEocService modelDrivenEocService;

    @Autowired
    public OrganizationUtil(Optional<ModelDrivenEocService> optionalModelDrivenEocService) {
        this.modelDrivenEocService = optionalModelDrivenEocService.orElse(null);
    }

    public List<String> getEmpId() {
        String eocEmpId = null;
        try {
            Object empInfoDataObject = this.modelDrivenEocService.getEmpInfo();
            if (empInfoDataObject instanceof EmpInfoData) {
                EmpInfoData empInfoData = (EmpInfoData)empInfoDataObject;
                eocEmpId = empInfoData.getId();
            } else {
                DWEAIResult dweaiResult = (DWEAIResult)empInfoDataObject;
                log.debug(LOG_ERROR_MESSAGE_FORMAT, (Object)dweaiResult.getCode(), (Object)dweaiResult.getParameter());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(eocEmpId);
        return result;
    }

    public List<String> getDeptId() {
        String eocEmpDeptId = null;
        try {
            Object empInfoDataObject = this.modelDrivenEocService.getEmpInfo();
            if (empInfoDataObject instanceof EmpInfoData) {
                EmpInfoData empInfoData = (EmpInfoData)empInfoDataObject;
                eocEmpDeptId = empInfoData.getDepts().get(0).getId();
            } else {
                DWEAIResult dweaiResult = (DWEAIResult)empInfoDataObject;
                log.debug(LOG_ERROR_MESSAGE_FORMAT, (Object)dweaiResult.getCode(), (Object)dweaiResult.getParameter());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(eocEmpDeptId);
        return result;
    }

    public List<Object> getDeptIdAll() {
        Object deptIdsAllObject = null;
        try {
            deptIdsAllObject = this.modelDrivenEocService.getDeptIdAll();
            if (deptIdsAllObject instanceof List) {
                log.debug("eoc deptIds({}))", deptIdsAllObject);
            } else {
                DWEAIResult dweaiResult = (DWEAIResult)deptIdsAllObject;
                log.debug(LOG_ERROR_MESSAGE_FORMAT, (Object)dweaiResult.getCode(), (Object)dweaiResult.getParameter());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll((List)deptIdsAllObject);
        return result;
    }
}

