/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.event;

import com.digiwin.http.client.DWHttpClient;
import com.digiwin.lcdp.modeldriven.config.ModelDrivenCommonsAutoConfiguration;
import com.digiwin.lcdp.modeldriven.event.EaiRegisterApplicationListener;
import com.digiwin.lcdp.modeldriven.event.EaiRegisterEventCondition;
import com.digiwin.lcdp.modeldriven.event.EaiRegisterEventProperties;
import com.digiwin.lcdp.modeldriven.event.EaiRegisterEventPublisher;
import com.digiwin.lcdp.modeldriven.event.EaiRegisterProcessor;
import com.digiwin.lcdp.modeldriven.event.EaiRegisterThreadProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.handler.IgnoreTopLevelConverterNotFoundBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableAsync
@AutoConfigureAfter(value={ModelDrivenCommonsAutoConfiguration.class})
@Configuration
public class EaiDynamicRegisterAutoConfiguration {
    private static final Logger _log = LoggerFactory.getLogger(EaiDynamicRegisterAutoConfiguration.class);
    private static final String CLASS_LOG_TAG = "[" + EaiDynamicRegisterAutoConfiguration.class.getSimpleName() + "]";

    @Bean(name={"lcdp-eai-reg-event-properties"})
    @Conditional(value={EaiRegisterEventCondition.class})
    public EaiRegisterEventProperties eaiRegisterEventProperties(ApplicationContext context) {
        EaiRegisterEventProperties eaiRegisterEventProperties = null;
        Binder binder = Binder.get((Environment)context.getEnvironment());
        IgnoreTopLevelConverterNotFoundBindHandler handler = new IgnoreTopLevelConverterNotFoundBindHandler();
        ConfigurationPropertyName cfgPropertyName = ConfigurationPropertyName.of((CharSequence)"lcdp.eai.reg.event");
        BindResult bindResult = binder.bind(cfgPropertyName, Bindable.of(EaiRegisterEventProperties.class), (BindHandler)handler);
        eaiRegisterEventProperties = bindResult.isBound() ? (EaiRegisterEventProperties)bindResult.get() : new EaiRegisterEventProperties();
        _log.info("{} bean:{} ({}) created!", new Object[]{CLASS_LOG_TAG, "lcdp-eai-reg-event-properties", eaiRegisterEventProperties});
        return eaiRegisterEventProperties;
    }

    @Bean(name={"lcdp-eai-reg-event-thread-properties"})
    @ConditionalOnBean(name={"lcdp-eai-reg-event-properties"})
    public EaiRegisterThreadProperties eventThreadProperties(ApplicationContext context) {
        Binder binder = Binder.get((Environment)context.getEnvironment());
        IgnoreTopLevelConverterNotFoundBindHandler handler = new IgnoreTopLevelConverterNotFoundBindHandler();
        ConfigurationPropertyName cfgPropertyName = ConfigurationPropertyName.of((CharSequence)"lcdp.eai.reg.event.thread");
        BindResult bindResult = binder.bind(cfgPropertyName, Bindable.of(EaiRegisterThreadProperties.class), (BindHandler)handler);
        EaiRegisterThreadProperties threadProperties = null;
        threadProperties = bindResult.isBound() ? (EaiRegisterThreadProperties)bindResult.get() : new EaiRegisterThreadProperties();
        _log.info("{} bean:{}({}) created!", new Object[]{CLASS_LOG_TAG, "lcdp-eai-reg-event-thread-properties", threadProperties});
        return threadProperties;
    }

    @Bean(name={"lcdp-eai-reg-event-executor"})
    @ConditionalOnBean(name={"lcdp-eai-reg-event-thread-properties"})
    public ThreadPoolTaskExecutor eventExecutor(@Qualifier(value="lcdp-eai-reg-event-thread-properties") EaiRegisterThreadProperties eventThreadProperties) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("lcdp-eai-reg-event-exec-");
        executor.setCorePoolSize(eventThreadProperties.getCorePoolSize());
        executor.setMaxPoolSize(eventThreadProperties.getMaximumPoolSize());
        executor.setQueueCapacity(eventThreadProperties.getWorkQueueSize());
        executor.setKeepAliveSeconds(eventThreadProperties.getKeepAliveTime());
        _log.info("{} bean:{} created!", (Object)CLASS_LOG_TAG, (Object)"lcdp-eai-reg-event-executor");
        return executor;
    }

    @Bean(name={"lcdp-eai-reg-event-publisher"})
    @ConditionalOnBean(name={"lcdp-eai-reg-event-properties"})
    public EaiRegisterEventPublisher getEaiRegisterEventPublisher(@Qualifier(value="lcdp-eai-reg-event-properties") EaiRegisterEventProperties eaiRegisterEventProperties) {
        EaiRegisterEventPublisher eaiRegisterEventPublisher = new EaiRegisterEventPublisher();
        _log.info("{} bean:{} created!", (Object)CLASS_LOG_TAG, (Object)"lcdp-eai-reg-event-publisher");
        return eaiRegisterEventPublisher;
    }

    @Bean(name={"lcdp-eai-reg-service-processor"})
    @ConditionalOnBean(name={"lcdp-eai-reg-event-properties"})
    public EaiRegisterProcessor getEaiRegisterProcessor(DWHttpClient dwHttpClient) {
        EaiRegisterProcessor eaiRegisterProcessor = new EaiRegisterProcessor();
        _log.info("{} bean:{} created!", (Object)CLASS_LOG_TAG, (Object)"lcdp-eai-reg-service-processor");
        return eaiRegisterProcessor;
    }

    @Bean(name={"lcdp-eai-reg-event-listener"})
    @ConditionalOnBean(name={"lcdp-eai-reg-event-publisher"})
    public EaiRegisterApplicationListener getEaiRegisterApplicationListener(@Qualifier(value="lcdp-eai-reg-service-processor") EaiRegisterProcessor eaiRegisterProcessor) {
        EaiRegisterApplicationListener eaiRegisterApplicationListener = new EaiRegisterApplicationListener();
        _log.info("{} bean:{} created!", (Object)CLASS_LOG_TAG, (Object)"lcdp-eai-reg-event-listener");
        return eaiRegisterApplicationListener;
    }
}

