/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.container.DWMethod;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.eai.EAIService;
import com.digiwin.lcdp.modeldriven.enums.ModelApiTypeEnum;
import com.digiwin.lcdp.modeldriven.pojo.BindApi;
import com.digiwin.lcdp.modeldriven.utils.ApiTypeUtil;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiTypeBMUtil {
    private static final Logger logger = LoggerFactory.getLogger(ApiTypeBMUtil.class);
    private static final String CLASS_LOG_TAG = "[" + ApiTypeBMUtil.class.getSimpleName() + "]";
    private static final String BM_EAI_SERVICE_ID_PREFIX = "lcdp.bm.crud.eai.";
    private static final String BMD_EAI_SERVICE_ID_PREFIX = "lcdp.bmd.crud.eai.";
    public static final String DELETE = "delete";

    private ApiTypeBMUtil() {
    }

    public static String getApiTypeForBMDataLayer(DWEAIHeader eaiHeader, List<BindApi> bmdApiListConfig, boolean hasBindApiList) {
        String apiType = hasBindApiList ? ApiTypeUtil.getApiType(eaiHeader, bmdApiListConfig) : ApiTypeBMUtil.getApiTypeInBMDataLayer(eaiHeader);
        return apiType;
    }

    public static String getStdApiType(String methodName, String postfix) {
        String serviceType = null;
        block6 : switch (methodName) {
            case "get": {
                if (StringUtils.isNotBlank((CharSequence)postfix)) {
                    switch (postfix) {
                        case "list.get": {
                            serviceType = ModelApiTypeEnum.LIST.getApiTypeName();
                            break block6;
                        }
                        case "detail.get": {
                            serviceType = ModelApiTypeEnum.DETAIL.getApiTypeName();
                            break block6;
                        }
                    }
                    serviceType = ModelApiTypeEnum.LIST.getApiTypeName();
                    break;
                }
                serviceType = ModelApiTypeEnum.LIST.getApiTypeName();
                break;
            }
            case "post": {
                serviceType = ModelApiTypeEnum.CREATE.getApiTypeName();
                break;
            }
            case "put": {
                if (StringUtils.isNotBlank((CharSequence)postfix)) {
                    switch (postfix) {
                        case "valid": {
                            serviceType = ModelApiTypeEnum.VALID.getApiTypeName();
                            break block6;
                        }
                        case "invalid": {
                            serviceType = ModelApiTypeEnum.INVALID.getApiTypeName();
                            break block6;
                        }
                    }
                    serviceType = ModelApiTypeEnum.UPDATE.getApiTypeName();
                    break;
                }
                serviceType = ModelApiTypeEnum.UPDATE.getApiTypeName();
                break;
            }
            case "delete": {
                serviceType = ModelApiTypeEnum.DELETE.getApiTypeName();
                break;
            }
        }
        logger.debug("{} apiType:{} hitStyle:{}", new Object[]{CLASS_LOG_TAG, serviceType, "IBMEAICrudService"});
        return serviceType;
    }

    private static String getApiTypeInBMDataLayer(DWEAIHeader eaiHeader) {
        EAIService methodAnnotation;
        String methodAnnotEaiId;
        String serviceType = null;
        DWMethod dwMethod = eaiHeader.getMappingMethod();
        Method method = dwMethod.getMethod();
        if (dwMethod.getMethod().isAnnotationPresent(EAIService.class) && (methodAnnotEaiId = (methodAnnotation = method.getAnnotation(EAIService.class)).id()).startsWith(BMD_EAI_SERVICE_ID_PREFIX)) {
            switch (methodAnnotEaiId) {
                case "lcdp.bmd.crud.eai.get": {
                    serviceType = ModelApiTypeEnum.LIST.getApiTypeName();
                    break;
                }
                case "lcdp.bmd.crud.eai.create": {
                    serviceType = ModelApiTypeEnum.CREATE.getApiTypeName();
                    break;
                }
                case "lcdp.bmd.crud.eai.update": {
                    serviceType = ModelApiTypeEnum.UPDATE.getApiTypeName();
                    break;
                }
                case "lcdp.bmd.crud.eai.delete": {
                    serviceType = ModelApiTypeEnum.DELETE.getApiTypeName();
                    break;
                }
            }
        }
        return serviceType;
    }

    public static String getApiTypeInBMBusinessLayer(DWEAIHeader eaiHeader) {
        EAIService methodAnnotation;
        String methodAnnotEaiId;
        String serviceType = null;
        DWMethod dwMethod = eaiHeader.getMappingMethod();
        Method method = dwMethod.getMethod();
        if (dwMethod.getMethod().isAnnotationPresent(EAIService.class) && (methodAnnotEaiId = (methodAnnotation = method.getAnnotation(EAIService.class)).id()).startsWith(BM_EAI_SERVICE_ID_PREFIX)) {
            switch (methodAnnotEaiId) {
                case "lcdp.bm.crud.eai.get": {
                    serviceType = ModelApiTypeEnum.LIST.getApiTypeName();
                    break;
                }
                case "lcdp.bm.crud.eai.create": {
                    serviceType = ModelApiTypeEnum.CREATE.getApiTypeName();
                    break;
                }
                case "lcdp.bm.crud.eai.update": {
                    serviceType = ModelApiTypeEnum.UPDATE.getApiTypeName();
                    break;
                }
                case "lcdp.bm.crud.eai.delete": {
                    serviceType = ModelApiTypeEnum.DELETE.getApiTypeName();
                    break;
                }
            }
        }
        return serviceType;
    }
}

