/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.lcdp.modeldriven.constants.ModelSqlConstants;
import java.util.Date;

public class DBTableUtil {
    private DBTableUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String addBackQuoteSymbol(String name) {
        if (name != null && !name.matches("^`.*`$")) {
            return "`" + name + "`";
        }
        return name;
    }

    public static String removeBackQuoteSymbol(String name) {
        if (name != null) {
            return name.replace("`", "");
        }
        return name;
    }

    public static String addApostropheSymbol(String name) {
        if (name != null && !name.matches("^'.*'$")) {
            return "'" + name + "'";
        }
        return name;
    }

    public static String removeApostropheSymbol(String name) {
        if (name == null) {
            return name;
        }
        return name.replace("'", "");
    }

    public static String getValueDataForSql(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return DBTableUtil.addApostropheSymbol(value.toString());
        }
        String returnValue = value instanceof Date ? DBTableUtil.addApostropheSymbol(ModelSqlConstants.BIND_SQL_DATETIME_FORMAT.format(value)) : value.toString();
        return returnValue;
    }
}

