/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.gateway.controller.EaiInfoUtils;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.entity.DWJsonEntity;
import com.digiwin.lcdp.modeldriven.config.ModelDrivenProperties;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.event.EaiRegDataInfo;
import com.digiwin.lcdp.modeldriven.event.EaiRegisterEventProperties;
import com.digiwin.lcdp.modeldriven.event.EaiRegisterEventPublisher;
import com.digiwin.lcdp.modeldriven.event.EaiServiceRegisterEvent;
import com.digiwin.lcdp.modeldriven.utils.ModelStringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class EaiRegisterUtil {
    private static final Logger log = LoggerFactory.getLogger(EaiRegisterUtil.class);
    private static final String CLASS_LOG_TAG = "[" + EaiRegisterUtil.class.getSimpleName() + "]";
    private final DWEAIProperties eaiProperties;
    private final DWHttpClient dwHttpClient;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final EaiRegisterEventProperties eaiRegisterEventProperties;
    private final EaiRegisterEventPublisher eaiRegisterEventPublisher;
    private final ModelDrivenProperties modelDrivenProperties;

    @Autowired
    public EaiRegisterUtil(DWEAIProperties eaiProperties, DWHttpClient dwHttpClient, ApplicationEventPublisher applicationEventPublisher, @Qualifier(value="lcdp-eai-reg-event-properties") Optional<EaiRegisterEventProperties> optionalEaiRegisterEventProperties, @Qualifier(value="lcdp-eai-reg-event-publisher") Optional<EaiRegisterEventPublisher> optionalEaiRegisterEventPublisher, @Qualifier(value="dw-modeldriven-properties") Optional<ModelDrivenProperties> optionalModelDrivenProperties) {
        this.eaiProperties = eaiProperties;
        this.dwHttpClient = dwHttpClient;
        this.applicationEventPublisher = applicationEventPublisher;
        this.eaiRegisterEventProperties = optionalEaiRegisterEventProperties.orElse(null);
        this.eaiRegisterEventPublisher = optionalEaiRegisterEventPublisher.orElse(null);
        this.modelDrivenProperties = optionalModelDrivenProperties.orElse(null);
    }

    public Object autoRegisterEAI(List<DWEAIHeader> newEaiHeaders, String code) throws Exception {
        return this.registerService(newEaiHeaders, code);
    }

    public Object autoRegisterEAI(List<DWEAIHeader> newEaiHeaders) {
        return this.registerService(newEaiHeaders);
    }

    public Object registerService(List<DWEAIHeader> newEaiHeaders, String code) throws Exception {
        Map resultValue = new HashMap();
        if (!this.modelDrivenProperties.isEspEnabledRegistration()) {
            log.warn("{}[registerService] 1 ignored reg esp, cause disabled(properties:eaiAutoRegistrationEnable)", (Object)CLASS_LOG_TAG);
            return resultValue;
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{this.eaiRegisterEventPublisher, this.eaiRegisterEventProperties}) && this.eaiRegisterEventProperties.isAsync()) {
            log.debug("{}[autoRegisterEAI] using ASync... code({}) eaiRegisterEventPublisher ({}), eaiRegisterEventProperties({})", new Object[]{CLASS_LOG_TAG, code, this.eaiRegisterEventPublisher, this.eaiRegisterEventProperties});
            EaiRegDataInfo eaiRegDataInfo = new EaiRegDataInfo();
            eaiRegDataInfo.setEaiHeaders(newEaiHeaders);
            eaiRegDataInfo.setModelCodeName(code);
            eaiRegDataInfo.setEaiProperties(this.eaiProperties);
            EaiServiceRegisterEvent dataEvent = new EaiServiceRegisterEvent(eaiRegDataInfo);
            log.debug("[autoRegisterEAI] starting call eaiRegisterEventPublisher in code({})", (Object)code);
            this.eaiRegisterEventPublisher.publishDataChangeEvent(dataEvent);
            log.debug("[autoRegisterEAI] finished call eaiRegisterEventPublisher in code({})", (Object)code);
            return resultValue;
        }
        log.debug("using Sync... code({}) eaiRegisterEventPublisher({}), eaiRegisterEventProperties({})", new Object[]{code, this.eaiRegisterEventPublisher, this.eaiRegisterEventProperties});
        List newEaiServiceIds = newEaiHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList());
        log.info("EAI Services start auto-registering code({}), newEaiServiceIds({})...", (Object)code, newEaiServiceIds);
        resultValue = EaiInfoUtils.getSrvRegInfo(() -> newEaiServiceIds, (DWEAIProperties)this.eaiProperties);
        HttpPost post = new HttpPost(EaiInfoUtils.getEAIRegSrvURL());
        post.setEntity((HttpEntity)new DWJsonEntity(resultValue));
        EntityUtils.toString((HttpEntity)post.getEntity(), (Charset)StandardCharsets.UTF_8);
        post.addHeader("digi-action", "reg");
        CloseableHttpResponse responseReturn = null;
        try (CloseableHttpResponse response = (CloseableHttpResponse)this.dwHttpClient.execute((HttpUriRequest)post, new DWRequestOption(false));){
            responseReturn = response;
            HttpEntity httpEntity = response.getEntity();
            String responseBody = EaiRegisterUtil.getResponseBody(httpEntity);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                log.error("Something wrong in the process of eai services auto-registration...");
                log.error(responseBody);
            } else {
                log.info("EAI Services have registered automatically.");
            }
        }
        catch (Exception e) {
            log.error("eai auto register failed!", (Throwable)e);
        }
        return responseReturn;
    }

    public Object registerService(List<DWEAIHeader> newEaiHeaders) {
        HashMap resultValue = new HashMap();
        if (!this.modelDrivenProperties.isEspEnabledRegistration()) {
            log.warn("{}[registerService] 2 ignored reg esp, cause disabled(properties:eaiAutoRegistrationEnable)", (Object)CLASS_LOG_TAG);
            return resultValue;
        }
        log.debug("{}[registerService] using ASync(eaiRegisterEventPublisher), eaiRegisterEventProperties({})", (Object)CLASS_LOG_TAG, (Object)this.eaiRegisterEventProperties);
        EaiRegDataInfo eaiRegDataInfo = new EaiRegDataInfo();
        eaiRegDataInfo.setEaiHeaders(newEaiHeaders);
        eaiRegDataInfo.setEaiProperties(this.eaiProperties);
        EaiServiceRegisterEvent dataEvent = new EaiServiceRegisterEvent(eaiRegDataInfo);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)dataEvent);
        return resultValue;
    }

    public Object registerService(List<DWEAIHeader> newEaiHeaders, DWEAIProperties eaiProperties) {
        HashMap resultValue = new HashMap();
        if (!this.modelDrivenProperties.isEspEnabledRegistration()) {
            log.warn("{}[registerService] 3 ignored reg esp, cause disabled(properties:eaiAutoRegistrationEnable)", (Object)CLASS_LOG_TAG);
            return resultValue;
        }
        log.debug("{}[registerService] using ASync...  eaiRegisterEventPublisher ({}), eaiRegisterEventProperties({})", new Object[]{CLASS_LOG_TAG, this.eaiRegisterEventPublisher, this.eaiRegisterEventProperties});
        EaiRegDataInfo eaiRegDataInfo = new EaiRegDataInfo();
        eaiRegDataInfo.setModelCodeName(ModelDrivenContext.getContext().getCode());
        eaiRegDataInfo.setEaiHeaders(newEaiHeaders);
        eaiRegDataInfo.setEaiProperties(eaiProperties);
        EaiServiceRegisterEvent dataEvent = new EaiServiceRegisterEvent(eaiRegDataInfo);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)dataEvent);
        return resultValue;
    }

    public static String getEaiServicePrefixOfProd(String prod) {
        return ModelStringUtil.replaceUnderScoreAndDashToDot(prod.toLowerCase());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpResponse tryEaiPath(String eaiRegProdPath) throws UnsupportedEncodingException, InterruptedException {
        this.tryLocalEaiPath();
        String body = "{}";
        HttpPost post = new HttpPost(eaiRegProdPath);
        post.setEntity((HttpEntity)new DWJsonEntity((Object)body));
        post.setHeader("digi-action", "reg");
        String threadName = Thread.currentThread().getName();
        int retryCount = 0;
        while (true) {
            try (CloseableHttpResponse response = (CloseableHttpResponse)this.dwHttpClient.execute((HttpUriRequest)post, new DWRequestOption(false));){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    log.info("{}[tryEaiPath-{}] TH:{} >>> '{}' invoke success", new Object[]{CLASS_LOG_TAG, retryCount, threadName, eaiRegProdPath});
                    CloseableHttpResponse closeableHttpResponse = response;
                    return closeableHttpResponse;
                }
                log.error("{}[tryEaiPath-{}] TH:{} >>> '{}' is not ready to be invoked(localEai passed), responseStatus is {}, it'll be retry after 5 seconds", new Object[]{CLASS_LOG_TAG, retryCount, threadName, eaiRegProdPath, statusCode});
            }
            catch (IOException e) {
                log.error("{}[tryEaiPath-{}] TH:{} >>> Type-1 '{}' is not ready to be invoked, caused by exception:{}", new Object[]{CLASS_LOG_TAG, retryCount, threadName, eaiRegProdPath, ExceptionUtils.getMessage((Throwable)e)});
                ++retryCount;
            }
            log.error("{}[tryEaiPath-{}] TH:{} >>> Type-2 '{}' is not ready and sleep 5 seconds", new Object[]{CLASS_LOG_TAG, retryCount, threadName, eaiRegProdPath});
            Thread.sleep(5000L);
            ++retryCount;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpResponse tryLocalEaiPath() throws UnsupportedEncodingException, InterruptedException {
        String localIp = "127.0.0.1";
        String localPort = DWApplicationConfigUtils.getProperty((String)"serverPort");
        String localServiceUri = String.format("http://%s:%s/eai", localIp, localPort);
        int retryCount = 0;
        String body = "{}";
        HttpPost post = new HttpPost(localServiceUri);
        post.setEntity((HttpEntity)new DWJsonEntity((Object)body));
        post.setHeader("digi-action", "reg");
        String threadName = Thread.currentThread().getName();
        while (true) {
            try (CloseableHttpResponse response = (CloseableHttpResponse)this.dwHttpClient.execute((HttpUriRequest)post, new DWRequestOption(false));){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    log.info("{}[tryLocalEaiPath-{}] TH:{} >>> '{}' invoke success", new Object[]{CLASS_LOG_TAG, retryCount, threadName, localServiceUri});
                    CloseableHttpResponse closeableHttpResponse = response;
                    return closeableHttpResponse;
                }
                log.error("{}[tryLocalEaiPath-{}] TH:{} >>> '{}' is not ready to be invoked, responseStatus is {}, it'll be retry after 5 seconds", new Object[]{CLASS_LOG_TAG, retryCount, threadName, localServiceUri, statusCode});
            }
            catch (IOException e) {
                log.error("{}[tryLocalEaiPath-{}] TH:{} >>> Type-1 '{}' is not ready to be invoked(will sleep 5 seconds), caused by exception:{}", new Object[]{CLASS_LOG_TAG, retryCount, threadName, localServiceUri, ExceptionUtils.getMessage((Throwable)e)});
                ++retryCount;
            }
            log.error("{}[tryLocalEaiPath-{}] TH:{} >>> Type-2 '{}' is not ready and sleep 5 seconds", new Object[]{CLASS_LOG_TAG, retryCount, threadName, localServiceUri});
            Thread.sleep(5000L);
            ++retryCount;
        }
    }

    public HttpResponse retryRegProdApSrv(HttpPost post, DWHttpClient dwHttpClient) {
        CloseableHttpResponse responseReturn;
        long iRetryInterval = 5000L;
        while (true) {
            log.info("retryRegProdApSrv --> url({})", (Object)post.getURI());
            try {
                CloseableHttpResponse response = (CloseableHttpResponse)dwHttpClient.execute((HttpUriRequest)post, new DWRequestOption(false));
                Throwable throwable = null;
                try {
                    responseReturn = response;
                    HttpEntity httpEntity = response.getEntity();
                    String responseBody = EaiRegisterUtil.getResponseBody(httpEntity);
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode != 200) {
                        log.error("retryRegProdApSrv Something wrong in the process of eai services auto-registration, httpCode:{}, response:{}", (Object)statusCode, (Object)responseBody);
                        Thread.sleep(iRetryInterval);
                        continue;
                    }
                    Map responseBodyMap = (Map)DWGsonProvider.getGson().fromJson(responseBody, Map.class);
                    String errorOrCodeValue = "";
                    if (responseBodyMap.containsKey("error")) {
                        errorOrCodeValue = (String)responseBodyMap.get("error");
                    } else if (responseBodyMap.containsKey("errorCode")) {
                        errorOrCodeValue = (String)responseBodyMap.get("errorCode");
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)errorOrCodeValue)) {
                        log.info("retryRegProdApSrv success, httpCode:{}, error({}), response:{}", new Object[]{statusCode, errorOrCodeValue, post.getURI()});
                        break;
                    }
                    log.info("retryRegProdApSrv failed,  httpCode:{}, error({}), response:{}", new Object[]{errorOrCodeValue, statusCode, responseBody});
                    responseReturn.setStatusCode(417);
                    Thread.sleep(iRetryInterval);
                    log.info("ESP response ==> httpCode:{}, message:{}", (Object)statusCode, (Object)responseBody);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    response.close();
                }
            }
            catch (IOException | InterruptedException e) {
                log.error("Type-1  eai auto register failed!", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        log.info("EAI Services have registered automatically. responseReturn({})", (Object)responseReturn);
        return responseReturn;
    }

    private static String getResponseBody(HttpEntity httpEntity) throws IOException {
        InputStream responseStream;
        String responseBody = "";
        if (httpEntity != null && (responseStream = httpEntity.getContent()) != null) {
            responseBody = IOUtils.toString((InputStream)responseStream, (Charset)StandardCharsets.UTF_8);
        }
        return responseBody;
    }
}

