/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.lcdp.modeldriven.constants.ModelDBConstants;
import com.digiwin.lcdp.modeldriven.constants.ModelDrivenConstants;
import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.ModelApiTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.ModelFieldRelationTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelApiField;
import com.digiwin.lcdp.modeldriven.model.ModelApiFieldStateTransferConfig;
import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.BindApi;
import com.digiwin.lcdp.modeldriven.pojo.ModelDrivenDataPermissionIdData;
import com.digiwin.lcdp.modeldriven.report.model.SqlValueFields;
import com.digiwin.lcdp.modeldriven.utils.ModelQuerySelectUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import com.digiwin.utils.DWTenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamValidateUtil {
    private static final Logger log = LoggerFactory.getLogger(ParamValidateUtil.class);
    private static final String CLASS_LOG_TAG = "[" + ParamValidateUtil.class.getSimpleName() + "]";

    private ParamValidateUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void validateRequestParamWithPkAndBk(List<Map<String, Object>> paramDatas, ModelSchemaDTO masterModelSchema, ModelApiTypeEnum apiType) {
        ParamValidateUtil.validateRequestParam(paramDatas, masterModelSchema, apiType, true);
    }

    public static void validateRequestParamWithoutPkAndBk(List<Map<String, Object>> paramDatas, ModelSchemaDTO masterModelSchema, ModelApiTypeEnum apiType) {
        ParamValidateUtil.validateRequestParam(paramDatas, masterModelSchema, apiType, false);
    }

    public static void validateRequestParam(List<Map<String, Object>> paramDatas, ModelSchemaDTO masterModelSchema, ModelApiTypeEnum apiType, boolean validatePkAndBk) {
        Optional<BindApi> apiConfigOpt;
        Map<String, ModelSchemaDTO> modelSchemaMap = ModelSchemaUtil.getModelSchemaMap(masterModelSchema);
        Map<String, List<Map<String, Object>>> tileParamDatas = ParamValidateUtil.tileParameters(masterModelSchema, paramDatas);
        Map<String, List<ModelApiField>> tileRequestParamOfApiConfig = null;
        List<BindApi> bindApiListConfig = masterModelSchema.getBindApiListConfig();
        if (CollectionUtils.isNotEmpty(bindApiListConfig) && (apiConfigOpt = bindApiListConfig.stream().filter(apiConfig -> apiType.getValue().equals(apiConfig.getApiType())).findFirst()).isPresent()) {
            tileRequestParamOfApiConfig = ParamValidateUtil.tileApiField(apiConfigOpt.get().getApiConfig().getRequest_parameters());
        }
        for (Map.Entry<String, List<Map<String, Object>>> next : tileParamDatas.entrySet()) {
            String tableName = next.getKey();
            List<Map<String, Object>> paramData = next.getValue();
            if (!CollectionUtils.isNotEmpty(paramData)) continue;
            ModelSchemaDTO targetModelSchema = modelSchemaMap.get(tableName);
            for (Map<String, Object> data : paramData) {
                if (tileRequestParamOfApiConfig != null) {
                    ParamValidateUtil.validateAndFilterByApiConfig(data, tileRequestParamOfApiConfig.get(tableName));
                    continue;
                }
                if (!tableName.equals(masterModelSchema.getName()) || !validatePkAndBk) continue;
                ParamValidateUtil.validatePKAndBK(data, targetModelSchema);
            }
        }
    }

    public static ModelDrivenDataPermissionIdData validateSqlFields(SqlValueFields sqlValueFields) {
        String appId = Optional.ofNullable(sqlValueFields.getAppId()).orElseThrow(() -> new RuntimeException("appId of view_info can not be null"));
        String actionId = Optional.ofNullable(sqlValueFields.getActionId()).orElseThrow(() -> new RuntimeException("actionId of view_info can not be null"));
        String moduleId = Optional.ofNullable(sqlValueFields.getModuleId()).orElseThrow(() -> new RuntimeException("moduleId of view_info can not be null"));
        String tenantId = Optional.ofNullable(sqlValueFields.getTenantId()).orElseThrow(() -> new RuntimeException("tenantId of view_info can not be null"));
        String userId = Optional.ofNullable(sqlValueFields.getUserId()).orElseThrow(() -> new RuntimeException("userId of view_info can not be null"));
        return new ModelDrivenDataPermissionIdData(appId, actionId, moduleId, tenantId, userId);
    }

    public static Map<String, List<ModelApiField>> getApiResponseConfigByApiType(ModelSchemaDTO masterModelSchema, ModelApiTypeEnum apiType) {
        BindApi apiConfig2;
        Optional<BindApi> detailGetApiConfigOpt;
        Map<String, List<ModelApiField>> tileApiConfig = new HashMap<String, List<ModelApiField>>();
        if (masterModelSchema.getBindApiListConfig() != null && (detailGetApiConfigOpt = masterModelSchema.getBindApiListConfig().stream().filter(apiConfig -> apiType.getValue().equals(apiConfig.getApiType())).findFirst()).isPresent() && CollectionUtils.isNotEmpty((apiConfig2 = detailGetApiConfigOpt.get()).getApiConfig().getResponse_object())) {
            tileApiConfig = ParamValidateUtil.tileApiField(apiConfig2.getApiConfig().getResponse_object());
        }
        return tileApiConfig;
    }

    public static void validateManageStatusSource(List<Map<String, Object>> sourceDatas, List<Map<String, Object>> paramDatas, ModelSchemaDTO masterModelSchema, ModelApiTypeEnum apiType) {
        Map<Object, Object> tileApiConfig = new HashMap();
        List<BindApi> bindApiListConfig = masterModelSchema.getBindApiListConfig();
        if (CollectionUtils.isNotEmpty(bindApiListConfig)) {
            Optional<ModelApiField> manageStatusOpt;
            List modelApiFields;
            Optional<BindApi> apiConfigOpt = bindApiListConfig.stream().filter(apiConfig -> apiType.getValue().equals(apiConfig.getApiType())).findFirst();
            if (apiConfigOpt.isPresent()) {
                tileApiConfig = ParamValidateUtil.tileApiField(apiConfigOpt.get().getApiConfig().getRequest_parameters());
            }
            if (CollectionUtils.isNotEmpty((Collection)(modelApiFields = (List)tileApiConfig.get(masterModelSchema.getName()))) && (manageStatusOpt = modelApiFields.stream().filter(modelApiField -> "manage_status".equals(modelApiField.getData_name())).findFirst()).isPresent()) {
                ModelApiField manageStatusField = manageStatusOpt.get();
                ModelApiFieldStateTransferConfig manageStatusConfig = manageStatusField.getStateTransferConfig();
                ParamValidateUtil.updateParam(manageStatusField, manageStatusConfig, sourceDatas, paramDatas);
            }
        }
    }

    public static void updateParam(ModelApiField manageStatusField, ModelApiFieldStateTransferConfig manageStatusConfig, List<Map<String, Object>> sourceDatas, List<Map<String, Object>> paramDatas) {
        if (!manageStatusField.getShow()) {
            List errorSourceDatas = sourceDatas.stream().filter(data -> !manageStatusConfig.getSourceId().equals(data.get("manage_status"))).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(errorSourceDatas)) {
                String formatString = ResourceBundleUtils.getString("paramValidate.apiConfig.errorPrefix") + ResourceBundleUtils.getString("paramValidate.apiConfig.managestatusStateError");
                Map.Entry manageStatus = (Map.Entry)((Object)((Map)errorSourceDatas.get(0)).entrySet());
                String message = String.format(formatString, manageStatus);
                throw new IllegalArgumentException(message);
            }
            paramDatas.forEach(paramData -> paramData.put("manage_status", manageStatusConfig.getTargetIds()));
        }
    }

    public static Map<String, List<Map<String, Object>>> tileParameters(ModelSchemaDTO modelSchema, List<Map<String, Object>> masterTableParams) {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>();
        ArrayList newMasterTableRows = new ArrayList();
        masterTableParams.forEach(eachTableParam -> {
            List<ModelSchemaDTO> childrenModelSchema = modelSchema.getChildren();
            HashMap newMasterTableRow = new HashMap();
            eachTableParam.forEach((currentFieldName, currentFieldValue) -> {
                List childTableNames = childrenModelSchema.stream().map(ModelSchemaDTO::getName).collect(Collectors.toList());
                if (childTableNames.contains(currentFieldName)) {
                    List<Map<String, Object>> childrenTableParamterRows = ParamValidateUtil.getAllRowData(currentFieldValue);
                    Map<String, List<Map<String, Object>>> childrenTableDatas = ParamValidateUtil.tileParameters(childrenModelSchema.stream().filter(schema -> schema.getName().equalsIgnoreCase((String)currentFieldName)).findFirst().get(), childrenTableParamterRows);
                    childrenTableDatas.forEach((childrenTableName, childrenTableRows) -> result.computeIfAbsent((String)childrenTableName, k -> new ArrayList()).addAll(childrenTableRows));
                } else {
                    newMasterTableRow.put(currentFieldName, currentFieldValue);
                }
            });
            newMasterTableRows.add(newMasterTableRow);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)result.get(modelSchema.getName())))) {
            ((List)result.get(modelSchema.getName())).addAll(newMasterTableRows);
        } else {
            result.put(modelSchema.getName(), newMasterTableRows);
        }
        return result;
    }

    public static Map<String, List<ModelApiField>> tileApiField(List<ModelApiField> apiFields) {
        HashMap<String, List<ModelApiField>> result = new HashMap<String, List<ModelApiField>>();
        if (CollectionUtils.isNotEmpty(apiFields)) {
            apiFields.forEach(modelApiField -> {
                if (CollectionUtils.isNotEmpty(modelApiField.getField())) {
                    result.putAll(ParamValidateUtil.tileApiField(modelApiField.getField()));
                    String[] split = modelApiField.getFullPath().split("\\.");
                    int length = split.length;
                    String fieldName = split[length - 1];
                    result.put(fieldName, modelApiField.getField());
                }
            });
        }
        return result;
    }

    public static void validateAndFilterByApiConfig(Map<String, Object> rowData, List<ModelApiField> fields) {
        if (CollectionUtils.isNotEmpty(fields)) {
            StringBuilder builder = new StringBuilder("");
            List requestParamList = fields.stream().filter(ModelApiField::getShow).map(field -> {
                String[] split = field.getFullPath().split("\\.");
                int length = split.length;
                return split[length - 1];
            }).collect(Collectors.toList());
            List missingFields = fields.stream().filter(field -> {
                String[] split = field.getFullPath().split("\\.");
                int length = split.length;
                String fieldName = split[length - 1];
                return field.getShow() && field.getRequired() && !rowData.keySet().contains(fieldName);
            }).collect(Collectors.toList());
            Iterator<Map.Entry<String, Object>> iterator = rowData.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> next = iterator.next();
                if (requestParamList.contains(next.getKey())) continue;
                iterator.remove();
            }
            if (CollectionUtils.isNotEmpty(missingFields)) {
                builder.append(ResourceBundleUtils.getString("paramValidate.apiConfig.errorPrefix") + ResourceBundleUtils.getString("paramValidate.apiConfig.missFields")).append(String.join((CharSequence)",", missingFields.stream().map(field -> {
                    String[] split = field.getFullPath().split("\\.");
                    int length = split.length;
                    String fieldName = split[length - 1];
                    return "'" + fieldName + "'";
                }).collect(Collectors.toList())));
            }
            if (!"".equals(builder.toString())) {
                throw new IllegalArgumentException(builder.toString());
            }
        }
    }

    public static void validatePKAndBK(Map<String, Object> rowData, ModelSchemaDTO modelSchema) {
        Optional<ModelFieldDTO> pkOpt = modelSchema.getFields().stream().filter(ModelFieldDTO::isPk).findFirst();
        Optional<ModelIndexDTO> bkIndexOpt = modelSchema.getIndex().stream().filter(index -> index.getType().toLowerCase().equals(IndexTypeEnum.UNIQUE_INDEX.getIndexChar())).findFirst();
        ModelIndexDTO bkIndex = null;
        ModelFieldDTO pkField = null;
        if (bkIndexOpt.isPresent()) {
            bkIndex = bkIndexOpt.get();
        }
        if (bkIndex != null) {
            String bkIndexId = bkIndex.getId();
            bkIndex.getMember().forEach(indexField -> {
                if (!indexField.equals(DWTenantUtils.getTenantColumnName()) && rowData.get(indexField) == null) {
                    String errorMessage = String.format(ResourceBundleUtils.getString("paramValidate.bkValidateFail"), bkIndexId, indexField, rowData.entrySet());
                    throw new IllegalStateException(errorMessage);
                }
            });
        } else if (pkOpt.isPresent()) {
            pkField = pkOpt.get();
            if (rowData.get(pkField.getFieldId()) == null) {
                String errorMessage = String.format(ResourceBundleUtils.getString("paramValidate.pkValidateFail"), pkField.getFieldId(), rowData.entrySet());
                throw new IllegalStateException(errorMessage);
            }
        } else {
            String errorMessage = String.format(ResourceBundleUtils.getString("paramValidate.pkAndBkNotExist"), modelSchema.getName());
            throw new IllegalStateException(errorMessage);
        }
    }

    public static void filterParam(Map<String, Object> rowData, ModelSchemaDTO modelSchema) {
        Iterator<Map.Entry<String, Object>> iterator = rowData.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> next = iterator.next();
            String field = next.getKey();
            Object value = next.getValue();
            if (ModelDrivenConstants.EXCLUDE_VALIDATE_FIELDS.contains(field)) continue;
            Optional<ModelFieldDTO> optionalModelFieldDTO = modelSchema.getFields().stream().filter(modelSchemaField -> modelSchemaField.getFieldId().equals(field)).findFirst();
            if (optionalModelFieldDTO.isPresent()) {
                ModelFieldDTO modelField = optionalModelFieldDTO.get();
                if (modelField == null || StringUtils.isEmpty((CharSequence)modelField.getFieldType())) continue;
                ParamValidateUtil.updateRowData(rowData, modelField, field, value);
                continue;
            }
            iterator.remove();
        }
    }

    public static void updateRowData(Map<String, Object> rowData, ModelFieldDTO modelField, String rowFieldName, Object rowValue) {
        if (ModelDBConstants.MODEL_TIME_TYPE.stream().anyMatch(timeType -> timeType.equalsIgnoreCase(modelField.getFieldType()))) {
            rowData.put(rowFieldName, "".equals(rowValue) ? null : rowValue);
        } else if ("JSON".equalsIgnoreCase(modelField.getFieldType())) {
            rowData.put(rowFieldName, DWGsonProvider.getGson().toJson(rowData.get(rowFieldName)));
        }
    }

    public static void filterOutChildrenTableParam(Map<String, Object> rowData, ModelSchemaDTO modelSchema) {
        Iterator<Map.Entry<String, Object>> iterator = rowData.entrySet().iterator();
        List<ModelSchemaDTO> childrenSchema = ModelSchemaUtil.getChildrenModelSchema(modelSchema.getChildren());
        if (CollectionUtils.isEmpty(childrenSchema)) {
            return;
        }
        List childrenTableNames = childrenSchema.stream().map(ModelSchemaDTO::getName).collect(Collectors.toList());
        while (iterator.hasNext()) {
            Map.Entry<String, Object> next = iterator.next();
            String field = next.getKey();
            if (!childrenTableNames.contains(field)) continue;
            iterator.remove();
            log.warn("[filterOutChildrenTableParam] ignored field '{}', cause match children name({})", (Object)field, childrenTableNames);
        }
    }

    public static void validateStrategyOfChildrenTableRow(ModelSchemaDTO modelSchema, List<Map<String, Object>> masterTableParams) {
        for (Map<String, Object> masterTableParam : masterTableParams) {
            List<ModelSchemaDTO> childrenModelSchema = modelSchema.getChildren();
            List childTables = childrenModelSchema.stream().map(ModelSchemaDTO::getName).collect(Collectors.toList());
            masterTableParam.forEach((key, value) -> {
                if (childTables.contains(key)) {
                    List<Map<String, Object>> childrenTableParamterRows = new ArrayList();
                    if (value instanceof List) {
                        childrenTableParamterRows = (List)value;
                    } else if (value instanceof Map) {
                        childrenTableParamterRows.add((Map)value);
                    }
                    if (CollectionUtils.isNotEmpty(childrenTableParamterRows)) {
                        ParamValidateUtil.validateStrategy(childrenTableParamterRows, (String)((Map)childrenTableParamterRows.get(0)).get("update_type"));
                    }
                    ParamValidateUtil.validateStrategyOfChildrenTableRow(childrenModelSchema.stream().filter(schema -> schema.getName().equalsIgnoreCase((String)key)).findFirst().get(), childrenTableParamterRows);
                }
            });
        }
    }

    public static void validateStrategy(List<Map<String, Object>> childParams, String updateType) {
        childParams.forEach(childParam -> {
            if (ModelDrivenConstants.UPDATE_TYPE_SUBTABLE_PART_TYPE1.contains(updateType)) {
                if (!ModelDrivenConstants.UPDATE_TYPE_SUBTABLE_PART_TYPE1.contains(childParam.get("update_type"))) {
                    throw new IllegalArgumentException(String.format("'update_type' should be the same as parent table update type in %s ,error row:%s", String.join((CharSequence)" or ", ModelDrivenConstants.UPDATE_TYPE_SUBTABLE_PART_TYPE1), childParam.entrySet()));
                }
            } else if (updateType != null && !updateType.equalsIgnoreCase((String)childParam.get("update_type"))) {
                throw new IllegalArgumentException(String.format("'update_type' should be the same as parent table update type %s ,error row:%s", updateType, childParam.entrySet()));
            }
        });
    }

    public static List<Map<String, Object>> filterParameters(ModelSchemaDTO modelSchema, List<Map<String, Object>> masterTableParams) {
        ArrayList<Map<String, Object>> newMasterTableRows = new ArrayList<Map<String, Object>>();
        List<String> childTables = ModelSchemaUtil.getNextLevelChildNames(modelSchema);
        for (Map<String, Object> masterTableParam : masterTableParams) {
            if (ParamValidateUtil.shouldAddMasterRow(masterTableParam, childTables)) {
                newMasterTableRows.add(masterTableParam);
                break;
            }
            boolean childrenRowAllNullFlag = childTables.stream().noneMatch(masterTableParam::containsKey);
            if (!childrenRowAllNullFlag) continue;
            newMasterTableRows.add(masterTableParam);
        }
        return newMasterTableRows;
    }

    private static boolean shouldAddMasterRow(Map<String, Object> masterTableParam, List<String> childTables) {
        for (Map.Entry<String, Object> entry : masterTableParam.entrySet()) {
            List<Map<String, Object>> childrenTableParamterRows;
            Object updateTypeOfRow;
            String paramKey = entry.getKey();
            Object paramValue = entry.getValue();
            if (!childTables.contains(paramKey) || (updateTypeOfRow = (childrenTableParamterRows = ParamValidateUtil.getAllRowData(paramValue)).get(0).get("update_type")) == null || !ModelDrivenConstants.UPDATE_TYPE_SUBTABLE_PART_TYPE2.contains(updateTypeOfRow)) continue;
            return true;
        }
        return false;
    }

    public static List<Map<String, Object>> getAllRowData(Object paramValue) {
        ArrayList<Map<String, Object>> childrenTableParamterRows = new ArrayList<Map<String, Object>>();
        if (paramValue instanceof List) {
            childrenTableParamterRows.addAll((List)paramValue);
        } else if (paramValue instanceof Map) {
            childrenTableParamterRows.add((Map)paramValue);
        }
        return childrenTableParamterRows;
    }

    public static List<String> getSelectFieldsByApiConfigV2(Map<String, List<ModelApiField>> tileApiConfig, String targetTableName, ModelSchemaDTO modelSchema, DWQueryInfo queryInfo) {
        ArrayList<String> selectFields = new ArrayList<String>();
        Map<String, String> tableAliasMap = ParamValidateUtil.generateJoinTableAlias(queryInfo);
        List<ModelApiField> modelApiFields = tileApiConfig.get(targetTableName);
        List queryInfoTableNames = tableAliasMap.keySet().stream().collect(Collectors.toList());
        queryInfoTableNames.add(queryInfo.getTableName());
        for (ModelApiField modelApiField : modelApiFields) {
            String fieldTypeOfModelApiField = modelApiField.getModelFieldType();
            if (modelSchema == null || fieldTypeOfModelApiField != null && ModelFieldRelationTypeEnum.valueOf(fieldTypeOfModelApiField) == ModelFieldRelationTypeEnum.SIMPLE && modelApiField.getShow()) {
                String selectField = ModelQuerySelectUtil.getSelectField(modelApiField);
                selectFields.add(selectField);
                continue;
            }
            if (fieldTypeOfModelApiField == null || ModelFieldRelationTypeEnum.valueOf(fieldTypeOfModelApiField) != ModelFieldRelationTypeEnum.QUOTE_QUERY && ModelFieldRelationTypeEnum.valueOf(fieldTypeOfModelApiField) != ModelFieldRelationTypeEnum.QUOTE || !modelApiField.getShow()) continue;
            String[] split = modelApiField.getFullPath().split("\\.");
            int length = split.length;
            String field = split[length - 1];
            String fieldTableName = ModelQuerySelectUtil.getTableName(modelApiField);
            if (queryInfoTableNames.contains(fieldTableName)) {
                fieldTableName = ParamValidateUtil.getFieldTableName(fieldTableName, tableAliasMap);
                selectFields.add(String.join((CharSequence)".", fieldTableName, field) + " AS `" + modelApiField.getData_name() + "`");
                continue;
            }
            log.debug("{} ignored selectField({}), not exist in queryInfoTableNames (both queryJoins and tableAlias) of modelSchema({})", new Object[]{CLASS_LOG_TAG, modelApiField, modelSchema.getName()});
        }
        return selectFields;
    }

    public static String getFieldTableName(String fieldTableName, Map<String, String> tableAliasMap) {
        if (tableAliasMap.containsKey(fieldTableName)) {
            fieldTableName = tableAliasMap.get(fieldTableName);
        } else {
            log.debug("{}[getFieldTableName] {} not in tableAliasMap", (Object)CLASS_LOG_TAG, (Object)fieldTableName);
        }
        return fieldTableName;
    }

    public static String generateTableAlias(int num) {
        if (num > 702) {
            throw new IllegalArgumentException("too many join tables,please contact lcdp developers");
        }
        int hignNum = num / 26;
        if (hignNum >= 1) {
            char[] code = new char[]{(char)((char)hignNum + 96), (char)((char)(num - hignNum * 26) + 97)};
            return new String(code);
        }
        char[] code = new char[]{(char)((char)num + 97)};
        return new String(code);
    }

    public static Map<String, String> generateJoinTableAlias(ModelSchemaDTO modelSchema) {
        List<ModelFieldDTO> modelFieldDTOs = modelSchema.getFields();
        List quoteQueryFields = modelFieldDTOs.stream().filter(modelField -> ModelFieldRelationTypeEnum.valueOf(modelField.getType()) == ModelFieldRelationTypeEnum.QUOTE_QUERY).collect(Collectors.toList());
        List joinTables = quoteQueryFields.stream().map(modelField -> modelField.getAssociatedInfo().getTableName()).collect(Collectors.toList());
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        for (int i = 0; i < joinTables.size(); ++i) {
            aliasMap.put((String)joinTables.get(i), ParamValidateUtil.generateTableAlias(i));
        }
        return aliasMap;
    }

    public static Map<String, String> generateJoinTableAlias(DWQueryInfo queryInfo) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        List queryJoins = queryInfo.getJoin();
        queryJoins.stream().filter(queryJoin -> StringUtils.isNotBlank((CharSequence)queryJoin.getJoinTableAlias())).forEach(queryJoin -> aliasMap.put(queryJoin.getJoinTableName(), queryJoin.getJoinTableAlias()));
        return aliasMap;
    }
}

