/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils.compare;

import com.digiwin.app.ddl.enums.DataTypeEnum;
import com.digiwin.lcdp.modeldriven.constants.ModelDBConstants;
import com.digiwin.lcdp.modeldriven.enums.AlterColumnEnum;
import com.digiwin.lcdp.modeldriven.model.ModelOidDTO;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TableCompareUtil {
    private TableCompareUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String getCollation(DataTypeEnum dataType, boolean existedTable, AlterColumnEnum alterColumnEnum) {
        String returnValue = "";
        String name = dataType.getName();
        String type = dataType.getType();
        if (existedTable && alterColumnEnum == AlterColumnEnum.MODIFY_COLUMN) {
            if (Arrays.stream(ModelDBConstants.MYSQL_SQL_COLLATE_IGNORE_DATA_NAME).noneMatch(name::equals)) {
                if (Arrays.stream(ModelDBConstants.MYSQL_SQL_COLLATE_IGNORE_DATA_TYPE).noneMatch(type::equals)) {
                    returnValue = String.format(" COLLATE '%s' ", "utf8mb4_bin");
                }
            }
        }
        return returnValue;
    }

    public static List<Object> getPkList(ModelOidDTO modelOid) {
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put("code", modelOid.getCode());
        return Collections.singletonList(pkMap);
    }
}

