/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.aop;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.lcdp.modeldriven.utils.EaiHeaderUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ModelDrivenChangeDataVerifyInterceptor
implements MethodInterceptor {
    private static Logger logger = LoggerFactory.getLogger(ModelDrivenChangeDataVerifyInterceptor.class);
    private static final String _CLASSTAG = "[" + ModelDrivenChangeDataVerifyInterceptor.class.getSimpleName() + "]";
    @Autowired
    private EaiHeaderUtil eaiHeaderUtil;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String digiServiceName = DWServiceContext.getContext().getDigiServiceName();
        logger.debug("{} invoke eaiId({}), intercept {}.{})", new Object[]{_CLASSTAG, digiServiceName, invocation.getMethod().getDeclaringClass().getName(), invocation.getMethod().getName()});
        Object[] objects = invocation.getArguments();
        Map headers = (Map)objects[0];
        Map messageBody = (Map)objects[1];
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        if (params.get("queryConditions") == null) {
            String digiService = (String)headers.get("digi-service");
            JSONObject digiServiceJo = new JSONObject(digiService);
            String serviceProd = digiServiceJo.getString("prod");
            String serviceName = digiServiceJo.getString("name");
            String targetTableName = this.eaiHeaderUtil.getTableName(serviceName, serviceProd);
            if (StringUtils.isNotEmpty((CharSequence)targetTableName)) {
                logger.debug("{} targetTableName({}) from BMCode using digi-service:name({})", new Object[]{_CLASSTAG, targetTableName, serviceName});
                Object tableData = MapUtils.getObject((Map)params, (Object)targetTableName);
                boolean isEmptyData = ModelDataUtil.isDataEmpty(tableData);
                if (isEmptyData) {
                    throw new DWBusinessException(String.format(ResourceBundleUtils.getString("paramValidate.update.cannot.empty"), new Object[0]));
                }
            } else {
                logger.warn("{} no bmCode with digi-service:name{})", (Object)_CLASSTAG, (Object)serviceName);
            }
        }
        Object result = invocation.proceed();
        return result;
    }
}

