/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.config;

import com.digiwin.app.autoconfigure.DWEAIRestfulUrlRegisterAutoConfiguration;
import com.digiwin.app.autoconfigure.DWHttpClientAutoConfiguration;
import com.digiwin.app.autoconfigure.DWRestfulCommonsServiceAutoConfiguration;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.service.commons.config.DWServiceCommonsProvider;
import com.digiwin.lcdp.modeldriven.aop.DWEAICommonCrudInterceptor;
import com.digiwin.lcdp.modeldriven.aop.DWEAICrudInvocationListenerRegistry;
import com.digiwin.lcdp.modeldriven.aop.ModelDrivenChangeDataVerifyInterceptor;
import com.digiwin.lcdp.modeldriven.config.ModelDrivenDaoProperties;
import com.digiwin.lcdp.modeldriven.config.ModelDrivenDatabasePatch;
import com.digiwin.lcdp.modeldriven.config.ModelDrivenProperties;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.eai.builder.ModelStandardEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.environment.version.VersionSourceEnum;
import com.digiwin.lcdp.modeldriven.eoc.EocHttpRequester;
import com.digiwin.lcdp.modeldriven.eoc.EocProperties;
import com.digiwin.lcdp.modeldriven.eoc.ModelDrivenEocService;
import com.digiwin.lcdp.modeldriven.model.ModelDrivenEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.service.impl.ModelDrivenEAIMappingService;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenCommonsServiceUtil;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.JSQLParserException;
import org.aopalliance.aop.Advice;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;

@Configuration
@ComponentScan(basePackages={"com.digiwin.lcdp.modeldriven"})
@ConditionalOnClass(value={DWServiceCommonsProvider.class})
@AutoConfigureBefore(value={DWRestfulCommonsServiceAutoConfiguration.class, DWEAIRestfulUrlRegisterAutoConfiguration.class, DWHttpClientAutoConfiguration.class})
@ConditionalOnProperty(prefix="dap.service.commons.", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class ModelDrivenCommonsAutoConfiguration {
    private static final Logger _log = LoggerFactory.getLogger(ModelDrivenCommonsAutoConfiguration.class);
    private static final String _CLASSTAG = "[" + ModelDrivenCommonsAutoConfiguration.class.getSimpleName() + "]";

    @Bean(name={"bmCodes"})
    public Map<String, BMCode> getBMCodes() throws Exception {
        return new HashMap<String, BMCode>();
    }

    @Bean(name={"dw-modeldriven-properties"})
    public ModelDrivenProperties getModelDrivenProperties(Environment environment) {
        ModelDrivenProperties modelDrivenProperties = new ModelDrivenProperties();
        String modelDrivenCurrentVersion = ModelDrivenCommonsAutoConfiguration.class.getPackage().getImplementationVersion();
        if (StringUtils.isBlank((CharSequence)modelDrivenCurrentVersion)) {
            modelDrivenCurrentVersion = environment.getProperty("lcdp.modeldriven.env.current.version");
            if (StringUtils.isBlank((CharSequence)modelDrivenCurrentVersion)) {
                _log.warn("{} modeldriven current version:can't get in jar and env, can set {} of application.properties in dev environment", (Object)_CLASSTAG, (Object)"lcdp.modeldriven.env.current.version");
            } else {
                modelDrivenProperties.setCurrentSource(VersionSourceEnum.PROPERTIES);
                _log.info("{} modeldriven current version:{} in application.properties", (Object)_CLASSTAG, (Object)modelDrivenCurrentVersion);
            }
        } else {
            modelDrivenProperties.setCurrentSource(VersionSourceEnum.JAR);
            URL codeSourceLocation = ModelDrivenCommonsAutoConfiguration.class.getProtectionDomain().getCodeSource().getLocation();
            if (codeSourceLocation != null) {
                modelDrivenProperties.getCurrentMap().put("file", codeSourceLocation.getFile());
            }
            _log.info("{} modeldriven current version:{} in jar", (Object)_CLASSTAG, (Object)modelDrivenCurrentVersion);
        }
        modelDrivenProperties.setCurrentVersion(modelDrivenCurrentVersion);
        _log.trace("{} bean:eai {} created!", (Object)_CLASSTAG, (Object)"dw-modeldriven-properties");
        return modelDrivenProperties;
    }

    @Bean(name={"dw-modeldriven-service-commons-eai-registry"})
    public DWEAICrudInvocationListenerRegistry getRegistry() {
        DWEAICommonCrudInterceptor interceptor = new DWEAICommonCrudInterceptor();
        _log.info("{} bean:eai {} created!", (Object)_CLASSTAG, (Object)"dw-modeldriven-service-commons-eai-registry");
        return interceptor;
    }

    @Bean(name={"dw-modeldriven-commons-eai-crud-advisor"})
    @ConditionalOnBean(name={"dw-modeldriven-service-commons-eai-registry"})
    @ConditionalOnMissingBean(name={"dw-modeldriven-commons-eai-crud-advisor"})
    public Advisor dwEAICommonServiceAdvisor(@Qualifier(value="dw-modeldriven-service-commons-eai-registry") DWEAICrudInvocationListenerRegistry registry) {
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.getList(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.get(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.put(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.putValid(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.putInvalid(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.delete(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.post(..)) ");
        DWEAICommonCrudInterceptor dweaiCommonCrudInterceptor = (DWEAICommonCrudInterceptor)registry;
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)dweaiCommonCrudInterceptor);
        _log.info("{} bean:eai {} created!", (Object)_CLASSTAG, (Object)"dw-modeldriven-commons-eai-crud-advisor");
        return advisor;
    }

    @Bean(name={"dw-modeldriven-commons-eai-mapping-service"})
    public ModelDrivenEAIMappingService eaiMappingService(@Qualifier(value="dw-dao") DWDao dwdao, @Qualifier(value="dw-modeldriven-db-patch") ModelDrivenDatabasePatch modelDrivenDatabasePatch) throws JSQLParserException {
        if (dwdao != null) {
            modelDrivenDatabasePatch.upgrade();
        }
        ModelDrivenEAIMappingService eaiMappingService = new ModelDrivenEAIMappingService();
        _log.info("{} bean:eai {} created!", (Object)_CLASSTAG, (Object)"dw-modeldriven-commons-eai-mapping-service");
        return eaiMappingService;
    }

    @Bean(name={"dw-modeldriven-db-patch"})
    public ModelDrivenDatabasePatch modelDrivenDatabasePatch(@Qualifier(value="dw-modeldriven-properties") ModelDrivenProperties modelDrivenProperties) {
        ModelDrivenDatabasePatch modelDrivenDatabasePatch = new ModelDrivenDatabasePatch();
        _log.info("{} bean:eai {} created!", (Object)_CLASSTAG, (Object)"dw-modeldriven-db-patch");
        return modelDrivenDatabasePatch;
    }

    @Primary
    @Bean(value={"dw-service-commons-provider"})
    public DWServiceCommonsProvider getModelDrivenServiceCommonProvider(@Qualifier(value="modeldriven-bm-properties") BMProperties bmProperties) {
        Map<String, List<Class<?>>> commonsInterfaces = ModelDrivenCommonsServiceUtil.getCommonsServiceInterfaces();
        Map<String, List<DWServiceInfo>> commonsImplements = ModelDrivenCommonsServiceUtil.getCommonsServiceImplements();
        return new DWServiceCommonsProvider(commonsInterfaces, commonsImplements);
    }

    @Bean(value={"dw-modeldriven-eoc-properties"})
    public EocProperties getProperties(Environment environment) {
        EocProperties properties = new EocProperties();
        properties.setUrl(environment.getProperty("eocUrl"));
        properties.setContentType(environment.getProperty("eocContentType", "application/json; charset=UTF-8"));
        properties.setConnectionRequestTimeout(Integer.parseInt(environment.getProperty("eocHttpConnectionPoolRequestTimeout", "20000")));
        properties.setConnectionTimeout(Integer.parseInt(environment.getProperty("eocHttpConnectionTimeout", "60000")));
        properties.setRequestSocketTimeout(Integer.parseInt(environment.getProperty("eocSoTimeout", "30000")));
        properties.setEncode(environment.getProperty("eocEncode", "UTF-8"));
        properties.setConnectionMaxTotal(Integer.parseInt(environment.getProperty("eocHttpMaxConnections", "100")));
        properties.setKeepAliveTimeout(Long.parseLong(environment.getProperty("eocKeepAliveTimeout", "-1")));
        properties.setApiPathEmpInfo(environment.getProperty("eocUrlEmpInfo", "/api/eoc/v2/emp/info"));
        properties.setApiPathEmpDeptAll(environment.getProperty("eocUrlEmpDeptAll", "/api/eoc/v2/emp/direct/dept/all"));
        EocHttpRequester.setProperties(properties);
        _log.info("{} bean:eai {} created!", (Object)_CLASSTAG, (Object)"dw-modeldriven-eoc-properties");
        return properties;
    }

    @Bean(value={"dw-modeldriven-eocService"})
    public ModelDrivenEocService getModelDrivenEocService(@Qualifier(value="dw-modeldriven-eoc-properties") EocProperties eocProperties) {
        ModelDrivenEocService modelDrivenEocService = new ModelDrivenEocService();
        _log.info("{} bean:eai {} created!", (Object)_CLASSTAG, (Object)"dw-modeldriven-eocService");
        return modelDrivenEocService;
    }

    @Bean(name={"dw-modeldriven-crud-eai-builder"})
    public ModelStandardEaiHeaderBuilder modelStandardEaiHeaderBuilder(@Qualifier(value="dw-modeldriven-eai-repo") ModelDrivenEaiMethodRepository modelDrivenEaiMethodRepo) {
        return new ModelStandardEaiHeaderBuilder();
    }

    @Bean(name={"lcdp-modeldriven-std-crud-update-verify-interceptor"})
    public ModelDrivenChangeDataVerifyInterceptor modelDrivenChangeDataVerifyInterceptor() {
        ModelDrivenChangeDataVerifyInterceptor interceptor = new ModelDrivenChangeDataVerifyInterceptor();
        _log.info("{} bean:eai {} created!", (Object)_CLASSTAG, (Object)"lcdp-modeldriven-std-crud-update-verify-interceptor");
        return interceptor;
    }

    @Bean(name={"lcdp-modeldriven-std-crud-update-verify-advisor"})
    @ConditionalOnBean(name={"lcdp-modeldriven-std-crud-update-verify-interceptor"})
    @ConditionalOnMissingBean(name={"lcdp-modeldriven-std-crud-update-verify-advisor"})
    public Advisor modeldrivenStdUpdateVerifyAdvisor(@Qualifier(value="lcdp-modeldriven-std-crud-update-verify-interceptor") ModelDrivenChangeDataVerifyInterceptor updateTypeServiceVerifyInterceptor) {
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.put(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.putValid(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.putInvalid(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.delete(..)) ");
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)updateTypeServiceVerifyInterceptor);
        _log.info("{} bean:eai {} created!", (Object)_CLASSTAG, (Object)"lcdp-modeldriven-std-crud-update-verify-advisor");
        return advisor;
    }

    @Bean(name={"dw-modeldriven-dao-properties"})
    public ModelDrivenDaoProperties modelDrivenDaoProperties() {
        _log.info("{} bean:{} created!", (Object)_CLASSTAG, (Object)"dw-modeldriven-dao-properties");
        return new ModelDrivenDaoProperties();
    }
}

