/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.config;

import com.digiwin.app.service.commons.config.DWServiceCommonsProvider;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.app.service.eai.DWEAIServiceDefinitionParser;
import com.digiwin.app.service.eai.EAIService;
import com.digiwin.lcdp.modeldriven.config.ModelDrivenCommonsAutoConfiguration;
import com.digiwin.lcdp.modeldriven.config.condition.ModelDrivenEaiRegProdSrvCondition;
import com.digiwin.lcdp.modeldriven.constants.ESPConstants;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.eai.ModelDrivenStandardEaiHeaderUtil;
import com.digiwin.lcdp.modeldriven.listener.ModelDrivenApplicationListener;
import com.digiwin.lcdp.modeldriven.model.ModelDrivenEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMappingProvider;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.pojo.ModelDrivenEaiMethodDTO;
import com.digiwin.lcdp.modeldriven.service.impl.ModelDrivenEAIMappingService;
import com.digiwin.lcdp.modeldriven.utils.service.ServiceMappingUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@AutoConfigureAfter(value={ModelDrivenCommonsAutoConfiguration.class})
public class ModelDrivenEAIRestfulUrlRegisterAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenEAIRestfulUrlRegisterAutoConfiguration.class);
    private static final String _CLASSTAG = "[" + ModelDrivenEAIRestfulUrlRegisterAutoConfiguration.class.getSimpleName() + "]";

    @Bean(name={"dw-modeldriven-eai-repo"})
    public ModelDrivenEaiMethodRepository getModelDrivenEaiMethodRepository(@Qualifier(value="dw-service-commons-provider") DWServiceCommonsProvider serviceCommonsProvider) {
        Map commonsInterfaces = serviceCommonsProvider.getInterfaceServices();
        List interfList = (List)commonsInterfaces.get("commons");
        Optional<Class<?>> eaiClazz = interfList.stream().filter(p -> p.getTypeName().equals("com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService")).findFirst();
        Method[] commonsCrudEaiClazzMethods = eaiClazz.get().getMethods();
        List<String> dapStandardEaiPostFixNames = ESPConstants.EAI_SERVICE_POSTFIX;
        ModelDrivenEaiMethodRepository mdEaiMethodRepo = new ModelDrivenEaiMethodRepository();
        mdEaiMethodRepo.setEaiClazz(eaiClazz);
        Object listGetMethod = null;
        for (Method method : commonsCrudEaiClazzMethods) {
            if (!method.isAnnotationPresent(EAIService.class)) continue;
            EAIService methodAnnotation = method.getAnnotation(EAIService.class);
            String methodAnnotEaiId = methodAnnotation.id();
            if (listGetMethod == null && methodAnnotEaiId.endsWith(".eai.list.get")) {
                mdEaiMethodRepo.setListGetMethod(method);
            }
            for (String postFix : dapStandardEaiPostFixNames) {
                if (!methodAnnotEaiId.endsWith(postFix)) continue;
                String[] postFixToken = postFix.split("\\.");
                String eaiServicePostfix = postFixToken[2];
                if (postFixToken.length > 3) {
                    for (int i = 3; i < postFixToken.length; ++i) {
                        eaiServicePostfix = String.join((CharSequence)".", eaiServicePostfix, postFixToken[i]);
                    }
                }
                ModelDrivenEaiMethodDTO modelDrivenEaiMethodDTO = new ModelDrivenEaiMethodDTO();
                modelDrivenEaiMethodDTO.setEaiId(methodAnnotEaiId);
                modelDrivenEaiMethodDTO.setEaiServicePostfix(eaiServicePostfix);
                modelDrivenEaiMethodDTO.setMethod(method);
                log.debug("serviceMapping: eaiMethodRepo add eaiId({}), eaiServicePostfix({})", (Object)methodAnnotEaiId, (Object)eaiServicePostfix);
                mdEaiMethodRepo.add(methodAnnotEaiId, modelDrivenEaiMethodDTO);
            }
        }
        log.debug(_CLASSTAG + " bean:{} created!", (Object)"dw-modeldriven-eai-repo");
        return mdEaiMethodRepo;
    }

    @Bean(name={"dw-modeldriven-service-commons-mapping-provider"})
    @DependsOn(value={"dw-service-commons-provider"})
    public DWServiceMappingProvider eaiMappingProvider(@Qualifier(value="dw-modeldriven-commons-eai-mapping-service") ModelDrivenEAIMappingService eaiMappingService, @Qualifier(value="DWEAIServiceParser") DWEAIServiceDefinitionParser dwEaiServiceDefinitionParser, @Qualifier(value="dw-service-commons-provider") DWServiceCommonsProvider serviceCommonsProvider, @Qualifier(value="DWEAIHeaderRepository") DWEAIHeaderRepository dwEAIHeaderRepository, ModelDrivenStandardEaiHeaderUtil modelDrivenStandardEaiHeaderUtil) throws Exception {
        DWServiceMappingProvider eaiMappingProvider = new DWServiceMappingProvider();
        BMProperties properties = BMProperties.getProperties();
        if (properties == null || !properties.isEnabled()) {
            List serviceMappings = (List)eaiMappingService.getEAIList();
            log.info(_CLASSTAG + " serviceMapping: dw_service_mapping count:{} ", (Object)serviceMappings.size());
            List<MappingModelInfo> mappingModelInfos = new ArrayList<MappingModelInfo>();
            if (serviceMappings.size() > 0) {
                mappingModelInfos = (List)eaiMappingService.getChildrenTable();
            }
            ServiceMappingUtil.updateProd(serviceMappings, mappingModelInfos);
            List<DWEAIHeader> newHeaders = modelDrivenStandardEaiHeaderUtil.updateAndGetModelDrivenEaiHeaders(serviceMappings, mappingModelInfos);
            log.info(_CLASSTAG + " serviceMapping: refreshed ModelDriven DWEAIHeader count:{} ", (Object)newHeaders.size());
        }
        return eaiMappingProvider;
    }

    @Conditional(value={ModelDrivenEaiRegProdSrvCondition.class})
    @Bean
    public ModelDrivenApplicationListener buildModelDrivenApplicationListener() {
        return new ModelDrivenApplicationListener();
    }
}

