/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.aop;

import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.lcdp.modeldriven.customize.constants.BMConstants;
import com.digiwin.lcdp.modeldriven.utils.EaiRegisterUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BMCRUDDigiServiceNameInterceptor
implements MethodInterceptor {
    private static final String _CLASSTAG = "[" + BMCRUDDigiServiceNameInterceptor.class.getSimpleName() + "]";
    private static Logger logger = LoggerFactory.getLogger(BMCRUDDigiServiceNameInterceptor.class);
    private static final List<String> methodName = Stream.of("getList", "get", "put", "putValid", "putInvalid", "delete", "post").collect(Collectors.toList());

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object[] objects = invocation.getArguments();
        Map headers = (Map)objects[0];
        String digiService = (String)headers.get("digi-service");
        Map digiServiceMap = (Map)DWGsonProvider.getGson().fromJson(digiService, Map.class);
        String name = (String)digiServiceMap.get("name");
        String[] serviceNameToken = name.split("\\.");
        String serviceType = serviceNameToken[serviceNameToken.length - 1];
        if (BMConstants.SERVICE_TYPE_VALID.contains(serviceType) && headers.containsKey("digi-modeldriven")) {
            String orgDigiService = (String)headers.get("digi-modeldriven");
            Map orgDigiServiceMap = (Map)DWGsonProvider.getGson().fromJson(orgDigiService, Map.class);
            name = (String)orgDigiServiceMap.get("name");
            digiServiceMap.put("name", name);
        }
        String prod = (String)digiServiceMap.get("prod");
        String modelDrivenProdPrefix = EaiRegisterUtil.getEaiServicePrefixOfProd(prod) + ".";
        if (BMConstants.BMD_OLD_MODEL_SERVIC_NAME.contains(name)) {
            return invocation.proceed();
        }
        String digiServiceName = DWServiceContext.getContext().getDigiServiceName();
        String methodName = invocation.getMethod().getName();
        String[] split = name.split("\\.");
        boolean hasStdToken = StringUtils.equals((CharSequence)"std", (CharSequence)split[split.length - 2]);
        switch (methodName) {
            case "getList": {
                String getListName = modelDrivenProdPrefix + String.join((CharSequence)".", Arrays.copyOfRange(split, 2, split.length - 1)) + ".list.get";
                digiServiceMap.put("name", getListName);
                break;
            }
            case "get": {
                String getName = modelDrivenProdPrefix + String.join((CharSequence)".", Arrays.copyOfRange(split, 2, split.length - 1)) + ".detail.get";
                digiServiceMap.put("name", getName);
                break;
            }
            case "putValid": 
            case "putInvalid": {
                String putValidInvalidName = hasStdToken ? modelDrivenProdPrefix + String.join((CharSequence)".", (CharSequence[])ArrayUtils.add((Object[])Arrays.copyOfRange(split, 2, split.length - 2), (Object)serviceType)) : modelDrivenProdPrefix + String.join((CharSequence)".", (CharSequence[])ArrayUtils.add((Object[])Arrays.copyOfRange(split, 2, split.length - 1), (Object)serviceType));
                digiServiceMap.put("name", putValidInvalidName);
                break;
            }
            case "put": {
                String putName = modelDrivenProdPrefix + String.join((CharSequence)".", Arrays.copyOfRange(split, 2, split.length - 1)) + ".update";
                digiServiceMap.put("name", putName);
                break;
            }
            case "post": {
                String postName = modelDrivenProdPrefix + String.join((CharSequence)".", Arrays.copyOfRange(split, 2, split.length - 1)) + ".create";
                digiServiceMap.put("name", postName);
                break;
            }
            case "delete": {
                String deleteName = modelDrivenProdPrefix + String.join((CharSequence)".", Arrays.copyOfRange(split, 2, split.length - 1)) + ".delete";
                digiServiceMap.put("name", deleteName);
                break;
            }
        }
        headers.put("digi-service", DWGsonProvider.getGson().toJson((Object)digiServiceMap));
        logger.debug(_CLASSTAG + " origin eaiId({}) change to new eaiId({})", (Object)digiServiceName, digiServiceMap.get("name"));
        return invocation.proceed();
    }
}

