/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.config;

import com.digiwin.app.service.commons.config.DWServiceCommonsProvider;
import com.digiwin.app.service.eai.EAIService;
import com.digiwin.lcdp.modeldriven.aop.DWEAICommonCrudInterceptor;
import com.digiwin.lcdp.modeldriven.aop.DWEAICrudInvocationListenerRegistry;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.aop.BMAppInfoInterceptor;
import com.digiwin.lcdp.modeldriven.customize.aop.BMCrudInterceptor;
import com.digiwin.lcdp.modeldriven.customize.config.BMNacosRigestionApplicationListener;
import com.digiwin.lcdp.modeldriven.customize.config.condition.BMAdapterCondition;
import com.digiwin.lcdp.modeldriven.customize.config.condition.BMRoleCondition;
import com.digiwin.lcdp.modeldriven.customize.constants.CustomizeConstants;
import com.digiwin.lcdp.modeldriven.customize.eai.BMEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.customize.eai.BMEaiHeaderProvider;
import com.digiwin.lcdp.modeldriven.customize.handler.BMAdapterCustomizeHandler;
import com.digiwin.lcdp.modeldriven.customize.handler.BMAdapterDefaultCustomizeHandler;
import com.digiwin.lcdp.modeldriven.customize.handler.BMDefaultCRUDHandler;
import com.digiwin.lcdp.modeldriven.customize.handler.ICustomizeCRUDHandler;
import com.digiwin.lcdp.modeldriven.customize.model.BMEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.eai.builder.EaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.pojo.ModelDrivenEaiMethodDTO;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceUtil;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@Conditional(value={BMRoleCondition.class})
public class BMAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BMAutoConfiguration.class);
    private static final String _CLASSTAG = "[" + BMAutoConfiguration.class.getSimpleName() + "]";

    @Bean(name={"modeldriven-customize-bm-crud-adapter"})
    @Conditional(value={BMAdapterCondition.class})
    public Object getBMAdapter() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String adapterName = BMProperties.getProperties().getBmCrudAdapter();
        Object bmAdapterImplClazz = Class.forName(adapterName).newInstance();
        log.info(_CLASSTAG + " bean:{} created!", (Object)"modeldriven-customize-bm-crud-adapter");
        return bmAdapterImplClazz;
    }

    @Bean(name={"lcdp-bm-eai-method-repo"})
    public BMEaiMethodRepository getModelDrivenEaiMethodRepository(@Qualifier(value="dw-service-commons-provider") DWServiceCommonsProvider serviceCommonsProvider) {
        Map commonsInterfaces = serviceCommonsProvider.getInterfaceServices();
        List interfList = (List)commonsInterfaces.get("commons");
        Optional<Class<?>> eaiClazz = interfList.stream().filter(p -> p.getTypeName().equals(CustomizeConstants.CUSTOMIZE_COMMON_BM_CRUD_INTERFACE_NAME)).findFirst();
        Method[] commonsCrudEaiClazzMethods = eaiClazz.get().getMethods();
        List<String> bmStandardEaiPostFixNames = CustomizeConstants.CUSTOMIZE_BM_METHOD_POSTFIX;
        List bmBelongGetPostFixNames = Stream.of("detail.get", "list.get").collect(Collectors.toList());
        List bmBelongUpdatePostFixNames = Stream.of("valid", "invalid").collect(Collectors.toList());
        BMEaiMethodRepository bmEaiMethodRepo = new BMEaiMethodRepository();
        bmEaiMethodRepo.setEaiClazz(eaiClazz);
        Object listGetMethod = null;
        for (Method method : commonsCrudEaiClazzMethods) {
            ModelDrivenEaiMethodDTO modelDrivenEaiMethodDTO;
            String[] methodIdToken;
            String methodIdPrefix;
            if (!method.isAnnotationPresent(EAIService.class)) continue;
            EAIService methodAnnotation = method.getAnnotation(EAIService.class);
            String methodAnnotEaiId = methodAnnotation.id();
            for (String postFix : bmStandardEaiPostFixNames) {
                if (!methodAnnotEaiId.endsWith(postFix)) continue;
                String[] postFixToken = postFix.split("\\.");
                String eaiServicePostfix = postFixToken[2];
                if (postFixToken.length > 3) {
                    for (int i = 3; i < postFixToken.length; ++i) {
                        eaiServicePostfix = String.join((CharSequence)".", eaiServicePostfix, postFixToken[i]);
                    }
                }
                ModelDrivenEaiMethodDTO modelDrivenEaiMethodDTO2 = EaiServiceUtil.getModelDrivenEaiMethodDTO(method, methodAnnotEaiId, eaiServicePostfix, eaiClazz);
                log.debug(_CLASSTAG + " serviceMapping: eaiMethodRepo add eaiId({}), eaiServicePostfix({})", (Object)methodAnnotEaiId, (Object)eaiServicePostfix);
                bmEaiMethodRepo.add(methodAnnotEaiId, modelDrivenEaiMethodDTO2);
            }
            if (methodAnnotEaiId.endsWith(".crud.eai.get")) {
                if (listGetMethod == null) {
                    bmEaiMethodRepo.setListGetMethod(method);
                }
                for (String eaiServicePostfix : bmBelongGetPostFixNames) {
                    methodIdPrefix = "";
                    methodIdToken = methodAnnotEaiId.split("\\.");
                    for (int i = 0; i < methodIdToken.length - 1; ++i) {
                        methodIdPrefix = i != 0 ? String.join((CharSequence)".", methodIdPrefix, methodIdToken[i]) : methodIdToken[i];
                    }
                    String eaiId = String.join((CharSequence)".", methodIdPrefix, eaiServicePostfix);
                    modelDrivenEaiMethodDTO = EaiServiceUtil.getModelDrivenEaiMethodDTO(method, eaiId, eaiServicePostfix, eaiClazz);
                    log.debug(_CLASSTAG + " serviceMapping: eaiMethodRepo add eaiId({}), eaiServicePostfix({})", (Object)methodAnnotEaiId, (Object)eaiServicePostfix);
                    bmEaiMethodRepo.add(eaiId, modelDrivenEaiMethodDTO);
                }
            }
            if (!methodAnnotEaiId.endsWith(".crud.eai.update")) continue;
            for (String eaiServicePostfix : bmBelongUpdatePostFixNames) {
                methodIdPrefix = "";
                methodIdToken = methodAnnotEaiId.split("\\.");
                for (int i = 0; i < methodIdToken.length - 1; ++i) {
                    methodIdPrefix = i != 0 ? String.join((CharSequence)".", methodIdPrefix, methodIdToken[i]) : methodIdToken[i];
                }
                String methodRepoId = String.join((CharSequence)".", methodIdPrefix, eaiServicePostfix);
                modelDrivenEaiMethodDTO = EaiServiceUtil.getModelDrivenEaiMethodDTO(method, methodRepoId, eaiServicePostfix, eaiClazz);
                log.debug(_CLASSTAG + " serviceMapping: eaiMethodRepo add eaiId({}), eaiServicePostfix({})", (Object)methodAnnotEaiId, (Object)eaiServicePostfix);
                bmEaiMethodRepo.add(methodRepoId, modelDrivenEaiMethodDTO);
            }
        }
        return bmEaiMethodRepo;
    }

    @Bean(name={"modeldriven-customize-bm-crud-eai-headers"})
    public BMEaiHeaderProvider getBMEaiHeaderProvider(@Qualifier(value="lcdp-bm-eai-method-repo") BMEaiMethodRepository bmEaiMethodRepository) {
        BMEaiHeaderProvider bmEaiMethodHeaderProvider = new BMEaiHeaderProvider();
        return bmEaiMethodHeaderProvider;
    }

    @Bean(value={"modeldriven-customize-bm-crud-handler"})
    public ICustomizeCRUDHandler getCustomizeRuntimeHandler() {
        BMDefaultCRUDHandler customizeCrudHandler = new BMDefaultCRUDHandler();
        log.info(_CLASSTAG + " bean:{} created!", (Object)"modeldriven-customize-bm-crud-handler");
        return customizeCrudHandler;
    }

    @Bean(value={"modeldriven-customize-bm-adapter-handler"})
    public BMAdapterCustomizeHandler bmAdapterHandler() {
        BMAdapterDefaultCustomizeHandler bmAdapterDefaultHandler = new BMAdapterDefaultCustomizeHandler();
        log.info(_CLASSTAG + " bean:{} created!", (Object)"modeldriven-customize-bm-adapter-handler");
        return bmAdapterDefaultHandler;
    }

    @Bean(value={"dw-modeldriven-customize-bm-crud-eai-interceptor"})
    public BMCrudInterceptor getBMCrudInterceptor(@Qualifier(value="modeldriven-customize-bm-adapter-handler") BMAdapterCustomizeHandler bmAdapterHandler) {
        BMCrudInterceptor interceptor = new BMCrudInterceptor();
        log.info(_CLASSTAG + " bean:eai dw-modeldriven-customize-bm-crud-eai-interceptor created!");
        return interceptor;
    }

    @Primary
    @Bean(name={"dw-modeldriven-commons-eai-crud-advisor"})
    public Advisor dwEAICommonServiceAdvisor(@Qualifier(value="dw-modeldriven-service-commons-eai-registry") DWEAICrudInvocationListenerRegistry registry) {
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        String bmExpress = "execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.getList(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.get(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.put(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.putValid(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.putInvalid(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.delete(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.post(..))  || execution(* " + CustomizeConstants.CUSTOMIZE_COMMON_BM_CRUD_INTERFACE_NAME + ".*(..))";
        pointcut.setExpression(bmExpress);
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)((DWEAICommonCrudInterceptor)registry));
        log.info(_CLASSTAG + " bean:eai dw-modeldriven-commons-eai-crud-advisor created!");
        return advisor;
    }

    @Bean(name={"dw-modeldriven-customize-crud-eai-builder"})
    public EaiHeaderBuilder bmdEaiHeaderBuilder() {
        return new BMEaiHeaderBuilder();
    }

    @Bean
    public BMNacosRigestionApplicationListener buildBMNacosRegistionApplicationListener() {
        return new BMNacosRigestionApplicationListener();
    }

    @Bean(name={"dw-modeldriven-appinfo-advisor"})
    public Advisor dwModelDrivenAppinfoAdvisor(BMAppInfoInterceptor dwBMAppInfoInterceptor) {
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        String serviceWithAppInfo = "execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.getMetadata(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.getModelSql(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.getSqlReport(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.invoke(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.dataViewGet(..))";
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(serviceWithAppInfo);
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)dwBMAppInfoInterceptor);
        log.info(_CLASSTAG + "bean:eai dw-modeldriven-appinfo-advisor created!");
        return advisor;
    }
}

