/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.config;

import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.service.commons.config.DWServiceCommonsProvider;
import com.digiwin.app.service.eai.EAIService;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.aop.BMCRUDDigiServiceNameInterceptor;
import com.digiwin.lcdp.modeldriven.customize.config.BMNacosRigestionApplicationListener;
import com.digiwin.lcdp.modeldriven.customize.config.CustomizeAutoConfiguration;
import com.digiwin.lcdp.modeldriven.customize.config.condition.BMDataRoleCondition;
import com.digiwin.lcdp.modeldriven.customize.constants.CustomizeConstants;
import com.digiwin.lcdp.modeldriven.customize.eai.BMDataEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.customize.model.BMDataCRUDServiceRepository;
import com.digiwin.lcdp.modeldriven.customize.model.BMDataEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.eai.builder.EaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.eai.builder.ModelStandardEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.model.ModelDrivenEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.pojo.ModelDrivenEaiMethodDTO;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={BMDataRoleCondition.class})
@AutoConfigureAfter(value={CustomizeAutoConfiguration.class})
public class BMDataAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BMDataAutoConfiguration.class);
    private static final String _CLASSTAG = "[" + BMDataAutoConfiguration.class.getSimpleName() + "]";

    @Bean(name={"lcdp-bmd-eai-crud-service-repo"})
    public BMDataCRUDServiceRepository getBMDataEaiServiceRepo(@Qualifier(value="dw-service-commons-provider") DWServiceCommonsProvider serviceCommonsProvider, @Qualifier(value="modeldriven-bm-properties") BMProperties bmProperties) {
        BMDataCRUDServiceRepository bmdServiceRepository = new BMDataCRUDServiceRepository();
        Map<String, Class<?>> bmdInterfaceServices = bmProperties.getBmdCrudInterfaceService();
        for (String crudType : bmdInterfaceServices.keySet()) {
            bmdServiceRepository.addInterf(crudType, bmdInterfaceServices.get(crudType));
        }
        Map<String, DWServiceInfo> bmdImplementServices = bmProperties.getBmdCrudImplementService();
        for (String crudType : bmdImplementServices.keySet()) {
            bmdServiceRepository.addImplet(crudType, bmdImplementServices.get(crudType));
        }
        log.info(_CLASSTAG + " bean:{} created!", (Object)"lcdp-bmd-eai-crud-service-repo");
        return bmdServiceRepository;
    }

    @Bean(name={"lcdp-bmd-eai-method-repo"})
    public BMDataEaiMethodRepository getBMDataEaiMethodRepository(@Qualifier(value="dw-service-commons-provider") DWServiceCommonsProvider serviceCommonsProvider, @Qualifier(value="lcdp-bmd-eai-crud-service-repo") BMDataCRUDServiceRepository bmdCRUDServiceRepository, @Qualifier(value="dw-modeldriven-eai-repo") ModelDrivenEaiMethodRepository modelDrivenEaiMethodRepository) {
        List<String> bmStandardEaiPostFixNames = CustomizeConstants.CUSTOMIZE_BMD_METHOD_POSTFIX;
        ArrayList bmdCrudEaiClazzMethods = new ArrayList();
        Map<String, Class<?>> interfs = bmdCRUDServiceRepository.getInterfs();
        for (String crudType : interfs.keySet()) {
            Class<?> bmdEaiClazz = interfs.get(crudType);
            Method[] methods = bmdEaiClazz.getMethods();
            List tempMethods = Arrays.stream(methods).collect(Collectors.toList());
            bmdCrudEaiClazzMethods.addAll(tempMethods);
        }
        BMDataEaiMethodRepository bmDataEaiMethodRepo = new BMDataEaiMethodRepository();
        for (Method method : bmdCrudEaiClazzMethods) {
            if (!method.isAnnotationPresent(EAIService.class)) continue;
            EAIService methodAnnotation = method.getAnnotation(EAIService.class);
            String methodAnnotEaiId = methodAnnotation.id();
            for (String postFix : bmStandardEaiPostFixNames) {
                if (!methodAnnotEaiId.endsWith(postFix)) continue;
                String[] postFixToken = postFix.split("\\.");
                String eaiServicePostfix = postFixToken[2];
                if (postFixToken.length > 3) {
                    for (int i = 3; i < postFixToken.length; ++i) {
                        eaiServicePostfix = String.join((CharSequence)".", eaiServicePostfix, postFixToken[i]);
                    }
                }
                ModelDrivenEaiMethodDTO modelDrivenEaiMethodDTO = new ModelDrivenEaiMethodDTO();
                modelDrivenEaiMethodDTO.setEaiId(methodAnnotEaiId);
                modelDrivenEaiMethodDTO.setEaiServicePostfix(eaiServicePostfix);
                modelDrivenEaiMethodDTO.setMethod(method);
                log.debug("{} serviceMapping: eaiMethodRepo add eaiId({}), eaiServicePostfix({})", new Object[]{_CLASSTAG, methodAnnotEaiId, eaiServicePostfix});
                bmDataEaiMethodRepo.add(methodAnnotEaiId, modelDrivenEaiMethodDTO);
            }
        }
        bmDataEaiMethodRepo.setListGetMethod(modelDrivenEaiMethodRepository.getListGetMethod());
        log.info(_CLASSTAG + " bean:{} created!", (Object)"lcdp-bmd-eai-method-repo");
        return bmDataEaiMethodRepo;
    }

    @Bean(name={"dw-modeldriven-customize-crud-eai-builder"})
    public EaiHeaderBuilder bmdEaiHeaderBuilder(@Qualifier(value="dw-modeldriven-crud-eai-builder") ModelStandardEaiHeaderBuilder modelStandardEAIHeaderBuilder, @Qualifier(value="lcdp-bmd-eai-method-repo") BMDataEaiMethodRepository bmdEaiMethodRepository) {
        return new BMDataEaiHeaderBuilder();
    }

    @Bean
    public BMNacosRigestionApplicationListener buildBMNacosRegistionApplicationListener() {
        return new BMNacosRigestionApplicationListener();
    }

    @Bean(name={"dw-modeldriven-crud-digiservicename-advisor"})
    public Advisor dwModelDrivenCRUDEaiIdAdvisor(BMCRUDDigiServiceNameInterceptor dwDigiServiceNameInterceptor) {
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        String crudService = "execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.getList(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.get(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.put(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.putValid(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.putInvalid(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.delete(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.post(..)) ";
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(crudService);
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)dwDigiServiceNameInterceptor);
        return advisor;
    }
}

