/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.config;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.athena.esp.sdk.init.EspSdkInitialize;
import com.digiwin.dap.middleware.lmc.util.JsonUtils;
import com.digiwin.lcdp.modeldriven.customize.BMDInvoker;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.config.NacosServiceRegisterEvent;
import com.digiwin.lcdp.modeldriven.customize.model.BMDataEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.customize.service.impl.BMDataEAICrudService;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.utils.EaiHeaderUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiRegisterUtil;
import com.digiwin.lcdp.modeldriven.utils.NacosRegisterUtils;
import com.digiwin.lcdp.modeldriven.utils.service.ServiceMappingUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;

public class BMNacosRigestionApplicationListener
implements ApplicationListener {
    private static final Logger log = LoggerFactory.getLogger(BMNacosRigestionApplicationListener.class);
    private static final String _CLASSTAG = "[" + BMNacosRigestionApplicationListener.class.getSimpleName() + "]";
    @Autowired
    @Qualifier(value="modeldriven-bm-properties")
    private BMProperties bmProperties;
    @Autowired
    private NacosRegisterUtils nacosRegisterUtils;
    @Autowired
    private EaiHeaderUtil eaiHeaderUtil;
    @Autowired(required=false)
    private BMDataEAICrudService bmDataEAICrudService;
    @Autowired(required=false)
    @Qualifier(value="lcdp-bmd-eai-method-repo")
    private BMDataEaiMethodRepository bmdEaiMethodRepository;
    @Autowired
    private BMDInvoker bmdInvoker;
    @Autowired
    private EaiRegisterUtil eaiRegisterUtil;
    @Autowired
    private DWEAIHeaderRepository eaiHeaderRepository;

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Async
    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof InstanceRegisteredEvent) {
            if (BooleanUtils.isTrue((Boolean)this.bmProperties.isInitRegEvent())) {
                BMNacosRigestionApplicationListener.log.debug("{} ignore InstanceRegisteredEvent", (Object)BMNacosRigestionApplicationListener._CLASSTAG);
                return;
            }
            newEspEaiHeaders = new ArrayList<E>();
            serviceMappings = new ArrayList<E>();
            mappingModelInfos = new ArrayList<E>();
            currentBMRole = this.bmProperties.getRole();
            techEaiHeaders /* !! */  = new HashMap<K, ArrayList<E>>();
            this.initEspSdkInvoker();
            if (currentBMRole != null && currentBMRole == BMRole.bm) {
                bmTargetProds = DWApplicationConfigUtils.getProperty((String)"lcdp.bm.target.prod");
                if (StringUtils.isEmpty((CharSequence)bmTargetProds)) {
                    throw new RuntimeException(String.format("%s %s properties is not configured", new Object[]{BMNacosRigestionApplicationListener._CLASSTAG, "lcdp.bm.target.prod"}));
                }
                bmTargetProdList = Stream.of(bmTargetProds.split(",")).collect(Collectors.toList());
                queue = new LinkedBlockingDeque<Object>();
                queue.addAll(bmTargetProdList);
                targetProd = null;
                result = null;
                while ((targetProd = (String)queue.poll()) != null) {
                    try {
                        result = this.bmdInvoker.invokeGetBMDCodes(targetProd);
                        if ("0".equals(result.getCode())) break;
                        BMNacosRigestionApplicationListener.log.error("<<< get codes failed from target prod:{},caused by :{} ,it'll be try another target prod", (Object)targetProd, (Object)result.getDescription());
                        queue.add(targetProd);
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException var12_17) {
                        }
                    }
                    catch (Exception e) {
                        BMNacosRigestionApplicationListener.log.error("<<< get codes failed from target prod:{},it'll be try another target prod", (Object)targetProd, (Object)e);
                        queue.add(targetProd);
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException var13_19) {}
                    }
                }
                params = result.getParameter();
                serviceMappings = (List)JsonUtils.readValue((String)DWGsonProvider.getGson().toJson(params.get("serviceMapping")), (TypeReference)new TypeReference<List<DWServiceMapping>>(this){});
                mappingModelInfos = (List)JsonUtils.readValue((String)DWGsonProvider.getGson().toJson(params.get("mappingModelInfos")), (TypeReference)new TypeReference<List<MappingModelInfo>>(this){});
                ServiceMappingUtil.updateProd(serviceMappings, mappingModelInfos);
                serviceModelCodes = new ArrayList<E>();
                serviceMappings.stream().forEach((Consumer<DWServiceMapping>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$onApplicationEvent$0(java.util.List com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping ), (Lcom/digiwin/lcdp/modeldriven/pojo/DWServiceMapping;)V)(serviceModelCodes));
                BMNacosRigestionApplicationListener.log.debug("{} get codes(total:{}) successfully(from bmd target prod):{}", new Object[]{BMNacosRigestionApplicationListener._CLASSTAG, serviceModelCodes.size(), serviceModelCodes});
                try {
                    if (!CollectionUtils.isNotEmpty(serviceMappings)) ** GOTO lbl66
                    techEaiHeaders /* !! */  = this.eaiHeaderUtil.genServiceDiscoveryModelDrivenEaiHeaders(serviceMappings, mappingModelInfos);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else if (currentBMRole == BMRole.bmd) {
                try {
                    bmCode = (DWEAIResult)this.bmDataEAICrudService.getBMDCode(null, null);
                    serviceMappings = bmCode.getParameter().getOrDefault("serviceMapping", new ArrayList<E>());
                    mappingModelInfos = bmCode.getParameter().getOrDefault("mappingModelInfos", new ArrayList<E>());
                    if (CollectionUtils.isNotEmpty(serviceMappings)) {
                        techEaiHeaders /* !! */  = this.eaiHeaderUtil.genServiceDiscoveryModelDrivenEaiHeaders(serviceMappings, mappingModelInfos);
                    }
                }
                catch (Exception e) {
                    BMNacosRigestionApplicationListener.log.error("<<< get codes failed", (Throwable)e);
                    throw new RuntimeException("get codes failed ", e);
                }
            }
lbl66:
            // 5 sources

            modelDrivenGroupHeaders = this.eaiHeaderRepository.getHeaders("commons");
            espEaiHeaders = techEaiHeaders /* !! */ .getOrDefault("esp", new ArrayList<E>());
            if (CollectionUtils.isNotEmpty((Collection)espEaiHeaders)) {
                try {
                    this.eaiHeaderUtil.addAndUpdateDWEaiHeaders(espEaiHeaders);
                    BMNacosRigestionApplicationListener.log.info("{} *** BM({}) *** eai service start register ESP, size:{}", new Object[]{BMNacosRigestionApplicationListener._CLASSTAG, currentBMRole.getRole(), espEaiHeaders.size()});
                    this.eaiRegisterUtil.autoRegisterEAI(espEaiHeaders);
                    BMNacosRigestionApplicationListener.log.info("{} *** BM({}) *** eai service registered register ESP", (Object)BMNacosRigestionApplicationListener._CLASSTAG, (Object)currentBMRole.getRole());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            nacosEaiHeaders = techEaiHeaders /* !! */ .getOrDefault("nacos", new ArrayList<E>());
            try {
                if (CollectionUtils.isNotEmpty((Collection)nacosEaiHeaders)) {
                    this.eaiHeaderUtil.addAndUpdateDWEaiHeaders(nacosEaiHeaders);
                }
                modelDrivenGroupHeaders.stream().forEach((Consumer<DWHeader>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$onApplicationEvent$1(java.util.List com.digiwin.app.container.DWHeader ), (Lcom/digiwin/app/container/DWHeader;)V)((List)nacosEaiHeaders));
                Thread.sleep(2000L);
                BMNacosRigestionApplicationListener.log.info("{} nacos service start register, size:{}", (Object)BMNacosRigestionApplicationListener._CLASSTAG, (Object)nacosEaiHeaders.size());
                this.nacosRegisterUtils.registerService(nacosEaiHeaders);
                BMNacosRigestionApplicationListener.log.info("{} nacos service registered finished", (Object)BMNacosRigestionApplicationListener._CLASSTAG);
            }
            catch (Exception e) {
                BMNacosRigestionApplicationListener.log.error("{} nacos service register failed:{}", (Object)BMNacosRigestionApplicationListener._CLASSTAG, (Object)e);
                throw new RuntimeException("nacos service register failed", e);
            }
            this.bmProperties.setInitRegEvent(true);
            BMNacosRigestionApplicationListener.log.info("{}[onApplicationEvent] finished ({})", (Object)BMNacosRigestionApplicationListener._CLASSTAG, event.getClass());
        } else if (event instanceof NacosServiceRegisterEvent) {
            try {
                this.nacosRegisterUtils.nacosServiceRegister((List)event.getSource());
            }
            catch (Exception e) {
                BMNacosRigestionApplicationListener.log.error("{} nacos service register failed:{}", (Object)BMNacosRigestionApplicationListener._CLASSTAG, (Object)e);
                throw new RuntimeException("nacos service register failed", e);
            }
        } else {
            BMNacosRigestionApplicationListener.log.debug("{}[{}] ignored invalid event ({})", new Object[]{BMNacosRigestionApplicationListener._CLASSTAG, "onApplicationEvent", event.getClass().getName()});
        }
        BMNacosRigestionApplicationListener.log.info("{}[{}] finished", (Object)BMNacosRigestionApplicationListener._CLASSTAG, (Object)"onApplicationEvent");
    }

    private void initEspSdkInvoker() {
        String espDomain = DWApplicationConfigUtils.getProperty((String)"esp.domain");
        String mdcDomain = DWApplicationConfigUtils.getProperty((String)"mdc.domain");
        String tmDomain = DWApplicationConfigUtils.getProperty((String)"tm.domain");
        String eocDomain = DWApplicationConfigUtils.getProperty((String)"eoc.domain");
        String lmcDomain = DWApplicationConfigUtils.getProperty((String)"lmcUrl");
        EspSdkInitialize.initConfig((String)espDomain, (String)mdcDomain, (String)tmDomain, (String)eocDomain);
        EspSdkInitialize.initLmcConfig((String)lmcDomain);
        log.info("{}[{}] finished", (Object)_CLASSTAG, (Object)"initEspSdkInvoker");
    }

    private static /* synthetic */ void lambda$onApplicationEvent$1(List nacosEaiHeaders, DWHeader modelDrivenHeader) {
        nacosEaiHeaders.add((DWEAIHeader)modelDrivenHeader);
    }

    private static /* synthetic */ void lambda$onApplicationEvent$0(List serviceModelCodes, DWServiceMapping serviceMapping) {
        serviceModelCodes.add(serviceMapping.getCode());
    }
}

