/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.eai;

import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.constants.BMConstants;
import com.digiwin.lcdp.modeldriven.customize.model.BMDataEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.customize.utils.BMCenterUtil;
import com.digiwin.lcdp.modeldriven.eai.builder.EaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.eai.builder.ModelStandardEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.enums.ModelApiTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDrivenEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.BindApi;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.pojo.ModelDrivenEaiMethodDTO;
import com.digiwin.lcdp.modeldriven.utils.ApiTypeUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMethodHelper;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BMDataEaiHeaderBuilder
implements EaiHeaderBuilder {
    private static final Logger log = LoggerFactory.getLogger(BMDataEaiHeaderBuilder.class);
    private static final String _CLASSTAG = "[" + BMDataEaiHeaderBuilder.class.getSimpleName() + "]";
    @Autowired
    @Qualifier(value="dw-modeldriven-crud-eai-builder")
    ModelStandardEaiHeaderBuilder modelStandardEAIHeaderBuilder;
    @Autowired
    @Qualifier(value="dw-modeldriven-eai-repo")
    ModelDrivenEaiMethodRepository modelDrivenEaiMethodRepo;
    @Autowired
    @Qualifier(value="lcdp-bmd-eai-method-repo")
    BMDataEaiMethodRepository bmdEaiMethodRepository;
    @Autowired
    @Qualifier(value="bmCodes")
    Map<String, BMCode> bmCodes;

    @Override
    public List<DWEAIHeader> getEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        ArrayList<DWEAIHeader> standardEaiHeaders = new ArrayList<DWEAIHeader>();
        Method setMappingMethod = ModelDrivenMethodHelper.getSetMappingMethodAccessibleOfDWEAIHeader();
        String targetProdOfSite = BMCenterUtil.getProdOfSite();
        this.clearEaiHeaders();
        int serviceMapCount = 0;
        for (DWServiceMapping eaiService : serviceMappings) {
            ++serviceMapCount;
            String eaiTableName = eaiService.getTableName();
            String modelCode = eaiService.getCode();
            String modelSchemaStr = eaiService.getModelSchema();
            ModelSchemaDTO modelSchema = ModelSchemaUtil.getModelSchema(modelSchemaStr);
            String userExposePrefixEaiId = eaiService.getExposeEaiId();
            String eaiProd = eaiService.getProd();
            log.debug("{}[{}] serviceMapping: prod({}), eaiService({}), userExposePrefixEaiId({}) processing...", new Object[]{_CLASSTAG, serviceMapCount, eaiProd, eaiService.toSimpleString(), userExposePrefixEaiId});
            String targetProdOfDWServiceMapping = eaiService.getTargetProd();
            if (StringUtils.isBlank((CharSequence)targetProdOfDWServiceMapping)) {
                List<DWEAIHeader> newStdEaiHeaders = this.modelStandardEAIHeaderBuilder.getStdEaiHeaders(setMappingMethod, eaiService);
                standardEaiHeaders.addAll(newStdEaiHeaders);
                if (this.bmCodes == null) continue;
                newStdEaiHeaders.stream().forEach(stdEaiHeader -> this.bmCodes.put(((DWEAIHeader)stdEaiHeader).getEAIServiceId(), new BMCode(modelCode, targetProdOfDWServiceMapping, eaiTableName)));
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)targetProdOfDWServiceMapping) && targetProdOfSite.equalsIgnoreCase(targetProdOfDWServiceMapping)) {
                List<BindApi> bmdApiListConfig = modelSchema.getBmdApiListConfig();
                List<DWEAIHeader> newBMDEaiHeaders = this.getBMDataEaiHeaders(setMappingMethod, eaiService, this.bmdEaiMethodRepository, bmdApiListConfig);
                log.debug("{}[{}] targetProd matched, actual({}), expected(site:{}), add eaiservice({})", new Object[]{_CLASSTAG, serviceMapCount, targetProdOfDWServiceMapping, targetProdOfSite, newBMDEaiHeaders.stream().map(eaiHeader -> eaiHeader.getEAIServiceId()).collect(Collectors.toList())});
                this.bmdEaiMethodRepository.addEaiHeaders(newBMDEaiHeaders);
                if (this.bmCodes == null) continue;
                this.updateBMDataLayerBMCodes(eaiService, newBMDEaiHeaders, bmdApiListConfig);
                continue;
            }
            log.info("{}[{}] targetProd not match, actual({}), expected(site:{})", new Object[]{_CLASSTAG, serviceMapCount, targetProdOfDWServiceMapping, targetProdOfSite});
        }
        if (mappingModelInfos.size() > 0) {
            List<MappingModelInfo> stdMappingModelInfos;
            Method stdListGetMethod = this.modelDrivenEaiMethodRepo.getListGetMethod();
            Optional<Class<?>> stdEaiCrudClazz = this.modelDrivenEaiMethodRepo.getEaiClazz();
            List<MappingModelInfo> bmdMappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> mappingModelInfo.getTargetProd() != null).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(bmdMappingModelInfos)) {
                List<DWEAIHeader> newBMDChildrenListGetHeaders = this.getBMDataListGetHeaders(setMappingMethod, stdEaiCrudClazz, stdListGetMethod, bmdMappingModelInfos);
                this.bmdEaiMethodRepository.addEaiHeaders(newBMDChildrenListGetHeaders);
            }
            if (CollectionUtils.isNotEmpty(stdMappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> StringUtils.isBlank((CharSequence)mappingModelInfo.getTargetProd())).collect(Collectors.toList()))) {
                List<DWEAIHeader> newStdListGetHeaders = this.modelStandardEAIHeaderBuilder.getStdListGetHeaders(setMappingMethod, stdEaiCrudClazz, stdListGetMethod, stdMappingModelInfos, null);
                standardEaiHeaders.addAll(newStdListGetHeaders);
            }
        }
        this.modelStandardEAIHeaderBuilder.addIgnoreIntercepter(standardEaiHeaders);
        this.bmdEaiMethodRepository.addEaiHeaders(standardEaiHeaders);
        return standardEaiHeaders;
    }

    public List<DWEAIHeader> getBMDataEaiHeaders(Method setMappingMethod, DWServiceMapping eaiService, BMDataEaiMethodRepository bmdEaiMethodRepo, List<BindApi> bmdApiListConfig) throws InvocationTargetException, IllegalAccessException {
        List<Object> newEaiHeaders = new ArrayList();
        String targetProdOfDWServiceMapping = eaiService.getTargetProd();
        String targetProdOfCode = BMCenterUtil.getEaiServicePrefix(targetProdOfDWServiceMapping);
        Map<String, ModelDrivenEaiMethodDTO> bmdRepoEaiMethods = bmdEaiMethodRepo.getEaiMethodRepo();
        log.info("{} enter BMD master eai service", (Object)_CLASSTAG);
        String eaiTableName = eaiService.getTableName();
        String userExposePrefixEaiId = eaiService.getExposeEaiId();
        String bmdEaiId = EaiServiceNameUtil.covertToServiceName(eaiTableName);
        String bmdPrefixExposeEaiId = String.join((CharSequence)".", targetProdOfCode, bmdEaiId);
        String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
        log.debug("{} *** BMD *** serviceMapping: expose_eai_id prefix({}) from target prod ({}->{}), table_name({})", new Object[]{_CLASSTAG, bmdPrefixExposeEaiId, targetProdOfDWServiceMapping, targetProdOfCode, eaiTableName});
        boolean hasBindApiList = ModelDataUtil.hasBindApiConfig(bmdApiListConfig);
        if (hasBindApiList) {
            List mdServiceNames = bmdRepoEaiMethods.keySet().stream().collect(Collectors.toList());
            for (BindApi bindApi : bmdApiListConfig) {
                String apiName = bindApi.getApiName();
                String apiType = bindApi.getApiType();
                ModelDrivenEaiMethodDTO bmdEaiMethodDTO = this.getEaiMethod(apiType, bmdRepoEaiMethods);
                if (bmdEaiMethodDTO != null) {
                    Optional<Class<?>> eaiClazz = Optional.of(bmdEaiMethodDTO.getMethod().getDeclaringClass());
                    DWEAIHeader headerV = new DWEAIHeader("commons", apiName, eaiClazz.get());
                    setMappingMethod.invoke((Object)headerV, bmdEaiMethodDTO.getMethod(), false);
                    newEaiHeaders.add(headerV);
                    log.debug("{} *** BMD *** serviceMapping: hasBindApiList({}) add headerV expose_eai_id({})(ignored org serviceMapping eaiid prefix({})", new Object[]{_CLASSTAG, hasBindApiList, headerV.getEAIServiceId(), eaiService.getExposeEaiId()});
                    continue;
                }
                log.info("{} code({}) can't find lcdp base method, apiName({}) apiType({})", new Object[]{_CLASSTAG, eaiService.getCode(), apiName, apiType});
            }
        } else {
            newEaiHeaders = this.getBMDataStdEaiHeaders(setMappingMethod, eaiService, bmdEaiMethodRepo);
        }
        log.debug("{}[getBMDataEaiHeaders] serviceMapping: gen headerV expose_eai_id({})", (Object)_CLASSTAG, newEaiHeaders.stream().map(eaiHeader -> eaiHeader.getEAIServiceId()).collect(Collectors.toList()));
        return newEaiHeaders;
    }

    protected List<DWEAIHeader> getBMDataBindApiEaiHeaders(Method setMappingMethod, DWServiceMapping eaiService, BMDataEaiMethodRepository bmdEaiMethodRepo, List<BindApi> bmdApiListConfig) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        String targetProdOfDWServiceMapping = eaiService.getTargetProd();
        String targetProdOfCode = BMCenterUtil.getEaiServicePrefix(targetProdOfDWServiceMapping);
        Map<String, ModelDrivenEaiMethodDTO> mdEaiMethods = bmdEaiMethodRepo.getEaiMethodRepo();
        log.info("{} enter BMD master eai service", (Object)_CLASSTAG);
        String eaiTableName = eaiService.getTableName();
        String bmdEaiId = EaiServiceNameUtil.covertToServiceName(eaiTableName);
        String bmdPrefixExposeEaiId = String.join((CharSequence)".", targetProdOfCode, bmdEaiId);
        log.debug("{} *** BMD *** serviceMapping: expose_eai_id prefix({}) from target prod ({}->{}), table_name({})", new Object[]{_CLASSTAG, bmdPrefixExposeEaiId, targetProdOfDWServiceMapping, targetProdOfCode, eaiTableName});
        for (Map.Entry<String, ModelDrivenEaiMethodDTO> mdEaiMethod : mdEaiMethods.entrySet()) {
            ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethod.getValue();
            Optional<Class<?>> eaiClazz = Optional.of(mdEaiMethodDTO.getMethod().getDeclaringClass());
            String eaiServiceIdForServiceMapping = String.join((CharSequence)".", bmdPrefixExposeEaiId, "std", mdEaiMethodDTO.getEaiServicePostfix());
            DWEAIHeader headerV = new DWEAIHeader("commons", eaiServiceIdForServiceMapping, eaiClazz.get());
            setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
            newEaiHeaders.add(headerV);
        }
        log.debug("{}[getBMDataEaiHeaders] serviceMapping: gen headerV expose_eai_id({})", (Object)_CLASSTAG, newEaiHeaders.stream().map(eaiHeader -> eaiHeader.getEAIServiceId()).collect(Collectors.toList()));
        return newEaiHeaders;
    }

    protected List<DWEAIHeader> getBMDataStdEaiHeaders(Method setMappingMethod, DWServiceMapping eaiService, BMDataEaiMethodRepository bmdEaiMethodRepo) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        String targetProdOfDWServiceMapping = eaiService.getTargetProd();
        String targetProdOfCode = BMCenterUtil.getEaiServicePrefix(targetProdOfDWServiceMapping);
        Map<String, ModelDrivenEaiMethodDTO> mdEaiMethods = bmdEaiMethodRepo.getEaiMethodRepo();
        log.info("{} enter BMD master eai service", (Object)_CLASSTAG);
        String eaiTableName = eaiService.getTableName();
        String bmdEaiId = EaiServiceNameUtil.covertToServiceName(eaiTableName);
        String bmdPrefixExposeEaiId = String.join((CharSequence)".", targetProdOfCode, bmdEaiId);
        log.debug("{} *** BMD *** serviceMapping: expose_eai_id prefix({}) from target prod ({}->{}), table_name({})", new Object[]{_CLASSTAG, bmdPrefixExposeEaiId, targetProdOfDWServiceMapping, targetProdOfCode, eaiTableName});
        for (Map.Entry<String, ModelDrivenEaiMethodDTO> mdEaiMethod : mdEaiMethods.entrySet()) {
            ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethod.getValue();
            Optional<Class<?>> eaiClazz = Optional.of(mdEaiMethodDTO.getMethod().getDeclaringClass());
            String eaiServiceIdForServiceMapping = String.join((CharSequence)".", bmdPrefixExposeEaiId, "std", mdEaiMethodDTO.getEaiServicePostfix());
            DWEAIHeader headerV = new DWEAIHeader("commons", eaiServiceIdForServiceMapping, eaiClazz.get());
            setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
            newEaiHeaders.add(headerV);
        }
        log.debug("{}[getBMDataEaiHeaders] serviceMapping: gen headerV expose_eai_id({})", (Object)_CLASSTAG, newEaiHeaders.stream().map(eaiHeader -> eaiHeader.getEAIServiceId()).collect(Collectors.toList()));
        return newEaiHeaders;
    }

    public List<DWEAIHeader> getBMDataListGetHeaders(Method setMappingMethod, Optional<Class<?>> eaiClazz, Method listGetMethod, List<MappingModelInfo> mappingModelInfos) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
        if (mappingModelInfos.size() > 0 && listGetMethod != null) {
            log.info("{}EaiServiceUtil] enter children .list.get", (Object)_CLASSTAG);
            int modelinfoCount = 1;
            for (MappingModelInfo mappingModelInfo : mappingModelInfos) {
                String childTableName = mappingModelInfo.getChildtbl();
                String eaiTableName = mappingModelInfo.getTablename();
                String modelCode = mappingModelInfo.getCode();
                String targetProdOfDWServiceMapping = mappingModelInfo.getTargetProd();
                String targetProdOfCode = BMCenterUtil.getEaiServicePrefix(targetProdOfDWServiceMapping);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] code({}) serviceMapping-child: target_prod({}), child table({}), tableName({})", new Object[]{_CLASSTAG, modelinfoCount++, modelCode, targetProdOfCode, childTableName, eaiTableName});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    String bmdEaiId = EaiServiceNameUtil.covertToServiceName(childTableName);
                    String childEaiServiceIdForServiceMapping = String.join((CharSequence)".", targetProdOfCode, bmdEaiId, "std", "get");
                    log.info("{} *** BMD *** code({}), serviceMapping-child: childEaiServiceIdForServiceMapping({})", new Object[]{_CLASSTAG, modelCode, childEaiServiceIdForServiceMapping});
                    DWEAIHeader headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, eaiClazz.get());
                    setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                    childTableListGetHeaders.add(headerV);
                    if (log.isDebugEnabled()) {
                        log.debug("     --->> add eai service id:({}) by code [{}] ", (Object)headerV.getEAIServiceId(), (Object)modelCode);
                    }
                    if (this.bmCodes == null) continue;
                    this.bmCodes.put(bmdEaiId, new BMCode(modelCode, targetProdOfDWServiceMapping, eaiTableName));
                    continue;
                }
                log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
            }
            log.info("{}[getBMDataListGetHeaders] serviceMapping: children table .list.get count:{}", (Object)_CLASSTAG, (Object)childTableListGetHeaders.size());
        } else {
            log.warn("{}[getBMDataListGetHeaders] serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", new Object[]{_CLASSTAG, 0, listGetMethod});
        }
        return childTableListGetHeaders;
    }

    @Override
    public List<DWEAIHeader> getSubListGetHeaders(Method setMappingMethod, List<MappingModelInfo> mappingModelInfos, ModelSchemaDTO modelSchema) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
        Method listGetMethod = this.modelDrivenEaiMethodRepo.getListGetMethod();
        Optional<Class<?>> eaiClazz = this.modelDrivenEaiMethodRepo.getEaiClazz();
        if (mappingModelInfos.size() > 0 && listGetMethod != null) {
            log.info("{}[EaiServiceUtil] enter children .list.get", (Object)_CLASSTAG);
            Map<String, ModelSchemaDTO> modelSchemaMap = ModelSchemaUtil.getModelSchemaMap(modelSchema);
            int modelinfoCount = 0;
            for (MappingModelInfo mappingModelInfo : mappingModelInfos) {
                ++modelinfoCount;
                String childTableName = mappingModelInfo.getChildtbl();
                String eaiTableName = mappingModelInfo.getTablename();
                String modelCode = mappingModelInfo.getCode();
                String targetProdOfDWServiceMapping = mappingModelInfo.getTargetProd();
                String targetProdOfCode = BMCenterUtil.getEaiServicePrefix(targetProdOfDWServiceMapping);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] code({}) serviceMapping-child: target_prod({}), child table({}), tableName({})", new Object[]{_CLASSTAG, modelinfoCount, modelCode, targetProdOfCode, childTableName, eaiTableName});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    ModelSchemaDTO subModelSchema = modelSchemaMap.get(childTableName);
                    List<BindApi> subBmdApiListConfig = subModelSchema.getBmdApiListConfig();
                    boolean hasBindApiList = ModelDataUtil.hasBindApiConfig(subBmdApiListConfig);
                    if (hasBindApiList) {
                        for (BindApi bindApi : subBmdApiListConfig) {
                            String apiName = bindApi.getApiName();
                            String apiType = bindApi.getApiType();
                            DWEAIHeader headerV = new DWEAIHeader("commons", apiName, eaiClazz.get());
                            setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                            childTableListGetHeaders.add(headerV);
                            log.debug("{} *** BMD *** serviceMapping: hasBindApiList({}) add headerV expose_eai_id({})(ignored org serviceMapping eaiid prefix({})", new Object[]{_CLASSTAG, hasBindApiList, headerV.getEAIServiceId(), apiName});
                            BMCode bmCode = new BMCode(modelCode, targetProdOfDWServiceMapping, eaiTableName, true, childTableName);
                            bmCode.setApiType(apiType);
                            this.bmCodes.put(apiName, bmCode);
                        }
                        continue;
                    }
                    String bmdEaiId = EaiServiceNameUtil.covertToServiceName(childTableName);
                    String childEaiServiceIdForServiceMapping = String.join((CharSequence)".", targetProdOfCode, bmdEaiId, "std", "get");
                    log.info("{} *** BMD *** code({}), serviceMapping-child: childEaiServiceIdForServiceMapping({})", new Object[]{_CLASSTAG, modelCode, childEaiServiceIdForServiceMapping});
                    DWEAIHeader headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, eaiClazz.get());
                    setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                    childTableListGetHeaders.add(headerV);
                    if (log.isDebugEnabled()) {
                        log.debug("     --->> add eai service id:({}) by code [{}] ", (Object)headerV.getEAIServiceId(), (Object)modelCode);
                    }
                    BMCode bmCode = new BMCode(modelCode, targetProdOfDWServiceMapping, eaiTableName, true, childTableName);
                    bmCode.setApiType(ModelApiTypeEnum.SUB_GET.getApiTypeName());
                    this.bmCodes.put(childEaiServiceIdForServiceMapping, bmCode);
                    continue;
                }
                log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
            }
            log.info("{}[getSubListGetHeaders] serviceMapping: children table .list.get count:{}", (Object)_CLASSTAG, (Object)childTableListGetHeaders.size());
        } else {
            log.warn("{}[getSubListGetHeaders] serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", new Object[]{_CLASSTAG, 0, listGetMethod});
        }
        return childTableListGetHeaders;
    }

    public List<DWEAIHeader> convertBMDataEAIHeader(Method setMappingMethod, DWServiceMapping eaiService, BMDataEaiMethodRepository eaiMethodRepo, List<BindApi> bindApiListConfig) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        Map<String, ModelDrivenEaiMethodDTO> mdEaiMethods = eaiMethodRepo.getEaiMethodRepo();
        for (BindApi bindApi : bindApiListConfig) {
            String apiName = bindApi.getApiName();
            String apiType = bindApi.getApiType();
            List mdServiceNames = mdEaiMethods.keySet().stream().collect(Collectors.toList());
            Optional<String> optMatchServiceName = mdServiceNames.stream().filter(mdServiceName -> mdServiceName.contains("." + apiType)).findFirst();
            if (optMatchServiceName.isPresent()) {
                String actualEaiId = optMatchServiceName.get();
                ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethods.get(actualEaiId);
                Optional<Class<?>> eaiClazz = Optional.of(mdEaiMethodDTO.getMethod().getDeclaringClass());
                DWEAIHeader headerV = new DWEAIHeader("commons", apiName, eaiClazz.get());
                setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
                newEaiHeaders.add(headerV);
                continue;
            }
            log.info("{}[convertBMDataEAIHeader] can't find lcdp base method, bindApi({}) ", (Object)_CLASSTAG, (Object)bindApi);
        }
        return newEaiHeaders;
    }

    @Override
    public Map<String, List<DWEAIHeader>> getTechEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        ArrayList<DWEAIHeader> nacosEaiHeaders = new ArrayList<DWEAIHeader>();
        ArrayList<DWEAIHeader> espEaiHeaders = new ArrayList<DWEAIHeader>();
        Method setMappingMethod = ModelDrivenMethodHelper.getSetMappingMethodAccessibleOfDWEAIHeader();
        String targetProdOfSite = BMCenterUtil.getProdOfSite();
        int serviceMapCount = 0;
        boolean newServiceMappingHeaderCount = false;
        for (DWServiceMapping eaiService : serviceMappings) {
            String targetProdOfDWServiceMapping;
            ++serviceMapCount;
            String eaiTableName = eaiService.getTableName();
            String modelCode = eaiService.getCode();
            String modelSchemaStr = eaiService.getModelSchema();
            ModelSchemaDTO modelSchema = ModelSchemaUtil.getModelSchema(modelSchemaStr);
            if (log.isDebugEnabled()) {
                String userExposePrefixEaiId = eaiService.getExposeEaiId();
                String eaiProd = eaiService.getProd();
                log.debug("{}[{}] serviceMapping: prod({}), eaiService({}), userExposePrefixEaiId({}}) processing...", new Object[]{_CLASSTAG, serviceMapCount, eaiProd, eaiService.toSimpleString(), userExposePrefixEaiId});
            }
            if (StringUtils.isBlank((CharSequence)(targetProdOfDWServiceMapping = eaiService.getTargetProd()))) {
                List<MappingModelInfo> stdMappingModelInfos;
                List<DWEAIHeader> newStdEaiHeaders = this.modelStandardEAIHeaderBuilder.getStdEaiHeaders(setMappingMethod, eaiService);
                espEaiHeaders.addAll(newStdEaiHeaders);
                if (this.bmCodes != null) {
                    newStdEaiHeaders.stream().forEach(stdEaiHeader -> {
                        String apiType = ApiTypeUtil.getStdApiType(stdEaiHeader);
                        BMCode bmCode = new BMCode(modelCode, targetProdOfDWServiceMapping, eaiTableName);
                        bmCode.setApiType(apiType);
                        this.bmCodes.put(stdEaiHeader.getEAIServiceId(), bmCode);
                    });
                }
                if (!CollectionUtils.isNotEmpty(stdMappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> mappingModelInfo.getCode().equals(modelCode) && !mappingModelInfo.getChildtbl().equals(eaiTableName)).collect(Collectors.toList()))) continue;
                List<DWEAIHeader> stdListGetHeaders = this.modelStandardEAIHeaderBuilder.getSubListGetHeaders(setMappingMethod, stdMappingModelInfos, modelSchema);
                espEaiHeaders.addAll(stdListGetHeaders);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)targetProdOfDWServiceMapping) && targetProdOfSite.equalsIgnoreCase(targetProdOfDWServiceMapping)) {
                List<BindApi> bmdApiListConfig = modelSchema.getBmdApiListConfig();
                List<DWEAIHeader> bmdEaiHeaders = this.getBMDataEaiHeaders(setMappingMethod, eaiService, this.bmdEaiMethodRepository, bmdApiListConfig);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] targetProd matched, actual({}), expected(site:{}), add eaiservice({})", new Object[]{_CLASSTAG, serviceMapCount, targetProdOfDWServiceMapping, targetProdOfSite, bmdEaiHeaders.stream().map(eaiHeader -> eaiHeader.getEAIServiceId()).collect(Collectors.toList())});
                }
                this.updateBMDataLayerBMCodes(eaiService, bmdEaiHeaders, bmdApiListConfig);
                List<MappingModelInfo> currentSubModels = mappingModelInfos.stream().filter(mappingModelInfo -> mappingModelInfo.getCode().equals(modelCode) && !mappingModelInfo.getChildtbl().equals(eaiTableName)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(currentSubModels)) {
                    log.debug("{}[getTechEaiService] code({}) have children list api", (Object)_CLASSTAG, (Object)modelCode);
                    List<DWEAIHeader> newBMDChildrenListGetHeaders = this.getSubListGetHeaders(setMappingMethod, currentSubModels, modelSchema);
                    bmdEaiHeaders.addAll(newBMDChildrenListGetHeaders);
                } else {
                    log.debug("{}[getTechEaiService] code({}) have none children list api", (Object)_CLASSTAG, (Object)modelCode);
                }
                nacosEaiHeaders.addAll(bmdEaiHeaders);
                continue;
            }
            log.info("{}[{}] targetProd not match, actual({}), expected(site:{})", new Object[]{_CLASSTAG, serviceMapCount, targetProdOfDWServiceMapping, targetProdOfSite});
        }
        List addEaiNames = espEaiHeaders.stream().filter(newEaiHeader -> BMConstants.BMD_OLD_MODEL_SERVIC_NAME.stream().noneMatch(existedName -> StringUtils.equals((CharSequence)existedName, (CharSequence)newEaiHeader.getEAIServiceId()))).map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList());
        BMConstants.BMD_OLD_MODEL_SERVIC_NAME.addAll(addEaiNames);
        HashMap<String, List<DWEAIHeader>> prodEaiHeaders = new HashMap<String, List<DWEAIHeader>>();
        prodEaiHeaders.put("esp", espEaiHeaders);
        prodEaiHeaders.put("nacos", nacosEaiHeaders);
        return prodEaiHeaders;
    }

    @Override
    public Map<String, Map<String, List<DWEAIHeader>>> getProdEaiHeadersByService(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        HashMap<String, Map<String, List<DWEAIHeader>>> prodEaiHeadersMap = new HashMap<String, Map<String, List<DWEAIHeader>>>();
        ArrayList nacosEaiHeaders = new ArrayList();
        ArrayList espEaiHeaders = new ArrayList();
        Method setMappingMethod = ModelDrivenMethodHelper.getSetMappingMethodAccessibleOfDWEAIHeader();
        String targetProdOfSite = BMCenterUtil.getProdOfSite();
        this.clearEaiHeaders();
        int serviceMapCount = 0;
        int newServiceMappingHeaderCount = 0;
        BMRole bmRole = BMProperties.getProperties().getRole();
        for (DWServiceMapping eaiService : serviceMappings) {
            ++serviceMapCount;
            String eaiTableName = eaiService.getTableName();
            String targetProdOfDWServiceMapping = eaiService.getTargetProd();
            String userExposePrefixEaiId = eaiService.getExposeEaiId();
            String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
            if (log.isDebugEnabled()) {
                log.debug("{}[{}] *** BM({}) *** serviceMapping: prod({}), targetProd({}), eaiService({}), userExposePrefixEaiId({}}) processing...", new Object[]{_CLASSTAG, serviceMapCount, bmRole, eaiProd, targetProdOfDWServiceMapping, eaiService.toSimpleString(), userExposePrefixEaiId});
            }
            HashMap techTypeEaiHeaders = new HashMap();
            Map prodRegTypeEaiHeaders = prodEaiHeadersMap.getOrDefault(targetProdOfDWServiceMapping, new HashMap());
            if (StringUtils.isBlank((CharSequence)targetProdOfDWServiceMapping)) {
                log.info("{}[getProdEaiHeadersByService][{}] mix-bmd serviceMapping: ignored, cause target_prod is blank for prod({}) eaiService({})", new Object[]{_CLASSTAG, serviceMapCount, eaiService.getProd(), eaiService.toSimpleString()});
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)targetProdOfDWServiceMapping) && targetProdOfSite.equalsIgnoreCase(targetProdOfDWServiceMapping)) {
                List<DWEAIHeader> bmdEaiHeaders = this.getBMDataStdEaiHeaders(setMappingMethod, eaiService, this.bmdEaiMethodRepository);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] *** BM({}) targetProd matched, actual({}), expected(site:{}), add eaiservice({})", new Object[]{_CLASSTAG, serviceMapCount, bmRole.getRole(), targetProdOfDWServiceMapping, targetProdOfSite, bmdEaiHeaders.stream().map(eaiHeader -> eaiHeader.getEAIServiceId()).collect(Collectors.toList())});
                }
                List prodNacosEaiHeaders = prodRegTypeEaiHeaders.getOrDefault("nacos", new ArrayList());
                prodNacosEaiHeaders.addAll(bmdEaiHeaders);
                prodRegTypeEaiHeaders.put("nacos", prodNacosEaiHeaders);
                prodEaiHeadersMap.put(targetProdOfDWServiceMapping, prodRegTypeEaiHeaders);
                continue;
            }
            log.info("{}[{}] targetProd not match, actual({}), expected(site:{})", new Object[]{_CLASSTAG, serviceMapCount, targetProdOfDWServiceMapping, targetProdOfSite});
        }
        int newNacosServiceMappingHeaderCount = nacosEaiHeaders.size();
        newServiceMappingHeaderCount = espEaiHeaders.size();
        int newMappingModelInfoHeaderCount = 0;
        int newNacosMappingModelInfoHeaderCount = 0;
        if (mappingModelInfos.size() > 0) {
            Method stdListGetMethod = this.modelDrivenEaiMethodRepo.getListGetMethod();
            Optional<Class<?>> stdEaiCrudClazz = this.modelDrivenEaiMethodRepo.getEaiClazz();
            List<MappingModelInfo> bmdMappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> mappingModelInfo.getTargetProd() != null).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(bmdMappingModelInfos)) {
                Map<String, Map<String, List<DWEAIHeader>>> bmdChildrenListGetHeadersMap = this.getBMDataListGetHeadersByProd(setMappingMethod, stdEaiCrudClazz, stdListGetMethod, bmdMappingModelInfos);
                for (String prod : bmdChildrenListGetHeadersMap.keySet()) {
                    Map bmdProdChildrenListGet;
                    Map prodTechTypeEaiHeaderMap = (Map)prodEaiHeadersMap.get(prod);
                    List prodTechTypeNacosEaiHeaders = prodTechTypeEaiHeaderMap.getOrDefault("nacos", new ArrayList());
                    if (prodEaiHeadersMap.containsKey(prod)) {
                        bmdProdChildrenListGet = bmdChildrenListGetHeadersMap.getOrDefault(prod, new HashMap());
                        if (!bmdProdChildrenListGet.containsKey("nacos")) continue;
                        prodTechTypeNacosEaiHeaders.addAll((Collection)bmdProdChildrenListGet.get("nacos"));
                        prodEaiHeadersMap.put(prod, prodTechTypeEaiHeaderMap);
                        continue;
                    }
                    bmdProdChildrenListGet = bmdChildrenListGetHeadersMap.getOrDefault(prod, new HashMap());
                    if (!MapUtils.isNotEmpty((Map)bmdProdChildrenListGet)) continue;
                    prodEaiHeadersMap.put(prod, bmdProdChildrenListGet);
                }
            }
        }
        List addEaiNames = espEaiHeaders.stream().filter(newEaiHeader -> BMConstants.BMD_OLD_MODEL_SERVIC_NAME.stream().noneMatch(existedName -> StringUtils.equals((CharSequence)existedName, (CharSequence)newEaiHeader.getEAIServiceId()))).map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList());
        BMConstants.BMD_OLD_MODEL_SERVIC_NAME.addAll(addEaiNames);
        log.debug("{}[getEaiHeaders] *** BMD *** getEspEaiHeaders({})=std({})+mappingModelInfos({}) from serviceMappings({})", new Object[]{_CLASSTAG, espEaiHeaders.size(), newServiceMappingHeaderCount, newMappingModelInfoHeaderCount, serviceMapCount});
        log.debug("{}[getEaiHeaders] *** BMD *** getNacosEaiHeaders({})=std({})+mappingModelInfos({}) from serviceMappings({})", new Object[]{_CLASSTAG, this.bmdEaiMethodRepository.getEaiHeaders().size(), newNacosServiceMappingHeaderCount, newNacosMappingModelInfoHeaderCount, serviceMapCount});
        return prodEaiHeadersMap;
    }

    public Map<String, Map<String, List<DWEAIHeader>>> getBMDataListGetHeadersByProd(Method setMappingMethod, Optional<Class<?>> eaiClazz, Method listGetMethod, List<MappingModelInfo> mappingModelInfos) throws InvocationTargetException, IllegalAccessException {
        HashMap<String, Map<String, List<DWEAIHeader>>> childTableListGetHeadersMap = new HashMap<String, Map<String, List<DWEAIHeader>>>();
        if (mappingModelInfos.size() > 0 && listGetMethod != null) {
            log.info("{} EaiServiceUtil] enter children .list.get", (Object)_CLASSTAG);
            int modelinfoCount = 1;
            for (MappingModelInfo mappingModelInfo : mappingModelInfos) {
                ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
                String childTableName = mappingModelInfo.getChildtbl();
                String eaiTableName = mappingModelInfo.getTablename();
                String targetProdOfDWServiceMapping = mappingModelInfo.getTargetProd();
                String targetProdOfCode = BMCenterUtil.getEaiServicePrefix(targetProdOfDWServiceMapping);
                if (log.isDebugEnabled()) {
                    log.debug("{} [{}] code({}) serviceMapping-child: target_prod({}), child table({}), tableName({})", new Object[]{_CLASSTAG, modelinfoCount++, mappingModelInfo.getCode(), targetProdOfCode, childTableName, eaiTableName});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    String bmdEaiId = EaiServiceNameUtil.covertToServiceName(childTableName);
                    String childEaiServiceIdForServiceMapping = String.join((CharSequence)".", targetProdOfCode, bmdEaiId, "std", "get");
                    log.info("{} *** BMD *** code({}), serviceMapping-child: childEaiServiceIdForServiceMapping({})", new Object[]{_CLASSTAG, mappingModelInfo.getCode(), childEaiServiceIdForServiceMapping});
                    DWEAIHeader headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, eaiClazz.get());
                    setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                    childTableListGetHeaders.add(headerV);
                    Map prodEaiHeaders = childTableListGetHeadersMap.getOrDefault(targetProdOfDWServiceMapping, new HashMap());
                    List prodNacosEaiHeaders = prodEaiHeaders.getOrDefault("nacos", new ArrayList());
                    prodNacosEaiHeaders.addAll(childTableListGetHeaders);
                    prodEaiHeaders.put("nacos", prodNacosEaiHeaders);
                    childTableListGetHeadersMap.put(targetProdOfDWServiceMapping, prodEaiHeaders);
                    if (log.isDebugEnabled()) {
                        log.debug("     --->> add eai service id:({}) by code [{}] ", (Object)headerV.getEAIServiceId(), (Object)mappingModelInfo.getCode());
                    }
                } else {
                    log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
                }
                log.info("{}[getBMDataListGetHeaders] serviceMapping: children table .list.get count:{}", (Object)_CLASSTAG, (Object)childTableListGetHeaders.size());
            }
        } else {
            log.warn("{}[getBMDataListGetHeaders] serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", new Object[]{_CLASSTAG, 0, listGetMethod});
        }
        return childTableListGetHeadersMap;
    }

    @Override
    public Map<String, Map<String, List<DWEAIHeader>>> getProdTechEaiHeaders(Map<String, List<DWServiceMapping>> serviceMappingMap, Map<String, List<MappingModelInfo>> mappingModelInfosMap) throws Exception {
        return Collections.emptyMap();
    }

    @Override
    public void clearEaiHeaders() {
        this.bmdEaiMethodRepository.getEaiHeaders().clear();
        log.debug("{} bmdEaiMethodRepository clearEaiHeaders", (Object)_CLASSTAG);
    }

    public void updateBMDataLayerBMCodes(DWServiceMapping eaiService, List<DWEAIHeader> eaiHeaders, List<BindApi> bmdApiListConfig) {
        String modelCode = eaiService.getCode();
        String targetProdOfDWServiceMapping = eaiService.getTargetProd();
        String eaiTableName = eaiService.getTableName();
        boolean hasBindApiList = ModelDataUtil.hasBindApiConfig(bmdApiListConfig);
        eaiHeaders.stream().forEach(eaiHeader -> {
            BMCode bmCode = new BMCode(modelCode, targetProdOfDWServiceMapping, eaiTableName, BMRole.bmd);
            if (hasBindApiList) {
                apiType = ApiTypeUtil.getApiTypeInBMDataLayer(eaiHeader, bmdApiListConfig);
                bmCode.setApiType(apiType);
            } else {
                apiType = ApiTypeUtil.getApiTypeInBMDataLayer(eaiHeader);
                bmCode.setApiType(apiType);
            }
            String eaiServiceId = eaiHeader.getEAIServiceId();
            this.bmCodes.put(eaiServiceId, bmCode);
        });
    }

    public ModelDrivenEaiMethodDTO getEaiMethod(String apiType, Map<String, ModelDrivenEaiMethodDTO> mdEaiMethods) {
        ModelDrivenEaiMethodDTO bmdEaiMethodDTO = null;
        switch (apiType) {
            case "get": {
                bmdEaiMethodDTO = mdEaiMethods.get("lcdp.bmd.crud.eai.get");
                break;
            }
            case "create": {
                bmdEaiMethodDTO = mdEaiMethods.get("lcdp.bmd.crud.eai.create");
                break;
            }
            case "update": {
                bmdEaiMethodDTO = mdEaiMethods.get("lcdp.bmd.crud.eai.update");
                break;
            }
            case "delete": {
                bmdEaiMethodDTO = mdEaiMethods.get("lcdp.bmd.crud.eai.delete");
                break;
            }
            default: {
                log.warn("{} *** BMD *** can't match BMDataEaiMethodRepository's method using apiType({}) ", (Object)_CLASSTAG, (Object)apiType);
            }
        }
        return bmdEaiMethodDTO;
    }
}

