/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.eai;

import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.model.BMEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.customize.utils.BMCenterUtil;
import com.digiwin.lcdp.modeldriven.customize.utils.BMEaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.eai.builder.EaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.eai.builder.ModelStandardEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.enums.ModelApiTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.ModelCreateTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDrivenEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.BindApi;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.pojo.ModelDrivenEaiMethodDTO;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMethodHelper;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.service.RegTypeUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BMEaiHeaderBuilder
implements EaiHeaderBuilder {
    private static final Logger log = LoggerFactory.getLogger(BMEaiHeaderBuilder.class);
    private static final String _CLASSTAG = "[" + BMEaiHeaderBuilder.class.getSimpleName() + "]";
    @Autowired
    @Qualifier(value="dw-modeldriven-crud-eai-builder")
    ModelStandardEaiHeaderBuilder modelStandardEAIHeaderBuilder;
    @Autowired
    @Qualifier(value="dw-modeldriven-eai-repo")
    ModelDrivenEaiMethodRepository modelDrivenEaiMethodRepo;
    @Autowired
    @Qualifier(value="lcdp-bm-eai-method-repo")
    BMEaiMethodRepository bmEaiMethodRepository;
    @Autowired
    @Qualifier(value="bmCodes")
    Map<String, BMCode> bmCodes;

    @Override
    public List<DWEAIHeader> getEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        Method setMappingMethod = ModelDrivenMethodHelper.getSetMappingMethodAccessibleOfDWEAIHeader();
        HashMap childrenBindApi = new HashMap();
        int orgServiceMappingCount = CollectionUtils.isNotEmpty(serviceMappings) ? serviceMappings.size() : 0;
        int orgMappingModelInfosCount = CollectionUtils.isNotEmpty(mappingModelInfos) ? mappingModelInfos.size() : 0;
        int serviceMapCount = 0;
        int newServiceMappingHeaderCount = 0;
        int newMappingModelInfoHeaderCount = 0;
        for (DWServiceMapping eaiService : serviceMappings) {
            ++serviceMapCount;
            String eaiTableName = eaiService.getTableName();
            String modelCode = eaiService.getCode();
            String modelSchemaStr = eaiService.getModelSchema();
            ModelSchemaDTO modelSchema = ModelSchemaUtil.getModelSchema(modelSchemaStr);
            List<BindApi> bindApiListConfig = modelSchema.getBindApiListConfig();
            String userExposePrefixEaiId = eaiService.getExposeEaiId();
            String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
            log.debug("{}[{}] serviceMapping: prod({}), eaiService({}),userExposePrefixEaiId({}}) processing ... ", new Object[]{_CLASSTAG, serviceMapCount, eaiProd, eaiService.toSimpleString(), userExposePrefixEaiId});
            List<DWEAIHeader> bmEaiHeaders = this.getBMEaiHeaders(setMappingMethod, eaiService, this.bmEaiMethodRepository, bindApiListConfig);
            List<MappingModelInfo> currentSubModels = mappingModelInfos.stream().filter(mappingModelInfo -> mappingModelInfo.getCode().equals(modelCode) && !mappingModelInfo.getChildtbl().equals(mappingModelInfo.getTablename())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(currentSubModels)) {
                log.debug("{}[getEaiHeaders] code({}) have children", (Object)_CLASSTAG, (Object)modelCode);
                ArrayList<DWEAIHeader> bmSubListGetHeaders = new ArrayList<DWEAIHeader>();
                List<DWEAIHeader> currentSubListGetHeaders = this.getSubListGetHeaders(setMappingMethod, currentSubModels, modelSchema);
                bmSubListGetHeaders.addAll(currentSubListGetHeaders);
                newMappingModelInfoHeaderCount += bmSubListGetHeaders.size();
                bmEaiHeaders.addAll(bmSubListGetHeaders);
            } else {
                log.debug("{}[getTechEaiService] code({}) have none children list api", (Object)_CLASSTAG, (Object)modelCode);
            }
            newEaiHeaders.addAll(bmEaiHeaders);
        }
        log.debug("{}[getEaiHeaders] *** BM *** getEaiHeaders({})=bm({})+mappingModelInfos({}) from serviceMappings({})", new Object[]{_CLASSTAG, newEaiHeaders.size(), newServiceMappingHeaderCount, newMappingModelInfoHeaderCount, serviceMapCount});
        return newEaiHeaders;
    }

    public List<DWEAIHeader> getBMEaiHeaders(Method setMappingMethod, DWServiceMapping eaiService, BMEaiMethodRepository bmEaiMethodRepo, List<BindApi> bindApiListConfig) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        Map<String, ModelDrivenEaiMethodDTO> mdEaiMethods = bmEaiMethodRepo.getEaiMethodRepo();
        Optional<Class<?>> eaiClazz = bmEaiMethodRepo.getEaiClazz();
        log.info("{} enter md master eai service", (Object)_CLASSTAG);
        String eaiTableName = eaiService.getTableName();
        String userExposePrefixEaiId = eaiService.getExposeEaiId();
        String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
        log.debug("{} serviceMapping: prod({}) eaiService({}) process table_name({}) expose_ea_id({})", new Object[]{_CLASSTAG, eaiProd, eaiService.toSimpleString(), eaiTableName, userExposePrefixEaiId});
        boolean hasBindApiList = ModelDataUtil.hasBindApiConfig(bindApiListConfig);
        if (hasBindApiList) {
            for (BindApi bindApi : bindApiListConfig) {
                String apiName = bindApi.getApiName();
                String apiType = bindApi.getApiType();
                List mdServiceNames = mdEaiMethods.keySet().stream().collect(Collectors.toList());
                Optional<String> optMatchServiceName = mdServiceNames.stream().filter(mdServiceName -> mdServiceName.contains("." + apiType)).findFirst();
                if (optMatchServiceName.isPresent()) {
                    String actualEaiId = optMatchServiceName.get();
                    ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethods.get(actualEaiId);
                    DWEAIHeader headerV = new DWEAIHeader("commons", apiName, eaiClazz.get());
                    setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
                    newEaiHeaders.add(headerV);
                    this.bmCodes.put(apiName, new BMCode(eaiService.getCode(), eaiService.getTargetProd(), eaiTableName));
                    log.debug("{} *** BM *** serviceMapping: hasBindApiList({}) add headerV expose_eai_id({})(ignored org serviceMapping eaiid prefix({})", new Object[]{_CLASSTAG, hasBindApiList, headerV.getEAIServiceId(), eaiService.getExposeEaiId()});
                    continue;
                }
                log.info("{} can't find lcdp base method, bindApi({}) ", (Object)_CLASSTAG, (Object)bindApi);
            }
        } else {
            for (Map.Entry<String, ModelDrivenEaiMethodDTO> mdEaiMethod : mdEaiMethods.entrySet()) {
                ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethod.getValue();
                String eaiServiceIdForServiceMapping = String.join((CharSequence)".", userExposePrefixEaiId, "std", mdEaiMethodDTO.getEaiServicePostfix());
                DWEAIHeader headerV = new DWEAIHeader("commons", eaiServiceIdForServiceMapping, eaiClazz.get());
                setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
                newEaiHeaders.add(headerV);
                this.bmCodes.put(eaiServiceIdForServiceMapping, new BMCode(eaiService.getCode(), eaiService.getTargetProd(), eaiTableName));
                log.debug("{} *** BM *** serviceMapping: hasBindApiList({}) add headerV expose_eai_id({})", new Object[]{_CLASSTAG, hasBindApiList, headerV.getEAIServiceId()});
            }
        }
        return newEaiHeaders;
    }

    public List<DWEAIHeader> getBMListGetHeaders(Method setMappingMethod, Optional<Class<?>> eaiClazz, Method listGetMethod, List<MappingModelInfo> mappingModelInfos, Map<String, Object> childrenBindApi) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
        if (mappingModelInfos.size() > 0 && listGetMethod != null) {
            log.info("{}[getBMListGetHeaders] *** BM *** enter children .list.get", (Object)_CLASSTAG);
            int modelinfoCount = 1;
            boolean hasChildrenBindApi = MapUtils.isNotEmpty(childrenBindApi);
            for (MappingModelInfo mappingModelInfo : mappingModelInfos) {
                String childTableName = mappingModelInfo.getChildtbl();
                String eaiTableName = mappingModelInfo.getTablename();
                String userExposePrefixEaiId = mappingModelInfo.getEaiid();
                String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] *** BM *** code({}), serviceMapping-child: prod({}), child table({}), tableName({})", new Object[]{_CLASSTAG, mappingModelInfo.getCode(), modelinfoCount++, eaiProd, childTableName, eaiTableName});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    String childEaiServiceIdForServiceMapping = "";
                    if (hasChildrenBindApi && childrenBindApi.containsKey(childTableName)) {
                        Object childBindApiObj = childrenBindApi.get(childTableName);
                        if (childBindApiObj != null && ((List)childBindApiObj).size() > 0) {
                            BindApi childBindApi = (BindApi)((List)childBindApiObj).get(0);
                            childEaiServiceIdForServiceMapping = childBindApi.getApiName();
                            log.debug(" --->> child Bind Api({}), eaiTableName({}) of code [{}] ", new Object[]{childEaiServiceIdForServiceMapping, eaiTableName, mappingModelInfo.getCode()});
                        } else if (childBindApiObj != null && ((List)childBindApiObj).size() == 0) {
                            log.info(" --->> ignored gen DWEAIHeader, cause child BindApi is empty, eaiTableName({}) of code [{}] ", (Object)eaiTableName, (Object)mappingModelInfo.getCode());
                            continue;
                        }
                    } else {
                        childEaiServiceIdForServiceMapping = EaiServiceNameUtil.getBMChildListGetEaiServiceId(eaiProd, childTableName);
                        log.debug(" --->> child bm Api({}), eaiTableName({}) of code [{}] ", new Object[]{childEaiServiceIdForServiceMapping, eaiTableName, mappingModelInfo.getCode()});
                    }
                    DWEAIHeader headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, eaiClazz.get());
                    setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                    childTableListGetHeaders.add(headerV);
                    if (log.isDebugEnabled()) {
                        log.debug("  --->> add eai service id:({}) by code [{}] ", (Object)headerV.getEAIServiceId(), (Object)mappingModelInfo.getCode());
                    }
                    this.bmCodes.put(childEaiServiceIdForServiceMapping, new BMCode(mappingModelInfo.getCode(), mappingModelInfo.getTargetProd(), eaiTableName, true, childTableName));
                    continue;
                }
                log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
            }
            log.info("{} serviceMapping: children table .list.get count:{}", (Object)_CLASSTAG, (Object)childTableListGetHeaders.size());
        } else {
            log.warn("{} serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", new Object[]{_CLASSTAG, 0, listGetMethod});
        }
        return childTableListGetHeaders;
    }

    @Override
    public List<DWEAIHeader> getSubListGetHeaders(Method setMappingMethod, List<MappingModelInfo> mappingModelInfos, ModelSchemaDTO modelSchema) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
        if (mappingModelInfos.size() > 0) {
            log.info("{}[getSubListGetHeaders] enter children .list.get", (Object)_CLASSTAG);
            Map<String, ModelSchemaDTO> modelSchemaMap = ModelSchemaUtil.getModelSchemaMap(modelSchema);
            int modelinfoCount = 0;
            for (MappingModelInfo mappingModelInfo : mappingModelInfos) {
                ++modelinfoCount;
                String childTableName = mappingModelInfo.getChildtbl();
                String eaiTableName = mappingModelInfo.getTablename();
                String modelCode = mappingModelInfo.getCode();
                String targetProdOfDWServiceMapping = mappingModelInfo.getTargetProd();
                String targetProdOfCode = BMCenterUtil.getEaiServicePrefix(targetProdOfDWServiceMapping);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] code({}) serviceMapping-child: target_prod({}), child table({}), tableName({})", new Object[]{_CLASSTAG, modelinfoCount, modelCode, targetProdOfCode, childTableName, eaiTableName});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    BMCode bmCode;
                    DWEAIHeader headerV;
                    Method subListGetMethod;
                    Optional<Class<?>> subEaiCrudClazz;
                    if (StringUtils.isBlank((CharSequence)mappingModelInfo.getTargetProd())) {
                        subEaiCrudClazz = this.modelDrivenEaiMethodRepo.getEaiClazz();
                        subListGetMethod = this.modelDrivenEaiMethodRepo.getListGetMethod();
                    } else {
                        subEaiCrudClazz = this.bmEaiMethodRepository.getEaiClazz();
                        subListGetMethod = this.bmEaiMethodRepository.getListGetMethod();
                    }
                    ModelSchemaDTO subModelSchema = modelSchemaMap.get(childTableName);
                    List<BindApi> subApiListConfig = subModelSchema.getBindApiListConfig();
                    boolean hasBindApiList = ModelDataUtil.hasBindApiConfig(subApiListConfig);
                    if (hasBindApiList) {
                        for (BindApi bindApi : subApiListConfig) {
                            String apiName = bindApi.getApiName();
                            headerV = new DWEAIHeader("commons", apiName, subEaiCrudClazz.get());
                            setMappingMethod.invoke((Object)headerV, subListGetMethod, false);
                            childTableListGetHeaders.add(headerV);
                            log.debug("{} *** BM *** serviceMapping: hasBindApiList({}) add headerV expose_eai_id({})(ignored org serviceMapping eaiid prefix({})", new Object[]{_CLASSTAG, hasBindApiList, headerV.getEAIServiceId(), apiName});
                            bmCode = new BMCode(modelCode, targetProdOfDWServiceMapping, eaiTableName, true, childTableName);
                            bmCode.setApiType(bindApi.getApiType());
                            bmCode.setRole(BMRole.bm);
                            this.bmCodes.put(apiName, bmCode);
                        }
                        continue;
                    }
                    String userExposePrefixEaiId = mappingModelInfo.getEaiid();
                    String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
                    String childEaiServiceIdForServiceMapping = EaiServiceNameUtil.getBMChildListGetEaiServiceId(eaiProd, childTableName);
                    log.info("{} *** BM *** code({}), serviceMapping-child: childEaiServiceIdForServiceMapping({})", new Object[]{_CLASSTAG, modelCode, childEaiServiceIdForServiceMapping});
                    headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, subEaiCrudClazz.get());
                    setMappingMethod.invoke((Object)headerV, subListGetMethod, false);
                    childTableListGetHeaders.add(headerV);
                    if (log.isDebugEnabled()) {
                        log.debug("     --->> add eai service id:({}) by code [{}] ", (Object)headerV.getEAIServiceId(), (Object)modelCode);
                    }
                    bmCode = new BMCode(modelCode, targetProdOfDWServiceMapping, eaiTableName, true, childTableName);
                    bmCode.setApiType(ModelApiTypeEnum.LIST.getApiTypeName());
                    this.bmCodes.put(childEaiServiceIdForServiceMapping, bmCode);
                    continue;
                }
                log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
            }
            log.info("{}[getSubListGetHeaders] serviceMapping: children table .list.get count:{}", (Object)_CLASSTAG, (Object)childTableListGetHeaders.size());
        } else {
            log.warn("{}[getSubListGetHeaders] serviceMapping: ignored to generate children .list.get service(serviceMapping size({})", (Object)_CLASSTAG, (Object)0);
        }
        return childTableListGetHeaders;
    }

    public Map<String, Map<String, List<DWEAIHeader>>> getBMListGetHeadersByProd(Method setMappingMethod, Optional<Class<?>> eaiClazz, Method listGetMethod, List<MappingModelInfo> mappingModelInfos, Map<String, Object> childrenBindApi) throws InvocationTargetException, IllegalAccessException {
        HashMap<String, Map<String, List<DWEAIHeader>>> childTableListGetHeadersMap = new HashMap<String, Map<String, List<DWEAIHeader>>>();
        List validMappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> !StringUtils.equals((CharSequence)mappingModelInfo.getChildtbl(), (CharSequence)mappingModelInfo.getTablename())).collect(Collectors.toList());
        if (validMappingModelInfos.size() > 0 && listGetMethod != null) {
            log.info("{} [getBMListGetHeaders] *** BM *** enter children .list.get", (Object)_CLASSTAG);
            int modelinfoCount = 1;
            boolean hasChildrenBindApi = MapUtils.isNotEmpty(childrenBindApi);
            for (MappingModelInfo mappingModelInfo2 : validMappingModelInfos) {
                ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
                String childTableName = mappingModelInfo2.getChildtbl();
                String eaiTableName = mappingModelInfo2.getTablename();
                String targetProdOfDWServiceMapping = mappingModelInfo2.getTargetProd();
                String targetProdOfCode = BMCenterUtil.getEaiServicePrefix(targetProdOfDWServiceMapping);
                String userExposePrefixEaiId = mappingModelInfo2.getEaiid();
                String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] *** BM *** code({}), serviceMapping-child: prod({}), child table({}), tableName({})", new Object[]{_CLASSTAG, modelinfoCount++, mappingModelInfo2.getCode(), eaiProd, childTableName, eaiTableName});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    String childEaiServiceIdForServiceMapping = "";
                    if (hasChildrenBindApi && childrenBindApi.containsKey(childTableName)) {
                        Object childBindApiObj = childrenBindApi.get(childTableName);
                        if (childBindApiObj != null && ((List)childBindApiObj).size() > 0) {
                            BindApi childBindApi = (BindApi)((List)childBindApiObj).get(0);
                            childEaiServiceIdForServiceMapping = childBindApi.getApiName();
                            log.debug(" --->> child Bind Api({}), eaiTableName({}) of code [{}] ", new Object[]{childEaiServiceIdForServiceMapping, eaiTableName, mappingModelInfo2.getCode()});
                        } else if (childBindApiObj != null && ((List)childBindApiObj).size() == 0) {
                            log.info(" --->> ignored gen DWEAIHeader, cause child BindApi is empty, eaiTableName({}) of code [{}] ", (Object)eaiTableName, (Object)mappingModelInfo2.getCode());
                            continue;
                        }
                    } else {
                        childEaiServiceIdForServiceMapping = StringUtils.isNotBlank((CharSequence)targetProdOfDWServiceMapping) ? EaiServiceNameUtil.getBMChildListGetEaiServiceId(eaiProd, childTableName) : EaiServiceNameUtil.getChildListGetEaiServiceId(eaiProd, childTableName);
                        log.debug(" --->> child bm Api({}), eaiTableName({}) of code [{}] ", new Object[]{childEaiServiceIdForServiceMapping, eaiTableName, mappingModelInfo2.getCode()});
                    }
                    DWEAIHeader headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, eaiClazz.get());
                    setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                    childTableListGetHeaders.add(headerV);
                    String regProdName = BMEaiServiceNameUtil.getAppProd(userExposePrefixEaiId, eaiTableName);
                    Map prodEaiHeaders = childTableListGetHeadersMap.getOrDefault(regProdName, new HashMap());
                    List prodEspEaiHeaders = prodEaiHeaders.getOrDefault("esp", new ArrayList());
                    prodEspEaiHeaders.addAll(childTableListGetHeaders);
                    prodEaiHeaders.put("esp", prodEspEaiHeaders);
                    childTableListGetHeadersMap.put(regProdName, prodEaiHeaders);
                    if (log.isDebugEnabled()) {
                        log.debug("{}[getBMListGetHeadersByProd] BM()  --->> ESP add prod{} eai service id:({}) by code [{}] ", new Object[]{_CLASSTAG, regProdName, headerV.getEAIServiceId(), mappingModelInfo2.getCode()});
                    }
                    if (StringUtils.isNotBlank((CharSequence)targetProdOfDWServiceMapping)) {
                        List prodNacosEaiHeaders = prodEaiHeaders.getOrDefault("nacos", new ArrayList());
                        prodNacosEaiHeaders.addAll(childTableListGetHeaders);
                        prodEaiHeaders.put("nacos", prodNacosEaiHeaders);
                        childTableListGetHeadersMap.put(regProdName, prodEaiHeaders);
                        this.bmCodes.put(childEaiServiceIdForServiceMapping, new BMCode(mappingModelInfo2.getCode(), mappingModelInfo2.getTargetProd(), eaiTableName, true, childTableName));
                        if (log.isDebugEnabled()) {
                            log.debug("{}  --->> NACOS add prod{} eai service id:({}) by code [{}] ", new Object[]{_CLASSTAG, regProdName, headerV.getEAIServiceId(), mappingModelInfo2.getCode()});
                        }
                    }
                } else {
                    log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
                }
                log.info("{} serviceMapping: children table .list.get count:{}", (Object)_CLASSTAG, (Object)childTableListGetHeaders.size());
            }
        } else {
            log.warn("{} serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", new Object[]{_CLASSTAG, 0, listGetMethod});
        }
        return childTableListGetHeadersMap;
    }

    public Map<String, List<DWEAIHeader>> getTechBMListGetHeadersByProd(Method setMappingMethod, Optional<Class<?>> eaiClazz, Method listGetMethod, List<MappingModelInfo> mappingModelInfos, Map<String, Object> childrenBindApi) throws InvocationTargetException, IllegalAccessException {
        ArrayList espEaiHeaders = new ArrayList();
        ArrayList nacosEaiHeaders = new ArrayList();
        List validMappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> !StringUtils.equals((CharSequence)mappingModelInfo.getChildtbl(), (CharSequence)mappingModelInfo.getTablename())).collect(Collectors.toList());
        if (validMappingModelInfos.size() > 0 && listGetMethod != null) {
            log.info("{} [getBMListGetHeaders] *** BM *** enter children .list.get", (Object)_CLASSTAG);
            int modelinfoCount = 1;
            boolean hasChildrenBindApi = MapUtils.isNotEmpty(childrenBindApi);
            for (MappingModelInfo mappingModelInfo2 : validMappingModelInfos) {
                ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
                String childTableName = mappingModelInfo2.getChildtbl();
                String eaiTableName = mappingModelInfo2.getTablename();
                String targetProdOfDWServiceMapping = mappingModelInfo2.getTargetProd();
                String targetProdOfCode = BMCenterUtil.getEaiServicePrefix(targetProdOfDWServiceMapping);
                String userExposePrefixEaiId = mappingModelInfo2.getEaiid();
                String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] *** BM *** code({}), serviceMapping-child: prod({}), child table({}), tableName({})", new Object[]{_CLASSTAG, modelinfoCount++, mappingModelInfo2.getCode(), eaiProd, childTableName, eaiTableName});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    String childEaiServiceIdForServiceMapping = "";
                    if (hasChildrenBindApi && childrenBindApi.containsKey(childTableName)) {
                        Object childBindApiObj = childrenBindApi.get(childTableName);
                        if (childBindApiObj != null && ((List)childBindApiObj).size() > 0) {
                            BindApi childBindApi = (BindApi)((List)childBindApiObj).get(0);
                            childEaiServiceIdForServiceMapping = childBindApi.getApiName();
                            log.debug(" --->> child Bind Api({}), eaiTableName({}) of code [{}] ", new Object[]{childEaiServiceIdForServiceMapping, eaiTableName, mappingModelInfo2.getCode()});
                        } else if (childBindApiObj != null && ((List)childBindApiObj).size() == 0) {
                            log.info(" --->> ignored gen DWEAIHeader, cause child BindApi is empty, eaiTableName({}) of code [{}] ", (Object)eaiTableName, (Object)mappingModelInfo2.getCode());
                            continue;
                        }
                    } else {
                        childEaiServiceIdForServiceMapping = StringUtils.isNotBlank((CharSequence)targetProdOfDWServiceMapping) ? EaiServiceNameUtil.getBMChildListGetEaiServiceId(eaiProd, childTableName) : EaiServiceNameUtil.getChildListGetEaiServiceId(eaiProd, childTableName);
                        log.debug(" --->> child bm Api({}), eaiTableName({}) of code [{}] ", new Object[]{childEaiServiceIdForServiceMapping, eaiTableName, mappingModelInfo2.getCode()});
                    }
                    DWEAIHeader headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, eaiClazz.get());
                    setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                    childTableListGetHeaders.add(headerV);
                    String regProdName = BMEaiServiceNameUtil.getAppProd(userExposePrefixEaiId, eaiTableName);
                    espEaiHeaders.addAll(childTableListGetHeaders);
                    if (log.isDebugEnabled()) {
                        log.debug("{}[getBMListGetHeadersByProd] BM()  --->> ESP add prod{} eai service id:({}) by code [{}] ", new Object[]{_CLASSTAG, regProdName, headerV.getEAIServiceId(), mappingModelInfo2.getCode()});
                    }
                    if (StringUtils.isNotBlank((CharSequence)targetProdOfDWServiceMapping)) {
                        nacosEaiHeaders.addAll(childTableListGetHeaders);
                        this.bmCodes.put(childEaiServiceIdForServiceMapping, new BMCode(mappingModelInfo2.getCode(), mappingModelInfo2.getTargetProd(), eaiTableName, true, childTableName));
                        if (log.isDebugEnabled()) {
                            log.debug("{}  --->> NACOS add prod{} eai service id:({}) by code [{}] ", new Object[]{_CLASSTAG, regProdName, headerV.getEAIServiceId(), mappingModelInfo2.getCode()});
                        }
                    }
                } else {
                    log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
                }
                log.info("{} serviceMapping: children table .list.get count:{}", (Object)_CLASSTAG, (Object)childTableListGetHeaders.size());
            }
        } else {
            log.warn("{} serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", new Object[]{_CLASSTAG, 0, listGetMethod});
        }
        HashMap<String, List<DWEAIHeader>> childTableListGetHeadersMap = new HashMap<String, List<DWEAIHeader>>();
        childTableListGetHeadersMap.put("esp", espEaiHeaders);
        childTableListGetHeadersMap.put("nacos", nacosEaiHeaders);
        return childTableListGetHeadersMap;
    }

    @Override
    public Map<String, List<DWEAIHeader>> getTechEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        ArrayList<DWEAIHeader> espEaiHeaders = new ArrayList<DWEAIHeader>();
        ArrayList<DWEAIHeader> nacosEaiHeaders = new ArrayList<DWEAIHeader>();
        Method setMappingMethod = ModelDrivenMethodHelper.getSetMappingMethodAccessibleOfDWEAIHeader();
        Optional<Class<?>> stdEaiCrudClazz = this.modelDrivenEaiMethodRepo.getEaiClazz();
        HashMap<String, Object> childrenBindApi = new HashMap<String, Object>();
        int orgServiceMappingCount = CollectionUtils.isNotEmpty(serviceMappings) ? serviceMappings.size() : 0;
        int orgMappingModelInfosCount = CollectionUtils.isNotEmpty(mappingModelInfos) ? mappingModelInfos.size() : 0;
        int serviceMapCount = 0;
        int newServiceMappingHeaderCount = 0;
        BMRole bmRole = BMProperties.getProperties().getRole();
        ArrayList<String> modelCodesForUserExistTable = new ArrayList<String>();
        for (DWServiceMapping eaiService : serviceMappings) {
            ++serviceMapCount;
            String eaiTableName = eaiService.getTableName();
            String modelCode = eaiService.getCode();
            String modelSchemaStr = eaiService.getModelSchema();
            ModelSchemaDTO modelSchema = ModelSchemaUtil.getModelSchema(modelSchemaStr);
            String useExistedTable = modelSchema.getUseExistedTable();
            ModelCreateTypeEnum useExistedTableEnum = ModelCreateTypeEnum.getTypeEnum(useExistedTable);
            if (useExistedTableEnum != null && useExistedTableEnum == ModelCreateTypeEnum.EXISTED_TABLE) {
                modelCodesForUserExistTable.add(modelCode);
                continue;
            }
            List<BindApi> bindApiListConfig = modelSchema.getBindApiListConfig();
            String targetProdOfDWServiceMapping = eaiService.getTargetProd();
            String userExposePrefixEaiId = eaiService.getExposeEaiId();
            String regProdName = eaiService.getProd();
            log.debug("{}[{}] serviceMapping: regProd({}), eaiService({}),userExposePrefixEaiId({}}) processing ... ", new Object[]{_CLASSTAG, serviceMapCount, regProdName, eaiService.toSimpleString(), userExposePrefixEaiId});
            if (StringUtils.isBlank((CharSequence)targetProdOfDWServiceMapping) && bindApiListConfig == null) {
                List<DWEAIHeader> stdListGetHeaders = this.modelStandardEAIHeaderBuilder.getStdEaiHeaders(setMappingMethod, eaiService, this.modelDrivenEaiMethodRepo);
                espEaiHeaders.addAll(stdListGetHeaders);
                continue;
            }
            List<DWEAIHeader> bmEaiHeaders = this.getBMEaiHeaders(setMappingMethod, eaiService, this.bmEaiMethodRepository, bindApiListConfig);
            espEaiHeaders.addAll(bmEaiHeaders);
            nacosEaiHeaders.addAll(bmEaiHeaders);
        }
        int newNacosServiceMappingHeaderCount = nacosEaiHeaders.size();
        newServiceMappingHeaderCount = espEaiHeaders.size();
        HashMap<String, List<DWEAIHeader>> techEaiHeaders = new HashMap<String, List<DWEAIHeader>>();
        techEaiHeaders.put("esp", espEaiHeaders);
        techEaiHeaders.put("nacos", nacosEaiHeaders);
        mappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> !modelCodesForUserExistTable.contains(mappingModelInfo.getCode())).collect(Collectors.toList());
        int newMappingModelInfoHeaderCount = 0;
        if (mappingModelInfos.size() > 0) {
            List<MappingModelInfo> stdMappingModelInfo;
            Method bmListGetMethod = this.bmEaiMethodRepository.getListGetMethod();
            Optional<Class<?>> bmEaiCrudClazz = this.bmEaiMethodRepository.getEaiClazz();
            List<MappingModelInfo> bmMappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> mappingModelInfo.getTargetProd() != null).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(bmMappingModelInfos)) {
                Map<String, List<DWEAIHeader>> bmSubListGetHeadersMap = this.getTechBMListGetHeadersByProd(setMappingMethod, bmEaiCrudClazz, bmListGetMethod, bmMappingModelInfos, childrenBindApi);
                RegTypeUtil.mergeTechType(techEaiHeaders, bmSubListGetHeadersMap);
                int bmSubListGetHeaderCount = MapUtils.isNotEmpty(bmSubListGetHeadersMap) ? bmSubListGetHeadersMap.size() : 0;
                newMappingModelInfoHeaderCount += bmSubListGetHeaderCount;
            }
            if (CollectionUtils.isNotEmpty(stdMappingModelInfo = mappingModelInfos.stream().filter(mappingModelInfo -> StringUtils.isBlank((CharSequence)mappingModelInfo.getTargetProd())).collect(Collectors.toList()))) {
                Method stdListGetMethod = this.modelDrivenEaiMethodRepo.getListGetMethod();
                Map<String, List<DWEAIHeader>> stdListGetHeadersMap = this.modelStandardEAIHeaderBuilder.getTechStdListGetHeaders(setMappingMethod, stdEaiCrudClazz, stdListGetMethod, stdMappingModelInfo, childrenBindApi);
                if (MapUtils.isNotEmpty(stdListGetHeadersMap)) {
                    RegTypeUtil.mergeTechType(techEaiHeaders, stdListGetHeadersMap);
                }
                int stdSubListGetHeaderCount = MapUtils.isNotEmpty(stdListGetHeadersMap) ? stdListGetHeadersMap.size() : 0;
                newMappingModelInfoHeaderCount += stdSubListGetHeaderCount;
            }
            log.debug("{}[getEaiHeaders] *** BM *** getEaiHeaders=bm({})+mappingModelInfos({}) from serviceMappings({})", new Object[]{_CLASSTAG, newServiceMappingHeaderCount, newMappingModelInfoHeaderCount, serviceMapCount});
        }
        return techEaiHeaders;
    }

    @Override
    public Map<String, Map<String, List<DWEAIHeader>>> getProdEaiHeadersByService(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        HashMap<String, Map<String, List<DWEAIHeader>>> prodEaiHeadersMap = new HashMap<String, Map<String, List<DWEAIHeader>>>();
        ArrayList nacosEaiHeaders = new ArrayList();
        ArrayList espEaiHeaders = new ArrayList();
        Method setMappingMethod = ModelDrivenMethodHelper.getSetMappingMethodAccessibleOfDWEAIHeader();
        Optional<Class<?>> stdEaiCrudClazz = this.modelDrivenEaiMethodRepo.getEaiClazz();
        HashMap<String, Object> childrenBindApi = new HashMap<String, Object>();
        int orgServiceMappingCount = CollectionUtils.isNotEmpty(serviceMappings) ? serviceMappings.size() : 0;
        int orgMappingModelInfosCount = CollectionUtils.isNotEmpty(mappingModelInfos) ? mappingModelInfos.size() : 0;
        int serviceMapCount = 0;
        int newServiceMappingHeaderCount = 0;
        BMRole bmRole = BMProperties.getProperties().getRole();
        for (DWServiceMapping eaiService : serviceMappings) {
            ++serviceMapCount;
            String eaiTableName = eaiService.getTableName();
            String modelCode = eaiService.getCode();
            String modelSchemaStr = eaiService.getModelSchema();
            ModelSchemaDTO modelSchema = ModelSchemaUtil.getModelSchema(modelSchemaStr);
            List<BindApi> bindApiListConfig = modelSchema.getBindApiListConfig();
            String targetProdOfDWServiceMapping = eaiService.getTargetProd();
            String userExposePrefixEaiId = eaiService.getExposeEaiId();
            String regProdName = eaiService.getProd();
            log.debug("{}[{}] serviceMapping: regProd({}), eaiService({}),userExposePrefixEaiId({}}) processing ... ", new Object[]{_CLASSTAG, serviceMapCount, regProdName, eaiService.toSimpleString(), userExposePrefixEaiId});
            Map prodEaiHeaders = prodEaiHeadersMap.getOrDefault(regProdName, new HashMap());
            if (StringUtils.isBlank((CharSequence)targetProdOfDWServiceMapping) && bindApiListConfig == null) {
                List<DWEAIHeader> stdListGetHeaders = this.modelStandardEAIHeaderBuilder.getStdEaiHeaders(setMappingMethod, eaiService, this.modelDrivenEaiMethodRepo);
                List prodNacosEaiHeaders = prodEaiHeaders.getOrDefault("esp", new ArrayList());
                prodNacosEaiHeaders.addAll(stdListGetHeaders);
                prodEaiHeaders.put("esp", prodNacosEaiHeaders);
                prodEaiHeadersMap.put(regProdName, prodEaiHeaders);
                continue;
            }
            List<DWEAIHeader> bmEaiHeaders = this.getBMEaiHeaders(setMappingMethod, eaiService, this.bmEaiMethodRepository, bindApiListConfig);
            List prodEspEaiHeaders = prodEaiHeaders.getOrDefault("esp", new ArrayList());
            prodEspEaiHeaders.addAll(bmEaiHeaders);
            List prodNacosEaiHeaders = prodEaiHeaders.getOrDefault("nacos", new ArrayList());
            prodNacosEaiHeaders.addAll(bmEaiHeaders);
            prodEaiHeaders.put("esp", prodEspEaiHeaders);
            prodEaiHeaders.put("nacos", prodNacosEaiHeaders);
            prodEaiHeadersMap.put(regProdName, prodEaiHeaders);
        }
        int newNacosServiceMappingHeaderCount = nacosEaiHeaders.size();
        newServiceMappingHeaderCount = espEaiHeaders.size();
        int newMappingModelInfoHeaderCount = 0;
        if (mappingModelInfos.size() > 0) {
            List<MappingModelInfo> stdMappingModelInfo;
            Method bmListGetMethod = this.bmEaiMethodRepository.getListGetMethod();
            Optional<Class<?>> bmEaiCrudClazz = this.bmEaiMethodRepository.getEaiClazz();
            List<MappingModelInfo> bmMappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> mappingModelInfo.getTargetProd() != null).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(bmMappingModelInfos)) {
                Map<String, Map<String, List<DWEAIHeader>>> bmSubListGetHeadersMap = this.getBMListGetHeadersByProd(setMappingMethod, bmEaiCrudClazz, bmListGetMethod, bmMappingModelInfos, childrenBindApi);
                RegTypeUtil.mergeRegType(prodEaiHeadersMap, bmSubListGetHeadersMap);
                int bmSubListGetHeaderCount = MapUtils.isNotEmpty(bmSubListGetHeadersMap) ? bmSubListGetHeadersMap.size() : 0;
                newMappingModelInfoHeaderCount += bmSubListGetHeaderCount;
            }
            if (CollectionUtils.isNotEmpty(stdMappingModelInfo = mappingModelInfos.stream().filter(mappingModelInfo -> StringUtils.isBlank((CharSequence)mappingModelInfo.getTargetProd())).collect(Collectors.toList()))) {
                Method stdListGetMethod = this.modelDrivenEaiMethodRepo.getListGetMethod();
                Map<String, Map<String, List<DWEAIHeader>>> stdListGetHeadersMap = this.modelStandardEAIHeaderBuilder.getStdListGetHeadersByProd(setMappingMethod, stdEaiCrudClazz, stdListGetMethod, stdMappingModelInfo, childrenBindApi);
                if (MapUtils.isNotEmpty(stdListGetHeadersMap)) {
                    RegTypeUtil.mergeRegType(prodEaiHeadersMap, stdListGetHeadersMap);
                }
                int stdSubListGetHeaderCount = MapUtils.isNotEmpty(stdListGetHeadersMap) ? stdListGetHeadersMap.size() : 0;
                newMappingModelInfoHeaderCount += stdSubListGetHeaderCount;
            }
            log.debug("{}[getEaiHeaders] *** BM *** getEaiHeaders=bm({})+mappingModelInfos({}) from serviceMappings({})", new Object[]{_CLASSTAG, newServiceMappingHeaderCount, newMappingModelInfoHeaderCount, serviceMapCount});
        }
        return prodEaiHeadersMap;
    }

    @Override
    public Map<String, Map<String, List<DWEAIHeader>>> getProdTechEaiHeaders(Map<String, List<DWServiceMapping>> serviceMappingMap, Map<String, List<MappingModelInfo>> mappingModelInfosMap) throws Exception {
        return Collections.emptyMap();
    }

    @Override
    public void clearEaiHeaders() {
        this.bmEaiMethodRepository.getEaiHeaders().clear();
    }
}

