/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.app.service.eai.DWEAIServiceDefinitionParser;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.customize.utils.BMCenterUtil;
import com.digiwin.lcdp.modeldriven.eai.builder.EaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.eai.builder.ModelStandardEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMethodHelper;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.service.ServiceMappingUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class EaiHeaderUtil {
    private static final Logger log = LoggerFactory.getLogger(EaiHeaderUtil.class);
    private static final String _CLASSTAG = "[" + EaiHeaderUtil.class.getSimpleName() + "]";
    @Autowired
    DWEAIHeaderRepository dwEAIHeaderRepository;
    @Autowired
    DWEAIServiceDefinitionParser dwEaiServiceDefinitionParser;
    @Autowired
    @Qualifier(value="bmCodes")
    Map<String, BMCode> bmCodes;
    @Autowired
    @Qualifier(value="dw-modeldriven-crud-eai-builder")
    ModelStandardEaiHeaderBuilder modelStandardEAIHeaderBuilder;
    @Autowired(required=false)
    @Qualifier(value="dw-modeldriven-customize-crud-eai-builder")
    EaiHeaderBuilder customizeEAIHeaderBuilder;

    public Map<String, List<DWEAIHeader>> genServiceDiscoveryModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        Map<String, List<DWEAIHeader>> techEaiHeaders = new HashMap<String, List<DWEAIHeader>>();
        List<Object> newEaiHeaders = new ArrayList();
        BMProperties bmProperties = BMProperties.getProperties();
        if (bmProperties == null || !bmProperties.isEnabled()) {
            newEaiHeaders = this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos, this.modelStandardEAIHeaderBuilder);
            return techEaiHeaders;
        }
        techEaiHeaders = this.genServiceDiscoveryModelDrivenEaiHeaders(serviceMappings, mappingModelInfos, this.customizeEAIHeaderBuilder);
        return techEaiHeaders;
    }

    public List<DWEAIHeader> genModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList();
        BMProperties bmProperties = BMProperties.getProperties();
        if (bmProperties == null || !bmProperties.isEnabled()) {
            newEaiHeaders = this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos, this.modelStandardEAIHeaderBuilder);
            return newEaiHeaders;
        }
        newEaiHeaders = this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos, this.customizeEAIHeaderBuilder);
        return newEaiHeaders;
    }

    public List<DWEAIHeader> genModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos, EaiHeaderBuilder eaiHeaderBuilder) throws Exception {
        log.info("{} genEaiHeaders using {}", (Object)_CLASSTAG, (Object)eaiHeaderBuilder.toString());
        List<DWEAIHeader> newEaiHeaders = eaiHeaderBuilder.getEaiHeaders(serviceMappings, mappingModelInfos);
        return newEaiHeaders;
    }

    public Map<String, List<DWEAIHeader>> genServiceDiscoveryModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos, EaiHeaderBuilder eaiHeaderBuilder) throws Exception {
        log.info("{} genEaiHeaders using {}", (Object)_CLASSTAG, (Object)eaiHeaderBuilder.toString());
        Map<String, List<DWEAIHeader>> allProdEaiHeaders = eaiHeaderBuilder.getTechEaiHeaders(serviceMappings, mappingModelInfos);
        return allProdEaiHeaders;
    }

    public List<DWEAIHeader> updateAndGetModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        List<DWEAIHeader> newEaiHeaders = this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos);
        if (CollectionUtils.isNotEmpty(newEaiHeaders)) {
            this.addAndUpdateDWEaiHeaders(newEaiHeaders);
        }
        return newEaiHeaders;
    }

    public void addAndUpdateDWEaiHeaders(List<DWEAIHeader> newEaiHeaders) throws Exception {
        if (CollectionUtils.isNotEmpty(newEaiHeaders)) {
            List orgDWHeaders = this.dwEAIHeaderRepository.getHeaders("commons");
            int newHeaderCount = newEaiHeaders.size();
            int orgInitHeaderCount = orgDWHeaders.size();
            List existedOrgDWHeaders = orgDWHeaders.stream().filter(orgDWHeader -> newEaiHeaders.stream().anyMatch(tempHeader -> ((DWEAIHeader)orgDWHeader).getEAIServiceId().equals(tempHeader.getEAIServiceId()))).collect(Collectors.toList());
            List existedDWEaiHeaderNames = existedOrgDWHeaders.stream().map(oldEaiHeader -> ((DWEAIHeader)oldEaiHeader).getEAIServiceId()).collect(Collectors.toList());
            int duplicatedCount = existedDWEaiHeaderNames.size();
            log.info("{} duplicate dwEaiHeader names {}", (Object)_CLASSTAG, existedDWEaiHeaderNames);
            log.info("{}[init] orgHeaderCount({}), mdHeaderCount({}), duplicatedCount({})", new Object[]{_CLASSTAG, orgDWHeaders.size(), newHeaderCount, duplicatedCount});
            newEaiHeaders.stream().filter(newEaiHeader -> !existedOrgDWHeaders.contains(newEaiHeader.getEAIServiceId())).forEach(newEaiHeader -> orgDWHeaders.add(newEaiHeader));
            log.debug(_CLASSTAG + " added to DWEAIHeaderRepository: {}", newEaiHeaders.stream().map(newEaiHeader -> newEaiHeader.getEAIServiceId()).collect(Collectors.toList()));
            log.info("{}[added] orgHeaderCount({})= initOrgHeaderCount({}) + mdHeaderCount({})", new Object[]{_CLASSTAG, orgDWHeaders.size(), orgInitHeaderCount, newHeaderCount});
            Method registerHeaderMethod = ModelDrivenMethodHelper.getRegisterHeaderAccessibleOfDWEAIServiceDefinitionParser();
            registerHeaderMethod.invoke((Object)this.dwEaiServiceDefinitionParser, "commons", orgDWHeaders);
            log.info("{}[{}] refresh DWEAIHeaderRepository size(total({}) = org({}) + modeldriven({}) - duplicated({}))", new Object[]{_CLASSTAG, "dw-modeldriven-service-commons-mapping-provider", orgDWHeaders.size(), orgInitHeaderCount, newHeaderCount, 0});
        } else {
            log.info("{}[{}] ignored refresh DWEAIHeaderRepository, cause empty newEaiHeaders ", (Object)_CLASSTAG, (Object)"dw-modeldriven-service-commons-mapping-provider");
        }
    }

    public List<DWHeader> getDropEaiHeaders(List<DWEAIHeader> draftEaiHeaders, List<DWHeader> actualHeaders) {
        List<Object> dropEaiHeaders = new ArrayList<DWHeader>();
        if (CollectionUtils.isNotEmpty(actualHeaders)) {
            dropEaiHeaders = actualHeaders.stream().filter(actual -> draftEaiHeaders.stream().noneMatch(draft -> ((DWEAIHeader)actual).getEAIServiceId().equals(draft.getEAIServiceId()))).collect(Collectors.toList());
            int dropHeaderCount = dropEaiHeaders.size();
            log.info("{}[{}] drop size({}) ({})", new Object[]{_CLASSTAG, dropHeaderCount, dropEaiHeaders});
        } else {
            log.info("{} ignored drop any DWEAIHeader", (Object)_CLASSTAG);
        }
        return dropEaiHeaders;
    }

    public void executeDropExistedEaiHeaders(List<DWHeader> dropEaiHeaders) {
        List orgDWHeaders = this.dwEAIHeaderRepository.getHeaders("commons");
        int repoBefore = orgDWHeaders.size();
        dropEaiHeaders.stream().forEach(dropDWHeader -> orgDWHeaders.remove(dropDWHeader));
        List dropList = dropEaiHeaders.stream().map(dropEaiHeader -> ((DWEAIHeader)dropEaiHeader).getEAIServiceId()).collect(Collectors.toList());
        int repoAfter = orgDWHeaders.size();
        log.info("{} drop DWEAIHeaderRepository--> dropped({},{})(dwEAIHeaderRepo: before({}), after({}))", new Object[]{_CLASSTAG, dropList.size(), dropList, repoBefore, orgDWHeaders.size()});
    }

    public List<DWEAIHeader> getAddEaiHeaders(List<DWEAIHeader> draftEaiHeaders, List<DWHeader> actualHeaders) {
        List<Object> addEaiHeaders = new ArrayList();
        addEaiHeaders = draftEaiHeaders.stream().filter(draft -> actualHeaders.stream().noneMatch(actual -> Objects.equals(draft.getEAIServiceId(), ((DWEAIHeader)actual).getEAIServiceId()))).collect(Collectors.toList());
        int dropHeaderCount = addEaiHeaders.size();
        log.info("{} drop size({}) ({})", new Object[]{_CLASSTAG, dropHeaderCount, addEaiHeaders});
        return addEaiHeaders;
    }

    public List<DWEAIHeader> genServiceModelInfoData(ModelSchemaDTO masterModelSchema, String modelDrivenProdPrefix, String code) throws Exception {
        String masterTableName = masterModelSchema.getName();
        String userExposePrefixEaiId = EaiServiceNameUtil.getEaiPrefixName(modelDrivenProdPrefix, masterTableName);
        String modelSchemaStr = ModelDataUtil.getModelSchemaStr(masterModelSchema);
        List<ModelSchemaDTO> allChildrenSchemas = ModelSchemaUtil.getChildrenModelSchema(masterModelSchema.getChildren());
        DWServiceMapping serviceMapping = new DWServiceMapping();
        serviceMapping.setTableName(masterTableName);
        serviceMapping.setExposeEaiId(userExposePrefixEaiId);
        serviceMapping.setModelSchema(modelSchemaStr);
        serviceMapping.setCode(code);
        ArrayList<DWServiceMapping> serviceMappings = new ArrayList<DWServiceMapping>();
        serviceMappings.add(serviceMapping);
        List<MappingModelInfo> mappingModelInfos = ModelDataUtil.getChildrenMappingModelInfo(allChildrenSchemas, masterTableName, userExposePrefixEaiId, code);
        ServiceMappingUtil.updateProd(serviceMappings, mappingModelInfos);
        BMProperties bmProperties = BMProperties.getProperties();
        if (bmProperties != null && bmProperties.isEnabled()) {
            BMCenterUtil.modifyServiceMapping(serviceMappings);
            BMCenterUtil.modifyMappingModelInfo(mappingModelInfos);
        }
        List<DWEAIHeader> eaiHeaders = this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos);
        return eaiHeaders;
    }

    public List<DWHeader> getExistedEaiHeaders(List<DWEAIHeader> dweaiHeaders) {
        List<Object> existedEaiHeaders = new ArrayList<DWHeader>();
        if (CollectionUtils.isNotEmpty(dweaiHeaders)) {
            List orgDWHeaders = this.dwEAIHeaderRepository.getHeaders("commons");
            existedEaiHeaders = orgDWHeaders.stream().filter(orgDWHeader -> orgDWHeader instanceof DWEAIHeader && dweaiHeaders.stream().anyMatch(dweaiHeader -> ((DWEAIHeader)orgDWHeader).getEAIServiceId().equals(dweaiHeader.getEAIServiceId()))).collect(Collectors.toList());
            log.info("{} get existedEaiHeaders({} from DWEAIHeaderRepository({}({})))", new Object[]{_CLASSTAG, existedEaiHeaders.size(), "commons", orgDWHeaders.size()});
        } else {
            log.info("{} ignored get existedEaiHeaders  from DWEAIHeaderRepository", (Object)_CLASSTAG);
        }
        return existedEaiHeaders;
    }

    public String getTableName(String serviceName, String serviceProdfix) {
        BMCode bmCode = this.bmCodes.getOrDefault(serviceName, null);
        String tableName = bmCode != null ? bmCode.getTableName() : "";
        return tableName;
    }

    public List<DWEAIHeader> refreshEaiService(ModelSchemaDTO masterModelSchema, String modelDrivenProdPrefix, String code) throws Exception {
        List<DWEAIHeader> newEaiHeaders = this.genServiceModelInfoData(masterModelSchema, modelDrivenProdPrefix, code);
        this.addAndUpdateDWEaiHeaders(newEaiHeaders);
        return newEaiHeaders;
    }
}

