/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.lcdp.modeldriven.constants.ModelDBConstants;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.ModelTableSchemaCache;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.pojo.ExceptionSQLInfo;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlParserUtil;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import com.digiwin.utils.DWTenantUtils;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ModelDrivenExceptionUtils {
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenExceptionUtils.class);

    public Throwable filterSQLException(Throwable e) {
        try {
            this.dealSQLException(e);
            return e;
        }
        catch (Exception ex) {
            log.error("ExceptionUtils.filterSQLException error!", (Throwable)ex);
            return ex;
        }
    }

    public Throwable dealSQLException(Throwable throwable) throws Exception {
        Field superDetailMessage = Throwable.class.getDeclaredField("detailMessage");
        if (throwable != null) {
            if (throwable.getCause() == null) {
                if (throwable instanceof SQLException && ((SQLException)throwable).getNextException() != null) {
                    superDetailMessage.setAccessible(true);
                    superDetailMessage.set(throwable, this.customizeErrorMessage(((SQLException)throwable).getNextException()));
                }
                return throwable;
            }
            Throwable causeExceptions = this.dealSQLException(throwable.getCause());
            if (causeExceptions == null) {
                return throwable;
            }
            if (causeExceptions instanceof SQLException) {
                SQLException cause = (SQLException)causeExceptions;
                superDetailMessage.setAccessible(true);
                superDetailMessage.set(throwable, cause.getMessage());
                return cause;
            }
        }
        return throwable;
    }

    public String customizeErrorMessage(Throwable throwable) {
        Object message = throwable.getMessage();
        if (((String)message).indexOf("Duplicate entry") != -1) {
            String i18nDescription;
            int endKeyName;
            int startRowValue = ((String)message).indexOf("'");
            int endRowValue = ((String)message).indexOf("'", startRowValue + 1);
            String rowValue = ((String)message).substring(startRowValue + 1, endRowValue);
            int startKeyName = ((String)message).indexOf("'", endRowValue + 1);
            String keyName = ((String)message).substring(startKeyName + 1, endKeyName = ((String)message).indexOf("'", startKeyName + 1));
            List<String> keyMembers = this.getConstrainMember(keyName);
            if (CollectionUtils.isNotEmpty(keyMembers)) {
                String memberStr = String.join((CharSequence)",", keyMembers);
                i18nDescription = String.format(ResourceBundleUtils.getString("sqlException.duplicateentry.WithConstrainMember"), rowValue, keyName, memberStr);
            } else {
                i18nDescription = String.format(ResourceBundleUtils.getString("sqlException.duplicateentry"), rowValue, keyName);
            }
            StringBuilder builder = new StringBuilder().append("errCode:").append("P.LCDP.102.0001").append("  ").append("description:").append(i18nDescription);
            return builder.toString();
        }
        Map currentModifyColumns = (Map)ModelDrivenContext.getContext().getExtraMap().get("exceptionAlterDDL");
        if (MapUtils.isNotEmpty((Map)currentModifyColumns)) {
            String tableName = (String)currentModifyColumns.get("exceptionAlterDDLTable");
            List modifyColumnNames = currentModifyColumns.getOrDefault("exceptionAlterDDLColumns", new ArrayList());
            String alterInfo = String.format(ResourceBundleUtils.getString("lcdp.modeldriven.publish.fail.SqlExceptionShowAlterColumn"), tableName, modifyColumnNames);
            message = (String)message + ", " + alterInfo;
        }
        return message;
    }

    public String customizeErrorMessageV2(Throwable throwable) {
        Object message = throwable.getMessage();
        SQLException sqlException = ((SQLException)throwable).getNextException();
        if (sqlException.getSQLState().startsWith("23")) {
            Matcher matcherDuplicateEntry = ModelDBConstants.PATTERN_DUPLICATE_ENTRY.matcher((CharSequence)message);
            if (matcherDuplicateEntry.find()) {
                String i18nDescription;
                String rowValue = matcherDuplicateEntry.group(1);
                String keyName = matcherDuplicateEntry.group(2);
                List<String> keyMembers = this.getConstrainMember(keyName);
                List<Map<String, Object>> keyColumnsMembers = this.getConstrainMemberColumn(keyName);
                if (CollectionUtils.isNotEmpty(keyColumnsMembers)) {
                    ArrayList<CallSite> columnNames = new ArrayList<CallSite>();
                    for (Map<String, Object> tableColumnName : keyColumnsMembers) {
                        columnNames.add((CallSite)((Object)("[" + String.valueOf(tableColumnName.get("columnComment")) + "]=" + String.valueOf(tableColumnName.get("columnValue")))));
                    }
                    String memberStr = String.join((CharSequence)",", columnNames);
                    i18nDescription = String.format(ResourceBundleUtils.getString("sqlException.duplicateentry.WithConstrainMember"), rowValue, keyName, memberStr);
                } else {
                    i18nDescription = String.format(ResourceBundleUtils.getString("sqlException.duplicateentry"), rowValue, keyName);
                }
                StringBuilder builder = new StringBuilder().append("errCode:").append("P.LCDP.102.0001").append("  ").append("description:").append(i18nDescription);
                return builder.toString();
            }
            Map currentModifyColumns = (Map)ModelDrivenContext.getContext().getExtraMap().get("exceptionAlterDDL");
            if (MapUtils.isNotEmpty((Map)currentModifyColumns)) {
                String tableName = (String)currentModifyColumns.get("exceptionAlterDDLTable");
                List modifyColumnNames = currentModifyColumns.getOrDefault("exceptionAlterDDLColumns", new ArrayList());
                String alterInfo = String.format(ResourceBundleUtils.getString("lcdp.modeldriven.publish.fail.SqlExceptionShowAlterColumn"), tableName, modifyColumnNames);
                message = (String)message + ", " + alterInfo;
            }
        }
        return message;
    }

    public List<String> getConstrainMember(String keyName) {
        ModelDTO publishedModel;
        ModelSchemaDTO modelSchema;
        ModelTable modelTable;
        ModelTableSchemaCache modelTableSchemaCache;
        Map<String, Object> indexesMap;
        List<String> indexMembers = new ArrayList<String>();
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map currentModifyColumns = (Map)modelDrivenContext.getExtraMap().get("exceptionAlterDDL");
        if (MapUtils.isNotEmpty((Map)currentModifyColumns)) {
            String tableName = (String)currentModifyColumns.get("exceptionAlterDDLTable");
            Map draftModelTableMap = (Map)ModelDrivenContext.getContext().getExtraMap().get("draftModelTables");
            ModelTable modelTable2 = (ModelTable)draftModelTableMap.get(tableName);
            TableIndex tableIndex = modelTable2.getIndexes().stream().filter(index -> index.getName().equals(keyName)).findFirst().get();
            if (Objects.nonNull(tableIndex)) {
                indexMembers = tableIndex.getMember();
            }
        } else if (modelDrivenContext.getDraftModel() == null && (indexesMap = (modelTableSchemaCache = ModelSchemaUtil.getModelTableSchemaCache(modelTable = ModelSchemaUtil.getCurrentLevelModelTable(modelSchema = (publishedModel = modelDrivenContext.getPublishedModel()).getSchema()))).getPublishedRemainIndexes()).containsKey(keyName)) {
            TableIndex tableIndex = (TableIndex)indexesMap.get(keyName);
            indexMembers = tableIndex.getMember();
        }
        return indexMembers;
    }

    public List<Map<String, Object>> getConstrainMemberColumn(String keyName) {
        LinkedList<Map<String, Object>> returnValue = new LinkedList<Map<String, Object>>();
        ArrayList<String> indexMembers = new ArrayList();
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map currentModifyColumns = (Map)modelDrivenContext.getExtraMap().get("exceptionAlterDDL");
        ExceptionSQLInfo exceptionSQLInfo = (ExceptionSQLInfo)modelDrivenContext.getExtraMap().get("exceptionDMLSqlInfo");
        ModelTable targetModelTable = null;
        if (MapUtils.isNotEmpty((Map)currentModifyColumns)) {
            String tableName = (String)currentModifyColumns.get("exceptionAlterDDLTable");
            Map draftModelTableMap = (Map)ModelDrivenContext.getContext().getExtraMap().get("draftModelTables");
            targetModelTable = (ModelTable)draftModelTableMap.get(tableName);
            TableIndex tableIndex = targetModelTable.getIndexes().stream().filter(index -> index.getName().equals(keyName)).findFirst().get();
            if (Objects.nonNull(tableIndex)) {
                indexMembers = tableIndex.getMember();
            }
        } else if (exceptionSQLInfo != null && exceptionSQLInfo.getSqlParam() != null) {
            ModelDTO publishedModel = modelDrivenContext.getPublishedModel();
            ModelSchemaDTO modelSchema = publishedModel.getSchema();
            Map<Object, Object> sqlInfoMap = new HashMap();
            Map insertKeyValueMap = new HashMap();
            try {
                sqlInfoMap = ModelSqlParserUtil.getSqlCommandInfo(exceptionSQLInfo.getSqlParam());
                String tableName = (String)sqlInfoMap.get("tableName");
                insertKeyValueMap = (Map)sqlInfoMap.get("keyValue");
                Map<String, ModelSchemaDTO> modelSchemaTableMap = ModelSchemaUtil.getModelSchemaMap(modelSchema);
                targetModelTable = ModelSchemaUtil.getCurrentLevelModelTable(modelSchemaTableMap.get(tableName));
                ModelTableSchemaCache modelTableSchemaCache = ModelSchemaUtil.getModelTableSchemaCache(targetModelTable);
                Map<String, Object> indexesMap = modelTableSchemaCache.getPublishedRemainIndexes();
                if (indexesMap.containsKey(keyName)) {
                    TableIndex tableIndex = (TableIndex)indexesMap.get(keyName);
                    indexMembers = tableIndex.getMember();
                    List<TableColumn> targetColumns = this.getValidTableColumns(targetModelTable, indexMembers);
                    for (TableColumn tableColumn : targetColumns) {
                        HashMap<String, String> member = new HashMap<String, String>();
                        Object value = insertKeyValueMap.get(tableColumn.getColumnName());
                        member.put("columnName", tableColumn.getColumnName());
                        member.put("columnComment", tableColumn.getComment());
                        member.put("columnValue", (String)value);
                        returnValue.add(member);
                    }
                }
            }
            catch (JSQLParserException e) {
                log.warn(e.getMessage());
            }
        }
        return returnValue;
    }

    public List<TableColumn> getValidTableColumns(ModelTable targetModelTable, List<String> indexMembers) {
        List<TableColumn> targetColumns = new ArrayList<TableColumn>();
        if (CollectionUtils.isNotEmpty(indexMembers) && targetModelTable != null) {
            targetColumns = targetModelTable.getColumns().stream().filter(targetColumn -> !targetColumn.getColumnName().equals(DWTenantUtils.getTenantColumnName()) && indexMembers.stream().anyMatch(indexMemberName -> targetColumn.getColumnName().equals(indexMemberName))).collect(Collectors.toList());
        }
        return targetColumns;
    }

    public String getDuplicateKey(String throwSQLErrorMessage) {
        Matcher matcherDuplicateEntry = ModelDBConstants.PATTERN_DUPLICATE_ENTRY.matcher(throwSQLErrorMessage);
        if (matcherDuplicateEntry.find()) {
            String duplicateEntry = matcherDuplicateEntry.group(1);
            String key = matcherDuplicateEntry.group(2);
            return key;
        }
        return null;
    }
}

