/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.customize.config.NacosServiceRegisterEvent;
import com.digiwin.loadbalance.service.UpdateMetadataService;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class NacosRegisterUtils {
    private static final Logger _log = LoggerFactory.getLogger(NacosRegisterUtils.class);
    @Autowired(required=false)
    UpdateMetadataService updateMetadataService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    public void autoRegisterNacos(List<DWEAIHeader> newEaiHeaders) throws Exception {
        this.registerService(newEaiHeaders);
    }

    public void registerService(List<DWEAIHeader> newEaiHeaders) throws Exception {
        NacosServiceRegisterEvent nacosServiceRegisterEvent = new NacosServiceRegisterEvent(newEaiHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList()));
        this.applicationEventPublisher.publishEvent((ApplicationEvent)nacosServiceRegisterEvent);
    }

    public void registerService(List<DWEAIHeader> newEaiHeaders, String prod) throws Exception {
        List<String> eaiServiceIdList = newEaiHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList());
        this.nacosServiceRegister(eaiServiceIdList, prod);
    }

    public void nacosServiceRegister(List<String> eaiIds) throws Exception {
        HashMap eaiIdsMap = new HashMap();
        eaiIds.forEach(eaiId -> eaiIdsMap.put(eaiId, new int[]{132}));
        this.updateMetadataService.updateInstanceMetadata(eaiIdsMap);
        this.updateMetadataService.updateServiceMetadataIfNeed();
        _log.debug("<<< nacos service register successfully , service ids :{}", eaiIds);
    }

    public void nacosServiceRegister(List<String> eaiIds, String prod) throws Exception {
        HashMap eaiIdsMap = new HashMap();
        eaiIds.forEach(eaiId -> eaiIdsMap.put(eaiId, new int[]{132}));
        this.updateMetadataService.updateInstanceMetadata(prod, eaiIdsMap);
        this.updateMetadataService.updateServiceMetadataIfNeed(prod);
        _log.debug("<<< nacos service register successfully , prod({}) service ids :{}", (Object)prod, eaiIds);
    }
}

