/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;

public class SqlParserUtil {
    private static final Logger logger = LoggerFactory.getLogger(SqlParserUtil.class);
    private static final String _CLASSTAG = "[" + SqlParserUtil.class.getSimpleName() + "]";

    public static List<String> getSql(String sqlFilePath) {
        List<String> sqlArr = new ArrayList<String>();
        try {
            InputStreamReader isr = new InputStreamReader(SqlParserUtil.class.getClassLoader().getResourceAsStream(sqlFilePath), "UTF-8");
            String sqlStr = FileCopyUtils.copyToString((Reader)isr);
            sqlArr = Arrays.asList(sqlStr.split(";\r\n"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sqlArr;
    }

    public static void initalSqlExecute(String dbConnectionString, String account, String password, String sqlFilePath) throws Exception {
        Connection connection = DriverManager.getConnection(dbConnectionString, account, password);
        Statement statement = connection.createStatement();
        List<String> sqls = SqlParserUtil.getSql(sqlFilePath);
        logger.debug("sqlPath:{} sqlContents:{}", (Object)sqlFilePath, sqls);
        sqls.forEach(sql -> {
            try {
                statement.addBatch((String)sql);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
        statement.executeBatch();
        statement.close();
    }

    public static String getMainTable(String sql) throws Exception {
        String tableName = "";
        net.sf.jsqlparser.statement.Statement statement = CCJSqlParserUtil.parse((String)sql);
        if (statement instanceof Select) {
            PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
            FromItem fromItem = select.getFromItem();
            if (fromItem instanceof Table) {
                tableName = ((Table)fromItem).getName();
            } else {
                while (fromItem instanceof SubSelect && ((SubSelect)fromItem).getSelectBody() != null) {
                    SubSelect subSelect = (SubSelect)fromItem;
                    PlainSelect ssubSelect = (PlainSelect)subSelect.getSelectBody();
                    if (ssubSelect.getFromItem() instanceof Table) {
                        tableName = ((Table)ssubSelect.getFromItem()).getName();
                        break;
                    }
                    if (!(ssubSelect.getFromItem() instanceof SubSelect)) continue;
                    fromItem = ssubSelect.getFromItem();
                }
            }
            logger.debug("get tableName '{}' from sql '{}'", (Object)tableName, (Object)sql);
            return tableName;
        }
        throw new RuntimeException(String.format("sql is not a select statement:'%s'", sql));
    }
}

