/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.aop;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.lcdp.modeldriven.aop.DWEAICrudInvocationListener;
import com.digiwin.lcdp.modeldriven.aop.DWEAICrudInvocationListenerRegistry;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.constants.BMConstants;
import com.digiwin.lcdp.modeldriven.customize.handler.BMAdapterCustomizeHandler;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.utils.ApiNameUtil;
import com.digiwin.lcdp.modeldriven.utils.BMCodeUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class DWEAICommonCrudInterceptor
implements MethodInterceptor,
DWEAICrudInvocationListenerRegistry {
    private static Logger logger = LoggerFactory.getLogger(DWEAICommonCrudInterceptor.class);
    private static final String _CLASSTAG = "[" + DWEAICommonCrudInterceptor.class.getSimpleName() + "]";
    @Autowired(required=false)
    @Qualifier(value="modeldriven-customize-bm-crud-adapter")
    private Object serviceAdapter;
    @Autowired(required=false)
    @Qualifier(value="modeldriven-customize-bm-adapter-handler")
    private BMAdapterCustomizeHandler bmAdapterHandler;
    @Autowired
    @Qualifier(value="bmCodes")
    Map<String, BMCode> bmCodes;
    Map<String, LinkedList<DWEAICrudInvocationListener>> listeners = new HashMap<String, LinkedList<DWEAICrudInvocationListener>>();

    public Map<String, LinkedList<DWEAICrudInvocationListener>> getListeners() {
        return this.listeners;
    }

    public void setListeners(Map<String, LinkedList<DWEAICrudInvocationListener>> listeners) {
        this.listeners = listeners;
    }

    public Object getServiceAdapter() {
        return this.serviceAdapter;
    }

    public void setServiceAdapter(Object serviceAdapter) {
        this.serviceAdapter = serviceAdapter;
    }

    @Override
    public void register(String eaiId, DWEAICrudInvocationListener listener) {
        logger.debug("{} add eaiId({}), listener({})", new Object[]{_CLASSTAG, eaiId, listener.getClass().getTypeName()});
        LinkedList<DWEAICrudInvocationListener> linkedLists = this.listeners.getOrDefault(eaiId, new LinkedList());
        linkedLists.add(listener);
        this.listeners.put(eaiId, linkedLists);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String digiServiceName = DWServiceContext.getContext().getDigiServiceName();
        logger.debug("{} invoke eaiId({}), intercept {}.{})", new Object[]{_CLASSTAG, digiServiceName, invocation.getMethod().getDeclaringClass().getName(), invocation.getMethod().getName()});
        LinkedList<DWEAICrudInvocationListener> serviceListeners = this.listeners.get(digiServiceName);
        Object result = null;
        boolean isStandardService = false;
        BMCode bmCode = BMCodeUtil.getBMCodeByServiceName(this.bmCodes, digiServiceName);
        if (bmCode == null || StringUtils.isBlank((CharSequence)bmCode.getTargetProd())) {
            isStandardService = true;
        }
        if (this.isChildrenListGet(digiServiceName)) {
            result = invocation.proceed();
        } else if (CollectionUtils.isNotEmpty(serviceListeners)) {
            Object[] objects = invocation.getArguments();
            Map headers = (Map)objects[0];
            Map messageBody = (Map)objects[1];
            StopWatch stopWatch = StopWatch.createStarted();
            StringBuffer timeRecord = new StringBuffer();
            try {
                timeRecord.append(String.format("beforeInvoke(%d) ", stopWatch.getTime()));
                logger.debug(timeRecord.toString());
                for (DWEAICrudInvocationListener targetListener : serviceListeners) {
                    logger.debug(_CLASSTAG + " invoke ({}) , service({}) interceptor({}) beforeInvoke ", (Object)digiServiceName, (Object)targetListener.getClass().getTypeName());
                    targetListener.beforeInvoke(headers, messageBody);
                }
                if (this.serviceAdapter != null && !isStandardService) {
                    Method bmAdapterBeforeInvoke = this.serviceAdapter.getClass().getDeclaredMethod("beforeInvoke", Map.class, Map.class);
                    bmAdapterBeforeInvoke.invoke(this.serviceAdapter, headers, messageBody);
                }
                timeRecord.append(String.format("afterBeforeInvoke(%d) ", stopWatch.getTime()));
                result = invocation.proceed();
                timeRecord.append(String.format("invocation.proceed()(%d) ", stopWatch.getTime()));
                for (DWEAICrudInvocationListener targetListener : serviceListeners) {
                    logger.debug("{} invoke ({}) , service({}) interceptor({}) around ", new Object[]{_CLASSTAG, digiServiceName, targetListener.getClass().getTypeName()});
                    targetListener.around(headers, messageBody);
                }
            }
            catch (Throwable e) {
                timeRecord.append(String.format("before doException(%d) ", stopWatch.getTime()));
                for (DWEAICrudInvocationListener targetListener : serviceListeners) {
                    logger.debug("{} invoke ({}) , service({}) interceptor({}) doException ", new Object[]{_CLASSTAG, digiServiceName, targetListener.getClass().getTypeName()});
                    targetListener.doException(e);
                }
                timeRecord.append(String.format("after doException(%d) ", stopWatch.getTime()));
                throw e;
            }
            finally {
                if (!stopWatch.isStopped()) {
                    stopWatch.stop();
                }
            }
            if (this.serviceAdapter != null && !isStandardService) {
                Method bmAdapterAfterInvoke = this.serviceAdapter.getClass().getDeclaredMethod("afterInvoke", Map.class, Object.class);
                bmAdapterAfterInvoke.invoke(this.serviceAdapter, headers, result);
            }
            for (DWEAICrudInvocationListener targetListener : serviceListeners) {
                logger.debug("{} invoke ({}) , service({}) interceptor({}) afterInvoke ", new Object[]{_CLASSTAG, digiServiceName, targetListener.getClass().getTypeName()});
                targetListener.afterInvoke(invocation, result);
            }
        } else if (isStandardService) {
            logger.debug("{} ignore to invoke adapter, serviceName({}), bmCode is null or targetProd is blank", (Object)_CLASSTAG, (Object)digiServiceName);
            result = invocation.proceed();
        } else {
            String serviceType = ApiNameUtil.getServiceNameType(digiServiceName);
            if (this.serviceAdapter != null && !BMConstants.SERVICE_TYPE_VALID.contains(serviceType)) {
                Method bmAdapterBeforeInvoke;
                logger.debug("{} invoke ({}) , target interceptor matched none", (Object)_CLASSTAG, (Object)digiServiceName);
                Object[] objects = invocation.getArguments();
                Map headers = (Map)objects[0];
                Map messageBody = (Map)objects[1];
                StopWatch stopWatch = StopWatch.createStarted();
                StringBuffer timeRecord = new StringBuffer();
                try {
                    timeRecord.append(String.format("beforeInvoke(%d) ", stopWatch.getTime()));
                    logger.debug(timeRecord.toString());
                    bmAdapterBeforeInvoke = this.serviceAdapter.getClass().getDeclaredMethod("beforeInvoke", Map.class, Map.class);
                    bmAdapterBeforeInvoke.invoke(this.serviceAdapter, headers, messageBody);
                    timeRecord.append(String.format("afterBeforeInvoke(%d) ", stopWatch.getTime()));
                    result = invocation.proceed();
                    timeRecord.append(String.format("invocation.proceed()(%d) ", stopWatch.getTime()));
                }
                catch (Throwable e) {
                    timeRecord.append(String.format("catch doException(%d) ", stopWatch.getTime()));
                    throw e;
                }
                finally {
                    if (!stopWatch.isStopped()) {
                        stopWatch.stop();
                    }
                }
                bmAdapterBeforeInvoke = this.serviceAdapter.getClass().getDeclaredMethod("afterInvoke", Map.class, Object.class);
                bmAdapterBeforeInvoke.invoke(this.serviceAdapter, headers, result);
                logger.debug("{} didn't have registered interceptor when invoke eaiId({})", (Object)_CLASSTAG, (Object)digiServiceName);
            } else {
                result = invocation.proceed();
            }
        }
        return result;
    }

    private boolean isChildrenListGet(String eaiId) {
        if (BMProperties.getProperties().isEnabled() && BMProperties.getProperties().getRole() != BMRole.bmd) {
            Optional<BMCode> bmCode = Optional.ofNullable(this.bmCodes.get(eaiId));
            if (bmCode.isPresent()) {
                return bmCode.get().isChildrenTableListGet();
            }
            logger.warn("{} digiServiceName '{}' can not be found in BMCodes", (Object)_CLASSTAG, (Object)eaiId);
            return false;
        }
        return false;
    }
}

