/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.config;

import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.commons.config.DWServiceCommonsProvider;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.eai.EAIService;
import com.digiwin.lcdp.modeldriven.config.condition.ModelDrivenDisabledLoadBalanceCondition;
import com.digiwin.lcdp.modeldriven.config.condition.ModelDrivenEnabledLoadBalanceCondition;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.aop.BMCRUDDigiServiceNameInterceptor;
import com.digiwin.lcdp.modeldriven.customize.config.CustomizeAutoConfiguration;
import com.digiwin.lcdp.modeldriven.customize.config.condition.BMDataRoleCondition;
import com.digiwin.lcdp.modeldriven.customize.constants.CustomizeConstants;
import com.digiwin.lcdp.modeldriven.customize.eai.BMDataEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.customize.model.BMDataCRUDServiceRepository;
import com.digiwin.lcdp.modeldriven.customize.model.BMDataEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.customize.registry.BMAbstractRegistryApplicationListener;
import com.digiwin.lcdp.modeldriven.customize.registry.BMDataLayerRegistryApplicationListener;
import com.digiwin.lcdp.modeldriven.customize.service.impl.BMDataEAICrudService;
import com.digiwin.lcdp.modeldriven.eai.builder.EaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.eai.builder.ModelStandardEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.enums.RegisterServiceTechTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDrivenEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.pojo.ModelDrivenEaiMethodDTO;
import com.digiwin.lcdp.modeldriven.pojo.TechEaiData;
import com.digiwin.lcdp.modeldriven.utils.EaiHeaderUtil;
import com.digiwin.lcdp.modeldriven.utils.service.RegTypeUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aopalliance.aop.Advice;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@Conditional(value={BMDataRoleCondition.class})
@AutoConfigureAfter(value={CustomizeAutoConfiguration.class})
public class BMDataAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BMDataAutoConfiguration.class);
    private static final String _CLASSTAG = "[" + BMDataAutoConfiguration.class.getSimpleName() + "]";

    @Bean(name={"lcdp-bmd-eai-crud-service-repo"})
    public BMDataCRUDServiceRepository getBMDataEaiServiceRepo(@Qualifier(value="dw-service-commons-provider") DWServiceCommonsProvider serviceCommonsProvider, @Qualifier(value="modeldriven-bm-properties") BMProperties bmProperties) {
        BMDataCRUDServiceRepository bmdServiceRepository = new BMDataCRUDServiceRepository();
        Map<String, Class<?>> bmdInterfaceServices = bmProperties.getBmdCrudInterfaceService();
        for (String crudType : bmdInterfaceServices.keySet()) {
            bmdServiceRepository.addInterf(crudType, bmdInterfaceServices.get(crudType));
        }
        Map<String, DWServiceInfo> bmdImplementServices = bmProperties.getBmdCrudImplementService();
        for (String crudType : bmdImplementServices.keySet()) {
            bmdServiceRepository.addImplet(crudType, bmdImplementServices.get(crudType));
        }
        log.info("{} bean:{} created!", (Object)_CLASSTAG, (Object)"lcdp-bmd-eai-crud-service-repo");
        return bmdServiceRepository;
    }

    @Bean(name={"lcdp-bmd-eai-method-repo"})
    public BMDataEaiMethodRepository bmdEaiMethodRepository(@Qualifier(value="dw-service-commons-provider") DWServiceCommonsProvider serviceCommonsProvider, @Qualifier(value="lcdp-bmd-eai-crud-service-repo") BMDataCRUDServiceRepository bmdCRUDServiceRepository, @Qualifier(value="dw-modeldriven-eai-repo") ModelDrivenEaiMethodRepository modelDrivenEaiMethodRepository) {
        List<String> bmStandardEaiPostFixNames = CustomizeConstants.CUSTOMIZE_BMD_METHOD_POSTFIX;
        ArrayList bmdCrudEaiClazzMethods = new ArrayList();
        Map<String, Class<?>> interfs = bmdCRUDServiceRepository.getInterfs();
        for (String crudType : interfs.keySet()) {
            Class<?> bmdEaiClazz = interfs.get(crudType);
            Method[] methods = bmdEaiClazz.getMethods();
            List tempMethods = Arrays.stream(methods).collect(Collectors.toList());
            bmdCrudEaiClazzMethods.addAll(tempMethods);
        }
        BMDataEaiMethodRepository bmDataEaiMethodRepo = new BMDataEaiMethodRepository();
        for (Method method : bmdCrudEaiClazzMethods) {
            if (!method.isAnnotationPresent(EAIService.class)) continue;
            EAIService methodAnnotation = method.getAnnotation(EAIService.class);
            String methodAnnotEaiId = methodAnnotation.id();
            for (String postFix : bmStandardEaiPostFixNames) {
                if (!methodAnnotEaiId.endsWith(postFix)) continue;
                String[] postFixToken = postFix.split("\\.");
                String eaiServicePostfix = postFixToken[2];
                if (postFixToken.length > 3) {
                    for (int i = 3; i < postFixToken.length; ++i) {
                        eaiServicePostfix = String.join((CharSequence)".", eaiServicePostfix, postFixToken[i]);
                    }
                }
                ModelDrivenEaiMethodDTO modelDrivenEaiMethodDTO = new ModelDrivenEaiMethodDTO();
                modelDrivenEaiMethodDTO.setEaiId(methodAnnotEaiId);
                modelDrivenEaiMethodDTO.setEaiServicePostfix(eaiServicePostfix);
                modelDrivenEaiMethodDTO.setMethod(method);
                log.debug("{} serviceMapping: eaiMethodRepo add eaiId({}), eaiServicePostfix({})", new Object[]{_CLASSTAG, methodAnnotEaiId, eaiServicePostfix});
                bmDataEaiMethodRepo.add(methodAnnotEaiId, modelDrivenEaiMethodDTO);
            }
        }
        bmDataEaiMethodRepo.setListGetMethod(modelDrivenEaiMethodRepository.getListGetMethod());
        log.info("{} bean:{} created!", (Object)_CLASSTAG, (Object)"lcdp-bmd-eai-method-repo");
        return bmDataEaiMethodRepo;
    }

    @Bean(name={"modeldriven-customize-crud-eai-builder"})
    @ConditionalOnProperty(name={"lcdp.bm.role"}, havingValue="bmd")
    public EaiHeaderBuilder bmdEaiHeaderBuilder(@Qualifier(value="dw-modeldriven-crud-eai-builder") ModelStandardEaiHeaderBuilder modelStandardEAIHeaderBuilder, @Qualifier(value="lcdp-bmd-eai-method-repo") BMDataEaiMethodRepository bmdEaiMethodRepository) {
        return new BMDataEaiHeaderBuilder();
    }

    @Bean(name={"modeldriven-customize-genEaiHeaders"})
    @DependsOn(value={"modeldriven-tech-eaiheader"})
    @ConditionalOnProperty(name={"lcdp.bm.role"}, havingValue="bmd")
    public Object autoGenBMDataEaiHeaders(@Qualifier(value="modeldriven-tech-eaiheader") TechEaiData targetTechEaiData, BMDataEAICrudService bmDataEAICrudService, EaiHeaderUtil eaiHeaderUtil) {
        Map<String, List<DWEAIHeader>> newTechEaiHeaders = new HashMap<String, List<DWEAIHeader>>();
        try {
            DWEAIResult serviceResult = (DWEAIResult)bmDataEAICrudService.getBMDCode(null, null);
            List serviceMappings = serviceResult.getParameter().getOrDefault("serviceMapping", new ArrayList());
            List mappingModelInfos = serviceResult.getParameter().getOrDefault("mappingModelInfos", new ArrayList());
            if (CollectionUtils.isNotEmpty((Collection)serviceMappings)) {
                newTechEaiHeaders = eaiHeaderUtil.genServiceDiscoveryModelDrivenEaiHeaders(serviceMappings, mappingModelInfos);
            }
        }
        catch (Exception e) {
            String errorRootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
            log.error("{} >>> get codes failed, cause:{}", (Object)_CLASSTAG, (Object)errorRootCauseMessage);
        }
        Map<String, List<DWEAIHeader>> targetTechEai = targetTechEaiData.getTechHeaders();
        RegTypeUtil.mergeTechType(targetTechEai, newTechEaiHeaders);
        log.info("{} bean: {} created!", (Object)_CLASSTAG, (Object)"modeldriven-customize-genEaiHeaders");
        return newTechEaiHeaders;
    }

    @Bean(name={"modeldriven-customize-bmd-updateEaiRepo"})
    @DependsOn(value={"modeldriven-customize-genEaiHeaders"})
    @ConditionalOnProperty(name={"lcdp.bm.role"}, havingValue="bmd")
    public Object updateBMDataLayerEaiRepository(@Qualifier(value="modeldriven-tech-eaiheader") TechEaiData targetTechEaiData, EaiHeaderUtil eaiHeaderUtil) {
        Map targetTechEai = targetTechEaiData.getTechHeaders();
        String espTech = RegisterServiceTechTypeEnum.ESP.getTechType();
        List newEspEaiHeaders = targetTechEai.getOrDefault(espTech, new ArrayList());
        boolean isBmdRegistryNacosToEsp = BMProperties.getProperties().isBmdRegistryNacosToEsp();
        log.debug("{}[updateBMDataLayerEaiRepository] BmdRegistryNacosToEsp={}", (Object)_CLASSTAG, (Object)isBmdRegistryNacosToEsp);
        if (isBmdRegistryNacosToEsp) {
            String nacosTech = RegisterServiceTechTypeEnum.NACOS.getTechType();
            List nacosEaiHeaders = targetTechEai.getOrDefault(nacosTech, new ArrayList());
            if (CollectionUtils.isNotEmpty((Collection)nacosEaiHeaders)) {
                try {
                    newEspEaiHeaders.addAll(nacosEaiHeaders);
                    log.info("{} *** BMD *** nacos updated espEaiHeaders, size:{} when BmdRegistryNacosToEsp={})", new Object[]{_CLASSTAG, nacosEaiHeaders.size(), isBmdRegistryNacosToEsp});
                }
                catch (Exception e) {
                    String errorRootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
                    log.error("{} *** BMD *** nacos updated espEaiHeaders failed:{}  when BmdRegistryNacosToEsp={}", new Object[]{_CLASSTAG, errorRootCauseMessage, isBmdRegistryNacosToEsp});
                }
            } else {
                log.debug("{} *** BMD *** ignored nacos espEaiHeaders, size:{} when BmdRegistryNacosToEsp={})", new Object[]{_CLASSTAG, nacosEaiHeaders.size(), isBmdRegistryNacosToEsp});
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)newEspEaiHeaders)) {
            try {
                eaiHeaderUtil.addAndUpdateCommonsHeaders(newEspEaiHeaders);
                log.info("{} *** BMD *** {} updated eai header, size:{}", new Object[]{_CLASSTAG, espTech, newEspEaiHeaders.size()});
            }
            catch (Exception e) {
                String errorRootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
                log.error("{} *** BMD *** {} updated eai header failed, cause:{}", new Object[]{_CLASSTAG, espTech, errorRootCauseMessage});
            }
        }
        log.info("{} bean: {} created!", (Object)_CLASSTAG, (Object)"modeldriven-customize-bmd-updateEaiRepo");
        return newEspEaiHeaders;
    }

    @Bean
    @DependsOn(value={"modeldriven-customize-bmd-updateEaiRepo"})
    @Conditional(value={ModelDrivenEnabledLoadBalanceCondition.class})
    @ConditionalOnProperty(name={"lcdp.bm.role"}, havingValue="bmd")
    public BMAbstractRegistryApplicationListener buildBMNacosRegistionApplicationListener() {
        return new BMDataLayerRegistryApplicationListener();
    }

    @Bean(name={"modeldriven-customize-bmd-nacos-addRepo"})
    @Conditional(value={ModelDrivenDisabledLoadBalanceCondition.class})
    @DependsOn(value={"modeldriven-customize-genEaiHeaders"})
    public Object updateBMDataNacosEaiServiceToRepoOnly(@Qualifier(value="modeldriven-tech-eaiheader") TechEaiData targetTechEaiData, EaiHeaderUtil eaiHeaderUtil) {
        String nacosTech;
        Map targetTechEai = targetTechEaiData.getTechHeaders();
        List nacosEaiHeaders = targetTechEai.getOrDefault(nacosTech = RegisterServiceTechTypeEnum.NACOS.getTechType(), new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)nacosEaiHeaders)) {
            try {
                eaiHeaderUtil.addAndUpdateCommonsHeaders(nacosEaiHeaders);
                log.info("{} *** BMD *** {} disabled, updated eaiHeader repo, size:{}", new Object[]{_CLASSTAG, nacosTech, nacosEaiHeaders.size()});
            }
            catch (Exception e) {
                String errorRootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
                log.error("{} *** BMD *** {} disabled, update eaiHeader repo failed:{}", new Object[]{_CLASSTAG, nacosTech, errorRootCauseMessage});
            }
        }
        log.warn("{} bean: modeldriven-customize-bmd-nacos-addRepo created!", (Object)_CLASSTAG);
        return nacosEaiHeaders;
    }

    @Bean(name={"dw-modeldriven-crud-digiservicename-advisor"})
    public Advisor dwModelDrivenCRUDEaiIdAdvisor(BMCRUDDigiServiceNameInterceptor dwDigiServiceNameInterceptor) {
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        String crudService = "execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.getList(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.get(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.put(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.putValid(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.putInvalid(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.delete(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.post(..)) ";
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(crudService);
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)dwDigiServiceNameInterceptor);
        log.info("{} bean:eai dw-modeldriven-crud-digiservicename-advisor created!", (Object)_CLASSTAG);
        return advisor;
    }
}

