/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.utils;

import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.pojo.BindApi;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BMDataEaiServiceNameUtil {
    private static final Logger logger = LoggerFactory.getLogger(BMDataEaiServiceNameUtil.class);
    private static final String _CLASSTAG = "[" + BMDataEaiServiceNameUtil.class.getSimpleName() + "]";

    @Deprecated
    public static String getEaiIdOfServiceMapping(String tableName, String prod) {
        String prefixOnlyProd = EaiServiceNameUtil.convertEaiIdTypeForServiceMapping(prod);
        String prefixEaiId = EaiServiceNameUtil.getEaiPrefixName(prefixOnlyProd, tableName);
        return prefixEaiId;
    }

    public static String getEaiIdPrefixOfServiceMapping(String targetProd) {
        String bmdEaiIdPrefix = BMDataEaiServiceNameUtil.getProdForServiceName(targetProd);
        return bmdEaiIdPrefix;
    }

    public static String getBMDataServiceName(String bmEaiId, String targetProd) {
        String[] bmEaiIdArr = bmEaiId.split("\\.");
        String bmEaiIdSuffix = String.join((CharSequence)".", Arrays.copyOfRange(bmEaiIdArr, 2, bmEaiIdArr.length));
        String[] split = targetProd.toLowerCase().replaceAll("\\-", "\\.").split("\\.");
        CharSequence[] prods = Arrays.copyOf(split, split.length - 1);
        String bmdServiceName = String.join((CharSequence)".", Stream.of(String.join((CharSequence)".", prods), bmEaiIdSuffix).collect(Collectors.toList()));
        return bmdServiceName;
    }

    public static String replaceProdWithTargetProd(String bmEaiId, BMCode bmCode) {
        String targetProd = bmCode.getTargetProd();
        String modelCode = bmCode.getCode();
        String replace = BMDataEaiServiceNameUtil.replaceProdWithTargetProd(bmEaiId, modelCode, targetProd);
        return replace;
    }

    public static String getTableNameByListGet(String serviceName, String modelDrivenProdPrefix) {
        String targetTableName = "";
        if (StringUtils.endsWith((CharSequence)serviceName, (CharSequence)".get")) {
            if (StringUtils.endsWith((CharSequence)serviceName, (CharSequence)".std.list.get")) {
                targetTableName = ModelDataUtil.replaceLast(serviceName.replaceFirst(modelDrivenProdPrefix, ""), ".std.list.get", "").replaceAll("\\.", "_");
            } else if (StringUtils.endsWith((CharSequence)serviceName, (CharSequence)".std.get")) {
                targetTableName = ModelDataUtil.replaceLast(serviceName.replaceFirst(modelDrivenProdPrefix, ""), ".std.get", "").replaceAll("\\.", "_");
            }
        }
        return targetTableName;
    }

    public static String generateBMDEaiId(String bmEaiId, BMCode bmCode) {
        String replace = BMDataEaiServiceNameUtil.replaceProdWithTargetProd(bmEaiId, bmCode);
        replace = BMDataEaiServiceNameUtil.replacePostfixOfServiceName(replace, bmEaiId, bmCode);
        return replace;
    }

    public static String getBMDEaiId(String bmEaiId, BMCode bmCode) {
        String bmdApiName = bmCode.getBmdApi();
        return bmdApiName;
    }

    public static String replaceProdWithTargetProd(String bmEaiId, String modelCode, String targetProd) {
        String bmdProdPart = BMDataEaiServiceNameUtil.getEaiIdPrefixOfServiceMapping(targetProd);
        String bmdModelCodePart = modelCode.toLowerCase().replace("_", ".");
        String[] bmEaiIdArr = bmEaiId.split(bmdModelCodePart);
        String bmdServiceApiTypePart = bmEaiIdArr[bmEaiIdArr.length - 1];
        String bmdServiceName = String.join((CharSequence)".", bmdProdPart, bmdModelCodePart) + bmdServiceApiTypePart;
        return bmdServiceName;
    }

    @Deprecated
    public static String generateBMDEaiId(String bmEaiId, String targetProd) {
        String replace = BMDataEaiServiceNameUtil.getBMDataServiceName(bmEaiId, targetProd);
        replace = BMDataEaiServiceNameUtil.replacePostfixOfServiceName(replace);
        return replace;
    }

    public static String replacePostfixOfServiceName(String bmdServiceName) {
        List getMatch = Stream.of(".detail.get", ".list.get", ".valid", ".invalid").collect(Collectors.toList());
        int index = -1;
        String matchStr = "";
        for (int i = 0; i < getMatch.size(); ++i) {
            int lastIndex = bmdServiceName.lastIndexOf((String)getMatch.get(i));
            if (lastIndex == -1) continue;
            index = lastIndex;
            matchStr = (String)getMatch.get(i);
            break;
        }
        if (index != -1) {
            return bmdServiceName.substring(0, index) + (matchStr.endsWith("get") ? ".get" : ".update");
        }
        return bmdServiceName;
    }

    @Deprecated
    public static String getBMDataEaiIdV2(String bmEaiId, String targetProd, Map digiServiceMap) {
        String methodName;
        Object bmdServiceName = "";
        String[] serviceNameToken = bmEaiId.split("\\.");
        String serviceType = serviceNameToken[serviceNameToken.length - 1];
        String prod = (String)digiServiceMap.get("prod");
        String digiServiceName = bmEaiId;
        String[] split = bmEaiId.split("\\.");
        boolean hasStdToken = StringUtils.equals((CharSequence)"std", (CharSequence)split[split.length - 2]);
        switch (methodName = serviceNameToken[serviceNameToken.length - 1]) {
            case "getList": {
                String getListName = targetProd + String.join((CharSequence)".", Arrays.copyOfRange(split, 2, split.length - 1)) + ".list.get";
                bmdServiceName = getListName;
                break;
            }
            case "get": {
                String getName = targetProd + String.join((CharSequence)".", Arrays.copyOfRange(split, 2, split.length - 1)) + ".detail.get";
                bmdServiceName = getName;
                break;
            }
            case "putValid": 
            case "putInvalid": {
                String putValidInvalidName = hasStdToken ? targetProd + String.join((CharSequence)".", (CharSequence[])ArrayUtils.add((Object[])Arrays.copyOfRange(split, 2, split.length - 2), (Object)serviceType)) : targetProd + String.join((CharSequence)".", (CharSequence[])ArrayUtils.add((Object[])Arrays.copyOfRange(split, 2, split.length - 1), (Object)serviceType));
                bmdServiceName = putValidInvalidName;
                break;
            }
            case "put": {
                String putName = targetProd + String.join((CharSequence)".", Arrays.copyOfRange(split, 2, split.length - 1)) + ".update";
                bmdServiceName = putName;
                break;
            }
            case "post": {
                String postName = targetProd + String.join((CharSequence)".", Arrays.copyOfRange(split, 2, split.length - 1)) + ".create";
                bmdServiceName = postName;
                break;
            }
            case "delete": {
                String deleteName = targetProd + String.join((CharSequence)".", Arrays.copyOfRange(split, 2, split.length - 1)) + ".delete";
                bmdServiceName = deleteName;
                break;
            }
        }
        logger.debug("{} origin eaiId({}) change to new eaiId({})", new Object[]{_CLASSTAG, digiServiceName, bmdServiceName});
        return bmdServiceName;
    }

    public static String getProdForServiceName(String espProdName) {
        String[] split = EaiServiceNameUtil.convertEaiIdTypeForServiceMapping(espProdName).split("\\.");
        if (split.length >= 2) {
            CharSequence[] prods = Arrays.copyOf(split, split.length - 1);
            return String.join((CharSequence)".", prods);
        }
        return split[0];
    }

    public static String getServiceType(String serviceName) {
        String[] serviceNameToken = serviceName.split("\\.");
        return serviceNameToken[serviceNameToken.length - 1];
    }

    public static String getServiceType(String serviceName, List<BindApi> bmdApiListConfig) {
        String[] serviceNameToken = serviceName.split("\\.");
        return serviceNameToken[serviceNameToken.length - 1];
    }

    public static String replacePostfixOfServiceName(String bmdServiceName, String bmEaiId, BMCode bmCode) {
        String modelCode = bmCode.getCode();
        String modelCodeServicePart = modelCode.toLowerCase().replace("_", ".");
        String[] bmEaiIdArraySplitByModelCode = bmEaiId.split(modelCodeServicePart);
        if (bmEaiIdArraySplitByModelCode[bmEaiIdArraySplitByModelCode.length - 1].startsWith(".std.")) {
            return BMDataEaiServiceNameUtil.replacePostfixOfServiceName((String)bmdServiceName);
        }
        if (bmEaiIdArraySplitByModelCode[0].endsWith(".lc.")) {
            String postfix = "";
            if (bmEaiId.endsWith(".get")) {
                postfix = ".get";
            } else if (bmEaiId.endsWith(".create")) {
                postfix = ".create";
            } else if (bmEaiId.endsWith(".update")) {
                postfix = ".update";
            } else if (bmEaiId.endsWith(".delete")) {
                postfix = ".delete";
            } else if (bmEaiId.endsWith(".valid")) {
                postfix = ".valid";
            } else if (bmEaiId.endsWith(".invalid")) {
                postfix = ".invalid";
            }
            String[] bmdEaiIdArr = ((String)bmdServiceName).split(modelCodeServicePart);
            bmdServiceName = bmdEaiIdArr[0] + modelCodeServicePart + ".std" + postfix;
        }
        return bmdServiceName;
    }

    public static String getValidTypeTableName(String servicePrefixWithEndPoint, String nameOfDigiService, String prodOfDigiService, String validType) {
        String targetTableName = "";
        if (nameOfDigiService.startsWith(servicePrefixWithEndPoint)) {
            targetTableName = ModelDataUtil.replaceLast(nameOfDigiService.replaceFirst(servicePrefixWithEndPoint, ""), validType, "").replaceAll("\\.", "_");
        } else {
            String prodPrefix = BMDataEaiServiceNameUtil.getEaiIdPrefixOfServiceMapping(prodOfDigiService) + ".";
            targetTableName = ModelDataUtil.replaceLast(nameOfDigiService.replaceFirst(prodPrefix, ""), validType, "").replaceAll("\\.", "_");
        }
        return targetTableName;
    }
}

