/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.dataview.impl;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWOnColumn;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWPaginationQueryResult;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryJoinRelation;
import com.digiwin.app.dao.DWQueryJoinTable;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.DWSubQueryInfo;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.ddl.util.MetadataSqlGenerator;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.data.permission.DWRowPermissionDefaultMatchOption;
import com.digiwin.data.permission.DWRowPermissionElement;
import com.digiwin.data.permission.DWRowPermissionEmpty;
import com.digiwin.data.permission.DWRowPermissionMatchOption;
import com.digiwin.data.permission.DWUserPermission;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoOrderConditionDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoParameterDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoReturnFieldDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoReturnFieldsDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoSecondlyQueryConditionDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoSecondlySortConditionDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoTableDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewParameterDTO;
import com.digiwin.lcdp.modeldriven.dataview.utils.DataViewFieldUtil;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSwitchCfg;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.permission.ModelDrivenDataPermission;
import com.digiwin.lcdp.modeldriven.pojo.QueryConditionDTO;
import com.digiwin.lcdp.modeldriven.utils.DataEntryDataUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiResultUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.QueryConditionUtils;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class ModelDrivenDataViewService {
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenDataViewService.class);
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    @Autowired
    QueryConditionUtils queryConditionUtils;

    public Object dataviewGet(DataViewParameterDTO viewParams) throws Exception {
        String actionId;
        String moduleId;
        DWUserPermission dataPermData;
        DWQueryInfo queryInfo;
        DataViewInfoParameterDTO dataViewInfoParameterDTO = viewParams.getView_info();
        Assert.notNull((Object)dataViewInfoParameterDTO, (String)"dataViewInfoParameterDTO must not be null");
        String dataViewCode = dataViewInfoParameterDTO.getCode();
        if (CollectionUtils.isEmpty(dataViewInfoParameterDTO.getTables()) && dataViewCode != null) {
            DWDataSetOperationOption option = new DWDataSetOperationOption();
            option.setTenantEnabled(false);
            option.setManagementFieldEnabled(false);
            DWQueryInfo queryInfo2 = new DWQueryInfo("dw_lcdp_data_view");
            queryInfo2.addEqualInfo("code", (Object)dataViewCode);
            DWDataRow dataRow = this.dao.selectOne(queryInfo2, option);
            DataViewInfoParameterDTO dataViewInfo = null;
            if (dataRow == null || dataRow.getData() == null) {
                throw new RuntimeException(String.format(ResourceBundleUtils.getString("lcdp.modeldriven.dataview.notExist"), dataViewCode));
            }
            dataViewInfo = (DataViewInfoParameterDTO)DWGsonProvider.getGson().fromJson(dataRow.getData().get("dataView").toString(), DataViewInfoParameterDTO.class);
            if (dataViewInfo != null) {
                viewParams.setView_info(dataViewInfo);
            } else {
                throw new RuntimeException(String.format(ResourceBundleUtils.getString("lcdp.modeldriven.dataview.info.notExist"), dataViewCode));
            }
        }
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        DWSubQueryInfo dwSubQueryInfo = new DWSubQueryInfo("", "dataviewAlias");
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        DataViewInfoParameterDTO viewInfo = viewParams.getView_info();
        List<DataViewInfoSecondlyQueryConditionDTO> secondlyQueryParams = viewParams.getSearch_info();
        List<DataViewInfoSecondlySortConditionDTO> secondlySortParams = viewParams.getSort_info();
        Boolean useHasNext = viewParams.getUse_has_next() == null ? false : viewParams.getUse_has_next();
        DataViewInfoTableDTO mainTable = viewParams.getView_info().getTables().stream().filter(table -> table.getMain()).findFirst().orElseThrow(() -> new RuntimeException("main table of module is missing"));
        ModelDTO model = this.getModel(mainTable.getTable());
        Assert.notNull((Object)model, (String)String.format(ResourceBundleUtils.getString("lcdp.modeldriven.model.notExist"), mainTable.getTable()));
        ModelSchemaDTO modelSchema = model.getSchema();
        List<Map> customizedConditionValues = viewParams.getQueryConditionValues();
        if (useHasNext.booleanValue()) {
            int pageSize = viewParams.getPage_size();
            int pageNumber = viewParams.getPage_no();
            queryInfo = new DWPagableQueryInfo();
            ((DWPagableQueryInfo)queryInfo).setPageSize(pageSize);
            ((DWPagableQueryInfo)queryInfo).setPageNumber(pageNumber);
        } else {
            queryInfo = new DWQueryInfo();
        }
        if (!ObjectUtils.isEmpty((Object)viewInfo) && CollectionUtils.isNotEmpty(viewInfo.getTables())) {
            viewInfo.getTables().forEach(table -> this.dealDataViewTables((DWQueryInfo)dwSubQueryInfo, (DataViewInfoTableDTO)table));
        }
        if (!ObjectUtils.isEmpty((Object)viewInfo.getReturnFields())) {
            this.dealDataViewReturnFields((DWQueryInfo)dwSubQueryInfo, viewInfo.getReturnFields());
        }
        if (CollectionUtils.isNotEmpty(viewInfo.getQueryConditions())) {
            this.dealDataViewSearchInfo((DWQueryInfo)dwSubQueryInfo, viewInfo.getQueryConditions(), customizedConditionValues);
        }
        if (CollectionUtils.isNotEmpty(secondlyQueryParams)) {
            this.dealDataViewSecondSearchInfo((DWQueryInfo)dwSubQueryInfo, secondlyQueryParams, viewInfo, customizedConditionValues);
        }
        if (CollectionUtils.isNotEmpty(viewInfo.getOrderList())) {
            this.dealDataViewOrderInfo((DWQueryInfo)dwSubQueryInfo, viewInfo.getOrderList());
        }
        if (CollectionUtils.isNotEmpty(secondlySortParams)) {
            this.dealDataViewSecondlySortInfo((DWQueryInfo)dwSubQueryInfo, secondlySortParams, viewInfo);
        }
        if (!ObjectUtils.isEmpty((Object)modelSchema) && !"returnSql".equals(viewInfo.getExecuteType()) && this.enablePermission(modelSchema) && (dataPermData = (DWUserPermission)ModelDrivenDataPermission.getDataPermission(moduleId = "basicDataEntry", actionId = Optional.ofNullable(viewParams.getActivityId()).orElseThrow(() -> new RuntimeException("actionId of view_info can not be null")), model.getAppId())) != null) {
            DWUserPermission userPermission = dataPermData;
            Field rowPermissionField = DWUserPermission.class.getDeclaredField("rowPermission");
            rowPermissionField.setAccessible(true);
            DWRowPermissionElement rowPermission = (DWRowPermissionElement)rowPermissionField.get(userPermission);
            if (!userPermission.isSuperadmin() && (rowPermission instanceof DWRowPermissionEmpty || rowPermission == null)) {
                returnValue.put(viewParams.getView_info().getCode(), new ArrayList());
                return returnValue;
            }
            log.debug(String.format("[dataview permission] %s permission : {}", viewParams.getView_info().getCode()), rowPermissionField.get(userPermission));
            DWRowPermissionDefaultMatchOption rowPermissionOption = new DWRowPermissionDefaultMatchOption();
            DWQueryCondition queryCondition = dataPermData.getRowPermission().getQueryCondition((DWRowPermissionMatchOption)rowPermissionOption);
            dwSubQueryInfo.setCondition(queryCondition);
        }
        queryInfo.from(dwSubQueryInfo);
        queryInfo.setTableName(dwSubQueryInfo.getTableName());
        if ("returnSql".equals(viewInfo.getExecuteType()) || "preview".equals(viewInfo.getActionType())) {
            PlainSelect selectBody;
            Statement selectSql;
            String sql = null;
            DWSqlInfo sqlInfo = this.dao.getDialect().parse(option, queryInfo, sql);
            sql = sqlInfo.getSql();
            if (StringUtils.isNotEmpty((CharSequence)sql) && (selectSql = CCJSqlParserUtil.parse((String)sql, null)) instanceof Select && (selectBody = (PlainSelect)((Select)selectSql).getSelectBody()).getFromItem() != null) {
                sql = ((SubSelect)selectBody.getFromItem()).getSelectBody().toString();
            }
            if (sql != null) {
                SqlParam sqlparam = new SqlParam();
                sqlparam.setSql(sql);
                sqlparam.setParams(sqlInfo.getParameters());
                sql = ModelSqlGenerator.getCombinedSql(sqlparam);
            }
            returnValue.put("returnSql", sql);
            ModelDrivenContext.getContext().getExtraMap().put("querySQL", sql);
            if ("returnSql".equals(viewInfo.getExecuteType())) {
                return returnValue;
            }
        }
        if (useHasNext.booleanValue()) {
            DWPaginationQueryResult queryResult = this.dao.selectWithPage((DWPagableQueryInfo)queryInfo, option);
            DWDataSet dataset = queryResult.getDataSet();
            long totalRowCount = queryResult.getRowCount();
            long totalPageCount = queryResult.getPageCount();
            returnValue.put("total_results", totalRowCount);
            returnValue.put("has_next", (long)((DWPagableQueryInfo)queryInfo).getPageNumber() < totalPageCount);
            List<Map<String, Object>> datas = DataEntryDataUtil.convertFromJson(dataset.getTable(dwSubQueryInfo.getTableName()));
            returnValue.put(viewParams.getView_info().getCode(), datas);
        } else {
            DWDataSet dataset = this.dao.select(queryInfo, option);
            List<Map<String, Object>> datas = DataEntryDataUtil.convertFromJson(dataset.getTable(dwSubQueryInfo.getTableName()));
            returnValue.put(viewParams.getView_info().getCode(), datas);
        }
        return returnValue;
    }

    @Deprecated
    public Object dataviewGetByCode(DataViewParameterDTO dataViewParamData) throws Exception {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        DataViewInfoParameterDTO viewInfo = dataViewParamData.getView_info();
        String code = viewInfo.getCode();
        DWQueryInfo queryinfo = new DWQueryInfo("dw_lcdp_data_view");
        queryinfo.addEqualInfo("code", (Object)code);
        option.setManagementFieldEnabled(false);
        option.setTenantEnabled(false);
        List viewInfos = this.dao.select(DataViewInfoParameterDTO.class, queryinfo, option);
        if (CollectionUtils.isNotEmpty((Collection)viewInfos)) {
            dataViewParamData.setView_info((DataViewInfoParameterDTO)viewInfos.get(0));
            return this.dataviewGet(dataViewParamData);
        }
        throw new RuntimeException(String.format("can not find dataview by code '%s'", code));
    }

    private void dealDataViewTables(DWQueryInfo queryInfo, DataViewInfoTableDTO table) {
        if (!ObjectUtils.isEmpty((Object)table)) {
            if (table.getMain().booleanValue()) {
                queryInfo.setTableName(table.getTable());
                String tablePath = Optional.ofNullable(table.getPath()).orElseThrow(() -> new RuntimeException("'path' of table '%s' can not be null"));
                String tableName = Optional.ofNullable(table.getTable()).orElseThrow(() -> new RuntimeException("'table' of table '%s' can not be null"));
                try {
                    List<String> primaryKeys = this.getPrimaryKeys(this.dao, table.getTable());
                    if (CollectionUtils.isNotEmpty(primaryKeys)) {
                        ArrayList conditions = new ArrayList();
                        primaryKeys.forEach(primaryKey -> {
                            DWOnColumn onColumn = new DWOnColumn(tableName + "." + primaryKey, DWQueryValueOperator.Equals, tablePath + "." + primaryKey);
                            conditions.add(onColumn);
                        });
                        queryInfo.setJoinOnColumn(DWQueryJoinRelation.InnerJoin, new DWQueryJoinTable(tableName, tablePath), conditions.toArray(new DWOnColumn[conditions.size()]));
                    }
                }
                catch (Exception e) {
                    log.error("get primary key of table '%s' error", (Throwable)e);
                }
                if (CollectionUtils.isNotEmpty(table.getJoin())) {
                    table.getJoin().forEach(joinTable -> {
                        ArrayList conditions = new ArrayList();
                        if (CollectionUtils.isNotEmpty(joinTable.getAssociatedFields())) {
                            joinTable.getAssociatedFields().forEach(associatedFields -> {
                                DWOnColumn onColumn = new DWOnColumn(associatedFields.getRight(), DWQueryValueOperator.Equals, associatedFields.getLeft());
                                conditions.add(onColumn);
                            });
                            queryInfo.setJoinOnColumn(DWQueryJoinRelation.LeftJoin, new DWQueryJoinTable(joinTable.getTable(), joinTable.getPath()), conditions.toArray(new DWOnColumn[conditions.size()]));
                        }
                        if (CollectionUtils.isNotEmpty(joinTable.getJoin())) {
                            this.dealDataViewTables(queryInfo, (DataViewInfoTableDTO)joinTable);
                        }
                    });
                }
            } else if (CollectionUtils.isNotEmpty(table.getJoin())) {
                table.getJoin().forEach(joinTable -> {
                    ArrayList conditions = new ArrayList();
                    if (CollectionUtils.isNotEmpty(joinTable.getAssociatedFields())) {
                        joinTable.getAssociatedFields().forEach(associatedFields -> {
                            DWOnColumn onColumn = new DWOnColumn(associatedFields.getRight(), DWQueryValueOperator.Equals, associatedFields.getLeft());
                            conditions.add(onColumn);
                        });
                        queryInfo.setJoinOnColumn(DWQueryJoinRelation.LeftJoin, new DWQueryJoinTable(joinTable.getTable(), joinTable.getPath()), conditions.toArray(new DWOnColumn[conditions.size()]));
                    }
                    if (CollectionUtils.isNotEmpty(joinTable.getJoin())) {
                        this.dealDataViewTables(queryInfo, (DataViewInfoTableDTO)joinTable);
                    }
                });
            }
        }
    }

    private void dealDataViewReturnFields(DWQueryInfo queryInfo, DataViewInfoReturnFieldsDTO returnFields) {
        if (!ObjectUtils.isEmpty((Object)returnFields)) {
            String mainTableName = returnFields.getTable();
            List<DataViewInfoReturnFieldDTO> fields = returnFields.getFields();
            if (CollectionUtils.isNotEmpty(fields)) {
                List simpleFields = fields.stream().filter(field -> "SIMPLE".equals(Optional.ofNullable(field.getType()).orElseThrow(() -> new RuntimeException(String.format("the type of field '%s' can not be null", field.getFieldId()))))).collect(Collectors.toList());
                List quoteQueryFields = fields.stream().filter(field -> "QUOTE_QUERY".equals(Optional.ofNullable(field.getType()).orElseThrow(() -> new RuntimeException(String.format("the type of field '%s' can not be null", field.getFieldId()))))).collect(Collectors.toList());
                List collectionFields = fields.stream().filter(field -> "COLLECTION".equals(Optional.ofNullable(field.getType()).orElseThrow(() -> new RuntimeException(String.format("the type of field '%s' can not be null", field.getFieldId()))))).collect(Collectors.toList());
                List operateFields = fields.stream().filter(field -> "OPERATE".equals(Optional.ofNullable(field.getType()).orElseThrow(() -> new RuntimeException(String.format("the type of field '%s' can not be null", field.getFieldId()))))).collect(Collectors.toList());
                simpleFields.stream().forEach(field -> queryInfo.addSelectField(new String[]{field.getShortPath() + " as `" + field.getFullPath() + "`"}));
                quoteQueryFields.stream().forEach(field -> {
                    List<DataViewInfoReturnFieldDTO> quoteFields = field.getFields();
                    if (CollectionUtils.isNotEmpty(quoteFields)) {
                        quoteFields.forEach(quoteField -> queryInfo.addSelectField(new String[]{quoteField.getShortPath() + " as `" + quoteField.getFullPath() + "`"}));
                    }
                });
                collectionFields.stream().forEach(field -> {
                    List<DataViewInfoReturnFieldDTO> quoteFields = field.getFields();
                    if (CollectionUtils.isNotEmpty(quoteFields)) {
                        quoteFields.forEach(quoteField -> queryInfo.addSelectField(new String[]{quoteField.getShortPath() + " as `" + quoteField.getFullPath() + "`"}));
                    }
                });
                operateFields.stream().forEach(operatefield -> queryInfo.addSelectField(new String[]{operatefield.getExpression() + " as `" + operatefield.getFieldId() + "`"}));
            }
        }
    }

    private void dealDataViewSearchInfo(DWQueryInfo queryInfo, List<QueryConditionDTO> searchInfos, List<Map> customizedConditionValues) {
        if (CollectionUtils.isNotEmpty(searchInfos)) {
            Collections.sort(searchInfos, Comparator.comparingDouble(item -> Double.parseDouble(item.getOrder().toString())));
            DWQueryCondition condition = new DWQueryCondition();
            this.queryConditionUtils.generateCondition(searchInfos.iterator(), condition, customizedConditionValues);
            queryInfo.setCondition(condition);
        }
    }

    private void dealDataViewSecondSearchInfo(DWQueryInfo queryInfo, List<DataViewInfoSecondlyQueryConditionDTO> mainQueryInfoParams, DataViewInfoParameterDTO viewInfo, List<Map> customizedConditionValues) {
        if (CollectionUtils.isNotEmpty(mainQueryInfoParams)) {
            for (DataViewInfoSecondlyQueryConditionDTO mainQueryInfoParam : mainQueryInfoParams) {
                String searchField = mainQueryInfoParam.getSearch_field();
                String[] s = searchField.split("__");
                Map<String, String> tableAliasMap = null;
                tableAliasMap = s.length == 1 ? this.getTableAlias(viewInfo.getTables(), "", true) : this.getTableAlias(viewInfo.getTables(), s[s.length - 2], false);
                if (!MapUtils.isNotEmpty(tableAliasMap)) continue;
                Map.Entry<String, String> entry = tableAliasMap.entrySet().iterator().next();
                String tableName = entry.getKey();
                String tableAlias = entry.getValue();
                mainQueryInfoParam.setSearch_field(tableAlias + "." + s[s.length - 1]);
                mainQueryInfoParam.setTable_name(tableName);
            }
            Collections.sort(mainQueryInfoParams, Comparator.comparingDouble(item -> Double.parseDouble(item.getOrder().toString())));
            DWQueryCondition condition = new DWQueryCondition();
            this.queryConditionUtils.generateCondition(mainQueryInfoParams.iterator(), condition, customizedConditionValues);
            queryInfo.getCondition().addCondition(condition);
        }
    }

    private void dealDataViewOrderInfo(DWQueryInfo queryInfo, List<DataViewInfoOrderConditionDTO> orderInfos) {
        if (CollectionUtils.isNotEmpty(orderInfos)) {
            Collections.sort(orderInfos, Comparator.comparingDouble(item -> Double.parseDouble(item.getOrder())));
            orderInfos.forEach(orderInfo -> {
                String orderField = DataViewFieldUtil.getOrderField(orderInfo);
                switch (orderInfo.getOrderType()) {
                    case "asc": {
                        queryInfo.addOrderBy(orderField, true);
                        break;
                    }
                    case "desc": {
                        queryInfo.addOrderBy(orderField, false);
                        break;
                    }
                }
            });
        }
    }

    private void dealDataViewSecondlySortInfo(DWQueryInfo queryInfo, List<DataViewInfoSecondlySortConditionDTO> orderInfos, DataViewInfoParameterDTO viewInfo) {
        if (CollectionUtils.isNotEmpty(orderInfos)) {
            for (DataViewInfoSecondlySortConditionDTO mainSortInfoParam : orderInfos) {
                String sortField = mainSortInfoParam.getSort_field();
                String[] s = sortField.split("__");
                Map<String, String> tableAliasMap = null;
                tableAliasMap = s.length == 1 ? this.getTableAlias(viewInfo.getTables(), "", true) : this.getTableAlias(viewInfo.getTables(), s[s.length - 2], false);
                if (!MapUtils.isNotEmpty(tableAliasMap)) continue;
                String tableAlias = tableAliasMap.values().iterator().next();
                mainSortInfoParam.setSort_field(tableAlias + "." + s[s.length - 1]);
            }
            orderInfos.forEach(orderInfo -> {
                String orderField = StringUtils.isNotEmpty((CharSequence)orderInfo.getTable_path()) ? orderInfo.getTable_path() + "." + orderInfo.getSort_field() : orderInfo.getSort_field();
                switch (orderInfo.getSort_type()) {
                    case "asc": {
                        queryInfo.addOrderBy(orderField, true);
                        break;
                    }
                    case "desc": {
                        queryInfo.addOrderBy(orderField, false);
                        break;
                    }
                }
            });
        }
    }

    private Map<String, String> getTableAlias(List<DataViewInfoTableDTO> tables, String tableName, boolean isMain) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (isMain) {
            DataViewInfoTableDTO mainTable = tables.stream().filter(table -> table.getMain()).findFirst().orElseThrow(() -> new RuntimeException("there is no main table exists"));
            result.put(mainTable.getTable(), mainTable.getPath());
            return result;
        }
        for (DataViewInfoTableDTO table2 : tables) {
            if (table2.getTable().equals(tableName)) {
                result.put(tableName, table2.getPath());
                return result;
            }
            if (!CollectionUtils.isNotEmpty(table2.getJoin())) continue;
            return this.getTableAlias(table2.getJoin(), tableName, false);
        }
        throw new RuntimeException("there is no table alias for " + tableName);
    }

    List<String> getPrimaryKeys(DWDao dao, String tableName) throws Exception {
        String sql = MetadataSqlGenerator.getPrimaryKey((String)tableName);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        ArrayList<String> pks = new ArrayList<String>();
        List result = dao.select((IDWSQLOptions)option, sql, new Object[0]);
        for (Map map : result) {
            Object pk = map.get("pk");
            if (!Objects.nonNull(pk)) continue;
            pks.add(Objects.toString(pk));
        }
        return pks;
    }

    public ModelDTO getModel(String mainTableName) {
        if (StringUtils.isNotEmpty((CharSequence)mainTableName)) {
            String modelCode = mainTableName;
            DWQueryInfo queryInfo = new DWQueryInfo("dw_lcdp_model");
            queryInfo.addEqualInfo("code", (Object)modelCode);
            DWDataSetOperationOption option = new DWDataSetOperationOption();
            option.setTenantEnabled(false);
            option.setManagementFieldEnabled(false);
            DWDataSet modelTables = this.dao.select(queryInfo, option);
            DWDataTable table = modelTables.getTable("dw_lcdp_model");
            if (table.getRows().size() <= 0) {
                return null;
            }
            DWDataRow row = table.getRow(0);
            return ModelSchemaUtil.getModel(row);
        }
        throw new RuntimeException(String.format("tableName '%s' is missing", mainTableName));
    }

    private boolean enablePermission(ModelSchemaDTO model) {
        return "Y".equals(Optional.ofNullable(model.getSwitchCfg()).orElse(new ModelSwitchCfg()).getDataPermission());
    }

    public DWEAIResult updateViewInfos(DataViewDTO dataView) {
        if ("single".equals(dataView.getPublishFlag())) {
            if (CollectionUtils.isNotEmpty(dataView.getViewInfos())) {
                Map<String, Object> viewInfo2 = dataView.getViewInfos().get(0);
                DWDataSetOperationOption option = new DWDataSetOperationOption();
                option.setTenantEnabled(false);
                option.setManagementFieldEnabled(false);
                String deleteSql = "delete from dw_lcdp_data_view where code = ?";
                this.dao.update((IDWSQLOptions)option, deleteSql, new Object[]{viewInfo2.get("code")});
                DWDataSet dataset = new DWDataSet();
                DWDataTable dataTable = dataset.newTable("dw_lcdp_data_view");
                dataView.getViewInfos().forEach(viewInfoMap -> {
                    viewInfoMap.put("dataView", DWGsonProvider.getGson().toJson(viewInfoMap.get("dataView")));
                    ModelDataUtil.dealInsertMgmtFields(viewInfo2);
                    dataTable.newRow(viewInfoMap).setState("C");
                });
                this.dao.execute(dataset, option);
                return EaiResultUtil.getDWEAIResult(null);
            }
        } else if ("batch".equals(dataView.getPublishFlag()) && CollectionUtils.isNotEmpty(dataView.getViewInfos())) {
            DWDataSetOperationOption option = new DWDataSetOperationOption();
            option.setTenantEnabled(false);
            option.setManagementFieldEnabled(false);
            String deleteSql = "delete from dw_lcdp_data_view where application= ?";
            this.dao.update((IDWSQLOptions)option, deleteSql, new Object[]{dataView.getApplication()});
            DWDataSet dataset = new DWDataSet();
            DWDataTable dataTable = dataset.newTable("dw_lcdp_data_view");
            dataView.getViewInfos().forEach(viewInfo -> {
                viewInfo.put("dataView", DWGsonProvider.getGson().toJson(viewInfo.get("dataView")));
                ModelDataUtil.dealInsertMgmtFields(viewInfo);
                dataTable.newRow(viewInfo).setState("C");
            });
            this.dao.execute(dataset, option);
            return EaiResultUtil.getDWEAIResult(null);
        }
        return EaiResultUtil.getDWEAIFalseResult(null);
    }
}

