/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.gateway.controller.EaiInfoUtils;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.entity.DWJsonEntity;
import com.digiwin.lcdp.modeldriven.config.ModelDrivenProperties;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.event.EaiRegDataInfo;
import com.digiwin.lcdp.modeldriven.event.EaiRegisterEventProperties;
import com.digiwin.lcdp.modeldriven.event.EaiRegisterEventPublisher;
import com.digiwin.lcdp.modeldriven.event.EaiServiceRegisterEvent;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class EaiRegisterUtil {
    private static final Logger log = LoggerFactory.getLogger(EaiRegisterUtil.class);
    private static final String _CLASSTAG = "[" + EaiRegisterUtil.class.getSimpleName() + "]";
    @Autowired
    DWEAIProperties eaiProperties;
    @Autowired(required=false)
    @Qualifier(value="lcdp-eai-reg-event-properties")
    EaiRegisterEventProperties eaiRegisterEventProperties;
    @Autowired(required=false)
    @Qualifier(value="lcdp-eai-reg-event-publisher")
    EaiRegisterEventPublisher eaiRegisterEventPublisher;
    @Autowired
    private DWHttpClient dwHttpClient;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    @Qualifier(value="dw-modeldriven-properties")
    private ModelDrivenProperties modelDrivenProperties;

    public Object autoRegisterEAI(List<DWEAIHeader> newEaiHeaders, String code) throws Exception {
        return this.registerService(newEaiHeaders, code);
    }

    public Object autoRegisterEAI(List<DWEAIHeader> newEaiHeaders) throws Exception {
        return this.registerService(newEaiHeaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object registerService(List<DWEAIHeader> newEaiHeaders, String code) throws Exception {
        HashMap hashMap = new HashMap();
        if (!this.modelDrivenProperties.isEspEnabledRegistration()) {
            log.warn("{}[registerService] 1 ignored reg esp, cause disabled(properties:eaiAutoRegistrationEnable)", (Object)_CLASSTAG);
            return hashMap;
        }
        if (this.eaiRegisterEventPublisher != null && this.eaiRegisterEventProperties != null && this.eaiRegisterEventProperties.isAsync()) {
            log.debug("{}[autoRegisterEAI] using ASync... code({}) eaiRegisterEventPublisher ({}), eaiRegisterEventProperties({})", new Object[]{_CLASSTAG, code, this.eaiRegisterEventPublisher, this.eaiRegisterEventProperties});
            EaiRegDataInfo eaiRegDataInfo = new EaiRegDataInfo();
            eaiRegDataInfo.setEaiHeaders(newEaiHeaders);
            eaiRegDataInfo.setModelCodeName(code);
            eaiRegDataInfo.setEaiProperties(this.eaiProperties);
            EaiServiceRegisterEvent dataEvent = new EaiServiceRegisterEvent(eaiRegDataInfo);
            log.debug("[autoRegisterEAI] starting call eaiRegisterEventPublisher in code({})", (Object)code);
            this.eaiRegisterEventPublisher.publishDataChangeEvent(dataEvent);
            log.debug("[autoRegisterEAI] finished call eaiRegisterEventPublisher in code({})", (Object)code);
            return hashMap;
        }
        log.debug("using Sync... code({}) eaiRegisterEventPublisher({}), eaiRegisterEventProperties({})", new Object[]{code, this.eaiRegisterEventPublisher, this.eaiRegisterEventProperties});
        List newEaiServiceIds = newEaiHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList());
        log.info("EAI Services start auto-registering code({}), newEaiServiceIds({})...", (Object)code, newEaiServiceIds);
        Map map = EaiInfoUtils.getSrvRegInfo(() -> newEaiServiceIds, (DWEAIProperties)this.eaiProperties);
        HttpPost post = new HttpPost(EaiInfoUtils.getEAIRegSrvURL());
        post.setEntity((HttpEntity)new DWJsonEntity((Object)map));
        EntityUtils.toString((HttpEntity)post.getEntity(), (Charset)StandardCharsets.UTF_8);
        post.addHeader("digi-action", "reg");
        CloseableHttpResponse responseReturn = null;
        try {
            block14: {
                try (CloseableHttpResponse response = (CloseableHttpResponse)this.dwHttpClient.execute((HttpUriRequest)post, new DWRequestOption(false));){
                    int statusCode;
                    InputStream responseStream;
                    responseReturn = response;
                    String responseBody = "";
                    HttpEntity httpEntity = response.getEntity();
                    if (httpEntity != null && (responseStream = httpEntity.getContent()) != null) {
                        responseBody = IOUtils.toString((InputStream)responseStream, (Charset)StandardCharsets.UTF_8);
                    }
                    if ((statusCode = response.getStatusLine().getStatusCode()) != 200) {
                        log.error("Something wrong in the process of eai services auto-registration...");
                        log.error(responseBody);
                    } else {
                        log.info("EAI Services have registered automatically.");
                    }
                    if (response == null) break block14;
                }
            }
        }
        catch (Exception e) {
            log.error("eai auto register failed!", (Throwable)e);
        }
        finally {
            log.info("EAI Services finished auto-registering...");
            return responseReturn;
        }
    }

    public Object registerService(List<DWEAIHeader> newEaiHeaders) throws Exception {
        HashMap resultValue = new HashMap();
        if (!this.modelDrivenProperties.isEspEnabledRegistration()) {
            log.warn("{}[registerService] 2 ignored reg esp, cause disabled(properties:eaiAutoRegistrationEnable)", (Object)_CLASSTAG);
            return resultValue;
        }
        log.debug("{}[registerService] using ASync(eaiRegisterEventPublisher), eaiRegisterEventProperties({})", (Object)_CLASSTAG, (Object)this.eaiRegisterEventProperties);
        EaiRegDataInfo eaiRegDataInfo = new EaiRegDataInfo();
        eaiRegDataInfo.setEaiHeaders(newEaiHeaders);
        eaiRegDataInfo.setEaiProperties(this.eaiProperties);
        EaiServiceRegisterEvent dataEvent = new EaiServiceRegisterEvent(eaiRegDataInfo);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)dataEvent);
        return resultValue;
    }

    public Object registerService(List<DWEAIHeader> newEaiHeaders, DWEAIProperties eaiProperties) throws Exception {
        HashMap resultValue = new HashMap();
        if (!this.modelDrivenProperties.isEspEnabledRegistration()) {
            log.warn("{}[registerService] 3 ignored reg esp, cause disabled(properties:eaiAutoRegistrationEnable)", (Object)_CLASSTAG);
            return resultValue;
        }
        log.debug("{}[registerService] using ASync...  eaiRegisterEventPublisher ({}), eaiRegisterEventProperties({})", new Object[]{_CLASSTAG, this.eaiRegisterEventPublisher, this.eaiRegisterEventProperties});
        EaiRegDataInfo eaiRegDataInfo = new EaiRegDataInfo();
        eaiRegDataInfo.setModelCodeName(ModelDrivenContext.getContext().getCode());
        eaiRegDataInfo.setEaiHeaders(newEaiHeaders);
        eaiRegDataInfo.setEaiProperties(eaiProperties);
        EaiServiceRegisterEvent dataEvent = new EaiServiceRegisterEvent(eaiRegDataInfo);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)dataEvent);
        return resultValue;
    }

    public static String getEaiServicePrefixOfProd(String prod) {
        String returnValue = prod.toLowerCase().replaceAll("-", "\\.");
        returnValue = returnValue.replaceAll("_", "\\.");
        return returnValue;
    }

    public HttpResponse tryEaiPath(String eaiPath, DWHttpClient dwHttpClient) throws Exception {
        String localPath = "http://127.0.0.1:" + DWApplicationConfigUtils.getProperty((String)"serverPort") + "/eai";
        this.tryLocalEaiPath(localPath, dwHttpClient);
        String body = "{}";
        while (true) {
            CloseableHttpResponse closeableHttpResponse;
            block11: {
                CloseableHttpResponse response;
                block10: {
                    HttpPost post = new HttpPost(eaiPath);
                    post.setEntity((HttpEntity)new DWJsonEntity((Object)body));
                    post.setHeader("digi-action", "reg");
                    response = (CloseableHttpResponse)dwHttpClient.execute((HttpUriRequest)post, new DWRequestOption(false));
                    try {
                        int statusCode = response.getStatusLine().getStatusCode();
                        if (statusCode == 200) break block10;
                        log.error("[" + Thread.currentThread().getName() + "]<<< '{}' is not ready to be invoked(127.0.0.1 /eai passed), response status is {}, it'll be retry after 5 seconds", (Object)eaiPath, (Object)statusCode);
                        Thread.sleep(5000L);
                        if (response == null) continue;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            log.error("[" + Thread.currentThread().getName() + "]<<< '{}' is not ready to be invoked, caused by exception:" + e.getMessage(), (Object)eaiPath);
                            continue;
                        }
                    }
                    response.close();
                    continue;
                }
                log.info("[" + Thread.currentThread().getName() + "]<<< '{}' invoke success", (Object)eaiPath);
                closeableHttpResponse = response;
                if (response == null) break block11;
                response.close();
            }
            return closeableHttpResponse;
            break;
        }
    }

    public HttpResponse tryLocalEaiPath(String eaiPath, DWHttpClient dwHttpClient) throws Exception {
        String body = "{}";
        while (true) {
            CloseableHttpResponse closeableHttpResponse;
            block11: {
                CloseableHttpResponse response;
                block10: {
                    HttpPost post = new HttpPost(eaiPath);
                    post.setEntity((HttpEntity)new DWJsonEntity((Object)body));
                    post.setHeader("digi-action", "reg");
                    response = (CloseableHttpResponse)dwHttpClient.execute((HttpUriRequest)post, new DWRequestOption(false));
                    try {
                        int statusCode = response.getStatusLine().getStatusCode();
                        if (statusCode == 200) break block10;
                        log.error("[" + Thread.currentThread().getName() + "]<<< tryLocalEaiPath '{}' is not ready to be invoked, response status is {}, it'll be retry after 5 seconds", (Object)eaiPath, (Object)statusCode);
                        Thread.sleep(5000L);
                        if (response == null) continue;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            log.error("[" + Thread.currentThread().getName() + "]<<< '{}' is not ready to be invoked, caused by exception:" + e.getMessage(), (Object)eaiPath);
                            continue;
                        }
                    }
                    response.close();
                    continue;
                }
                log.info("[" + Thread.currentThread().getName() + "]<<< '{}' invoke success", (Object)eaiPath);
                closeableHttpResponse = response;
                if (response == null) break block11;
                response.close();
            }
            return closeableHttpResponse;
            break;
        }
    }

    public HttpResponse retryRegProdApSrv(HttpPost post, DWHttpClient dwHttpClient) throws InterruptedException {
        long iRetryInterval = 5000L;
        CloseableHttpResponse responseReturn = null;
        while (true) {
            log.info("retryRegProdApSrv --> url({})", (Object)post.getURI().toString());
            try (CloseableHttpResponse response = (CloseableHttpResponse)dwHttpClient.execute((HttpUriRequest)post, new DWRequestOption(false));){
                int statusCode;
                InputStream responseStream;
                responseReturn = response;
                String responseBody = "";
                HttpEntity httpEntity = response.getEntity();
                if (httpEntity != null && (responseStream = httpEntity.getContent()) != null) {
                    responseBody = IOUtils.toString((InputStream)responseStream, (Charset)StandardCharsets.UTF_8);
                }
                if ((statusCode = response.getStatusLine().getStatusCode()) != 200) {
                    log.error("retryRegProdApSrv Something wrong in the process of eai services auto-registration, httpCode:{}, response:{}", (Object)statusCode, (Object)responseBody);
                    Thread.sleep(iRetryInterval);
                    continue;
                }
                Map responseBodyMap = (Map)DWGsonProvider.getGson().fromJson(responseBody, Map.class);
                String errorOrCodeValue = "";
                if (responseBodyMap.containsKey("error")) {
                    errorOrCodeValue = (String)responseBodyMap.get("error");
                } else if (responseBodyMap.containsKey("errorCode")) {
                    errorOrCodeValue = (String)responseBodyMap.get("errorCode");
                }
                if (!StringUtils.isNotEmpty((CharSequence)errorOrCodeValue)) {
                    log.info("retryRegProdApSrv success, httpCode:{}, error({}), response:{}", new Object[]{statusCode, errorOrCodeValue, post.getURI().toString()});
                    break;
                }
                log.info("retryRegProdApSrv failed,  httpCode:{}, error({}), response:{}", new Object[]{errorOrCodeValue, statusCode, responseBody});
                responseReturn.setStatusCode(417);
                Thread.sleep(iRetryInterval);
                log.info("ESP response ==> httpCode:{}, message:{}", (Object)statusCode, (Object)responseBody);
            }
            catch (Exception e) {
                log.error("eai auto register failed!", (Throwable)e);
            }
        }
        log.info("EAI Services have registered automatically. responseReturn({})", (Object)responseReturn);
        return responseReturn;
    }
}

