/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.ddl.model.Field;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.model.BMDataEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.enums.AlterAutoIncrementEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterIndexEnum;
import com.digiwin.lcdp.modeldriven.enums.ModelCreateTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.PublishStatusEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelPublishedEspResult;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.ModelTableSchemaCache;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.model.TableSqlParamDTO;
import com.digiwin.lcdp.modeldriven.report.model.DBTableNameCheckResult;
import com.digiwin.lcdp.modeldriven.utils.DBExecuteHandler;
import com.digiwin.lcdp.modeldriven.utils.DBTableUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiHeaderUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiRegisterUtil;
import com.digiwin.lcdp.modeldriven.utils.MixEaiRegisterUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenContextExtraUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelNewSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlParserUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelTablePartialSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelTableSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.NacosRegisterUtils;
import com.digiwin.lcdp.modeldriven.utils.compare.ColumnCompareUtil;
import com.digiwin.lcdp.modeldriven.utils.compare.IndexCompareUtil;
import com.digiwin.lcdp.modeldriven.utils.service.ServiceMappingUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ModelTableHelperExpress {
    private static final Logger log = LoggerFactory.getLogger(ModelTableHelperExpress.class);
    private static final String _CLASSTAG = "[" + ModelTableHelperExpress.class.getSimpleName() + "]";
    @Autowired
    private EaiRegisterUtil eaiRegisterUtil;
    @Autowired
    private EaiHeaderUtil eaiHeaderUtil;
    @Autowired
    private DBExecuteHandler dbExecuteService;
    @Autowired(required=false)
    @Qualifier(value="lcdp-bmd-eai-method-repo")
    private BMDataEaiMethodRepository bmdEaiMethodRepository;
    @Autowired(required=false)
    private MixEaiRegisterUtil mixEaiRegisterUtil;
    @Autowired(required=false)
    private NacosRegisterUtils nacosRegisterUtils;

    public DWServiceResult alterTableExpress(String masterTableName, LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>> alterTableMap) throws Exception {
        AtomicReference<PublishStatusEnum> alterRunStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        boolean alterSuccess = false;
        HashMap<String, Object> paramAll = new HashMap<String, Object>();
        LinkedList<SqlParam> ddlSqlParams = new LinkedList<SqlParam>();
        LinkedList<SqlParam> dmlSqlParams = new LinkedList<SqlParam>();
        for (String tableName : alterTableMap.keySet()) {
            LinkedHashMap<String, List<SqlParam>> tableAlterMap = alterTableMap.get(tableName);
            List<SqlParam> currentTblDmlSqlParams = tableAlterMap.get("dml");
            dmlSqlParams.addAll(currentTblDmlSqlParams);
            List<SqlParam> currentTblDdlSqlParams = tableAlterMap.get("ddl");
            ddlSqlParams.addAll(currentTblDdlSqlParams);
        }
        paramAll.put("dml", dmlSqlParams);
        paramAll.put("ddl", ddlSqlParams);
        DWEAIResult executeResult = this.dbExecuteService.executeAlterTable(paramAll);
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map<String, Object> extraMapOfModelContext = modelDrivenContext.getExtraMap();
        ModelDrivenContextExtraUtil.updatePublishReturnSql(ddlSqlParams, dmlSqlParams, extraMapOfModelContext);
        alterRunStatus.set(PublishStatusEnum.CHANGED);
        boolean executeSuccess = false;
        String resultCode = executeResult.getCode();
        if (NumberUtils.isDigits((String)resultCode) && NumberUtils.compare((int)0, (int)NumberUtils.createInteger((String)resultCode)) == 0) {
            executeSuccess = true;
        }
        String description = executeResult.getDescription();
        if (!executeSuccess) {
            SQLException cause = new SQLException(description, executeResult.getSqlCode());
            throw new RuntimeException(cause);
        }
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        ModelSchemaDTO draftModelSchemaDTO = draftModel.getSchema();
        String code = draftModel.getCode();
        ModelDTO publishedModel = modelDrivenContext.getPublishedModel();
        ModelSchemaDTO publishedModelSchemaDTO = publishedModel.getSchema();
        String modelDrivenProdPrefix = (String)extraMapOfModelContext.getOrDefault("modelDrivenProdPrefix", "");
        ModelCreateTypeEnum useExistedTable = ModelCreateTypeEnum.getTypeEnum(draftModelSchemaDTO.getUseExistedTable());
        List<DWEAIHeader> publishedEaiHeaders = this.eaiHeaderUtil.genServiceModelInfoData(publishedModelSchemaDTO, modelDrivenProdPrefix, code);
        List<DWHeader> existedEaiHeaders = this.eaiHeaderUtil.getExistedEaiHeaders(publishedEaiHeaders);
        BMProperties bmProperties = BMProperties.getProperties();
        if (!bmProperties.isEnabled() && !useExistedTable.equals((Object)ModelCreateTypeEnum.EXISTED_TABLE) || bmProperties.isEnabled() && bmProperties.getRole() == BMRole.bmd) {
            List<DWEAIHeader> newBMDataNacosEaiHeaders;
            List<DWEAIHeader> draftEspEaiHeaders = this.eaiHeaderUtil.genServiceModelInfoData(draftModelSchemaDTO, modelDrivenProdPrefix, code);
            List<DWEAIHeader> addEspEaiHeaders = this.eaiHeaderUtil.getAddEaiHeaders(draftEspEaiHeaders, existedEaiHeaders);
            if (CollectionUtils.isNotEmpty(draftEspEaiHeaders) || CollectionUtils.isNotEmpty(addEspEaiHeaders) || bmProperties.isBmdRegistryNacosToEsp() && bmProperties.getRole() == BMRole.bmd) {
                if (bmProperties.isBmdRegistryNacosToEsp() && bmProperties.getRole() == BMRole.bmd && CollectionUtils.isNotEmpty(newBMDataNacosEaiHeaders = this.bmdEaiMethodRepository.getEaiHeaders())) {
                    draftEspEaiHeaders.addAll(newBMDataNacosEaiHeaders);
                    log.info("{}[alterTableExpress] *** BM *** code({}) add nacos to esp service(size:{}, {})", new Object[]{_CLASSTAG, code, newBMDataNacosEaiHeaders.size(), newBMDataNacosEaiHeaders.stream().map(eaiHeaer -> eaiHeaer.getEAIServiceId()).collect(Collectors.toList())});
                }
                if (CollectionUtils.isNotEmpty(draftEspEaiHeaders)) {
                    this.eaiHeaderUtil.addAndUpdateCommonsHeaders(draftEspEaiHeaders);
                    log.info("{}[alterTableExpress] code({}) starting call register ESP service", (Object)_CLASSTAG, (Object)code);
                    Object regResult = this.eaiRegisterUtil.registerService(draftEspEaiHeaders, code);
                    List<DWHeader> dropEAIHeaders = this.eaiHeaderUtil.getDropEaiHeaders(draftEspEaiHeaders, existedEaiHeaders);
                    this.eaiHeaderUtil.executeDropExistedEaiHeaders(dropEAIHeaders);
                    log.info("{}[alterTableExpress] code({}) finished call register ESP service result({})", new Object[]{_CLASSTAG, code, regResult});
                } else {
                    log.debug("{}[alterTableExpress] code({}) finished call register ESP service without any eaiHeaders", (Object)_CLASSTAG, (Object)code);
                }
            } else {
                log.info("{}[alterTableExpress] code({}) ignored to register ESP service(draftHeaders and addEaiHeaders are all zero)", (Object)_CLASSTAG, (Object)code);
            }
            if (bmProperties.isEnabled() && bmProperties.getRole() == BMRole.bmd) {
                log.info("{}[alterTableExpress] code({}) starting call register NACOS service", (Object)_CLASSTAG, (Object)code);
                newBMDataNacosEaiHeaders = this.bmdEaiMethodRepository.getEaiHeaders();
                if (CollectionUtils.isNotEmpty(newBMDataNacosEaiHeaders)) {
                    this.eaiHeaderUtil.addAndUpdateCommonsHeaders(newBMDataNacosEaiHeaders);
                    this.nacosRegisterUtils.nacosServiceRegister(newBMDataNacosEaiHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList()));
                }
                log.info("{}[alterTableExpress] code({}) finished call register NACOS service(size:{})", new Object[]{_CLASSTAG, code, newBMDataNacosEaiHeaders.size()});
            }
            List<DWHeader> dropEAIHeaders = this.eaiHeaderUtil.getDropEaiHeaders(draftEspEaiHeaders, existedEaiHeaders);
            if (CollectionUtils.isNotEmpty(draftEspEaiHeaders)) {
                if (CollectionUtils.isNotEmpty(dropEAIHeaders)) {
                    this.eaiHeaderUtil.executeDropExistedEaiHeaders(dropEAIHeaders);
                }
                log.info("{}[alterTableExpress] code({}) just drop DWEAIHeaders ({})", new Object[]{_CLASSTAG, code, dropEAIHeaders.stream().map(dropEAIHeader -> dropEAIHeader.getServiceName()).collect(Collectors.toList())});
            }
        } else {
            log.debug("{}[alterTableExpress] code({}) ignored to register esp/nacos (isUseExistedTable:{},bmRole:{})", new Object[]{_CLASSTAG, code, useExistedTable, bmProperties.getRole()});
        }
        return DWServiceResultBuilder.build((boolean)executeSuccess, (String)description, (Object)executeResult);
    }

    public boolean dropTableExpress(List<String> tableNames, ModelDTO model) throws Exception {
        boolean modelActivityExists;
        String code = model.getCode();
        HashMap<String, Object> paramAll = new HashMap<String, Object>();
        LinkedList<SqlParam> ddlSqlParams = new LinkedList<SqlParam>();
        LinkedList<SqlParam> dmlSqlParams = new LinkedList<SqlParam>();
        LinkedList<SqlParam> modelDeleteSqls = ModelSqlGenerator.generateDeleteModelSql(code);
        dmlSqlParams.addAll(modelDeleteSqls);
        LinkedList<SqlParam> deleteModelInfoSql = ModelSqlGenerator.generateDeleteModelInfoSql(code);
        dmlSqlParams.addAll(deleteModelInfoSql);
        boolean dataViewExists = this.dbExecuteService.checkTableExist("dw_lcdp_data_view");
        if (dataViewExists) {
            LinkedList<SqlParam> deleteDataViewSql = ModelSqlGenerator.generateDeleteDataViewSql(code);
            dmlSqlParams.addAll(deleteDataViewSql);
        }
        if (modelActivityExists = this.dbExecuteService.checkTableExist("dw_lcdp_model_activity")) {
            LinkedList<SqlParam> deleteActivitySql = ModelSqlGenerator.generateDeleteActivitySql(code);
            dmlSqlParams.addAll(deleteActivitySql);
        }
        for (String targetTableName : tableNames) {
            SqlParam serviceMapping = ModelSqlGenerator.generateDeleteServiceMappingSql(targetTableName);
            dmlSqlParams.add(serviceMapping);
            SqlParam deleteRdbmsTableParam = ModelSqlGenerator.generateDeleteRdbmsTableSql(targetTableName);
            dmlSqlParams.add(deleteRdbmsTableParam);
            SqlParam deleteRdbmsFieldsParam = ModelSqlGenerator.generateDeleteRdbmsFieldSql(targetTableName);
            dmlSqlParams.add(deleteRdbmsFieldsParam);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Delete Rdbms Table Params: code={},tableName = {}", (Object)code, (Object)targetTableName);
                log.debug(">>>>> gen Delete Rdbms Table SQL: {}", (Object)deleteRdbmsTableParam);
                log.debug(">>>>> gen Delete Rdbms SQL: {}", dmlSqlParams);
            }
            SqlParam dropTableSqlParam = ModelSqlGenerator.generateRenameTableSql(targetTableName);
            ddlSqlParams.add(dropTableSqlParam);
        }
        paramAll.put("dml", dmlSqlParams);
        paramAll.put("ddl", ddlSqlParams);
        DWEAIResult executeResult = this.dbExecuteService.executeDeleteTable(paramAll, model);
        boolean executeDeleteSuccess = false;
        String resultCode = executeResult.getCode();
        if (NumberUtils.isDigits((String)resultCode) && NumberUtils.compare((int)0, (int)NumberUtils.createInteger((String)resultCode)) == 0) {
            executeDeleteSuccess = true;
        }
        String description = executeResult.getDescription();
        if (!executeDeleteSuccess) {
            SQLException cause = new SQLException(description, executeResult.getSqlCode());
            throw new RuntimeException(cause);
        }
        return executeDeleteSuccess;
    }

    public DWServiceResult createCustomizeTableExpress(String masterTableName, List<ModelTable> draftModelTables) throws Exception {
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map<String, Object> extraMapOfModelContext = modelDrivenContext.getExtraMap();
        Map dbModelTables = extraMapOfModelContext.getOrDefault("actualModelTablesFromDB", new HashMap());
        LinkedList<SqlParam> dmlSqlParams = new LinkedList<SqlParam>();
        LinkedList<SqlParam> ddlSqlParams = new LinkedList<SqlParam>();
        for (ModelTable draftModelTable : draftModelTables) {
            String currentTableName = draftModelTable.getName();
            log.info("{}[createCustomizeTableExpress] ----- process table({}) ----", (Object)_CLASSTAG, (Object)currentTableName);
            List<TableColumn> draftTableColumns = draftModelTable.getColumns();
            boolean hasPrimaryKey = draftTableColumns.stream().anyMatch(Field::isPK);
            if (!hasPrimaryKey) {
                throw new IllegalArgumentException(String.format("The table(%s) must include a primary key!", currentTableName));
            }
            SqlParam insertRdbmsTableSqlParam = ModelNewSqlGenerator.generateInsertRdbmsTableSql(draftModelTable);
            dmlSqlParams.add(insertRdbmsTableSqlParam);
            if (dbModelTables.containsKey(currentTableName)) {
                log.info("{}[createCustomizeTableExpress] --> table({}) is existed", (Object)_CLASSTAG, (Object)currentTableName);
                LinkedList<String> ddlTablePartialSqlParams = new LinkedList<String>();
                ModelTable actualModelTable = (ModelTable)dbModelTables.get(currentTableName);
                LinkedList<String> partialTableAttributes = ModelTablePartialSqlGenerator.getAlterTableOptionsWhenNewPublish(draftModelTable.getComment());
                ddlTablePartialSqlParams.addAll(partialTableAttributes);
                List<TableColumn> actualTableColumns = actualModelTable.getColumns();
                LinkedHashMap<AlterAutoIncrementEnum, TableColumn> changedAutoIncrmtMap = ColumnCompareUtil.getChangeAutoIncrementColumn(draftTableColumns, actualTableColumns);
                boolean isChangeAutoIncrement = MapUtils.isNotEmpty(changedAutoIncrmtMap);
                LinkedHashMap<AlterIndexEnum, TableIndex> changedPkMap = IndexCompareUtil.getChangePkIndex(draftModelTable, actualModelTable);
                Map<AlterIndexEnum, List<TableIndex>> alterIndexesMap = ModelSqlGenerator.getCreateAndModifyIndexesMapWithActualModelTable(draftModelTable, actualModelTable);
                if (MapUtils.isNotEmpty(alterIndexesMap)) {
                    alterIndexesMap.forEach((alterIndexEnum, tableColumns) -> {
                        if (!CollectionUtils.isEmpty((Collection)tableColumns)) {
                            List<String> dirtyIndexPartialSqls = ModelTablePartialSqlGenerator.getAlterIndexesInfo(currentTableName, alterIndexEnum, tableColumns);
                            ddlTablePartialSqlParams.addAll(dirtyIndexPartialSqls);
                        }
                    });
                }
                boolean isChangePk = MapUtils.isNotEmpty(changedPkMap);
                log.info("{}[createCustomizeTableExpress] table({}), isChangeAutoIncrement({}), isChangePk({})", new Object[]{_CLASSTAG, currentTableName, isChangeAutoIncrement, isChangePk});
                List<String> newPartialTableColumns = ModelTablePartialSqlGenerator.updateColumnsSqlParams(draftModelTable, actualModelTable, changedAutoIncrmtMap, dmlSqlParams);
                newPartialTableColumns.stream().filter(newSql -> ddlTablePartialSqlParams.stream().noneMatch(ddlSqlParam -> Objects.equals(ddlSqlParam, newSql))).forEach(filteredSql -> ddlTablePartialSqlParams.add((String)filteredSql));
                List<SqlParam> alterTableDDL = ModelTableSqlGenerator.getCombinedSqls(currentTableName, ddlTablePartialSqlParams);
                ddlSqlParams.addAll(alterTableDDL);
                List<SqlParam> insertOrUpdateRdbmsFieldsParam = ModelNewSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(draftModelTable);
                dmlSqlParams.addAll(insertOrUpdateRdbmsFieldsParam);
                continue;
            }
            log.info("{}[createCustomizeTableExpress] table({}) is not existed", (Object)_CLASSTAG, (Object)currentTableName);
            TableSqlParamDTO tableSqlParamDTO = ModelSqlGenerator.getCreateTable(draftModelTable);
            dmlSqlParams.addAll(tableSqlParamDTO.getDmlSqlParams());
            ddlSqlParams.addAll(tableSqlParamDTO.getDdlSqlParams());
        }
        boolean createSuccess = false;
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        ModelSchemaDTO draftModelSchema = draftModel.getSchema();
        String code = draftModel.getCode();
        SqlParam insertModelTableParam = ModelSqlGenerator.generateInsertModelSql(draftModel);
        dmlSqlParams.add(insertModelTableParam);
        LinkedList<SqlParam> insertModelInfoTableParam = ModelSqlGenerator.generateUpdateModelInfoSql(draftModelTables, code);
        dmlSqlParams.addAll(insertModelInfoTableParam);
        ModelCreateTypeEnum useExistedTable = draftModel.getUseExistedTable();
        List<SqlParam> updateServiceMappingParam = ModelSqlGenerator.getInsertOrUpdateServiceMapping(draftModel);
        dmlSqlParams.addAll(updateServiceMappingParam);
        BMProperties bmProperties = BMProperties.getProperties();
        ModelPublishedEspResult executeCreateTableResult = this.dbExecuteService.executeCreateTableOfCreateModelDriven(ddlSqlParams, dmlSqlParams, draftModel);
        ModelDrivenContextExtraUtil.updatePublishReturnSql(ddlSqlParams, dmlSqlParams, extraMapOfModelContext);
        if (executeCreateTableResult.getPublishStatusEnum() == PublishStatusEnum.SUCCESS) {
            String modelDrivenProdPrefix = (String)extraMapOfModelContext.getOrDefault("modelDrivenProdPrefix", "");
            if (bmProperties.isEnabled() && bmProperties.getRole() == BMRole.mix) {
                log.info("{}[createCustomizeTableExpress] *** BM({}) *** code({}), get modelDrivenProdPrefix {}", new Object[]{_CLASSTAG, bmProperties.getRole(), code, modelDrivenProdPrefix});
                Map<String, Object> serviceMappingInfoData = ServiceMappingUtil.genServiceModelInfoMap(draftModelSchema, modelDrivenProdPrefix, code);
                List serviceMappings = (List)((Object)serviceMappingInfoData.getOrDefault("serviceMappings", new HashMap()));
                List mappingModelInfos = (List)((Object)serviceMappingInfoData.getOrDefault("mappingModelInfos", new HashMap()));
                this.mixEaiRegisterUtil.registerService(serviceMappings, mappingModelInfos);
            } else {
                List<DWEAIHeader> newEAIHeaders = this.eaiHeaderUtil.refreshEaiService(draftModelSchema, modelDrivenProdPrefix, code);
                log.info("{} code({}) isUseExistedTable({}), starting call register esp/nacos service", new Object[]{_CLASSTAG, code, useExistedTable});
                if (bmProperties.isEnabled() && bmProperties.getRole() == BMRole.bmd) {
                    List<DWEAIHeader> newBMDataEaiHeaders = this.bmdEaiMethodRepository.getEaiHeaders();
                    this.eaiHeaderUtil.addAndUpdateCommonsHeaders(newBMDataEaiHeaders);
                    if (bmProperties.isBmdRegistryNacosToEsp()) {
                        Object regResult = this.eaiRegisterUtil.autoRegisterEAI(newEAIHeaders, code);
                        log.info("{}[createCustomizeTableExpress] *** BM *** code({}) finished call register esp service result({})", new Object[]{_CLASSTAG, code, regResult});
                    }
                    this.nacosRegisterUtils.nacosServiceRegister(newBMDataEaiHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList()));
                } else if (!useExistedTable.equals((Object)ModelCreateTypeEnum.EXISTED_TABLE)) {
                    Object regResult = this.eaiRegisterUtil.autoRegisterEAI(newEAIHeaders, code);
                    log.info("{} code({}) isUseExistedTable({}), finished call register esp service result({})", new Object[]{_CLASSTAG, code, useExistedTable, regResult});
                }
            }
            createSuccess = true;
        }
        return DWServiceResultBuilder.build((boolean)createSuccess, (String)"", null);
    }

    public DBTableNameCheckResult getTableNamesGeneratedByModelDriven(String sql) throws JSQLParserException {
        List<String> queryTableNames = ModelSqlParserUtil.getTables(sql);
        List<String> distinctTableNames = this.dbExecuteService.getTableNamesGeneratedByModelDriven(queryTableNames);
        DBTableNameCheckResult checkResult = new DBTableNameCheckResult();
        if (queryTableNames.size() != distinctTableNames.size()) {
            checkResult.setSqlTableNames(queryTableNames);
            checkResult.setModelTableNames(distinctTableNames);
            checkResult.setPassed(false);
        }
        return checkResult;
    }

    public ModelTable getModelTableFromDB(String tableName) throws JSQLParserException {
        ModelTable actualModelTable = null;
        boolean isTableExist = this.dbExecuteService.checkTableExist(tableName);
        if (isTableExist) {
            List data = this.dbExecuteService.getCreateTableSqlByDBFunc(tableName);
            if (CollectionUtils.isEmpty((Collection)data)) {
                String errorMessage = String.format("[getModelTableFromDB] table(%s) existed but no create table sql data", tableName);
                log.error("{}[getModelTableFromDB] {}", (Object)_CLASSTAG, (Object)errorMessage);
                throw new IllegalStateException(errorMessage);
            }
            log.info("{}[getModelTableFromDB] --> table({}) is existed", (Object)_CLASSTAG, (Object)tableName);
            actualModelTable = new ModelTable();
            CreateTable ccjCreateTable = ModelSqlParserUtil.fetchCCJCreateTable(data);
            List createOptStrs = ccjCreateTable.getTableOptionsStrings();
            Table ccjTable = ccjCreateTable.getTable();
            String pureTableName = DBTableUtil.removeBackQuoteSymbol(ccjTable.getName());
            actualModelTable.setName(pureTableName);
            actualModelTable.setComment(ModelSqlParserUtil.getComment(ccjCreateTable));
            List ccjColumnDefinitions = ccjCreateTable.getColumnDefinitions();
            List ccjIndexes = Optional.ofNullable(ccjCreateTable.getIndexes()).orElse(new ArrayList());
            List<TableColumn> actualTableColumns = ModelSqlParserUtil.getTableColumns(ccjColumnDefinitions, ccjIndexes);
            actualModelTable.setColumns(actualTableColumns);
            List<TableIndex> existedTableIndexes = ModelSqlParserUtil.getTableIndexes(ccjIndexes);
            actualModelTable.setIndexes(existedTableIndexes);
            TableIndex pkTableIndex = existedTableIndexes.stream().filter(tableIndex -> tableIndex.getName().equals("PRIMARY KEY")).findFirst().orElse(null);
            if (pkTableIndex != null) {
                actualModelTable.setPk(pkTableIndex.getMember().stream().collect(Collectors.joining(",")));
            }
        }
        return actualModelTable;
    }

    public Map<String, Object> getModelTableFromDatabase(List<String> tableNames) throws JSQLParserException {
        HashMap<String, Object> actualModelTables = new HashMap<String, Object>();
        Map<String, ModelTableSchemaCache> publishedTableCache = ModelDrivenContext.getContext().getPublishedTableCache();
        for (String tableName : tableNames) {
            ModelTable actualModelTable = this.getModelTableFromDB(tableName);
            if (actualModelTable == null) continue;
            actualModelTables.put(tableName, actualModelTable);
            ModelTableSchemaCache publishedTableSchemaCache = ModelSchemaUtil.getModelTableSchemaCache(actualModelTable);
            publishedTableCache.put(tableName, publishedTableSchemaCache);
        }
        return actualModelTables;
    }

    public String getTableName(String serviceName, String serviceProdfix) {
        return this.eaiHeaderUtil.getTableName(serviceName, serviceProdfix);
    }
}

