/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils.compare;

import com.digiwin.app.ddl.enums.DataTypeEnum;
import com.digiwin.lcdp.modeldriven.constants.ModelDBConstants;
import com.digiwin.lcdp.modeldriven.enums.AlterAutoIncrementEnum;
import com.digiwin.lcdp.modeldriven.enums.ColumnNullableEnum;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnCompareUtil {
    private static final Logger log = LoggerFactory.getLogger(ColumnCompareUtil.class);
    private static final String _CLASSTAG = "[" + ColumnCompareUtil.class.getSimpleName() + "]";

    public static List<TableColumn> getAddColumns(List<TableColumn> draftTableColumns, List<TableColumn> adcutalTableColumns) {
        List<TableColumn> addColumns = draftTableColumns.stream().filter(draftTableColumn -> ModelSchemaUtil.checkRelatedType(draftTableColumn) && adcutalTableColumns.stream().noneMatch(actualColumn -> Objects.equals(draftTableColumn.getColumnName(), actualColumn.getColumnName()))).collect(Collectors.toList());
        return addColumns;
    }

    public static List<TableColumn> getModifyColumns(List<TableColumn> draftTableColumns, List<TableColumn> actualTableColumns) {
        List<TableColumn> modifyColumns = draftTableColumns.stream().filter(draftTableColumn -> ModelSchemaUtil.checkRelatedType(draftTableColumn) && actualTableColumns.stream().anyMatch(actualColumn -> draftTableColumn.getColumnName().equals(actualColumn.getColumnName()) && !draftTableColumn.equalsIgnoredUnique(actualColumn))).collect(Collectors.toList());
        return modifyColumns;
    }

    public static List<TableColumn> getDropColumns(List<TableColumn> draftTableColumns, List<TableColumn> actualTableColumns, List<TableColumn> publishTableColumns) {
        List dropColumnsByComparedModel = publishTableColumns.stream().filter(publishedColumn -> ModelSchemaUtil.checkRelatedType(publishedColumn) && draftTableColumns.stream().noneMatch(draftModelField -> Objects.equals(publishedColumn.getColumnName(), draftModelField.getColumnName()))).collect(Collectors.toList());
        List<TableColumn> validDropColumns = dropColumnsByComparedModel.stream().filter(dropColumn -> actualTableColumns.stream().anyMatch(actualTableColumn -> Objects.equals(dropColumn.getColumnName(), actualTableColumn.getColumnName()))).collect(Collectors.toList());
        log.info("{} validDropColumns({}) = dropColumnsByComparedModel({}) anyMatch in actualTableColumns:({})", new Object[]{_CLASSTAG, validDropColumns.stream().map(vCol -> vCol.getColumnName()).collect(Collectors.toList()), dropColumnsByComparedModel.stream().map(dropCol -> dropCol.getColumnName()).collect(Collectors.toList()), actualTableColumns.stream().map(eCol -> eCol.getColumnName()).collect(Collectors.toList())});
        return validDropColumns;
    }

    public static LinkedHashMap<AlterAutoIncrementEnum, TableColumn> getChangeAutoIncrementColumn(List<TableColumn> draftTableColumns, List<TableColumn> actualTableColumns) {
        LinkedHashMap<AlterAutoIncrementEnum, TableColumn> changeMap = new LinkedHashMap<AlterAutoIncrementEnum, TableColumn>();
        TableColumn actualColumnWithAutoIncrement = actualTableColumns.stream().filter(existedColumn -> existedColumn.getAutoIncrement()).findFirst().orElse(null);
        TableColumn draftColumnWithAutoIncrement = draftTableColumns.stream().filter(draftColumn -> draftColumn.getAutoIncrement()).findFirst().orElse(null);
        log.debug("{} autoIncrement status, draft({}),actual({})", new Object[]{_CLASSTAG, draftColumnWithAutoIncrement, actualColumnWithAutoIncrement});
        if (actualColumnWithAutoIncrement != null && draftColumnWithAutoIncrement != null) {
            if (!StringUtils.equals((CharSequence)actualColumnWithAutoIncrement.getColumnName(), (CharSequence)draftColumnWithAutoIncrement.getColumnName())) {
                changeMap.put(AlterAutoIncrementEnum.DROP, actualColumnWithAutoIncrement);
                changeMap.put(AlterAutoIncrementEnum.ADD, draftColumnWithAutoIncrement);
                log.info("{} autoIncrement drop actual({}),add draft({})", new Object[]{_CLASSTAG, actualColumnWithAutoIncrement.getColumnName(), draftColumnWithAutoIncrement.getColumnName()});
            } else {
                log.info("{} autoIncrement ignore change(same columnName)", (Object)_CLASSTAG);
            }
        } else if (actualColumnWithAutoIncrement == null && draftColumnWithAutoIncrement != null) {
            changeMap.put(AlterAutoIncrementEnum.ADD, draftColumnWithAutoIncrement);
        } else if (actualColumnWithAutoIncrement != null && draftColumnWithAutoIncrement == null) {
            changeMap.put(AlterAutoIncrementEnum.DROP, actualColumnWithAutoIncrement);
        }
        log.debug("{}[getChangeAutoIncrementColumn] changeMap ({})", (Object)_CLASSTAG, changeMap);
        return changeMap;
    }

    public static String getTypeDDL(TableColumn field) {
        DataTypeEnum dataType = field.getDataType();
        String type = dataType.getType();
        String name = dataType.getName();
        Integer size = field.getSize();
        if (Objects.isNull(size)) {
            size = dataType.getDefaultSize();
        }
        if ("TEXT".equals(type) && ModelDBConstants.SQL_DATATYPE_NAME_WITHOUT_SIZE.contains(name)) {
            return name + " ";
        }
        String[] timeTypeNameWithSize = new String[]{"DATETIME", "TIME", "TIMESTAMP"};
        if ("TIME".equals(type) && Arrays.stream(timeTypeNameWithSize).anyMatch(timeType -> name.equals(timeType) && field.getSize() != null)) {
            return String.format("%s(%s) ", name, size);
        }
        if ("TIME".equals(type)) {
            return name + " ";
        }
        if ("REAL".equals(type)) {
            Integer scale = field.getScale();
            if (Objects.isNull(scale)) {
                scale = dataType.getDefaultScale();
            }
            return String.format("%s(%s,%s) ", name, size, scale);
        }
        return String.format("%s(%s) ", name, size);
    }

    public static ColumnNullableEnum getNullableEnum(boolean bool) {
        return bool ? ColumnNullableEnum.NULL : ColumnNullableEnum.NOT_NULL;
    }

    public static String booleanToYN(boolean bool) {
        return bool ? "Y" : "N";
    }

    public static String columnUniqueValue(boolean bool) {
        return bool ? "UNIQUE" : "";
    }

    public static String getSqlByAutoIncrementOrDefaultValue(TableColumn tableColumn) {
        String autoIncrementString = ColumnCompareUtil.getSqlByAutoIncrementOrDefaultValue(tableColumn, false);
        return autoIncrementString;
    }

    public static String getSqlByAutoIncrementOrDefaultValue(TableColumn tableColumn, boolean combinePk) {
        String autoIncrementString = tableColumn.getAutoIncrement() != false ? ColumnCompareUtil.getAutoIncrement(combinePk) : ColumnCompareUtil.getDefaultValue(tableColumn);
        return autoIncrementString;
    }

    public static String getAutoIncrement(boolean combinePk) {
        Object autoIncrementCmd = "AUTO_INCREMENT";
        if (combinePk) {
            autoIncrementCmd = (String)autoIncrementCmd + " PRIMARY KEY";
        }
        return autoIncrementCmd;
    }

    public static String getDefaultValue(TableColumn tableColumn) {
        boolean defaultValueIsExpr = tableColumn.getDefaultValueIsExpr();
        if (defaultValueIsExpr && tableColumn.getDefaultValueType().equalsIgnoreCase("expression")) {
            return "DEFAULT " + tableColumn.getDefaultValue();
        }
        return tableColumn.getDataType() == DataTypeEnum.BIT ? (tableColumn.getDefaultValue() != null ? (tableColumn.getDefaultValue().toUpperCase().equals("1") ? "DEFAULT TRUE" : "DEFAULT FALSE") : "") : (tableColumn.getDefaultValue() != null ? "DEFAULT '" + (tableColumn.getDefaultValue().equals("\"\"") ? "" : tableColumn.getDefaultValue()) + "'" : "");
    }

    public static String getDefaultValue(TableColumn tableColumn, boolean existedTable) {
        if (existedTable) {
            String columnName = tableColumn.getColumnName();
            if (columnName.equals("create_date")) {
                return "DEFAULT current_timestamp()";
            }
            if (columnName.equals("modified_date")) {
                return "DEFAULT NULL ON UPDATE current_timestamp()";
            }
        }
        return ColumnCompareUtil.getDefaultValue(tableColumn);
    }

    public static Integer getUpdateSize(Integer updatedInteger, Integer defaultInteger) {
        if (Objects.isNull(updatedInteger)) {
            if (Objects.isNull(defaultInteger)) {
                return 0;
            }
            return defaultInteger;
        }
        return updatedInteger;
    }
}

