/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.aop;

import com.digiwin.app.service.DWServiceContext;
import java.lang.reflect.Method;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BMCrudInterceptor
implements MethodInterceptor {
    private static Logger logger = LoggerFactory.getLogger(BMCrudInterceptor.class);
    private static final String _CLASSTAG = "[" + BMCrudInterceptor.class.getSimpleName() + "]";
    private Object bmAdapter;

    public Object getBmAdapter() {
        return this.bmAdapter;
    }

    public void setBmAdapter(Object bmAdapter) {
        this.bmAdapter = bmAdapter;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method bmAdapterBeforeInvoke;
        String digiServiceName = DWServiceContext.getContext().getDigiServiceName();
        logger.debug(_CLASSTAG + " invoke eaiId({})", (Object)digiServiceName);
        Object[] objects = invocation.getArguments();
        Map headers = (Map)objects[0];
        Map messageBody = (Map)objects[1];
        StopWatch stopWatch = StopWatch.createStarted();
        StringBuffer timeRecord = new StringBuffer();
        Object result = "";
        try {
            timeRecord.append(String.format(_CLASSTAG + " beforeInvoke(%d) ", stopWatch.getTime()));
            logger.debug(timeRecord.toString());
            bmAdapterBeforeInvoke = this.bmAdapter.getClass().getDeclaredMethod("beforeInvoke", Map.class, Map.class);
            bmAdapterBeforeInvoke.invoke(this.bmAdapter, headers, messageBody);
            timeRecord.append(String.format(_CLASSTAG + " afterBeforeInvoke(%d) ", stopWatch.getTime()));
            result = invocation.proceed();
            timeRecord.append(String.format(_CLASSTAG + " after invocation.proceed()(%d) ", stopWatch.getTime()));
        }
        catch (Throwable e) {
            try {
                timeRecord.append(String.format(_CLASSTAG + " after doException(%d) ", stopWatch.getTime()));
                if (!stopWatch.isStopped()) {
                    stopWatch.stop();
                }
                throw e;
            }
            catch (Throwable throwable) {
                Method bmAdapterBeforeInvoke2 = this.bmAdapter.getClass().getDeclaredMethod("afterInvoke", Map.class, Object.class);
                bmAdapterBeforeInvoke2.invoke(this.bmAdapter, headers, result);
                if (!stopWatch.isStopped()) {
                    stopWatch.stop();
                }
                logger.debug(_CLASSTAG + " finally eaiId({})", (Object)digiServiceName);
                throw throwable;
            }
        }
        bmAdapterBeforeInvoke = this.bmAdapter.getClass().getDeclaredMethod("afterInvoke", Map.class, Object.class);
        bmAdapterBeforeInvoke.invoke(this.bmAdapter, headers, result);
        if (!stopWatch.isStopped()) {
            stopWatch.stop();
        }
        logger.debug(_CLASSTAG + " finally eaiId({})", (Object)digiServiceName);
        return result;
    }
}

