/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.handler;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.digiwin.app.eai.exception.DWEaiException;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.lcdp.modeldriven.customize.handler.BMAdapterCustomizeHandler;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BMAdapterDefaultCustomizeHandler
implements BMAdapterCustomizeHandler {
    private static final Logger log = LoggerFactory.getLogger(BMAdapterDefaultCustomizeHandler.class);
    private static final String _CLASSTAG = "[" + BMAdapterDefaultCustomizeHandler.class.getSimpleName() + "]";

    @Override
    public Object processMessageBody(Object messageBody) {
        Object returnValue;
        if (messageBody instanceof Map) {
            String orgString = JSON.toJSONString((Object)messageBody);
            returnValue = JSON.parseObject((String)orgString, Map.class);
            log.debug("{} convertMessageBody JSON.parseObject( map to Map", (Object)_CLASSTAG);
        } else if (messageBody instanceof String) {
            returnValue = JSON.parseObject((String)((String)messageBody), HashMap.class);
            log.debug("{} convertMessageBody JSON.parseObject(String to Map", (Object)_CLASSTAG);
        } else {
            returnValue = messageBody;
            log.debug("{} do nothing", (Object)_CLASSTAG);
        }
        return returnValue;
    }

    @Override
    public Object processBMDataResult(String responseString) throws DWEaiException {
        log.debug("{} processBMDataResult. JSON.parseObject(String to DWEAIResult", (Object)_CLASSTAG);
        Map stdData = (Map)((Map)JSONObject.parseObject((String)responseString, Map.class)).get("std_data");
        Map execution = (Map)stdData.get("execution");
        String code = "";
        String sqlCode = "";
        String description = "";
        if (execution.containsKey("code")) {
            code = (String)execution.get("code");
        }
        if (!code.equals("0")) {
            DWEaiException dwEaiException = new DWEaiException(code, execution.get("message").toString());
            dwEaiException.setStacktrace(execution.get("stacktrace").toString());
            dwEaiException.setDescription(execution.get("description").toString());
            throw dwEaiException;
        }
        if (execution.containsKey("sql_code")) {
            sqlCode = (String)execution.get("sql_code");
        }
        if (execution.containsKey("description")) {
            description = (String)execution.get("description");
        }
        Map parameter = (Map)stdData.get("parameter");
        return new DWEAIResult(code, sqlCode, description, parameter);
    }
}

