/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.service.impl;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWOnColumn;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryJoinRelation;
import com.digiwin.app.dao.DWQueryJoinTable;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.lcdp.modeldriven.customize.service.IBMDataEAICrudService;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.service.impl.ModelDrivenEAIMappingService;
import com.digiwin.lcdp.modeldriven.utils.EaiResultUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.service.ServiceMappingUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class BMDataEAICrudService
implements IBMDataEAICrudService {
    private static final Logger log = LoggerFactory.getLogger(BMDataEAICrudService.class);
    private static final String _CLASSTAG = "[" + BMDataEAICrudService.class.getSimpleName() + "]";
    @Autowired
    @Qualifier(value="dw-modeldriven-commons-eai-mapping-service")
    ModelDrivenEAIMappingService eaiMappingService;
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;

    @Override
    public Object getBMCode(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        log.info("{}[getBMCode] enter...", (Object)_CLASSTAG);
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_service_mapping");
        queryInfo.setJoinOnColumn(DWQueryJoinRelation.LeftJoin, new DWQueryJoinTable("dw_lcdp_model_info"), new DWOnColumn[]{new DWOnColumn("table_name", DWQueryValueOperator.Equals, "table_name")});
        queryInfo.setJoinOnColumn(DWQueryJoinRelation.Join, new DWQueryJoinTable("dw_lcdp_model"), new DWOnColumn[]{new DWOnColumn(String.join((CharSequence)".", "dw_lcdp_model_info", "code"), DWQueryValueOperator.Equals, String.join((CharSequence)".", "dw_lcdp_model", "code"))});
        queryInfo.addSelectField(new String[]{String.join((CharSequence)".", "dw_lcdp_model_info", "code")});
        queryInfo.addSelectField(new String[]{String.join((CharSequence)".", "dw_lcdp_model", "model_schema") + " as modelSchema"});
        queryInfo.addSelectField(new String[]{"dw_service_mapping.*"});
        DWQueryCondition queryCondition = new DWQueryCondition();
        queryCondition.addFieldInfo("target_prod", DWQueryValueOperator.NotEquals, null);
        queryInfo.setCondition(queryCondition);
        List serviceMappings = this.dao.select(DWServiceMapping.class, queryInfo, option);
        List<MappingModelInfo> mappingModelInfos = new ArrayList<MappingModelInfo>();
        if (serviceMappings.size() > 0) {
            mappingModelInfos = (List)this.eaiMappingService.getBMChildrenTable();
        }
        ServiceMappingUtil.updateProd(serviceMappings, mappingModelInfos);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("serviceMapping", serviceMappings);
        result.put("mappingModelInfos", mappingModelInfos);
        log.info("{}[getBMDCode] finished, data(serviceMappings:{},mappingModelInfos:{})", new Object[]{_CLASSTAG, serviceMappings == null ? 0 : serviceMappings.size(), mappingModelInfos == null ? 0 : mappingModelInfos.size()});
        return EaiResultUtil.getDWEAIResult(result);
    }

    public Object getBMDCode(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        log.info("{}[getBMCode] enter...", (Object)_CLASSTAG);
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_service_mapping");
        queryInfo.setJoinOnColumn(DWQueryJoinRelation.LeftJoin, new DWQueryJoinTable("dw_lcdp_model_info"), new DWOnColumn[]{new DWOnColumn("table_name", DWQueryValueOperator.Equals, "table_name")});
        queryInfo.setJoinOnColumn(DWQueryJoinRelation.Join, new DWQueryJoinTable("dw_lcdp_model"), new DWOnColumn[]{new DWOnColumn(String.join((CharSequence)".", "dw_lcdp_model_info", "code"), DWQueryValueOperator.Equals, String.join((CharSequence)".", "dw_lcdp_model", "code"))});
        queryInfo.addSelectField(new String[]{"dw_lcdp_model_info.code"});
        queryInfo.addSelectField(new String[]{String.join((CharSequence)".", "dw_lcdp_model", "model_schema") + " as modelSchema"});
        queryInfo.addSelectField(new String[]{"dw_service_mapping.*"});
        List serviceMappings = this.dao.select(DWServiceMapping.class, queryInfo, option);
        List<MappingModelInfo> mappingModelInfos = new ArrayList<MappingModelInfo>();
        if (serviceMappings.size() > 0) {
            mappingModelInfos = (List)this.eaiMappingService.getChildrenTable();
        }
        ServiceMappingUtil.updateProd(serviceMappings, mappingModelInfos);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("serviceMapping", serviceMappings);
        result.put("mappingModelInfos", mappingModelInfos);
        log.info("{}[getBMDCode] finished, data(serviceMappings:{},mappingModelInfos:{})", new Object[]{_CLASSTAG, serviceMappings == null ? 0 : serviceMappings.size(), mappingModelInfos == null ? 0 : mappingModelInfos.size()});
        return EaiResultUtil.getDWEAIResult(result);
    }
}

