/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.dataview.utils;

import com.digiwin.app.dao.DWQueryField;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.lcdp.modeldriven.dataview.utils.DataViewFieldUtil;
import com.digiwin.lcdp.modeldriven.pojo.QueryConditionDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class CustomizeVariableUtil {
    public List<DWQueryField> generateQueryFieldsByCustomVariables(QueryConditionDTO searchInfo, List<Map> customizedConditionValues) {
        if (CollectionUtils.isNotEmpty((Collection)searchInfo.getSearch_value())) {
            List searchValues = searchInfo.getSearch_value();
            if (CollectionUtils.isNotEmpty(customizedConditionValues)) {
                customizedConditionValues.get(0).forEach((key, val) -> {
                    if (searchValues.contains(key)) {
                        if (val instanceof List) {
                            searchInfo.setSearch_value((List)val);
                        } else {
                            searchInfo.setSearch_value(Arrays.asList(val));
                        }
                    }
                });
            }
            return Arrays.asList(this.generateQueryFields(searchInfo));
        }
        return new ArrayList<DWQueryField>();
    }

    public DWQueryField generateQueryFields(QueryConditionDTO searchInfo) {
        DWQueryField dwQueryField = null;
        String searchField = DataViewFieldUtil.getQueryField(searchInfo);
        switch (searchInfo.getSearch_operator()) {
            case "equal": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.Equals, new Object[]{CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "not_equal": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.NotEquals, new Object[]{CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "greater_equal": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.GreaterThanOrEqualTo, new Object[]{CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "less_equal": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.LessThanOrEqualTo, new Object[]{CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "greater": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.GreaterThan, new Object[]{CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "less": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.LessThan, new Object[]{CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "like_r": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.Like, new Object[]{CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0).toString().replaceAll("%", "\\\\%") + "%"});
                break;
            }
            case "like": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.Like, new Object[]{"%" + CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0).toString().replaceAll("%", "\\\\%") + "%"});
                break;
            }
            case "l_like": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.Like, new Object[]{"%" + CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0).toString().replaceAll("%", "\\\\%")});
                break;
            }
            case "not_like": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.NotLike, new Object[]{"%" + CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0).toString().replaceAll("%", "\\\\%") + "%"});
                break;
            }
            case "exist": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.In, searchInfo.getSearch_value().toArray(new Object[1]));
                break;
            }
            case "not exist": {
                String[] fields = searchField.split("\\.");
                dwQueryField = new DWQueryField(fields[fields.length - 1], DWQueryValueOperator.NotIn, searchInfo.getSearch_value().toArray(new Object[1]));
                break;
            }
            case "between": {
                dwQueryField = new DWQueryField(searchField, DWQueryValueOperator.Between, searchInfo.getSearch_value().toArray(new Object[1]));
                break;
            }
            default: {
                throw new RuntimeException(String.format("operator '%s' is not supported", searchInfo.getSearch_operator()));
            }
        }
        return dwQueryField;
    }
}

