/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.eai;

import com.digiwin.app.persistconn.TokenProvider;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.entity.DWJsonEntity;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.digiwin.http.client.utils.DWRequestHeaderUtils;
import com.digiwin.iam.HttpRequestModel;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMHttpRequester;
import com.digiwin.lcdp.modeldriven.eai.EaiRequestDataInfo;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EaiProcessService {
    private static final Logger log = LoggerFactory.getLogger(EaiProcessService.class);
    @Autowired
    DWHttpClient httpClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(EaiRequestDataInfo requestDataInfo) throws Exception {
        HttpResponseModel responseModel;
        block15: {
            Map<String, Object> result = requestDataInfo.getBody();
            String uri = String.join((CharSequence)"/", requestDataInfo.getUrl(), requestDataInfo.getApiPath());
            log.debug("[EaiProcessService] invoke EAI ({})...", (Object)uri);
            HttpPost post = new HttpPost(uri);
            post.setEntity((HttpEntity)new DWJsonEntity(result));
            EntityUtils.toString((HttpEntity)post.getEntity(), (Charset)StandardCharsets.UTF_8);
            String appToken = TokenProvider.getAppToken();
            String userToken = TokenProvider.getToken();
            Map headers = DWRequestHeaderUtils.getIamApiRequiredHeaders();
            headers.put("Content-Type", "application/json;charset=UTF-8");
            headers.put("digi-middleware-auth-app", appToken);
            headers.put("digi-middleware-auth-user", userToken);
            responseModel = null;
            String responseBody = "";
            try (CloseableHttpResponse response = (CloseableHttpResponse)this.httpClient.execute((HttpUriRequest)post, () -> headers);){
                InputStream responseStream;
                HttpEntity httpEntity = response.getEntity();
                if (httpEntity != null && (responseStream = httpEntity.getContent()) != null) {
                    responseBody = IOUtils.toString((InputStream)responseStream, (Charset)StandardCharsets.UTF_8);
                }
                int statusCode = response.getStatusLine().getStatusCode();
                responseModel = new HttpResponseModel(statusCode, responseBody);
                if (statusCode != 200) {
                    log.error("Something wrong in the process of eai services auto-registration, httpCode:{}, response({})", (Object)statusCode, (Object)responseBody);
                } else {
                    log.info("ESP response ==> httpCode:{}, message:{}", (Object)statusCode, (Object)responseBody);
                    log.info("EAI Services have registered automatically successfully.");
                }
            }
            catch (Exception e) {
                if (e instanceof DWHttpFailedException) {
                    String responseMesg = (String)((DWHttpFailedException)e).getEntity(String.class);
                    log.error("eai auto register failed! (DWHttpFailedException, response({}))", (Object)responseMesg);
                    break block15;
                }
                log.error("eai auto register failed! ({})", (Throwable)e);
                HttpRequestModel requestModel = new HttpRequestModel();
                requestModel.setUrl(uri);
                requestModel.setRequestHeader(headers);
                requestModel.setRequestBody("");
                throw IAMHttpRequester.handleHttpStatus((HttpRequestModel)requestModel, (HttpResponseModel)responseModel);
            }
            finally {
                log.info("EAI Services finished auto-registering...");
            }
        }
        return responseModel;
    }
}

