/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.dao.DWBatchCondition;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWOnColumn;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryInfoBuilder;
import com.digiwin.app.dao.DWQueryJoinRelation;
import com.digiwin.app.dao.DWQueryJoinTable;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.utils.BMPublishHelper;
import com.digiwin.lcdp.modeldriven.enums.ModelCreateTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.PublishStatusEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelExtendModelInfo;
import com.digiwin.lcdp.modeldriven.model.ModelOidDTO;
import com.digiwin.lcdp.modeldriven.model.ModelPublishedEspResult;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaExtends;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.service.impl.ModelExtendPublishHelper;
import com.digiwin.lcdp.modeldriven.service.impl.ModelPublishHelper;
import com.digiwin.lcdp.modeldriven.utils.ApTokenUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiResultUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenContextExtraUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMetadataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelTableHelperExpress;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ModelPublishService {
    private static final Logger log = LoggerFactory.getLogger(ModelPublishService.class);
    private static final String CLASS_LOG_TAG = "[" + ModelPublishService.class.getSimpleName() + "]";
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    @Autowired
    private ModelTableHelperExpress modelTableHelperExpress;
    @Autowired
    private ModelPublishHelper modelPublishHelper;
    @Autowired
    private ModelExtendPublishHelper modelExtendPublishHelper;
    @Autowired
    private BMPublishHelper bmPublishHelper;

    public DWDataRow getPublished(ModelOidDTO modelOid) {
        String currentAppId = ApTokenUtil.getCurrentAppId();
        List<Object> pkList = this.getPkList(modelOid);
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        DWQueryInfo queryInfo = new DWQueryInfoBuilder().setOids(pkList).create();
        queryInfo.setTableName("dw_lcdp_model");
        DWDataSet dataSet = this.dao.select(queryInfo, option);
        if (dataSet != null && dataSet.getTable("dw_lcdp_model").getRows().size() > 0) {
            DWDataRow dataRow = dataSet.getTable("dw_lcdp_model").getRow(0);
            String publishedAppId = (String)dataRow.get("app_id");
            if (!currentAppId.equals(publishedAppId)) {
                log.warn("code({}) diff appid, draft({}), published({})", new Object[]{modelOid.getCode(), currentAppId, publishedAppId});
            }
            return dataRow;
        }
        return null;
    }

    public List<DWDataRow> getExtendPublishedModels(String mainTableCode, String appCode) {
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        String joinTableAliasName = "model";
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_lcdp_model_extend");
        DWOnColumn onColumn = new DWOnColumn("code", DWQueryValueOperator.Equals, "extend_model_code");
        DWQueryJoinTable extendJoinTable = new DWQueryJoinTable("dw_lcdp_model_extend");
        DWQueryJoinTable modelJoinTable = new DWQueryJoinTable("dw_lcdp_model", joinTableAliasName);
        queryInfo.setJoinOnColumn(DWQueryJoinRelation.Join, modelJoinTable, extendJoinTable, new DWOnColumn[]{onColumn});
        queryInfo.addFieldInfo("main_table_code", DWQueryValueOperator.Equals, new Object[]{mainTableCode});
        queryInfo.addFieldInfo("app_code", DWQueryValueOperator.Equals, new Object[]{appCode});
        queryInfo.addSelectField(new String[]{joinTableAliasName + ".*"});
        DWDataSet dataSet = this.dao.select(queryInfo, option);
        DWDataTable dwModelTable = dataSet.getTables().getPrimaryTable();
        ArrayList<DWDataRow> resultDataRow = new ArrayList<DWDataRow>();
        for (DWDataRow tempRow : dwModelTable.getRows()) {
            resultDataRow.add(tempRow);
        }
        return resultDataRow;
    }

    public List<DWDataRow> getExtendPublishedDataRows(List<String> codes) {
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_lcdp_model");
        queryInfo.addFieldInfo("code", DWQueryValueOperator.In, (Object[])codes.toArray(new String[0]));
        DWDataSet dataSet = this.dao.select(queryInfo, option);
        DWDataTable dwModelTable = dataSet.getTables().getPrimaryTable();
        ArrayList<DWDataRow> resultDataRow = new ArrayList<DWDataRow>();
        for (DWDataRow tempRow : dwModelTable.getRows()) {
            resultDataRow.add(tempRow);
        }
        return resultDataRow;
    }

    public DWServiceResult deleteModelSchema(ModelDTO model, Map<String, Object> messageBody) throws Exception {
        Map<Object, Object> returnData = new HashMap();
        String returnMessage = "";
        if (BMProperties.getProperties().isEnabled() && BMProperties.getProperties().getRole() == BMRole.bm) {
            returnData = this.bmPublishHelper.deleteModelSchema(messageBody);
        } else {
            String appId = ApTokenUtil.getCurrentAppId();
            model.setAppId(appId);
            String code = model.getCode();
            log.debug("code({}) input model_schema", (Object)model.getCode());
            String tenantId = model.getTargetTenantId();
            ModelOidDTO modelOidDTO = new ModelOidDTO(code, null, tenantId);
            DWDataRow publishedDataRow = this.getPublished(modelOidDTO);
            if (publishedDataRow == null || publishedDataRow.getData().size() == 0) {
                returnMessage = String.format(ResourceBundleUtils.getString("lcdp.modeldriven.publish.delete.datanone"), new Object[0]);
                log.warn(returnMessage);
            } else {
                model.setSchema(ModelSchemaUtil.getModelSchema((String)publishedDataRow.get("model_schema")));
                DWSQLExecutionResult publishedDelete = this.modelPublishHelper.deletePublished(model, publishedDataRow);
                returnData.put("model", publishedDelete.getDeleteCount());
                returnMessage = ResourceBundleUtils.getString("lcdp.modeldriven.publish.delete.success");
                if (publishedDelete.getDeleteCount() == 1 && this.modelTableHelperExpress.extendTableExisted()) {
                    this.modelExtendPublishHelper.deleteExtendModelSchema(model, publishedDataRow);
                }
            }
        }
        return DWServiceResultBuilder.build((String)returnMessage, returnData);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Map<String, Object> deleteModelInfoForDeleteModel(ModelDTO model) {
        DWDataSetOperationOption optionDelete = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        optionDelete.getDeleteOption().enableBatchCondition();
        DWBatchCondition batchCondition = new DWBatchCondition();
        String code = model.getCode();
        String appId = model.getAppId();
        batchCondition.addFieldInfo("code", DWQueryValueOperator.Equals, new Object[]{code});
        batchCondition.addFieldInfo("app_id", DWQueryValueOperator.Equals, new Object[]{appId});
        DWDataSet dataSetModelInfo = new DWDataSet();
        dataSetModelInfo.newTable("dw_lcdp_model_info").delete(batchCondition);
        DWSQLExecutionResult returnDaoValue = this.dao.execute(dataSetModelInfo, optionDelete);
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        if (log.isDebugEnabled()) {
            log.info("code({}) model_info deleted count({})", (Object)code, (Object)returnDaoValue.getDeleteCount());
        }
        return returnValue;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Object deleteModel(ModelDTO model) {
        String code = model.getCode();
        HashMap<String, Integer> returnValue = new HashMap<String, Integer>();
        DWDataSetOperationOption optionDelete = new DWDataSetOperationOption();
        optionDelete.setTenantEnabled(false);
        optionDelete.setManagementFieldEnabled(false);
        optionDelete.getDeleteOption().enableBatchCondition();
        DWBatchCondition batchCondition2 = new DWBatchCondition();
        batchCondition2.addFieldInfo("code", DWQueryValueOperator.Equals, new Object[]{code});
        DWDataSet dataSetModel = new DWDataSet();
        dataSetModel.newTable("dw_lcdp_model").delete(batchCondition2);
        DWSQLExecutionResult deleteModelResult = this.dao.execute(dataSetModel, optionDelete);
        returnValue.put("dw_lcdp_model", deleteModelResult.getDeleteCount());
        if (log.isDebugEnabled()) {
            log.debug("code({}) deleted ({})", (Object)code, returnValue);
        }
        return returnValue;
    }

    public DWEAIResult publishDraft(Map<String, Object> messageBody) throws Exception {
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map<String, Object> extraMapOfModelContext = modelDrivenContext.getExtraMap();
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        ModelSchemaDTO draftModelSchema = draftModel.getSchema();
        String code = draftModel.getCode();
        String modelTargetTenantId = draftModel.getTargetTenantId();
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        DWEAIResult publishResult = EaiResultUtil.getDWEAIResult(returnValue);
        returnValue.put("code", code);
        BMProperties bmProperties = BMProperties.getProperties();
        if (bmProperties.isEnabled() && bmProperties.getRole() == BMRole.bm) {
            publishResult = this.bmPublishHelper.registerServiceAndCallBmdService(draftModel, messageBody);
        } else {
            List<ModelTable> draftModelTables = ModelSchemaUtil.getModelTables(draftModelSchema, false);
            Map<String, ModelTable> draftModelTableMap = ModelSchemaUtil.getModelTableMap(draftModelTables);
            extraMapOfModelContext.put("draftModelTables", draftModelTableMap);
            List dirtyTableNames = draftModelTableMap.keySet().stream().collect(Collectors.toList());
            ModelOidDTO modelOidDTO = new ModelOidDTO(code, dirtyTableNames, modelTargetTenantId, null);
            DWDataRow publishedDataRow = this.getPublished(modelOidDTO);
            if (publishedDataRow != null) {
                PublishStatusEnum publishStatus;
                modelDrivenContext.setNewModelPublish(false);
                log.debug("code({}) preparing alter schema", (Object)draftModel.getCode());
                ModelDTO publishedModel = ModelSchemaUtil.getModel(publishedDataRow);
                modelDrivenContext.setPublishedModel(publishedModel);
                ModelSchemaDTO publishedModelSchema = publishedModel.getSchema();
                ModelSchemaUtil.reorganize(publishedModelSchema);
                String publishedModelStr = (String)publishedDataRow.get("model_schema");
                extraMapOfModelContext.put("pModelSchemaStr", publishedModelStr);
                List<ModelTable> publishedModelTables = ModelSchemaUtil.getModelTables(publishedModelSchema, false);
                Map<String, ModelTable> publishedModelTableMap = ModelSchemaUtil.getModelTableMap(publishedModelTables);
                extraMapOfModelContext.put("publishedModelTables", publishedModelTableMap);
                List publishedTableNames = publishedModelTableMap.keySet().stream().collect(Collectors.toList());
                List mixTableNames = (List)CollectionUtils.union(publishedTableNames, dirtyTableNames);
                Map<String, Object> modelTablesOfDb = this.modelTableHelperExpress.getModelTableFromDatabase(mixTableNames);
                extraMapOfModelContext.put("actualModelTablesFromDB", modelTablesOfDb);
                List existedTableNames = modelTablesOfDb.keySet().stream().collect(Collectors.toList());
                extraMapOfModelContext.put("existedTableNames", existedTableNames);
                dirtyTableNames = mixTableNames;
                ModelPublishedEspResult modelPublishedEspResult = this.modelPublishHelper.alterTableExpress();
                if (modelPublishedEspResult.getPublishStatusEnum() == PublishStatusEnum.SUCCESS && this.modelTableHelperExpress.extendTableExisted()) {
                    Map<String, ModelTable> draftParentModelTableMap = ModelSchemaUtil.getModelTableMap(draftModelTables);
                    List<String> draftParentModelCodes = draftParentModelTableMap.keySet().stream().collect(Collectors.toList());
                    Map<String, ModelTable> publishParentModelTableMap = ModelSchemaUtil.getModelTableMap(publishedModelTables);
                    List<String> publishedParentModelCodes = publishParentModelTableMap.keySet().stream().collect(Collectors.toList());
                    this.modelExtendPublishHelper.processExtendModelSchema(draftParentModelCodes, publishedParentModelCodes, code);
                }
                publishResult.setCode(PublishStatusEnum.FAILURE.equals((Object)(publishStatus = modelPublishedEspResult.getPublishStatusEnum())) ? "-1" : "0");
            } else {
                Map<String, Object> modelTablesOfDb = this.modelTableHelperExpress.getModelTableFromDatabase(dirtyTableNames);
                extraMapOfModelContext.put("actualModelTablesFromDB", modelTablesOfDb);
                List existedTableNames = modelTablesOfDb.keySet().stream().collect(Collectors.toList());
                extraMapOfModelContext.put("existedTableNames", existedTableNames);
                log.debug("code({}) preparing create schema", (Object)code);
                ModelPublishedEspResult modelPublishedEspResult = this.modelPublishHelper.createOrAlterCustomizeTableExpress();
                PublishStatusEnum publishStatus = modelPublishedEspResult.getPublishStatusEnum();
                publishResult.setCode(PublishStatusEnum.FAILURE.equals((Object)publishStatus) ? "-1" : "0");
            }
            ModelDrivenMetadataUtil.removeRdbmsMetadata(code, dirtyTableNames);
        }
        Object returnSql = ModelDrivenContextExtraUtil.getPublishReturnSql(extraMapOfModelContext);
        if (returnSql != null) {
            publishResult.getParameter().put("returnSql", returnSql);
        }
        return publishResult;
    }

    private static List<String> getDropModeCodes(List<String> dirtyTableNames, List<String> publishedTableNames) {
        List<String> finalDirtyTableNames = dirtyTableNames;
        List<String> dropTableNames = publishedTableNames.stream().filter(pTableName -> finalDirtyTableNames.contains(pTableName)).collect(Collectors.toList());
        return dropTableNames;
    }

    public DWEAIResult extendSchemaPublishDraft(Map<String, Object> messageBody) throws Exception {
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map<String, Object> extraMapOfModelContext = modelDrivenContext.getExtraMap();
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        String draftModelCode = draftModel.getCode();
        ModelSchemaExtends draftModelSchemaExtends = draftModel.getSchemaExtends();
        String draftMainTableName = draftModelSchemaExtends.getExtendMainTable();
        List<ModelSchemaDTO> draftExtendModelSchemas = draftModelSchemaExtends.getExtendModels();
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        DWEAIResult publishResult = EaiResultUtil.getDWEAIResult(returnValue);
        returnValue.put("code", draftModelCode);
        BMProperties bmProperties = BMProperties.getProperties();
        if (bmProperties.isEnabled() && bmProperties.getRole() == BMRole.bm) {
            publishResult = this.bmPublishHelper.callBmdService(draftModelCode, messageBody);
        } else {
            Map<String, ModelSchemaDTO> draftModelSchemaMap = ModelSchemaUtil.getChildrenModelSchemaMap(draftExtendModelSchemas);
            List<ModelTable> draftModelTables = ModelSchemaUtil.getModelTablesWithPhysicalColumns(draftModelSchemaMap);
            Map<String, ModelTable> draftModelTableMap = ModelSchemaUtil.getModelTableMap(draftModelTables);
            extraMapOfModelContext.put("draftModelTables", draftModelTableMap);
            List dirtyTableNames = draftModelTableMap.keySet().stream().collect(Collectors.toList());
            ArrayList currentModelCodeNames = new ArrayList();
            List<ModelExtendModelInfo> draftExtendModelInfos = draftModelSchemaExtends.getExtendModelInfo();
            if (CollectionUtils.isEmpty(draftExtendModelInfos)) {
                throw new DWBusinessException("modelExtend ExtendModelInfo is empty");
            }
            String draftAppCode = draftExtendModelInfos.get(0).getAppCode();
            draftExtendModelInfos.stream().forEach(extendModeInfo -> currentModelCodeNames.add(extendModeInfo.getCurrentModelCode()));
            List<DWDataRow> publishedDataRow = this.getExtendPublishedModels(draftMainTableName, draftAppCode);
            if (CollectionUtils.isNotEmpty(publishedDataRow)) {
                modelDrivenContext.setNewModelPublish(false);
                log.debug("{}[extendSchemaPublishDraft] code({}) preparing alter schema:({}), code({})", new Object[]{CLASS_LOG_TAG, draftModel.getCode(), dirtyTableNames, draftModelCode});
                HashMap<String, String> modelSchemaStrMap = new HashMap<String, String>();
                ArrayList<ModelSchemaDTO> publishedModelSchemas = new ArrayList<ModelSchemaDTO>();
                ModelDTO publishedModel = new ModelDTO();
                for (DWDataRow dataRow : publishedDataRow) {
                    ModelSchemaDTO publishedModelSchema = ModelSchemaUtil.parseModelSchema(dataRow);
                    ModelSchemaUtil.reorganize(publishedModelSchema);
                    String publishedModelStr = (String)dataRow.get("model_schema");
                    publishedModelSchemas.add(publishedModelSchema);
                    modelSchemaStrMap.put(publishedModelSchema.getName(), publishedModelStr);
                    publishedModel.setAppId((String)dataRow.get("app_id"));
                    publishedModel.setTargetTenantId((String)dataRow.get("target_tenant_id"));
                }
                ModelSchemaExtends publishedSchemaExtends = new ModelSchemaExtends();
                publishedSchemaExtends.setExtendModels(publishedModelSchemas);
                publishedModel.setCode(draftModelCode);
                publishedModel.setModelType("extend");
                publishedModel.setUseExistedTable(ModelCreateTypeEnum.EXISTED_TABLE);
                publishedModel.setSchemaExtends(publishedSchemaExtends);
                Map<String, ModelSchemaDTO> publishedModelSchemaMap = ModelSchemaUtil.getChildrenModelSchemaMap(publishedModelSchemas);
                List<ModelTable> publishedModelTables = ModelSchemaUtil.getModelTablesWithPhysicalColumns(publishedModelSchemaMap);
                extraMapOfModelContext.put("publishedModelSchemaMap", publishedModelSchemaMap);
                Map<String, ModelTable> publishedModelTableMap = ModelSchemaUtil.getModelTableMap(publishedModelTables);
                extraMapOfModelContext.put("publishedModelTables", publishedModelTableMap);
                List publishedTableNames = publishedModelTableMap.keySet().stream().collect(Collectors.toList());
                List mixTableNames = (List)CollectionUtils.union(publishedTableNames, dirtyTableNames);
                Map<String, Object> modelTablesOfDb = this.modelTableHelperExpress.getModelTableFromDatabase(mixTableNames);
                extraMapOfModelContext.put("actualModelTablesFromDB", modelTablesOfDb);
                List existedTableNames = modelTablesOfDb.keySet().stream().collect(Collectors.toList());
                extraMapOfModelContext.put("existedTableNames", existedTableNames);
                dirtyTableNames = mixTableNames;
                extraMapOfModelContext.put("pModelSchemaStr", modelSchemaStrMap);
                modelDrivenContext.setPublishedModel(publishedModel);
                ModelPublishedEspResult modelPublishedEspResult = this.modelExtendPublishHelper.alterExtendModel();
                PublishStatusEnum publishStatus = modelPublishedEspResult.getPublishStatusEnum();
                publishResult.setCode(PublishStatusEnum.FAILURE.equals((Object)publishStatus) ? "-1" : "0");
            } else {
                Map<String, Object> modelTablesOfDb = this.modelTableHelperExpress.getModelTableFromDatabase(dirtyTableNames);
                extraMapOfModelContext.put("actualModelTablesFromDB", modelTablesOfDb);
                List existedTableNames = modelTablesOfDb.keySet().stream().collect(Collectors.toList());
                extraMapOfModelContext.put("existedTableNames", existedTableNames);
                log.debug("{}[extendSchemaPublishDraft] code({}) process schema({})", new Object[]{CLASS_LOG_TAG, draftModelCode, dirtyTableNames});
                ModelPublishedEspResult modelPublishedEspResult = this.modelExtendPublishHelper.extendModelCreateOrAlterCustomizeTable();
                PublishStatusEnum publishStatus = modelPublishedEspResult.getPublishStatusEnum();
                publishResult.setCode(PublishStatusEnum.FAILURE.equals((Object)publishStatus) ? "-1" : "0");
            }
            ModelDrivenMetadataUtil.removeRdbmsMetadata(draftModelCode, dirtyTableNames);
            Object returnSql = ModelDrivenContextExtraUtil.getPublishReturnSql(extraMapOfModelContext);
            if (returnSql != null) {
                publishResult.getParameter().put("returnSql", returnSql);
            }
        }
        return publishResult;
    }

    @Deprecated
    private List<Object> getPkList(String appId, ModelOidDTO modelOid) {
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put("app_id", appId);
        pkMap.put("code", modelOid.getCode());
        return Collections.singletonList(pkMap);
    }

    private List<Object> getPkList(ModelOidDTO modelOid) {
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put("code", modelOid.getCode());
        return Collections.singletonList(pkMap);
    }

    private List<Object> getModelExtendsPkList(ModelOidDTO modelOid) {
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put("code", modelOid.getCode());
        return Collections.singletonList(pkMap);
    }

    public ModelPublishedEspResult createOrAlterCustomizeTableExpress() throws Exception {
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        log.debug("[ModelPublishService][createOrAlterCustomizeTableExpress] code({}) useExistedTable={}", (Object)draftModel.getCode(), (Object)draftModel.getUseExistedTable().getTypeChar());
        ModelSchemaDTO draftModelSchema = draftModel.getSchema();
        ModelSchemaUtil.checkModelSchema(draftModelSchema, true);
        Map draftModelTableMap = (Map)modelDrivenContext.getExtraMap().get("draftModelTables");
        List<ModelTable> draftModelTables = draftModelTableMap.values().stream().collect(Collectors.toList());
        AtomicReference<PublishStatusEnum> createStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        DWServiceResult serviceResult = this.modelTableHelperExpress.createCustomizeTableExpress(draftModelSchema.getName(), draftModelTables);
        boolean createRunStatus = serviceResult.getSuccess();
        if (log.isDebugEnabled()) {
            log.debug(String.format("[createOrAlterCustomizeTableExpress] expected(%b) actual(%b), description:(%s)", createStatus, createRunStatus, serviceResult.getMessage()));
        }
        if (createRunStatus) {
            createStatus.set(PublishStatusEnum.SUCCESS);
        } else {
            createStatus.set(PublishStatusEnum.FAILURE);
        }
        ModelPublishedEspResult publishedEspResult = new ModelPublishedEspResult();
        publishedEspResult.setPublishStatusEnum(createStatus.get());
        publishedEspResult.setServiceResult(serviceResult);
        return publishedEspResult;
    }
}

