/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.eai.exception.DWEaiException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.lcdp.modeldriven.constants.ModelDBConstants;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.ModelTableSchemaCache;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.pojo.ExceptionSQLInfo;
import com.digiwin.lcdp.modeldriven.utils.DBColumnUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlParserUtil;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class ModelDrivenExceptionUtils {
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenExceptionUtils.class);
    private static final String _CLASSTAG = "[" + ModelDrivenExceptionUtils.class.getSimpleName() + "]";
    String localContextLocal = LocaleContextHolder.getLocale().toString();

    public Throwable filterSQLException(Throwable e) {
        try {
            Map<String, Object> modelDrivenContextExtraMap = ModelDrivenContext.getContext().getExtraMap();
            String crudType = (String)modelDrivenContextExtraMap.getOrDefault("crudType", "");
            if (StringUtils.equals((CharSequence)crudType, (CharSequence)"dataView") && modelDrivenContextExtraMap.containsKey("querySQL")) {
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                DWEaiException dweaiException = new DWEaiException();
                if (rootCause instanceof SQLException) {
                    String message = this.customizeErrorMessageV2(rootCause);
                    dweaiException.setMessage(StringUtils.abbreviate((String)message, (int)200));
                    dweaiException.setSqlCode(((SQLException)rootCause).getSQLState());
                } else {
                    dweaiException.setMessage(rootCause.getMessage());
                }
                HashMap<String, String> parameters = new HashMap<String, String>();
                String returnSql = (String)modelDrivenContextExtraMap.get("querySQL");
                parameters.put("returnSql", returnSql);
                dweaiException.setParameter(parameters);
                e = dweaiException;
            } else {
                this.dealSQLException(e);
            }
            return e;
        }
        catch (Exception ex) {
            log.error("ModelDrivenExceptionUtils.filterSQLException error!", (Throwable)ex);
            return e;
        }
    }

    public Throwable dealSQLException(Throwable throwable) throws Exception {
        Field superDetailMessage = Throwable.class.getDeclaredField("detailMessage");
        if (throwable != null) {
            if (throwable.getCause() == null) {
                if (throwable instanceof SQLException && ((SQLException)throwable).getNextException() != null) {
                    superDetailMessage.setAccessible(true);
                    ExceptionSQLInfo exceptionSQLInfo = ModelSqlParserUtil.getExceptionSQLInfo(throwable);
                    ModelDrivenContext.getContext().getExtraMap().put("exceptionDXLSqlInfo", exceptionSQLInfo);
                    superDetailMessage.set(throwable, this.customizeErrorMessageV2(throwable));
                }
                return throwable;
            }
            Throwable causeExceptions = this.dealSQLException(throwable.getCause());
            if (causeExceptions == null) {
                return throwable;
            }
            if (causeExceptions instanceof SQLException) {
                SQLException cause = (SQLException)causeExceptions;
                superDetailMessage.setAccessible(true);
                superDetailMessage.set(throwable, cause.getMessage());
                return cause;
            }
        }
        return throwable;
    }

    public String customizeErrorMessage(Throwable throwable) {
        Object message = throwable.getMessage();
        if (((String)message).indexOf("Duplicate entry") != -1) {
            String i18nDescription;
            int endKeyName;
            int startRowValue = ((String)message).indexOf("'");
            int endRowValue = ((String)message).indexOf("'", startRowValue + 1);
            String rowValue = ((String)message).substring(startRowValue + 1, endRowValue);
            int startKeyName = ((String)message).indexOf("'", endRowValue + 1);
            String fullKeyName = ((String)message).substring(startKeyName + 1, endKeyName = ((String)message).indexOf("'", startKeyName + 1));
            List<String> keyMembers = this.getConstrainMember(fullKeyName);
            if (CollectionUtils.isNotEmpty(keyMembers)) {
                String memberStr = String.join((CharSequence)",", keyMembers);
                i18nDescription = String.format(ResourceBundleUtils.getString("sqlException.duplicateentry.WithConstrainMember"), rowValue, fullKeyName, memberStr);
            } else {
                i18nDescription = String.format(ResourceBundleUtils.getString("sqlException.duplicateentry"), rowValue, fullKeyName);
            }
            StringBuilder builder = new StringBuilder().append("errCode:").append("P.LCDP.102.0001").append("  ").append("description:").append(i18nDescription);
            message = builder.toString();
        } else {
            Map currentModifyColumns = (Map)ModelDrivenContext.getContext().getExtraMap().get("exceptionAlterDDL");
            if (MapUtils.isNotEmpty((Map)currentModifyColumns)) {
                String tableName = (String)currentModifyColumns.get("exceptionAlterDDLTable");
                List modifyColumnNames = currentModifyColumns.getOrDefault("exceptionAlterDDLColumns", new ArrayList());
                String alterInfo = String.format(ResourceBundleUtils.getString("lcdp.modeldriven.publish.fail.SqlExceptionShowAlterColumn"), tableName, modifyColumnNames);
                message = (String)message + ", " + alterInfo;
            }
        }
        return message;
    }

    public String customizeErrorMessageV2(Throwable throwable) {
        Object message = throwable.getMessage();
        Map<String, Object> modelDrivenContextExtraMap = ModelDrivenContext.getContext().getExtraMap();
        SQLException sqlException = ((SQLException)throwable).getNextException();
        if (sqlException.getSQLState().startsWith("23") || ((String)message).indexOf("Duplicate entry") != -1) {
            Matcher matcherDuplicateEntry = ModelDBConstants.PATTERN_DUPLICATE_ENTRY.matcher((CharSequence)message);
            if (matcherDuplicateEntry.find()) {
                String i18nDescription;
                String rowValue = matcherDuplicateEntry.group(1);
                String fullKeyName = matcherDuplicateEntry.group(2);
                List<Map<String, Object>> keyColumnsMembers = this.getConstrainMemberColumn(fullKeyName);
                if (CollectionUtils.isNotEmpty(keyColumnsMembers)) {
                    ArrayList<String> columnNames = new ArrayList<String>();
                    for (Map<String, Object> tableColumnName : keyColumnsMembers) {
                        Object keyMemberColumn = String.format("%s=%s", tableColumnName.get("indexColumnName"), tableColumnName.get("indexColumnComment"));
                        if (tableColumnName.containsKey("indexColumnValue")) {
                            keyMemberColumn = (String)keyMemberColumn + "=" + String.valueOf(tableColumnName.get("indexColumnValue"));
                        }
                        columnNames.add((String)keyMemberColumn);
                    }
                    String memberStr = String.join((CharSequence)", ", columnNames);
                    i18nDescription = String.format(ResourceBundleUtils.getString("sqlException.duplicateentry.WithConstrainMember"), rowValue, fullKeyName, memberStr);
                } else {
                    i18nDescription = String.format(ResourceBundleUtils.getString("sqlException.duplicateentry"), rowValue, fullKeyName);
                }
                String returnMessage = String.format("errCode:%s  description:%s", "P.LCDP.102.0001", i18nDescription);
                log.error("{} returnMessage:{}", (Object)_CLASSTAG, (Object)returnMessage);
                return returnMessage;
            }
            Map currentModifyColumns = (Map)modelDrivenContextExtraMap.get("exceptionAlterDDL");
            if (MapUtils.isNotEmpty((Map)currentModifyColumns)) {
                String tableName = (String)currentModifyColumns.get("exceptionAlterDDLTable");
                List modifyColumnNames = currentModifyColumns.getOrDefault("exceptionAlterDDLColumns", new ArrayList());
                String alterInfo = String.format(ResourceBundleUtils.getString("lcdp.modeldriven.publish.fail.SqlExceptionShowAlterColumn"), tableName, modifyColumnNames);
                message = (String)message + ", " + alterInfo;
            }
        } else {
            Map currentModifyColumns = (Map)modelDrivenContextExtraMap.get("exceptionAlterDDL");
            if (MapUtils.isNotEmpty((Map)currentModifyColumns)) {
                String tableName = (String)currentModifyColumns.get("exceptionAlterDDLTable");
                List modifyColumnNames = currentModifyColumns.getOrDefault("exceptionAlterDDLColumns", new ArrayList());
                String alterInfo = String.format(ResourceBundleUtils.getString("lcdp.modeldriven.publish.fail.SqlExceptionShowAlterColumn"), tableName, modifyColumnNames);
                message = (String)message + ", " + alterInfo;
            } else {
                ExceptionSQLInfo exceptionSQLInfo = (ExceptionSQLInfo)modelDrivenContextExtraMap.get("exceptionDXLSqlInfo");
                if (exceptionSQLInfo != null) {
                    String errorMessage = exceptionSQLInfo.getErrorMessage();
                    log.error("{} {}", (Object)_CLASSTAG, (Object)errorMessage);
                    Matcher matcherDuplicateEntry = ModelDBConstants.PATTERN_SQL_EXECUTE_EXCEPTION_ENTRY.matcher((CharSequence)message);
                    if (matcherDuplicateEntry.find()) {
                        String filteredMessage = matcherDuplicateEntry.group(1);
                        String tableName = exceptionSQLInfo.getTableName();
                        Matcher tableMatch = ModelDBConstants.PATTERN_TABLE_ENTRY.matcher(filteredMessage);
                        if (tableMatch.find() && StringUtils.isNotBlank((CharSequence)tableName)) {
                            String fullTableName = tableMatch.group(1);
                            filteredMessage = filteredMessage.replace(fullTableName, tableName);
                        }
                        message = String.format("errCode:%s  description:%s", "P.LCDP.100.0000", filteredMessage);
                    }
                }
            }
        }
        return message;
    }

    public List<String> getConstrainMember(String fullKeyName) {
        String tableName;
        String keyName;
        ModelDTO publishedModel;
        ModelSchemaDTO modelSchema;
        ModelTable modelTable;
        ModelTableSchemaCache modelTableSchemaCache;
        Map<String, Object> indexesMap;
        List<String> indexMembers = new ArrayList<String>();
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map currentModifyColumns = (Map)modelDrivenContext.getExtraMap().get("exceptionAlterDDL");
        if (MapUtils.isNotEmpty((Map)currentModifyColumns)) {
            TableIndex tableIndex;
            String tableName2 = (String)currentModifyColumns.get("exceptionAlterDDLTable");
            Map draftModelTableMap = (Map)ModelDrivenContext.getContext().getExtraMap().get("draftModelTables");
            ModelTable modelTable2 = (ModelTable)draftModelTableMap.get(tableName2);
            String keyName2 = this.getKeyName(fullKeyName, tableName2);
            Optional<TableIndex> optionTableIndex = modelTable2.getIndexes().stream().filter(index -> index.getName().equals(keyName2)).findFirst();
            if (optionTableIndex.isPresent() && Objects.nonNull(tableIndex = optionTableIndex.get())) {
                indexMembers = tableIndex.getMember();
            }
        } else if (modelDrivenContext.getDraftModel() == null && (indexesMap = (modelTableSchemaCache = ModelSchemaUtil.getModelTableSchemaCache(modelTable = ModelSchemaUtil.getCurrentLevelModelTable(modelSchema = (publishedModel = modelDrivenContext.getPublishedModel()).getSchema()))).getPublishedRemainIndexes()).containsKey(keyName = this.getKeyName(fullKeyName, tableName = modelTable.getName()))) {
            TableIndex tableIndex = (TableIndex)indexesMap.get(keyName);
            indexMembers = tableIndex.getMember();
        }
        return indexMembers;
    }

    public List<Map<String, Object>> getConstrainMemberColumn(String fullKeyName) {
        List<Map<String, Object>> returnValue = new LinkedList<Map<String, Object>>();
        ArrayList indexMembers = new ArrayList();
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map currentModifyColumns = (Map)modelDrivenContext.getExtraMap().get("exceptionAlterDDL");
        ExceptionSQLInfo exceptionSQLInfo = (ExceptionSQLInfo)modelDrivenContext.getExtraMap().get("exceptionDXLSqlInfo");
        if (MapUtils.isNotEmpty((Map)currentModifyColumns)) {
            String tableName = (String)currentModifyColumns.get("exceptionAlterDDLTable");
            Map draftModelTableMap = (Map)ModelDrivenContext.getContext().getExtraMap().get("draftModelTables");
            ModelTable targetModelTable = (ModelTable)draftModelTableMap.get(tableName);
            ModelTableSchemaCache modelTableSchemaCache = ModelSchemaUtil.getModelTableSchemaCache(targetModelTable);
            Map<String, Object> indexesMap = modelTableSchemaCache.getPublishedRemainIndexes();
            String keyName = this.getKeyName(fullKeyName, tableName);
            if ("PRIMARY".equals(keyName)) {
                List<String> pks = ModelSchemaUtil.getPrimaryKeys(targetModelTable.getColumns());
                TableIndex pkIndex = new TableIndex("PRIMARY", pks);
                pkIndex.setType(IndexTypeEnum.PRIMARY_KEY);
                returnValue = this.getIndexColumnI18n(pkIndex, targetModelTable);
            } else if (indexesMap.containsKey(keyName)) {
                TableIndex tableIndex = (TableIndex)indexesMap.get(keyName);
                returnValue = this.getIndexColumnI18n(tableIndex, targetModelTable);
            }
        } else if (exceptionSQLInfo != null && exceptionSQLInfo.getSqlParam() != null) {
            ModelDTO publishedModel = modelDrivenContext.getPublishedModel();
            ModelSchemaDTO modelSchema = publishedModel.getSchema();
            try {
                Map<String, Object> sqlInfoMap = ModelSqlParserUtil.getSqlCommandInfo(exceptionSQLInfo.getSqlParam());
                String tableName = (String)sqlInfoMap.get("tableName");
                Map<String, ModelSchemaDTO> modelSchemaTableMap = ModelSchemaUtil.getModelSchemaMap(modelSchema);
                ModelTable targetModelTable = ModelSchemaUtil.getCurrentLevelModelTable(modelSchemaTableMap.get(tableName));
                ModelTableSchemaCache modelTableSchemaCache = ModelSchemaUtil.getModelTableSchemaCache(targetModelTable);
                Map<String, Object> indexesMap = modelTableSchemaCache.getPublishedRemainIndexes();
                String keyName = this.getKeyName(fullKeyName, tableName);
                if ("PRIMARY".equals(keyName)) {
                    List<String> pks = ModelSchemaUtil.getPrimaryKeys(targetModelTable.getColumns());
                    TableIndex pkIndex = new TableIndex("PRIMARY", pks);
                    pkIndex.setType(IndexTypeEnum.PRIMARY_KEY);
                    returnValue = this.getIndexColumnI18n(pkIndex, targetModelTable);
                } else if (indexesMap.containsKey(keyName)) {
                    TableIndex tableIndex = (TableIndex)indexesMap.get(keyName);
                    returnValue = this.getIndexColumnI18n(tableIndex, targetModelTable);
                }
                if (CollectionUtils.isNotEmpty(returnValue)) {
                    Map insertKeyValueMap = (Map)sqlInfoMap.get("indexKeyInfo");
                    for (Map<String, Object> member : returnValue) {
                        String columnName = (String)member.get("indexColumnName");
                        Object value = insertKeyValueMap.get(columnName);
                        member.put("indexColumnValue", value);
                    }
                }
            }
            catch (JSQLParserException e) {
                log.warn(e.getMessage());
            }
        }
        return returnValue;
    }

    public List<TableColumn> getValidTableColumns(ModelTable targetModelTable, List<String> indexMembers) {
        List<TableColumn> targetColumns = new ArrayList<TableColumn>();
        if (CollectionUtils.isNotEmpty(indexMembers) && targetModelTable != null) {
            targetColumns = targetModelTable.getColumns().stream().filter(targetColumn -> indexMembers.stream().anyMatch(indexMemberName -> targetColumn.getColumnName().equals(indexMemberName))).collect(Collectors.toList());
        }
        return targetColumns;
    }

    @Deprecated
    public String getDuplicateKey(String throwSQLErrorMessage) {
        Matcher matcherDuplicateEntry = ModelDBConstants.PATTERN_DUPLICATE_ENTRY.matcher(throwSQLErrorMessage);
        if (matcherDuplicateEntry.find()) {
            String duplicateEntry = matcherDuplicateEntry.group(1);
            String key = matcherDuplicateEntry.group(2);
            return key;
        }
        return null;
    }

    public String getKeyName(String messageKeyName, String tableName) {
        if (StringUtils.contains((CharSequence)messageKeyName, (CharSequence)".")) {
            log.debug("{} key({}) contain '.', maybe MySQL 8.0 +", (Object)_CLASSTAG, (Object)messageKeyName);
            String[] keyNameSplit = messageKeyName.split(tableName + ".");
            String keyName = keyNameSplit[keyNameSplit.length - 1];
            return keyName;
        }
        return messageKeyName;
    }

    public List<Map<String, Object>> getIndexColumnI18n(TableIndex tableIndex, ModelTable targetModelTable) {
        LinkedList<Map<String, Object>> returnValue = new LinkedList<Map<String, Object>>();
        if (Objects.nonNull(tableIndex)) {
            String locale = DWServiceContext.getContext().getRequestHeader().getOrDefault("locale", this.localContextLocal).toString();
            List<String> indexMembers = tableIndex.getMember();
            List<TableColumn> targetColumns = this.getValidTableColumns(targetModelTable, indexMembers);
            for (TableColumn tableColumn : targetColumns) {
                Map<String, Object> memberInfo = this.getColumnI18n(tableColumn, locale);
                returnValue.add(memberInfo);
            }
        }
        return returnValue;
    }

    public Map<String, Object> getColumnI18n(TableColumn tableColumn, String locale) {
        HashMap<String, Object> columnI18nInfo = new HashMap<String, Object>();
        columnI18nInfo.put("indexColumnName", tableColumn.getColumnName());
        String columni18nOrComment = DBColumnUtil.getMessageLang(tableColumn, locale);
        columnI18nInfo.put("indexColumnComment", columni18nOrComment);
        return columnI18nInfo;
    }
}

