/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils.compare;

import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.compare.ColumnCompareUtil;
import com.digiwin.lcdp.modeldriven.utils.compare.IndexCompareUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelNewSqlGenerator {
    private static final Logger log = LoggerFactory.getLogger(ModelNewSqlGenerator.class);
    private static final String _CLASSTAG = "[" + ModelNewSqlGenerator.class.getSimpleName() + "]";

    public static SqlParam generateInsertRdbmsTableSql(ModelTable modelTable) {
        return new SqlParam("insert into dw_rdbms_tables  (table_name, table_display_name, table_description, delete_constraint) values(?, ?, ?, 'N') ON DUPLICATE KEY UPDATE table_name=?, table_display_name=?, table_description=?", new Object[]{modelTable.getName(), modelTable.getComment(), modelTable.getComment(), modelTable.getName(), modelTable.getComment(), modelTable.getComment()});
    }

    public static List<SqlParam> generateInsertOrUpdateRdbmsFieldSql(ModelTable modelTable) {
        LinkedList<SqlParam> returnValue = new LinkedList<SqlParam>();
        if (ModelDrivenContext.getContext().isNewModelPublish()) {
            Object[] sqlParamParamsForReset = new Object[]{modelTable.getName()};
            SqlParam sqlParamForResetPkAutoicmt = new SqlParam("update dw_rdbms_fields  set is_key = 'N', is_auto_increment = 'N' where table_name = ?", sqlParamParamsForReset);
            returnValue.add(sqlParamForResetPkAutoicmt);
        }
        for (TableColumn tableColumn : modelTable.getColumns()) {
            SqlParam sqlParam = ModelNewSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(modelTable.getName(), tableColumn);
            returnValue.add(sqlParam);
        }
        return returnValue;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> getCreateChildTablesCommand(String primaryTableName, String primaryKeyName, List<ModelTable> childrenTables, String foreignKeyName) {
        LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        for (ModelTable modelTable : childrenTables) {
            LinkedHashMap childDDMLValue = new LinkedHashMap();
            String childTableName = modelTable.getName();
            ArrayList<SqlParam> dmlSqlParams = new ArrayList<SqlParam>();
            ArrayList<SqlParam> ddlSqlParams = new ArrayList<SqlParam>();
            SqlParam insertRdbmsTableParam = ModelNewSqlGenerator.generateInsertRdbmsTableSql(modelTable);
            dmlSqlParams.add(insertRdbmsTableParam);
            List<SqlParam> insertOrUpdateRdbmsFieldsParam = ModelNewSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(modelTable);
            dmlSqlParams.addAll(insertOrUpdateRdbmsFieldsParam);
            childDDMLValue.put("dml", dmlSqlParams);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> modelTable({}) gen Insert Rdbms Table, SQL({})", (Object)childTableName, (Object)insertRdbmsTableParam);
                log.debug(">>>>> modelTable({}) gen Insert Rdbms Fields, size({})", (Object)childTableName, (Object)insertOrUpdateRdbmsFieldsParam.size());
            }
            SqlParam createTableSqlParam = ModelNewSqlGenerator.generateCreateTableSql(modelTable);
            log.debug(">>>>> modelTable({}) gen Create Table, SQL({})", (Object)childTableName, (Object)createTableSqlParam);
            ddlSqlParams.add(createTableSqlParam);
            childDDMLValue.put("ddl", ddlSqlParams);
            returnValue.put(childTableName, childDDMLValue);
        }
        return returnValue;
    }

    public static SqlParam generateCreateTableSql(ModelTable modelTable) {
        String indexSql;
        String pkCondtionSql;
        ArrayList params = new ArrayList();
        String tableName = modelTable.getName();
        String tableComment = modelTable.getComment();
        String columnsSql = modelTable.getColumns().stream().map(column -> String.format("`%s` %s %s %s %s %s '%s' ", column.getColumnName(), ColumnCompareUtil.getTypeDDL(column), ColumnCompareUtil.getNullableEnum(column.nullable()).getSqlChar(), ColumnCompareUtil.columnUniqueValue(column.getUnique()), ColumnCompareUtil.getSqlByAutoIncrementOrDefaultValue(column), "COMMENT", column.getComment())).collect(Collectors.joining(" , "));
        ArrayList<String> constraints = new ArrayList<String>();
        TableIndex draftPkTableColumn = modelTable.getIndexes().stream().filter(index -> index.getType() == IndexTypeEnum.PRIMARY_KEY).findFirst().orElse(null);
        if (draftPkTableColumn != null && StringUtils.isNotBlank((CharSequence)(pkCondtionSql = IndexCompareUtil.generatePrimaryKeySql(draftPkTableColumn.getMember())))) {
            constraints.add(pkCondtionSql);
        }
        if (StringUtils.isNotBlank((CharSequence)(indexSql = IndexCompareUtil.generateIndexes(modelTable.getIndexes())))) {
            constraints.add(indexSql);
        }
        String constraintsSql = String.join((CharSequence)", ", constraints);
        String createTableSql = String.format("CREATE TABLE IF NOT EXISTS `%s` ( %s , %s ) COMMENT='%s' CHARACTER SET = '%s' COLLATE='%s' ENGINE=InnoDB", tableName, columnsSql, constraintsSql, tableComment, "utf8mb4", "utf8mb4_bin");
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(createTableSql);
        sqlParam.setParams(params.toArray());
        return sqlParam;
    }

    public static SqlParam generateInsertOrUpdateRdbmsFieldSql(String tableName, TableColumn tableColumn) {
        String isPk = ColumnCompareUtil.booleanToYN(tableColumn.isPK());
        String defaultValue = tableColumn.getDefaultValue() != null ? tableColumn.getDefaultValue() : "null";
        Integer size = ColumnCompareUtil.getUpdateSize(tableColumn.getSize(), tableColumn.getDataType().getDefaultSize());
        Integer scale = ColumnCompareUtil.getUpdateSize(tableColumn.getScale(), tableColumn.getDataType().getDefaultScale());
        String nullable = ColumnCompareUtil.booleanToYN(tableColumn.nullable());
        String autoIncrement = ColumnCompareUtil.booleanToYN(tableColumn.getAutoIncrement() != false || tableColumn.getAutoIncrement() != false);
        Object[] sqlParamParams = new Object[]{tableName, tableColumn.getSeq(), tableColumn.getColumnName(), isPk, tableColumn.getDataType().getName(), tableColumn.getComment(), defaultValue, nullable, size, scale, autoIncrement, tableName, tableColumn.getSeq(), tableColumn.getColumnName(), isPk, tableColumn.getDataType().getName(), tableColumn.getComment(), defaultValue, nullable, size, scale, autoIncrement};
        return new SqlParam("insert into dw_rdbms_fields  (table_name, seq, field_name, is_key, field_type, status_code, field_display_name, default_value, nullable, is_version, size, scale, is_auto_increment)  values (?, ?, ?, ?, ?, 'N', ?, ?, ?, 'N', ?, ?, ?)  ON DUPLICATE KEY UPDATE table_name=?, seq=?, field_name=?, is_key=?, field_type=?, status_code='N', field_display_name=?, default_value=?, nullable=?, is_version='N', size=?, scale=?, is_auto_increment=? ", sqlParamParams);
    }

    public static SqlParam generateInsertServiceMappingSql(ModelTable modelTable) {
        String modelDrivenProdPrefix = (String)ModelDrivenContext.getContext().getExtraMap().getOrDefault("modelDrivenProdPrefix", "");
        String tableName = modelTable.getName();
        String prefixEaiId = EaiServiceNameUtil.getEaiPrefixName(modelDrivenProdPrefix, tableName);
        String insertServiceMappingSql = "insert into dw_service_mapping(table_name, expose_eai_id) values(?, ?) ON DUPLICATE KEY UPDATE table_name=? ,expose_eai_id=? ";
        return new SqlParam(insertServiceMappingSql, new Object[]{tableName, prefixEaiId, tableName, prefixEaiId});
    }
}

