/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.common.crypto.aes;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AESUtil {
    public static String generateKey(String seed) throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.setSeed(seed.getBytes(StandardCharsets.UTF_8));
        keyGenerator.init(192, secureRandom);
        SecretKey secretKey = keyGenerator.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        return AESUtil.byte2hex(enCodeFormat);
    }

    public static String encrypt(String secretKey, String content) throws Exception {
        byte[] enCodeFormat = AESUtil.hex2byte(secretKey);
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, key);
        byte[] bytes = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
        return AESUtil.byte2hex(bytes);
    }

    public static String decrypt(String secretKey, String content) throws IllegalArgumentException {
        try {
            if (content == null || content.length() < 2) {
                return content;
            }
            byte[] enCodeFormat = AESUtil.hex2byte(secretKey);
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, key);
            byte[] result = cipher.doFinal(AESUtil.hex2byte(content));
            return new String(result, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u89e3\u5bc6\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private static String byte2hex(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        String tmp = "";
        for (byte aB : b) {
            tmp = Integer.toHexString(aB & 0xFF);
            if (tmp.length() == 1) {
                sb.append("0");
            }
            sb.append(tmp);
        }
        return sb.toString().toUpperCase();
    }

    private static byte[] hex2byte(String inputString) {
        if (inputString == null || inputString.length() < 2) {
            return new byte[0];
        }
        inputString = inputString.toLowerCase();
        int l = inputString.length() / 2;
        byte[] result = new byte[l];
        for (int i = 0; i < l; ++i) {
            String tmp = inputString.substring(2 * i, 2 * i + 2);
            result[i] = (byte)(Integer.parseInt(tmp, 16) & 0xFF);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(AESUtil.decrypt("550F743242C486791EDBDEDEE3498BAA", "4E7865BC5C58A9367227497724343A11CDBB79744C4C7F6D613793133F94CA29"));
        System.out.println(AESUtil.decrypt("550F743242C486791EDBDEDEE3498BAA", ""));
        System.out.println(AESUtil.encrypt("550F743242C486791EDBDEDEE3498BAA", "wangjwc@digiwin.com"));
    }
}

