/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.common.datetime;

import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateTimeUtil {
    private static final Logger log = LoggerFactory.getLogger(DateTimeUtil.class);
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    public static final DateTimeFormatter DEFAULT_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final String DEFAULT_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final DateTimeFormatter DEFAULT_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final String MIN_DATETIME_USE_DEFAULT_PATTERN = "1970-01-01 00:00:00";
    public static final String MOBILE_SHOW_DEFAULT_DATE_PATTERN = "yyyy.MM.dd";
    public static final DateTimeFormatter MOBILE_SHOW_DEFAULT_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy.MM.dd");

    public static LocalDateTime parseUseDefaultPattern(String dateTime) {
        if (null == dateTime || dateTime.trim().isEmpty()) {
            return LocalDateTime.MIN;
        }
        return LocalDateTime.parse(dateTime, DEFAULT_DATETIME_FORMATTER);
    }

    public static LocalDate parseLocalDateUseDefaultPattern(String date) {
        if (null == date || date.trim().isEmpty()) {
            return LocalDate.MIN;
        }
        return LocalDate.parse(date, DEFAULT_DATE_FORMATTER);
    }

    public static String getTodayDateTextInMobileShowDefaultPattern() {
        LocalDate localDate = LocalDate.now();
        return String.format("%s.%s.%s", localDate.getYear(), DateTimeUtil.getFullMonth(localDate.getMonthValue()), DateTimeUtil.getFullDate(localDate.getDayOfMonth()));
    }

    public static String getDateTextInMobileShowDefaultPattern(String defaultDatePatternText) {
        LocalDate localDate;
        if (null == defaultDatePatternText || defaultDatePatternText.isEmpty()) {
            return "";
        }
        try {
            localDate = LocalDate.parse(defaultDatePatternText, DEFAULT_DATE_FORMATTER);
        }
        catch (Exception e) {
            return defaultDatePatternText;
        }
        return String.format("%s.%s.%s", localDate.getYear(), DateTimeUtil.getFullMonth(localDate.getMonthValue()), DateTimeUtil.getFullDate(localDate.getDayOfMonth()));
    }

    public static String getTimeDistanceFromStartToEnd(String startTime, String endTime) {
        String endDateString;
        LocalDateTime start = DateTimeUtil.parseUseDefaultPattern(startTime);
        LocalDateTime end = DateTimeUtil.parseUseDefaultPattern(endTime);
        String dateThisYearFormat = "%s.%s";
        String dateNotThisYearFormat = "%s.%s.%s";
        LocalDate startDate = start.toLocalDate();
        LocalDate endDate = end.toLocalDate();
        LocalDate today = LocalDate.now();
        String startDateString = startDate.getYear() == today.getYear() ? String.format(dateThisYearFormat, DateTimeUtil.getFullMonth(startDate.getMonthValue()), DateTimeUtil.getFullDate(startDate.getDayOfMonth())) : String.format(dateNotThisYearFormat, startDate.getYear(), DateTimeUtil.getFullMonth(startDate.getMonthValue()), DateTimeUtil.getFullDate(startDate.getDayOfMonth()));
        String string = endDateString = endDate.getYear() == today.getYear() ? String.format(dateThisYearFormat, DateTimeUtil.getFullMonth(endDate.getMonthValue()), DateTimeUtil.getFullDate(endDate.getDayOfMonth())) : String.format(dateNotThisYearFormat, endDate.getYear(), DateTimeUtil.getFullMonth(endDate.getMonthValue()), DateTimeUtil.getFullDate(endDate.getDayOfMonth()));
        if (startDateString.trim().equalsIgnoreCase(endDateString.trim())) {
            return startDateString;
        }
        return String.format("%s-%s", startDateString, endDateString);
    }

    public static String getDateDistanceFromStartToEnd(String startDate, String endDate) {
        return DateTimeUtil.getTimeDistanceFromStartToEnd(startDate + " 00:00:00", endDate + " 00:00:00");
    }

    public static String getFullYear(Integer year) {
        return String.format("%04d", year);
    }

    public static String getFullMonth(Integer month) {
        return String.format("%02d", month);
    }

    public static String getFullDate(Integer day) {
        return String.format("%02d", day);
    }

    public static String getFullHour(Integer hour) {
        return String.format("%02d", hour);
    }

    public static String getFullMinute(Integer minute) {
        return String.format("%02d", minute);
    }

    public static Boolean isTodayTime(String otherTimeStringUseDefaultPattern) {
        LocalDateTime otherTime = DateTimeUtil.parseUseDefaultPattern(otherTimeStringUseDefaultPattern);
        LocalDate otherDate = otherTime.toLocalDate();
        return otherDate.equals(LocalDate.now());
    }

    public static Boolean isBeforeNowDateTime(String otherDateTimeStr) {
        LocalDateTime localDateTime = DateTimeUtil.parseUseDefaultPattern(otherDateTimeStr);
        return localDateTime.isBefore(LocalDateTime.now());
    }

    public static Boolean isAfterNowDatetime(String otherDateTimeStr) {
        LocalDateTime localDateTime = DateTimeUtil.parseUseDefaultPattern(otherDateTimeStr);
        return localDateTime.isAfter(LocalDateTime.now());
    }

    public static Boolean isEqualNowDatetime(String otherDateTimeStr) {
        LocalDateTime localDateTime = DateTimeUtil.parseUseDefaultPattern(otherDateTimeStr);
        return localDateTime.isEqual(LocalDateTime.now());
    }

    public static Boolean isBeforeNowDate(String otherDateStr) {
        LocalDate otherDate = DateTimeUtil.parseLocalDateUseDefaultPattern(otherDateStr);
        return otherDate.isBefore(LocalDate.now());
    }

    public static Boolean isAfterNowDate(String otherDateStr) {
        LocalDate otherDate = DateTimeUtil.parseLocalDateUseDefaultPattern(otherDateStr);
        return otherDate.isAfter(LocalDate.now());
    }

    public static Boolean isEqualNowDate(String otherDateStr) {
        LocalDate otherDate = DateTimeUtil.parseLocalDateUseDefaultPattern(otherDateStr);
        return otherDate.isEqual(LocalDate.now());
    }

    public static String getMonthDateOfTime(String otherTimeStringUseDefaultPattern) {
        LocalDateTime localDateTime = DateTimeUtil.parseUseDefaultPattern(otherTimeStringUseDefaultPattern);
        return String.format("%s.%s", DateTimeUtil.getFullMonth(localDateTime.getMonthValue()), DateTimeUtil.getFullDate(localDateTime.getDayOfMonth()));
    }

    public static String getYearMonthOfTime(String otherTimeStringUseDefaultPattern) {
        LocalDateTime localDateTime = DateTimeUtil.parseUseDefaultPattern(otherTimeStringUseDefaultPattern);
        return String.format("%s-%s", DateTimeUtil.getFullDate(localDateTime.getYear()), DateTimeUtil.getFullDate(localDateTime.getMonthValue()));
    }

    public static String getTodayUseSpecifiedPattern(String pattern) {
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(pattern);
        return LocalDate.now().format(dateFormatter);
    }

    public static String getTodayTimeUseDefaultPattern() {
        return LocalDateTime.now().format(DEFAULT_DATETIME_FORMATTER);
    }

    public static String getTodayUseDefaultPattern() {
        return LocalDate.now().format(DEFAULT_DATE_FORMATTER);
    }

    public static String getTodayByPattern(String pattern) {
        if (StringUtils.isBlank((CharSequence)pattern)) {
            pattern = DEFAULT_DATE_PATTERN;
        }
        DateTimeFormatter DEFAULT_DATE_FORMATTER = DateTimeFormatter.ofPattern(pattern);
        return LocalDate.now().format(DEFAULT_DATE_FORMATTER);
    }

    public static String getInputCalendarDateUseDefaultPattern(@NotNull(message="\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a") @Pattern(regexp="^\\d{4}$", message="\u5e74\u4efd\u683c\u5f0f\u4e0d\u7b26\u5408") @NotNull(message="\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a") @Pattern(regexp="^\\d{4}$", message="\u5e74\u4efd\u683c\u5f0f\u4e0d\u7b26\u5408") String year, @NotNull(message="\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a") @Pattern(regexp="^0\\d[1-9]|\\d[10-12]$", message="\u6708\u4efd\u683c\u5f0f\u4e0d\u7b26\u5408") @NotNull(message="\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a") @Pattern(regexp="^0\\d[1-9]|\\d[10-12]$", message="\u6708\u4efd\u683c\u5f0f\u4e0d\u7b26\u5408") String month, @NotNull(message="\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a") @Pattern(regexp="^0\\d[1-9]|\\d[10-31]$", message="\u65e5\u671f\u683c\u5f0f\u4e0d\u7b26\u5408") @NotNull(message="\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a") @Pattern(regexp="^0\\d[1-9]|\\d[10-31]$", message="\u65e5\u671f\u683c\u5f0f\u4e0d\u7b26\u5408") String date) {
        LocalDate localDate = LocalDate.of(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(date));
        return DEFAULT_DATE_FORMATTER.format(localDate);
    }

    public static String getInputCalendarDateUseDefaultPattern(@NotNull(message="\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a") @Pattern(regexp="^\\d{4}-\\d{2}-\\d{2}\\s00:00:00.000$", message="\u65e5\u671f\u683c\u5f0f\u4e0d\u7b26\u5408") @NotNull(message="\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a") @Pattern(regexp="^\\d{4}-\\d{2}-\\d{2}\\s00:00:00.000$", message="\u65e5\u671f\u683c\u5f0f\u4e0d\u7b26\u5408") String inputCalendarDate) {
        return inputCalendarDate.substring(0, 10).replace(".", "-");
    }

    public static boolean isDateUseDefaultPattern(String dateToTest) {
        java.util.regex.Pattern p = java.util.regex.Pattern.compile("([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-9])))");
        return p.matcher(dateToTest).find();
    }

    public static long getDatePeriod(String startDateStringUseDefaultPattern, String endDateStringUseDefaultPattern) {
        int errorResult = -1;
        if (!DateTimeUtil.isDateUseDefaultPattern(startDateStringUseDefaultPattern) || !DateTimeUtil.isDateUseDefaultPattern(endDateStringUseDefaultPattern)) {
            return errorResult;
        }
        if (StringUtil.isEmpty(startDateStringUseDefaultPattern) || StringUtil.isEmpty(endDateStringUseDefaultPattern)) {
            return errorResult;
        }
        LocalDate startDate = DateTimeUtil.parseLocalDateUseDefaultPattern(startDateStringUseDefaultPattern);
        LocalDate endDate = DateTimeUtil.parseLocalDateUseDefaultPattern(endDateStringUseDefaultPattern);
        return Math.abs(endDate.toEpochDay() - startDate.toEpochDay());
    }

    public static Boolean compareTime(String dateTimeStr1, String dateTimeStr2) {
        if (!DateTimeUtil.isDateUseDefaultPattern(dateTimeStr1) || !DateTimeUtil.isDateUseDefaultPattern(dateTimeStr2)) {
            return false;
        }
        LocalDateTime dateTime1 = DateTimeUtil.parseUseDefaultPattern(dateTimeStr1);
        LocalDateTime dateTime2 = DateTimeUtil.parseUseDefaultPattern(dateTimeStr2);
        return dateTime1.isBefore(dateTime2);
    }

    public static int getDateTimePeriod(String startDateTimeStr, String endDateTimeStr) {
        LocalDateTime endDateTime;
        if (!DateTimeUtil.isDateUseDefaultPattern(startDateTimeStr) || !DateTimeUtil.isDateUseDefaultPattern(endDateTimeStr)) {
            return 0;
        }
        LocalDateTime startDateTime = DateTimeUtil.parseUseDefaultPattern(startDateTimeStr);
        if (startDateTime.isAfter(endDateTime = DateTimeUtil.parseUseDefaultPattern(endDateTimeStr))) {
            return 0;
        }
        long secondPeriod = endDateTime.toEpochSecond(ZoneOffset.of("+8")) - startDateTime.toEpochSecond(ZoneOffset.of("+8"));
        return (int)(secondPeriod / 60L / 60L / 24L);
    }

    public static String getSevthDate(String pattern) {
        if (StringUtils.isBlank((CharSequence)pattern)) {
            pattern = DEFAULT_DATE_PATTERN;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Date date = DateUtils.addDays((Date)new Date(), (int)7);
        return sdf.format(date);
    }

    public static String getOneMonthDate(String pattern) {
        if (StringUtils.isBlank((CharSequence)pattern)) {
            pattern = DEFAULT_DATE_PATTERN;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Date date = DateUtils.addDays((Date)new Date(), (int)30);
        return sdf.format(date);
    }

    public static String currentDateAddYears(String pattern, int years) {
        if (StringUtils.isBlank((CharSequence)pattern)) {
            pattern = DEFAULT_DATE_PATTERN;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Date date = DateUtils.addYears((Date)new Date(), (int)years);
        return sdf.format(date);
    }

    public static String firstDayOfPreviousMonth(String pattern, int monthsToSubtract) {
        LocalDate date = monthsToSubtract == 0 ? LocalDate.now() : LocalDate.now().minusMonths(monthsToSubtract);
        LocalDate firstDay = LocalDate.of(date.getYear(), date.getMonth(), 1);
        LocalDateTime startTime = LocalDateTime.of(firstDay, LocalTime.MIN);
        return startTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String dateOfPreviousMonth(DateTimeFormatter dateTimeFormatter, int monthsToSubtract) {
        LocalDate date = monthsToSubtract == 0 ? LocalDate.now() : LocalDate.now().minusMonths(monthsToSubtract);
        return date.format(dateTimeFormatter);
    }

    public static String convert(String time, String defaultDatePattern) {
        StringBuffer newTime = new StringBuffer();
        if (time.contains(".")) {
            String[] times = time.split("\\.");
            newTime.append(times[0]).append("-").append(times[1]).append("-").append(times[2]);
            return newTime.toString();
        }
        return time;
    }

    public static Map<String, Object> getNowDateMap() {
        HashMap<String, Object> dateMap = new HashMap<String, Object>(3);
        LocalDate localDate = LocalDate.now();
        dateMap.put("year", String.valueOf(localDate.getYear()));
        dateMap.put("month", String.valueOf(localDate.getMonthValue()));
        dateMap.put("date", String.valueOf(localDate.getDayOfMonth()));
        return dateMap;
    }

    public static Boolean compareTimeHourMinute(String startTime, String endTime) {
        LocalDateTime start = DateTimeUtil.parseUseDefaultPattern(startTime);
        LocalDateTime end = DateTimeUtil.parseUseDefaultPattern(endTime);
        String startTimeText = String.format("%s:%s", DateTimeUtil.getFullHour(start.getHour()), DateTimeUtil.getFullMinute(start.getMinute()));
        String endTimeText = String.format("%s:%s", DateTimeUtil.getFullHour(end.getHour()), DateTimeUtil.getFullMinute(end.getMinute()));
        int i = startTimeText.compareTo(endTimeText);
        return i >= 0;
    }

    public static int getWorkingDaysBetweenDates(String startDateStr, String endDateStr) {
        int workingDays = 0;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_DATE_PATTERN);
            Date startDate = sdf.parse(startDateStr);
            Date endDate = sdf.parse(endDateStr);
            Calendar startCal = Calendar.getInstance();
            startCal.setTime(startDate);
            Calendar endCal = Calendar.getInstance();
            endCal.setTime(endDate);
            while (startCal.before(endCal) || startCal.equals(endCal)) {
                if (startCal.get(7) != 7 && startCal.get(7) != 1) {
                    ++workingDays;
                }
                startCal.add(5, 1);
            }
        }
        catch (Exception e) {
            log.error("getWorkingDaysBetweenDates error ", (Throwable)e);
        }
        return workingDays;
    }
}

