/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.common.file;

import com.digiwin.mobile.mobileuibot.common.string.RegexUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public final class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);
    private static final String IMAGE_JPEG = "jpeg";
    private static final String IMAGE_JPG = "jpg";
    private static final String IMAGE_BMP = "bmp";
    private static final String IMAGE_PNG = "png";
    private static final String[] FILE_IMAGE_EXTENSIONS = new String[]{"jpeg", "jpg", "bmp", "png"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(String filePath) {
        InputStream inputStream = null;
        StringBuilder data = new StringBuilder();
        try {
            ClassPathResource classPathResource = new ClassPathResource(filePath);
            inputStream = classPathResource.getInputStream();
            byte[] buffer = new byte[4096];
            int count = 0;
            while ((count = inputStream.read(buffer)) > 0) {
                data.append(new String(buffer, 0, count, StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error(e.getLocalizedMessage());
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    logger.error(e.getLocalizedMessage());
                }
            }
        }
        return data.toString();
    }

    public static File multipartFileToFile(MultipartFile file) {
        File toFile = null;
        try {
            if (file.getName().isEmpty() || file.getSize() <= 0L) {
                file = null;
            } else {
                InputStream ins = null;
                ins = file.getInputStream();
                toFile = new File(Objects.requireNonNull(file.getOriginalFilename()));
                FileUtil.inputStreamToFile(ins, toFile);
                ins.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return toFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void inputStreamToFile(InputStream ins, File file) {
        OutputStream os = null;
        try {
            os = Files.newOutputStream(file.toPath(), new OpenOption[0]);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ins.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.close();
            ins.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    logger.error("OutputStream close exception");
                }
            }
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    logger.error("InputStream close exception");
                }
            }
        }
    }

    public static String getFileExtension(String fileName) {
        int fileExtensionIdx = fileName.lastIndexOf(".");
        if (fileExtensionIdx == -1) {
            return "";
        }
        String fileExtension = fileName.substring(fileExtensionIdx + 1);
        if (RegexUtil.isMatch(RegexUtil.PATTERN_REGEX_NUMBER_ALPHABET_WORD, (CharSequence)fileExtension)) {
            return fileExtension;
        }
        return "";
    }

    public static boolean isImage(String fileName) {
        String extension = FileUtil.getFileExtension(fileName);
        for (String e : FILE_IMAGE_EXTENSIONS) {
            if (!extension.toLowerCase().equals(e)) continue;
            return true;
        }
        return false;
    }

    public static boolean fileExtendNameIsImage(String fileExtendName) {
        if (!StringUtils.hasLength((String)fileExtendName)) {
            return false;
        }
        for (String e : FILE_IMAGE_EXTENSIONS) {
            if (!fileExtendName.toLowerCase().equals(e)) continue;
            return true;
        }
        return false;
    }
}

