/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.common.json;

import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

public final class JsonUtil {
    private static JsonFactory _factory = new JsonFactory();
    private static ObjectMapper _objectMapper = new ObjectMapper(_factory);

    public static String javaObjectToJsonString(Object object) {
        String jsonString = "";
        if (null != object) {
            try {
                jsonString = _objectMapper.writeValueAsString(object);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                throw new ServiceException(e.getMessage());
            }
        }
        return jsonString;
    }

    public static <T> T objectToJavaObject(Object object, Class<T> targetClazz) {
        try {
            String temp = _objectMapper.writeValueAsString(object);
            return (T)_objectMapper.readValue(temp, targetClazz);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new ServiceException(e.getMessage());
        }
    }

    public static <T> T objectToJavaObject(Object object, TypeReference<T> tTypeReference) {
        try {
            String temp = _objectMapper.writeValueAsString(object);
            return (T)_objectMapper.readValue(temp, tTypeReference);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new ServiceException(e.getMessage());
        }
    }

    public static <T> T objectToJavaObject(Object object, JavaType javaType) {
        try {
            String temp = _objectMapper.writeValueAsString(object);
            return (T)_objectMapper.readValue(temp, javaType);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new ServiceException(e.getMessage());
        }
    }

    public static <T> T jsonStringToObject(String jsonString, Class<T> targetClazz) {
        try {
            return (T)_objectMapper.readValue(jsonString, targetClazz);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new ServiceException(e.getMessage());
        }
    }

    public static <T> T jsonStringToObject(String jsonString, TypeReference<T> tTypeReference) {
        try {
            return (T)_objectMapper.readValue(jsonString, tTypeReference);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new ServiceException(e.getMessage());
        }
    }

    public static <T> T jsonStringToObject(String jsonString, JavaType javaType) {
        try {
            return (T)_objectMapper.readValue(jsonString, javaType);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new ServiceException(e.getMessage());
        }
    }

    static {
        _factory.configure(JsonGenerator.Feature.IGNORE_UNKNOWN, true);
        _objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        _objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        _objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

