/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.common.reflection;

import java.io.File;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);

    public static <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        Set<Class<?>> classes = ReflectionUtils.getClasses(type.getPackage().getName());
        HashSet<Class<T>> collect = new HashSet<Class<T>>();
        for (Class<?> aClass : classes) {
            if (type.equals(aClass) || !type.isAssignableFrom(aClass) || aClass.isInterface() || Modifier.isAbstract(aClass.getModifiers())) continue;
            collect.add(aClass);
        }
        return collect;
    }

    public static Set<Class<?>> getClasses(String packageName) {
        HashSet classSet = new HashSet();
        try {
            String sourcePath = packageName.replace(".", "/");
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(sourcePath);
            while (urls.hasMoreElements()) {
                JarFile jarFile;
                JarURLConnection jarURLConnection;
                URL url = urls.nextElement();
                if (url == null) continue;
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String packagePath = url.getPath().replaceAll("%20", " ");
                    ReflectionUtils.addClass(classSet, packagePath, packageName);
                    continue;
                }
                if (!"jar".equals(protocol) || (jarURLConnection = (JarURLConnection)url.openConnection()) == null || (jarFile = jarURLConnection.getJarFile()) == null) continue;
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    String jarEntryName = jarEntry.getName();
                    if (!jarEntryName.contains(sourcePath) || !jarEntryName.endsWith(".class")) continue;
                    String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", ".");
                    ReflectionUtils.doAddClass(classSet, className);
                }
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5b50\u7c7b\u5931\u8d25", (Throwable)e);
        }
        return classSet;
    }

    private static void addClass(Set<Class<?>> classSet, String packagePath, String packageName) {
        File[] files;
        for (File file2 : files = new File(packagePath).listFiles(file -> file.isFile() && file.getName().endsWith(".class") || file.isDirectory())) {
            String fileName = file2.getName();
            if (file2.isFile()) {
                String className = fileName.substring(0, fileName.lastIndexOf("."));
                if (StringUtils.hasLength((String)packageName)) {
                    className = packageName + "." + className;
                }
                ReflectionUtils.doAddClass(classSet, className);
                continue;
            }
            String subPackagePath = fileName;
            if (StringUtils.hasLength((String)packagePath)) {
                subPackagePath = packagePath + "/" + subPackagePath;
            }
            String subPackageName = fileName;
            if (StringUtils.hasLength((String)packageName)) {
                subPackageName = packageName + "." + subPackageName;
            }
            ReflectionUtils.addClass(classSet, subPackagePath, subPackageName);
        }
    }

    public static Class<?> loadClass(String className, boolean isInitialized) {
        Class<?> cls;
        try {
            cls = Class.forName(className, isInitialized, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return cls;
    }

    public static Class<?> loadClass(String className) {
        return ReflectionUtils.loadClass(className, true);
    }

    private static void doAddClass(Set<Class<?>> classSet, String className) {
        Class<?> cls = ReflectionUtils.loadClass(className, false);
        classSet.add(cls);
    }
}

