/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.common.string;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public final class StringUtil {
    public static final String SOURCE_ATHENA = "athena";

    public static String clearEscapeControlCharacter(String inputString) {
        return inputString.replace("\r", "").replace("\n", "").replace("\f", "").replace("\t", "").replace("\b", "");
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isEmpty(Object obj) {
        return obj == null || ((String)obj).length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtil.isEmpty(cs);
    }

    public static boolean isNotEmpty(Object obj) {
        return !StringUtil.isEmpty(obj);
    }

    public static String valueOf(Object o) {
        return null == o ? "" : o.toString();
    }

    public static String applyLineFeed(String content) {
        if (null == content) {
            return content;
        }
        return content.replace("<br>", "\r\n").replace("<br/>", "\r\n").replace("</br>", "\r\n");
    }

    public static Map<String, String> parseQueryString(String queryString) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (queryString != null && !queryString.isEmpty()) {
            for (String param : queryString.split("&")) {
                String[] keyValue = param.split("=");
                if (keyValue.length == 2) {
                    try {
                        parameters.put(URLDecoder.decode(keyValue[0], "UTF-8"), URLDecoder.decode(keyValue[1], "UTF-8"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (keyValue.length != 1) continue;
                try {
                    parameters.put(URLDecoder.decode(keyValue[0], "UTF-8"), "");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return parameters;
    }

    public static String rebuildQueryStringFromMap(Map<String, String> queryStringParamsMap) {
        if (CollectionUtils.isEmpty(queryStringParamsMap)) {
            return "";
        }
        String queryString = "";
        StringBuilder queryStringBuilder = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : queryStringParamsMap.entrySet()) {
            if (first) {
                first = false;
            }
            try {
                queryStringBuilder.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8")).append("&");
            }
            catch (Exception exception) {}
        }
        queryString = queryStringBuilder.charAt(queryStringBuilder.length() - 1) == '&' ? queryStringBuilder.substring(0, queryStringBuilder.length()) : queryStringBuilder.toString();
        return queryString;
    }
}

