/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.common.currency;

import com.digiwin.mobile.mobileuibot.common.currency.MagnitudeUnit;
import java.text.DecimalFormat;

public final class CurrencyUtil {
    private CurrencyUtil() {
    }

    public static String fmtMicrometer(String text) {
        int i;
        DecimalFormat df = null;
        df = text.indexOf(".") > 0 ? ((i = text.length() - text.indexOf(".") - 1) == 0 ? new DecimalFormat("###,##0.") : (i == 1 ? new DecimalFormat("###,##0.0") : (i == 2 ? new DecimalFormat("###,##0.00") : (i == 3 ? new DecimalFormat("###,##0.000") : new DecimalFormat("###,##0.0000"))))) : new DecimalFormat("###,##0");
        double number = 0.0;
        try {
            number = Double.parseDouble(text);
        }
        catch (Exception e) {
            number = 0.0;
        }
        return df.format(number);
    }

    public static MagnitudeUnit getUnitOfMagnitudeByLocale(String locale, Double value) {
        MagnitudeUnit magnitudeUnit = new MagnitudeUnit();
        switch (locale) {
            case "en_US": {
                magnitudeUnit = CurrencyUtil.getUnitOfMagnitudeInEnUs(value);
                break;
            }
            case "zh_CN": {
                magnitudeUnit = CurrencyUtil.getUnitOfMagnitudeInZhCn(value);
                break;
            }
            case "zh_TW": {
                magnitudeUnit = CurrencyUtil.getUnitOfMagnitudeInZhTw(value);
                break;
            }
        }
        magnitudeUnit.setLocale(locale);
        return magnitudeUnit;
    }

    private static MagnitudeUnit getUnitOfMagnitudeInZhCn(Double value) {
        String unitText = "";
        Long level = 1L;
        if (Math.abs(value) >= 1.0E8) {
            unitText = "\u4ebf";
            level = 100000000L;
        } else if (Math.abs(value) >= 1.0E7) {
            unitText = "\u5343\u4e07";
            level = 10000000L;
        } else if (Math.abs(value) >= 10000.0) {
            unitText = "\u4e07";
            level = 10000L;
        } else {
            unitText = "";
        }
        return new MagnitudeUnit().setUnitText(unitText).setLevel(level);
    }

    private static MagnitudeUnit getUnitOfMagnitudeInZhTw(Double value) {
        String unitText = "";
        Long level = 1L;
        if (Math.abs(value) >= 1.0E8) {
            unitText = "\u5104";
            level = 100000000L;
        } else if (Math.abs(value) >= 1.0E7) {
            unitText = "\u5343\u842c";
            level = 10000000L;
        } else if (Math.abs(value) >= 10000.0) {
            unitText = "\u842c";
            level = 10000L;
        } else {
            unitText = "";
        }
        return new MagnitudeUnit().setUnitText(unitText).setLevel(level);
    }

    private static MagnitudeUnit getUnitOfMagnitudeInEnUs(Double value) {
        String unitText = "";
        Long level = 1L;
        if (Math.abs(value) >= 1.0E9) {
            unitText = "B";
            level = 1000000000L;
        } else if (Math.abs(value) >= 1000000.0) {
            unitText = "M";
            level = 1000000L;
        } else if (Math.abs(value) >= 1000.0) {
            unitText = "K";
            level = 1000L;
        } else {
            unitText = "";
        }
        return new MagnitudeUnit().setUnitText(unitText).setLevel(level);
    }
}

