/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.common.math;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class MathUtil {
    public static double getDecimalPoint(double d, int point) {
        BigDecimal bg = BigDecimal.valueOf(d);
        return bg.setScale(point, RoundingMode.FLOOR).doubleValue();
    }

    public static double getDecimalPoint(double d, int point, Boolean hasRound) {
        BigDecimal bg = BigDecimal.valueOf(d);
        double f = 0.0;
        f = hasRound != false ? bg.setScale(point, RoundingMode.HALF_UP).doubleValue() : MathUtil.getDecimalPoint(d, point);
        return f;
    }

    public static double doubleMathCalculation(double d1, double d2, String operatorType) {
        BigDecimal bigDecimal1 = new BigDecimal(String.valueOf(d1));
        BigDecimal bigDecimal2 = new BigDecimal(String.valueOf(d2));
        double resultValue = 0.0;
        switch (operatorType) {
            case "+": {
                resultValue = bigDecimal1.add(bigDecimal2).doubleValue();
                break;
            }
            case "-": {
                resultValue = bigDecimal1.subtract(bigDecimal2).doubleValue();
                break;
            }
            case "*": {
                resultValue = bigDecimal1.multiply(bigDecimal2).doubleValue();
                break;
            }
            case "/": {
                resultValue = bigDecimal1.divide(bigDecimal2, 2, 4).doubleValue();
                break;
            }
        }
        return resultValue;
    }

    public static String stripTrailingZerosInDoubleString(String doubleString) {
        String trailedZero;
        if (null == doubleString || doubleString.trim().isEmpty()) {
            return "";
        }
        if ("0".equals(doubleString)) {
            return "0";
        }
        int length = doubleString.length();
        int index = 0;
        for (int i = length - 1; i >= 0; --i) {
            char c = doubleString.charAt(i);
            if (c == '0') continue;
            if (c == '.') {
                index = i;
                break;
            }
            index = i + 1;
            break;
        }
        if ((trailedZero = doubleString.substring(0, index)).charAt((length = trailedZero.length()) - 1) == '.') {
            trailedZero = trailedZero.substring(0, length - 1);
        }
        return trailedZero;
    }

    public static Double[] findIrregularValues(Double[] rawValues, IrregularValueSearchStrategy strategy) {
        return null;
    }

    public static Double getFiveMultiplesRoundedValueByDigits(Double value, int roundingStrategy) {
        if (value == 0.0) {
            return value;
        }
        if (roundingStrategy == 0) {
            Double top2DigitsNumber = MathUtil.preprocessRoundedValueByDigits(value);
            if (value < 0.0) {
                if (top2DigitsNumber % 5.0 > 2.0) {
                    return MathUtil.ceilingToFiveMultiplesByDigitsIgnoreSign(value) * -1.0;
                }
                return MathUtil.flooringToFiveMultiplesByDigitsIgnoreSign(value) * -1.0;
            }
            if (top2DigitsNumber % 5.0 < 3.0) {
                return MathUtil.flooringToFiveMultiplesByDigitsIgnoreSign(value);
            }
            return MathUtil.ceilingToFiveMultiplesByDigitsIgnoreSign(value);
        }
        if (roundingStrategy == 1) {
            if (value < 0.0) {
                return MathUtil.flooringToFiveMultiplesByDigitsIgnoreSign(value) * -1.0;
            }
            return MathUtil.ceilingToFiveMultiplesByDigitsIgnoreSign(value);
        }
        if (roundingStrategy == -1) {
            if (value < 0.0) {
                return MathUtil.ceilingToFiveMultiplesByDigitsIgnoreSign(value) * -1.0;
            }
            return MathUtil.flooringToFiveMultiplesByDigitsIgnoreSign(value);
        }
        return value;
    }

    public static int getMinimumTimesToGreaterThanOne(Double value) {
        int n = 0;
        if (value == 0.0 || value >= 1.0) {
            return n;
        }
        Double prevValue = Math.abs(value);
        while (prevValue < 1.0) {
            prevValue = prevValue * 10.0;
            ++n;
        }
        return n;
    }

    public static Double getTwoMultiplesRoundedValueByDigits(Double value, int roundingStrategy) {
        return 0.0;
    }

    private static Double ceilingToFiveMultiplesByDigitsIgnoreSign(Double value) {
        String strIntValue;
        int m;
        int n;
        Double toRoundValue = value;
        if (value < 0.0) {
            toRoundValue = value * -1.0;
        }
        if (toRoundValue < 1.0) {
            int n2 = MathUtil.getMinimumTimesToGreaterThanOne(toRoundValue);
            Double newToRoundValue = toRoundValue * Math.pow(10.0, n2);
            long intValue = newToRoundValue.longValue();
            long ceiledIntValue = intValue % 5L == 0L ? intValue : (intValue / 5L + 1L) * 5L;
            if ((double)ceiledIntValue / 10.0 < toRoundValue) {
                ceiledIntValue = (intValue / 5L + 1L) * 5L;
            }
            return new Double((double)ceiledIntValue / Math.pow(10.0, n2));
        }
        if (toRoundValue >= 1.0 && toRoundValue < 5.0) {
            Double times = Math.ceil(toRoundValue / 0.5);
            return new Double(times * 0.5);
        }
        if (toRoundValue >= 5.0 && toRoundValue < 100.0) {
            long intValue = toRoundValue.longValue();
            long ceiledIntValue = intValue % 5L == 0L ? intValue : (intValue / 5L + 1L) * 5L;
            if ((double)ceiledIntValue < toRoundValue) {
                ceiledIntValue = (intValue / 5L + 1L) * 5L;
            }
            return new Double(ceiledIntValue);
        }
        long intValue = toRoundValue.longValue();
        long twoDigitsIntValue = intValue / (long)Math.pow(10.0, n = (m = (strIntValue = String.valueOf(intValue)).length()) - 2);
        long ceiledIntValue = twoDigitsIntValue % 5L == 0L ? twoDigitsIntValue : (twoDigitsIntValue / 5L + 1L) * 5L;
        if ((double)ceiledIntValue * Math.pow(10.0, n) < toRoundValue) {
            ceiledIntValue = (twoDigitsIntValue / 5L + 1L) * 5L;
        }
        return new Double((double)ceiledIntValue * Math.pow(10.0, n));
    }

    private static Double flooringToFiveMultiplesByDigitsIgnoreSign(Double value) {
        String strIntValue;
        int m;
        int n;
        Double toRoundValue = value;
        if (value < 0.0) {
            toRoundValue = value * -1.0;
        }
        if (toRoundValue < 1.0) {
            int n2 = MathUtil.getMinimumTimesToGreaterThanOne(toRoundValue);
            Double newToRoundValue = toRoundValue * Math.pow(10.0, n2);
            long intValue = newToRoundValue.longValue();
            long flooredIntValue = intValue % 5L == 0L ? intValue : intValue / 5L * 5L;
            return new Double((double)flooredIntValue / Math.pow(10.0, n2));
        }
        if (toRoundValue >= 1.0 && toRoundValue < 5.0) {
            Double times = Math.floor(toRoundValue / 0.5);
            return new Double(times * 0.5);
        }
        if (toRoundValue >= 5.0 && toRoundValue < 100.0) {
            long intValue = toRoundValue.longValue();
            long flooredIntValue = intValue % 5L == 0L ? intValue : intValue / 5L * 5L;
            return new Double(flooredIntValue);
        }
        long intValue = toRoundValue.longValue();
        long twoDigitsIntValue = intValue / (long)Math.pow(10.0, n = (m = (strIntValue = String.valueOf(intValue)).length()) - 2);
        long flooredIntValue = twoDigitsIntValue % 5L == 0L ? twoDigitsIntValue : twoDigitsIntValue / 5L * 5L;
        return new Double((double)flooredIntValue * Math.pow(10.0, n));
    }

    private static Double preprocessRoundedValueByDigits(Double value) {
        Double toPreprocessValue = value;
        if (value < 0.0) {
            toPreprocessValue = value * -1.0;
        }
        if (toPreprocessValue < 1.0) {
            int times = MathUtil.getMinimumTimesToGreaterThanOne(toPreprocessValue);
            Double newToRoundValue = toPreprocessValue * Math.pow(10.0, times);
            long intValue = newToRoundValue.longValue();
            return new Double(intValue);
        }
        if (toPreprocessValue >= 1.0 && toPreprocessValue < 100.0) {
            return toPreprocessValue;
        }
        long intValue = toPreprocessValue.longValue();
        String strIntValue = String.valueOf(intValue);
        int m = strIntValue.length();
        int n = m - 2;
        long twoDigitsIntValue = intValue / (long)Math.pow(10.0, n);
        return new Double(twoDigitsIntValue);
    }

    public static boolean canBeInteger(Double d) {
        if (d == null) {
            return false;
        }
        return (double)d.longValue() == d;
    }

    public static Double getMaxValueByAbs(Double d1, Double d2) {
        Double td1 = null == d1 ? 0.0 : d1;
        Double td2 = null == d2 ? 0.0 : d2;
        int compareResult = Double.compare(Math.abs(td1), Math.abs(td2));
        return compareResult >= 0 ? td1 : td2;
    }

    public static enum IrregularValueSearchStrategy {
        STATS_BASED,
        QUARTILE_BASED;

    }
}

