/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.common.url;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlUtil {
    private static final Logger log = LoggerFactory.getLogger(UrlUtil.class);

    public static String urlEncodeChinese(String url) {
        try {
            Matcher matcher = Pattern.compile("[\\u4e00-\\u9fa5]").matcher(url);
            String tmp = "";
            while (matcher.find()) {
                tmp = matcher.group();
                url = url.replaceAll(tmp, URLEncoder.encode(tmp, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("url Encode fail:{}", (Object)e.getMessage());
        }
        return url.replace(" ", "%20");
    }

    public static Map<String, String> parseUrl(String url) {
        String[] arrSplit;
        HashMap<String, String> mapRequest = new HashMap<String, String>();
        String strUrlParam = UrlUtil.truncateUrlPage(url);
        if (strUrlParam == null) {
            return mapRequest;
        }
        for (String strSplit : arrSplit = strUrlParam.split("[&]")) {
            String[] arrSplitEqual = strSplit.split("[=]");
            if (arrSplitEqual.length > 1) {
                mapRequest.put(arrSplitEqual[0], arrSplitEqual[1]);
                continue;
            }
            if (Objects.equals(arrSplitEqual[0], "")) continue;
            mapRequest.put(arrSplitEqual[0], "");
        }
        return mapRequest;
    }

    private static String truncateUrlPage(String strUrl) {
        String strAllParam = null;
        strUrl = strUrl.trim();
        String[] arrSplit = strUrl.split("[?]");
        if (strUrl.length() > 1 && arrSplit.length > 1 && arrSplit[1] != null) {
            strAllParam = arrSplit[1];
        }
        return strAllParam;
    }
}

