package com.digiwin.mobile.mobileuibot.dto;

import lombok.Data;

/**
 * <p>功能描述：版本管理 -- 分页查询请求类 </p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppClientPageDto.java
 * @Author: wangjwc
 * @Date: created at 2025/8/12 15:06
 */
@Data
public class AppClientPageDto extends QueryPageDto {
    /**
     * 应用ID（关联app_config.id）
     */
    private Long appId;
    /**
     * APP版本号
     */
    private String version;
    /**
     * 描述
     */
    private String descr;
    /**
     * 方式：0:apk上传方式，1链接方式
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.UpdateMethodsEnum
     */
    private Integer methods;
    /**
     *  下载地址（32位）
     */
    private String url32;
    /**
     *  下载地址（64位）
     */
    private String url64;
    /**
     *  MD5值（32位）
     */
    private String md532;
    /**
     *  MD5值（64位）
     */
    private String md564;
    /**
     * 提示标题
     */
    private String tipsTitle;
    /**
     * 提示内容
     */
    private String tips;
    /**
     * 发布状态：0未发布，1已发布，2取消发布
     * 注意：取消发布状态不可再设置其它状态，同一个app_id下只有一个已发布（当前校验的最新版本），其它设置为取消发布
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.PublishEnum
     */
    private Integer publish;


    //====================================app_update 表字段=======================================
    /**
     * 发布类型 0：局部发布，1：全量发布
     * 注意：局部发布下(条件必须配置），满足条件提示更新（强更/提示），不满足条件的一律不提示。
     * 全量发布下（未开启强更条件不可配置），开启强更，无条件全部强更，有条件不满足条件提示更新；关闭强更，没有条件都提示更新。
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.ReleaseTypeEnum
     */
    private Integer releaseType;
    /**
     * 强制版更 0：否，1：是
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.StrongUpdateEnum
     */
    private Integer strongUpdate;
    /**
     * 强制版更范围 0：全量，1：局部。
     * 注意：type=1&&strong_update=1有值
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.UpdateRangeEnum
     */
    private Integer updateRange;
}
